/*===---- arm_sve.h - ARM SVE intrinsics -----------------------------------===
 *
 *
 * Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
 * See https://llvm.org/LICENSE.txt for license information.
 * SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
 *
 *===-----------------------------------------------------------------------===
 */

#ifndef __ARM_SVE_H
#define __ARM_SVE_H

#if !defined(__LITTLE_ENDIAN__)
#error "Big endian is currently not supported for arm_sve.h"
#endif
#include <stdint.h>

#ifdef  __cplusplus
extern "C" {
#else
#include <stdbool.h>
#endif

typedef __fp16 float16_t;
typedef float float32_t;
typedef double float64_t;
typedef __SVInt8_t svint8_t;
typedef __SVInt16_t svint16_t;
typedef __SVInt32_t svint32_t;
typedef __SVInt64_t svint64_t;
typedef __SVUint8_t svuint8_t;
typedef __SVUint16_t svuint16_t;
typedef __SVUint32_t svuint32_t;
typedef __SVUint64_t svuint64_t;
typedef __SVFloat16_t svfloat16_t;

typedef __SVBfloat16_t svbfloat16_t;
#include <arm_bf16.h>
#include <arm_vector_types.h>
typedef __SVFloat32_t svfloat32_t;
typedef __SVFloat64_t svfloat64_t;
typedef __clang_svint8x2_t svint8x2_t;
typedef __clang_svint16x2_t svint16x2_t;
typedef __clang_svint32x2_t svint32x2_t;
typedef __clang_svint64x2_t svint64x2_t;
typedef __clang_svuint8x2_t svuint8x2_t;
typedef __clang_svuint16x2_t svuint16x2_t;
typedef __clang_svuint32x2_t svuint32x2_t;
typedef __clang_svuint64x2_t svuint64x2_t;
typedef __clang_svfloat16x2_t svfloat16x2_t;
typedef __clang_svfloat32x2_t svfloat32x2_t;
typedef __clang_svfloat64x2_t svfloat64x2_t;
typedef __clang_svint8x3_t svint8x3_t;
typedef __clang_svint16x3_t svint16x3_t;
typedef __clang_svint32x3_t svint32x3_t;
typedef __clang_svint64x3_t svint64x3_t;
typedef __clang_svuint8x3_t svuint8x3_t;
typedef __clang_svuint16x3_t svuint16x3_t;
typedef __clang_svuint32x3_t svuint32x3_t;
typedef __clang_svuint64x3_t svuint64x3_t;
typedef __clang_svfloat16x3_t svfloat16x3_t;
typedef __clang_svfloat32x3_t svfloat32x3_t;
typedef __clang_svfloat64x3_t svfloat64x3_t;
typedef __clang_svint8x4_t svint8x4_t;
typedef __clang_svint16x4_t svint16x4_t;
typedef __clang_svint32x4_t svint32x4_t;
typedef __clang_svint64x4_t svint64x4_t;
typedef __clang_svuint8x4_t svuint8x4_t;
typedef __clang_svuint16x4_t svuint16x4_t;
typedef __clang_svuint32x4_t svuint32x4_t;
typedef __clang_svuint64x4_t svuint64x4_t;
typedef __clang_svfloat16x4_t svfloat16x4_t;
typedef __clang_svfloat32x4_t svfloat32x4_t;
typedef __clang_svfloat64x4_t svfloat64x4_t;
typedef __SVBool_t  svbool_t;
typedef __clang_svboolx2_t  svboolx2_t;
typedef __clang_svboolx4_t  svboolx4_t;

typedef __clang_svbfloat16x2_t svbfloat16x2_t;
typedef __clang_svbfloat16x3_t svbfloat16x3_t;
typedef __clang_svbfloat16x4_t svbfloat16x4_t;
typedef __SVCount_t svcount_t;

enum svpattern
{
  SV_POW2 = 0,
  SV_VL1 = 1,
  SV_VL2 = 2,
  SV_VL3 = 3,
  SV_VL4 = 4,
  SV_VL5 = 5,
  SV_VL6 = 6,
  SV_VL7 = 7,
  SV_VL8 = 8,
  SV_VL16 = 9,
  SV_VL32 = 10,
  SV_VL64 = 11,
  SV_VL128 = 12,
  SV_VL256 = 13,
  SV_MUL4 = 29,
  SV_MUL3 = 30,
  SV_ALL = 31
};

enum svprfop
{
  SV_PLDL1KEEP = 0,
  SV_PLDL1STRM = 1,
  SV_PLDL2KEEP = 2,
  SV_PLDL2STRM = 3,
  SV_PLDL3KEEP = 4,
  SV_PLDL3STRM = 5,
  SV_PSTL1KEEP = 8,
  SV_PSTL1STRM = 9,
  SV_PSTL2KEEP = 10,
  SV_PSTL2STRM = 11,
  SV_PSTL3KEEP = 12,
  SV_PSTL3STRM = 13
};

/* Function attributes */
#define __ai static __inline__ __attribute__((__always_inline__, __nodebug__))

#define __aio static __inline__ __attribute__((__always_inline__, __nodebug__, __overloadable__))

#define svreinterpret_s8_s8(...) __builtin_sve_reinterpret_s8_s8(__VA_ARGS__)
#define svreinterpret_s8_u8(...) __builtin_sve_reinterpret_s8_u8(__VA_ARGS__)
#define svreinterpret_s8_s16(...) __builtin_sve_reinterpret_s8_s16(__VA_ARGS__)
#define svreinterpret_s8_u16(...) __builtin_sve_reinterpret_s8_u16(__VA_ARGS__)
#define svreinterpret_s8_s32(...) __builtin_sve_reinterpret_s8_s32(__VA_ARGS__)
#define svreinterpret_s8_u32(...) __builtin_sve_reinterpret_s8_u32(__VA_ARGS__)
#define svreinterpret_s8_s64(...) __builtin_sve_reinterpret_s8_s64(__VA_ARGS__)
#define svreinterpret_s8_u64(...) __builtin_sve_reinterpret_s8_u64(__VA_ARGS__)
#define svreinterpret_s8_f16(...) __builtin_sve_reinterpret_s8_f16(__VA_ARGS__)
#define svreinterpret_s8_bf16(...) __builtin_sve_reinterpret_s8_bf16(__VA_ARGS__)
#define svreinterpret_s8_f32(...) __builtin_sve_reinterpret_s8_f32(__VA_ARGS__)
#define svreinterpret_s8_f64(...) __builtin_sve_reinterpret_s8_f64(__VA_ARGS__)
#define svreinterpret_u8_s8(...) __builtin_sve_reinterpret_u8_s8(__VA_ARGS__)
#define svreinterpret_u8_u8(...) __builtin_sve_reinterpret_u8_u8(__VA_ARGS__)
#define svreinterpret_u8_s16(...) __builtin_sve_reinterpret_u8_s16(__VA_ARGS__)
#define svreinterpret_u8_u16(...) __builtin_sve_reinterpret_u8_u16(__VA_ARGS__)
#define svreinterpret_u8_s32(...) __builtin_sve_reinterpret_u8_s32(__VA_ARGS__)
#define svreinterpret_u8_u32(...) __builtin_sve_reinterpret_u8_u32(__VA_ARGS__)
#define svreinterpret_u8_s64(...) __builtin_sve_reinterpret_u8_s64(__VA_ARGS__)
#define svreinterpret_u8_u64(...) __builtin_sve_reinterpret_u8_u64(__VA_ARGS__)
#define svreinterpret_u8_f16(...) __builtin_sve_reinterpret_u8_f16(__VA_ARGS__)
#define svreinterpret_u8_bf16(...) __builtin_sve_reinterpret_u8_bf16(__VA_ARGS__)
#define svreinterpret_u8_f32(...) __builtin_sve_reinterpret_u8_f32(__VA_ARGS__)
#define svreinterpret_u8_f64(...) __builtin_sve_reinterpret_u8_f64(__VA_ARGS__)
#define svreinterpret_s16_s8(...) __builtin_sve_reinterpret_s16_s8(__VA_ARGS__)
#define svreinterpret_s16_u8(...) __builtin_sve_reinterpret_s16_u8(__VA_ARGS__)
#define svreinterpret_s16_s16(...) __builtin_sve_reinterpret_s16_s16(__VA_ARGS__)
#define svreinterpret_s16_u16(...) __builtin_sve_reinterpret_s16_u16(__VA_ARGS__)
#define svreinterpret_s16_s32(...) __builtin_sve_reinterpret_s16_s32(__VA_ARGS__)
#define svreinterpret_s16_u32(...) __builtin_sve_reinterpret_s16_u32(__VA_ARGS__)
#define svreinterpret_s16_s64(...) __builtin_sve_reinterpret_s16_s64(__VA_ARGS__)
#define svreinterpret_s16_u64(...) __builtin_sve_reinterpret_s16_u64(__VA_ARGS__)
#define svreinterpret_s16_f16(...) __builtin_sve_reinterpret_s16_f16(__VA_ARGS__)
#define svreinterpret_s16_bf16(...) __builtin_sve_reinterpret_s16_bf16(__VA_ARGS__)
#define svreinterpret_s16_f32(...) __builtin_sve_reinterpret_s16_f32(__VA_ARGS__)
#define svreinterpret_s16_f64(...) __builtin_sve_reinterpret_s16_f64(__VA_ARGS__)
#define svreinterpret_u16_s8(...) __builtin_sve_reinterpret_u16_s8(__VA_ARGS__)
#define svreinterpret_u16_u8(...) __builtin_sve_reinterpret_u16_u8(__VA_ARGS__)
#define svreinterpret_u16_s16(...) __builtin_sve_reinterpret_u16_s16(__VA_ARGS__)
#define svreinterpret_u16_u16(...) __builtin_sve_reinterpret_u16_u16(__VA_ARGS__)
#define svreinterpret_u16_s32(...) __builtin_sve_reinterpret_u16_s32(__VA_ARGS__)
#define svreinterpret_u16_u32(...) __builtin_sve_reinterpret_u16_u32(__VA_ARGS__)
#define svreinterpret_u16_s64(...) __builtin_sve_reinterpret_u16_s64(__VA_ARGS__)
#define svreinterpret_u16_u64(...) __builtin_sve_reinterpret_u16_u64(__VA_ARGS__)
#define svreinterpret_u16_f16(...) __builtin_sve_reinterpret_u16_f16(__VA_ARGS__)
#define svreinterpret_u16_bf16(...) __builtin_sve_reinterpret_u16_bf16(__VA_ARGS__)
#define svreinterpret_u16_f32(...) __builtin_sve_reinterpret_u16_f32(__VA_ARGS__)
#define svreinterpret_u16_f64(...) __builtin_sve_reinterpret_u16_f64(__VA_ARGS__)
#define svreinterpret_s32_s8(...) __builtin_sve_reinterpret_s32_s8(__VA_ARGS__)
#define svreinterpret_s32_u8(...) __builtin_sve_reinterpret_s32_u8(__VA_ARGS__)
#define svreinterpret_s32_s16(...) __builtin_sve_reinterpret_s32_s16(__VA_ARGS__)
#define svreinterpret_s32_u16(...) __builtin_sve_reinterpret_s32_u16(__VA_ARGS__)
#define svreinterpret_s32_s32(...) __builtin_sve_reinterpret_s32_s32(__VA_ARGS__)
#define svreinterpret_s32_u32(...) __builtin_sve_reinterpret_s32_u32(__VA_ARGS__)
#define svreinterpret_s32_s64(...) __builtin_sve_reinterpret_s32_s64(__VA_ARGS__)
#define svreinterpret_s32_u64(...) __builtin_sve_reinterpret_s32_u64(__VA_ARGS__)
#define svreinterpret_s32_f16(...) __builtin_sve_reinterpret_s32_f16(__VA_ARGS__)
#define svreinterpret_s32_bf16(...) __builtin_sve_reinterpret_s32_bf16(__VA_ARGS__)
#define svreinterpret_s32_f32(...) __builtin_sve_reinterpret_s32_f32(__VA_ARGS__)
#define svreinterpret_s32_f64(...) __builtin_sve_reinterpret_s32_f64(__VA_ARGS__)
#define svreinterpret_u32_s8(...) __builtin_sve_reinterpret_u32_s8(__VA_ARGS__)
#define svreinterpret_u32_u8(...) __builtin_sve_reinterpret_u32_u8(__VA_ARGS__)
#define svreinterpret_u32_s16(...) __builtin_sve_reinterpret_u32_s16(__VA_ARGS__)
#define svreinterpret_u32_u16(...) __builtin_sve_reinterpret_u32_u16(__VA_ARGS__)
#define svreinterpret_u32_s32(...) __builtin_sve_reinterpret_u32_s32(__VA_ARGS__)
#define svreinterpret_u32_u32(...) __builtin_sve_reinterpret_u32_u32(__VA_ARGS__)
#define svreinterpret_u32_s64(...) __builtin_sve_reinterpret_u32_s64(__VA_ARGS__)
#define svreinterpret_u32_u64(...) __builtin_sve_reinterpret_u32_u64(__VA_ARGS__)
#define svreinterpret_u32_f16(...) __builtin_sve_reinterpret_u32_f16(__VA_ARGS__)
#define svreinterpret_u32_bf16(...) __builtin_sve_reinterpret_u32_bf16(__VA_ARGS__)
#define svreinterpret_u32_f32(...) __builtin_sve_reinterpret_u32_f32(__VA_ARGS__)
#define svreinterpret_u32_f64(...) __builtin_sve_reinterpret_u32_f64(__VA_ARGS__)
#define svreinterpret_s64_s8(...) __builtin_sve_reinterpret_s64_s8(__VA_ARGS__)
#define svreinterpret_s64_u8(...) __builtin_sve_reinterpret_s64_u8(__VA_ARGS__)
#define svreinterpret_s64_s16(...) __builtin_sve_reinterpret_s64_s16(__VA_ARGS__)
#define svreinterpret_s64_u16(...) __builtin_sve_reinterpret_s64_u16(__VA_ARGS__)
#define svreinterpret_s64_s32(...) __builtin_sve_reinterpret_s64_s32(__VA_ARGS__)
#define svreinterpret_s64_u32(...) __builtin_sve_reinterpret_s64_u32(__VA_ARGS__)
#define svreinterpret_s64_s64(...) __builtin_sve_reinterpret_s64_s64(__VA_ARGS__)
#define svreinterpret_s64_u64(...) __builtin_sve_reinterpret_s64_u64(__VA_ARGS__)
#define svreinterpret_s64_f16(...) __builtin_sve_reinterpret_s64_f16(__VA_ARGS__)
#define svreinterpret_s64_bf16(...) __builtin_sve_reinterpret_s64_bf16(__VA_ARGS__)
#define svreinterpret_s64_f32(...) __builtin_sve_reinterpret_s64_f32(__VA_ARGS__)
#define svreinterpret_s64_f64(...) __builtin_sve_reinterpret_s64_f64(__VA_ARGS__)
#define svreinterpret_u64_s8(...) __builtin_sve_reinterpret_u64_s8(__VA_ARGS__)
#define svreinterpret_u64_u8(...) __builtin_sve_reinterpret_u64_u8(__VA_ARGS__)
#define svreinterpret_u64_s16(...) __builtin_sve_reinterpret_u64_s16(__VA_ARGS__)
#define svreinterpret_u64_u16(...) __builtin_sve_reinterpret_u64_u16(__VA_ARGS__)
#define svreinterpret_u64_s32(...) __builtin_sve_reinterpret_u64_s32(__VA_ARGS__)
#define svreinterpret_u64_u32(...) __builtin_sve_reinterpret_u64_u32(__VA_ARGS__)
#define svreinterpret_u64_s64(...) __builtin_sve_reinterpret_u64_s64(__VA_ARGS__)
#define svreinterpret_u64_u64(...) __builtin_sve_reinterpret_u64_u64(__VA_ARGS__)
#define svreinterpret_u64_f16(...) __builtin_sve_reinterpret_u64_f16(__VA_ARGS__)
#define svreinterpret_u64_bf16(...) __builtin_sve_reinterpret_u64_bf16(__VA_ARGS__)
#define svreinterpret_u64_f32(...) __builtin_sve_reinterpret_u64_f32(__VA_ARGS__)
#define svreinterpret_u64_f64(...) __builtin_sve_reinterpret_u64_f64(__VA_ARGS__)
#define svreinterpret_f16_s8(...) __builtin_sve_reinterpret_f16_s8(__VA_ARGS__)
#define svreinterpret_f16_u8(...) __builtin_sve_reinterpret_f16_u8(__VA_ARGS__)
#define svreinterpret_f16_s16(...) __builtin_sve_reinterpret_f16_s16(__VA_ARGS__)
#define svreinterpret_f16_u16(...) __builtin_sve_reinterpret_f16_u16(__VA_ARGS__)
#define svreinterpret_f16_s32(...) __builtin_sve_reinterpret_f16_s32(__VA_ARGS__)
#define svreinterpret_f16_u32(...) __builtin_sve_reinterpret_f16_u32(__VA_ARGS__)
#define svreinterpret_f16_s64(...) __builtin_sve_reinterpret_f16_s64(__VA_ARGS__)
#define svreinterpret_f16_u64(...) __builtin_sve_reinterpret_f16_u64(__VA_ARGS__)
#define svreinterpret_f16_f16(...) __builtin_sve_reinterpret_f16_f16(__VA_ARGS__)
#define svreinterpret_f16_bf16(...) __builtin_sve_reinterpret_f16_bf16(__VA_ARGS__)
#define svreinterpret_f16_f32(...) __builtin_sve_reinterpret_f16_f32(__VA_ARGS__)
#define svreinterpret_f16_f64(...) __builtin_sve_reinterpret_f16_f64(__VA_ARGS__)
#define svreinterpret_bf16_s8(...) __builtin_sve_reinterpret_bf16_s8(__VA_ARGS__)
#define svreinterpret_bf16_u8(...) __builtin_sve_reinterpret_bf16_u8(__VA_ARGS__)
#define svreinterpret_bf16_s16(...) __builtin_sve_reinterpret_bf16_s16(__VA_ARGS__)
#define svreinterpret_bf16_u16(...) __builtin_sve_reinterpret_bf16_u16(__VA_ARGS__)
#define svreinterpret_bf16_s32(...) __builtin_sve_reinterpret_bf16_s32(__VA_ARGS__)
#define svreinterpret_bf16_u32(...) __builtin_sve_reinterpret_bf16_u32(__VA_ARGS__)
#define svreinterpret_bf16_s64(...) __builtin_sve_reinterpret_bf16_s64(__VA_ARGS__)
#define svreinterpret_bf16_u64(...) __builtin_sve_reinterpret_bf16_u64(__VA_ARGS__)
#define svreinterpret_bf16_f16(...) __builtin_sve_reinterpret_bf16_f16(__VA_ARGS__)
#define svreinterpret_bf16_bf16(...) __builtin_sve_reinterpret_bf16_bf16(__VA_ARGS__)
#define svreinterpret_bf16_f32(...) __builtin_sve_reinterpret_bf16_f32(__VA_ARGS__)
#define svreinterpret_bf16_f64(...) __builtin_sve_reinterpret_bf16_f64(__VA_ARGS__)
#define svreinterpret_f32_s8(...) __builtin_sve_reinterpret_f32_s8(__VA_ARGS__)
#define svreinterpret_f32_u8(...) __builtin_sve_reinterpret_f32_u8(__VA_ARGS__)
#define svreinterpret_f32_s16(...) __builtin_sve_reinterpret_f32_s16(__VA_ARGS__)
#define svreinterpret_f32_u16(...) __builtin_sve_reinterpret_f32_u16(__VA_ARGS__)
#define svreinterpret_f32_s32(...) __builtin_sve_reinterpret_f32_s32(__VA_ARGS__)
#define svreinterpret_f32_u32(...) __builtin_sve_reinterpret_f32_u32(__VA_ARGS__)
#define svreinterpret_f32_s64(...) __builtin_sve_reinterpret_f32_s64(__VA_ARGS__)
#define svreinterpret_f32_u64(...) __builtin_sve_reinterpret_f32_u64(__VA_ARGS__)
#define svreinterpret_f32_f16(...) __builtin_sve_reinterpret_f32_f16(__VA_ARGS__)
#define svreinterpret_f32_bf16(...) __builtin_sve_reinterpret_f32_bf16(__VA_ARGS__)
#define svreinterpret_f32_f32(...) __builtin_sve_reinterpret_f32_f32(__VA_ARGS__)
#define svreinterpret_f32_f64(...) __builtin_sve_reinterpret_f32_f64(__VA_ARGS__)
#define svreinterpret_f64_s8(...) __builtin_sve_reinterpret_f64_s8(__VA_ARGS__)
#define svreinterpret_f64_u8(...) __builtin_sve_reinterpret_f64_u8(__VA_ARGS__)
#define svreinterpret_f64_s16(...) __builtin_sve_reinterpret_f64_s16(__VA_ARGS__)
#define svreinterpret_f64_u16(...) __builtin_sve_reinterpret_f64_u16(__VA_ARGS__)
#define svreinterpret_f64_s32(...) __builtin_sve_reinterpret_f64_s32(__VA_ARGS__)
#define svreinterpret_f64_u32(...) __builtin_sve_reinterpret_f64_u32(__VA_ARGS__)
#define svreinterpret_f64_s64(...) __builtin_sve_reinterpret_f64_s64(__VA_ARGS__)
#define svreinterpret_f64_u64(...) __builtin_sve_reinterpret_f64_u64(__VA_ARGS__)
#define svreinterpret_f64_f16(...) __builtin_sve_reinterpret_f64_f16(__VA_ARGS__)
#define svreinterpret_f64_bf16(...) __builtin_sve_reinterpret_f64_bf16(__VA_ARGS__)
#define svreinterpret_f64_f32(...) __builtin_sve_reinterpret_f64_f32(__VA_ARGS__)
#define svreinterpret_f64_f64(...) __builtin_sve_reinterpret_f64_f64(__VA_ARGS__)
__aio __attribute__((target("sve"))) svint8_t svreinterpret_s8(svint8_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_s8(op);
}

__aio __attribute__((target("sve"))) svint8_t svreinterpret_s8(svuint8_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_u8(op);
}

__aio __attribute__((target("sve"))) svint8_t svreinterpret_s8(svint16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_s16(op);
}

__aio __attribute__((target("sve"))) svint8_t svreinterpret_s8(svuint16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_u16(op);
}

__aio __attribute__((target("sve"))) svint8_t svreinterpret_s8(svint32_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_s32(op);
}

__aio __attribute__((target("sve"))) svint8_t svreinterpret_s8(svuint32_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_u32(op);
}

__aio __attribute__((target("sve"))) svint8_t svreinterpret_s8(svint64_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_s64(op);
}

__aio __attribute__((target("sve"))) svint8_t svreinterpret_s8(svuint64_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_u64(op);
}

__aio __attribute__((target("sve"))) svint8_t svreinterpret_s8(svfloat16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_f16(op);
}

__aio __attribute__((target("sve"))) svint8_t svreinterpret_s8(svbfloat16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_bf16(op);
}

__aio __attribute__((target("sve"))) svint8_t svreinterpret_s8(svfloat32_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_f32(op);
}

__aio __attribute__((target("sve"))) svint8_t svreinterpret_s8(svfloat64_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_f64(op);
}

__aio __attribute__((target("sve"))) svuint8_t svreinterpret_u8(svint8_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_s8(op);
}

__aio __attribute__((target("sve"))) svuint8_t svreinterpret_u8(svuint8_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_u8(op);
}

__aio __attribute__((target("sve"))) svuint8_t svreinterpret_u8(svint16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_s16(op);
}

__aio __attribute__((target("sve"))) svuint8_t svreinterpret_u8(svuint16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_u16(op);
}

__aio __attribute__((target("sve"))) svuint8_t svreinterpret_u8(svint32_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_s32(op);
}

__aio __attribute__((target("sve"))) svuint8_t svreinterpret_u8(svuint32_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_u32(op);
}

__aio __attribute__((target("sve"))) svuint8_t svreinterpret_u8(svint64_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_s64(op);
}

__aio __attribute__((target("sve"))) svuint8_t svreinterpret_u8(svuint64_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_u64(op);
}

__aio __attribute__((target("sve"))) svuint8_t svreinterpret_u8(svfloat16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_f16(op);
}

__aio __attribute__((target("sve"))) svuint8_t svreinterpret_u8(svbfloat16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_bf16(op);
}

__aio __attribute__((target("sve"))) svuint8_t svreinterpret_u8(svfloat32_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_f32(op);
}

__aio __attribute__((target("sve"))) svuint8_t svreinterpret_u8(svfloat64_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_f64(op);
}

__aio __attribute__((target("sve"))) svint16_t svreinterpret_s16(svint8_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_s8(op);
}

__aio __attribute__((target("sve"))) svint16_t svreinterpret_s16(svuint8_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_u8(op);
}

__aio __attribute__((target("sve"))) svint16_t svreinterpret_s16(svint16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_s16(op);
}

__aio __attribute__((target("sve"))) svint16_t svreinterpret_s16(svuint16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_u16(op);
}

__aio __attribute__((target("sve"))) svint16_t svreinterpret_s16(svint32_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_s32(op);
}

__aio __attribute__((target("sve"))) svint16_t svreinterpret_s16(svuint32_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_u32(op);
}

__aio __attribute__((target("sve"))) svint16_t svreinterpret_s16(svint64_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_s64(op);
}

__aio __attribute__((target("sve"))) svint16_t svreinterpret_s16(svuint64_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_u64(op);
}

__aio __attribute__((target("sve"))) svint16_t svreinterpret_s16(svfloat16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_f16(op);
}

__aio __attribute__((target("sve"))) svint16_t svreinterpret_s16(svbfloat16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_bf16(op);
}

__aio __attribute__((target("sve"))) svint16_t svreinterpret_s16(svfloat32_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_f32(op);
}

__aio __attribute__((target("sve"))) svint16_t svreinterpret_s16(svfloat64_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_f64(op);
}

__aio __attribute__((target("sve"))) svuint16_t svreinterpret_u16(svint8_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_s8(op);
}

__aio __attribute__((target("sve"))) svuint16_t svreinterpret_u16(svuint8_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_u8(op);
}

__aio __attribute__((target("sve"))) svuint16_t svreinterpret_u16(svint16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_s16(op);
}

__aio __attribute__((target("sve"))) svuint16_t svreinterpret_u16(svuint16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_u16(op);
}

__aio __attribute__((target("sve"))) svuint16_t svreinterpret_u16(svint32_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_s32(op);
}

__aio __attribute__((target("sve"))) svuint16_t svreinterpret_u16(svuint32_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_u32(op);
}

__aio __attribute__((target("sve"))) svuint16_t svreinterpret_u16(svint64_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_s64(op);
}

__aio __attribute__((target("sve"))) svuint16_t svreinterpret_u16(svuint64_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_u64(op);
}

__aio __attribute__((target("sve"))) svuint16_t svreinterpret_u16(svfloat16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_f16(op);
}

__aio __attribute__((target("sve"))) svuint16_t svreinterpret_u16(svbfloat16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_bf16(op);
}

__aio __attribute__((target("sve"))) svuint16_t svreinterpret_u16(svfloat32_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_f32(op);
}

__aio __attribute__((target("sve"))) svuint16_t svreinterpret_u16(svfloat64_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_f64(op);
}

__aio __attribute__((target("sve"))) svint32_t svreinterpret_s32(svint8_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_s8(op);
}

__aio __attribute__((target("sve"))) svint32_t svreinterpret_s32(svuint8_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_u8(op);
}

__aio __attribute__((target("sve"))) svint32_t svreinterpret_s32(svint16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_s16(op);
}

__aio __attribute__((target("sve"))) svint32_t svreinterpret_s32(svuint16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_u16(op);
}

__aio __attribute__((target("sve"))) svint32_t svreinterpret_s32(svint32_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_s32(op);
}

__aio __attribute__((target("sve"))) svint32_t svreinterpret_s32(svuint32_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_u32(op);
}

__aio __attribute__((target("sve"))) svint32_t svreinterpret_s32(svint64_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_s64(op);
}

__aio __attribute__((target("sve"))) svint32_t svreinterpret_s32(svuint64_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_u64(op);
}

__aio __attribute__((target("sve"))) svint32_t svreinterpret_s32(svfloat16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_f16(op);
}

__aio __attribute__((target("sve"))) svint32_t svreinterpret_s32(svbfloat16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_bf16(op);
}

__aio __attribute__((target("sve"))) svint32_t svreinterpret_s32(svfloat32_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_f32(op);
}

__aio __attribute__((target("sve"))) svint32_t svreinterpret_s32(svfloat64_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_f64(op);
}

__aio __attribute__((target("sve"))) svuint32_t svreinterpret_u32(svint8_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_s8(op);
}

__aio __attribute__((target("sve"))) svuint32_t svreinterpret_u32(svuint8_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_u8(op);
}

__aio __attribute__((target("sve"))) svuint32_t svreinterpret_u32(svint16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_s16(op);
}

__aio __attribute__((target("sve"))) svuint32_t svreinterpret_u32(svuint16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_u16(op);
}

__aio __attribute__((target("sve"))) svuint32_t svreinterpret_u32(svint32_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_s32(op);
}

__aio __attribute__((target("sve"))) svuint32_t svreinterpret_u32(svuint32_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_u32(op);
}

__aio __attribute__((target("sve"))) svuint32_t svreinterpret_u32(svint64_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_s64(op);
}

__aio __attribute__((target("sve"))) svuint32_t svreinterpret_u32(svuint64_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_u64(op);
}

__aio __attribute__((target("sve"))) svuint32_t svreinterpret_u32(svfloat16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_f16(op);
}

__aio __attribute__((target("sve"))) svuint32_t svreinterpret_u32(svbfloat16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_bf16(op);
}

__aio __attribute__((target("sve"))) svuint32_t svreinterpret_u32(svfloat32_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_f32(op);
}

__aio __attribute__((target("sve"))) svuint32_t svreinterpret_u32(svfloat64_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_f64(op);
}

__aio __attribute__((target("sve"))) svint64_t svreinterpret_s64(svint8_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_s8(op);
}

__aio __attribute__((target("sve"))) svint64_t svreinterpret_s64(svuint8_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_u8(op);
}

__aio __attribute__((target("sve"))) svint64_t svreinterpret_s64(svint16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_s16(op);
}

__aio __attribute__((target("sve"))) svint64_t svreinterpret_s64(svuint16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_u16(op);
}

__aio __attribute__((target("sve"))) svint64_t svreinterpret_s64(svint32_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_s32(op);
}

__aio __attribute__((target("sve"))) svint64_t svreinterpret_s64(svuint32_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_u32(op);
}

__aio __attribute__((target("sve"))) svint64_t svreinterpret_s64(svint64_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_s64(op);
}

__aio __attribute__((target("sve"))) svint64_t svreinterpret_s64(svuint64_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_u64(op);
}

__aio __attribute__((target("sve"))) svint64_t svreinterpret_s64(svfloat16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_f16(op);
}

__aio __attribute__((target("sve"))) svint64_t svreinterpret_s64(svbfloat16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_bf16(op);
}

__aio __attribute__((target("sve"))) svint64_t svreinterpret_s64(svfloat32_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_f32(op);
}

__aio __attribute__((target("sve"))) svint64_t svreinterpret_s64(svfloat64_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_f64(op);
}

__aio __attribute__((target("sve"))) svuint64_t svreinterpret_u64(svint8_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_s8(op);
}

__aio __attribute__((target("sve"))) svuint64_t svreinterpret_u64(svuint8_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_u8(op);
}

__aio __attribute__((target("sve"))) svuint64_t svreinterpret_u64(svint16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_s16(op);
}

__aio __attribute__((target("sve"))) svuint64_t svreinterpret_u64(svuint16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_u16(op);
}

__aio __attribute__((target("sve"))) svuint64_t svreinterpret_u64(svint32_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_s32(op);
}

__aio __attribute__((target("sve"))) svuint64_t svreinterpret_u64(svuint32_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_u32(op);
}

__aio __attribute__((target("sve"))) svuint64_t svreinterpret_u64(svint64_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_s64(op);
}

__aio __attribute__((target("sve"))) svuint64_t svreinterpret_u64(svuint64_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_u64(op);
}

__aio __attribute__((target("sve"))) svuint64_t svreinterpret_u64(svfloat16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_f16(op);
}

__aio __attribute__((target("sve"))) svuint64_t svreinterpret_u64(svbfloat16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_bf16(op);
}

__aio __attribute__((target("sve"))) svuint64_t svreinterpret_u64(svfloat32_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_f32(op);
}

__aio __attribute__((target("sve"))) svuint64_t svreinterpret_u64(svfloat64_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_f64(op);
}

__aio __attribute__((target("sve"))) svfloat16_t svreinterpret_f16(svint8_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_s8(op);
}

__aio __attribute__((target("sve"))) svfloat16_t svreinterpret_f16(svuint8_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_u8(op);
}

__aio __attribute__((target("sve"))) svfloat16_t svreinterpret_f16(svint16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_s16(op);
}

__aio __attribute__((target("sve"))) svfloat16_t svreinterpret_f16(svuint16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_u16(op);
}

__aio __attribute__((target("sve"))) svfloat16_t svreinterpret_f16(svint32_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_s32(op);
}

__aio __attribute__((target("sve"))) svfloat16_t svreinterpret_f16(svuint32_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_u32(op);
}

__aio __attribute__((target("sve"))) svfloat16_t svreinterpret_f16(svint64_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_s64(op);
}

__aio __attribute__((target("sve"))) svfloat16_t svreinterpret_f16(svuint64_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_u64(op);
}

__aio __attribute__((target("sve"))) svfloat16_t svreinterpret_f16(svfloat16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_f16(op);
}

__aio __attribute__((target("sve"))) svfloat16_t svreinterpret_f16(svbfloat16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_bf16(op);
}

__aio __attribute__((target("sve"))) svfloat16_t svreinterpret_f16(svfloat32_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_f32(op);
}

__aio __attribute__((target("sve"))) svfloat16_t svreinterpret_f16(svfloat64_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_f64(op);
}

__aio __attribute__((target("sve"))) svbfloat16_t svreinterpret_bf16(svint8_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_s8(op);
}

__aio __attribute__((target("sve"))) svbfloat16_t svreinterpret_bf16(svuint8_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_u8(op);
}

__aio __attribute__((target("sve"))) svbfloat16_t svreinterpret_bf16(svint16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_s16(op);
}

__aio __attribute__((target("sve"))) svbfloat16_t svreinterpret_bf16(svuint16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_u16(op);
}

__aio __attribute__((target("sve"))) svbfloat16_t svreinterpret_bf16(svint32_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_s32(op);
}

__aio __attribute__((target("sve"))) svbfloat16_t svreinterpret_bf16(svuint32_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_u32(op);
}

__aio __attribute__((target("sve"))) svbfloat16_t svreinterpret_bf16(svint64_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_s64(op);
}

__aio __attribute__((target("sve"))) svbfloat16_t svreinterpret_bf16(svuint64_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_u64(op);
}

__aio __attribute__((target("sve"))) svbfloat16_t svreinterpret_bf16(svfloat16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_f16(op);
}

__aio __attribute__((target("sve"))) svbfloat16_t svreinterpret_bf16(svbfloat16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_bf16(op);
}

__aio __attribute__((target("sve"))) svbfloat16_t svreinterpret_bf16(svfloat32_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_f32(op);
}

__aio __attribute__((target("sve"))) svbfloat16_t svreinterpret_bf16(svfloat64_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_f64(op);
}

__aio __attribute__((target("sve"))) svfloat32_t svreinterpret_f32(svint8_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_s8(op);
}

__aio __attribute__((target("sve"))) svfloat32_t svreinterpret_f32(svuint8_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_u8(op);
}

__aio __attribute__((target("sve"))) svfloat32_t svreinterpret_f32(svint16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_s16(op);
}

__aio __attribute__((target("sve"))) svfloat32_t svreinterpret_f32(svuint16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_u16(op);
}

__aio __attribute__((target("sve"))) svfloat32_t svreinterpret_f32(svint32_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_s32(op);
}

__aio __attribute__((target("sve"))) svfloat32_t svreinterpret_f32(svuint32_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_u32(op);
}

__aio __attribute__((target("sve"))) svfloat32_t svreinterpret_f32(svint64_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_s64(op);
}

__aio __attribute__((target("sve"))) svfloat32_t svreinterpret_f32(svuint64_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_u64(op);
}

__aio __attribute__((target("sve"))) svfloat32_t svreinterpret_f32(svfloat16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_f16(op);
}

__aio __attribute__((target("sve"))) svfloat32_t svreinterpret_f32(svbfloat16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_bf16(op);
}

__aio __attribute__((target("sve"))) svfloat32_t svreinterpret_f32(svfloat32_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_f32(op);
}

__aio __attribute__((target("sve"))) svfloat32_t svreinterpret_f32(svfloat64_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_f64(op);
}

__aio __attribute__((target("sve"))) svfloat64_t svreinterpret_f64(svint8_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_s8(op);
}

__aio __attribute__((target("sve"))) svfloat64_t svreinterpret_f64(svuint8_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_u8(op);
}

__aio __attribute__((target("sve"))) svfloat64_t svreinterpret_f64(svint16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_s16(op);
}

__aio __attribute__((target("sve"))) svfloat64_t svreinterpret_f64(svuint16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_u16(op);
}

__aio __attribute__((target("sve"))) svfloat64_t svreinterpret_f64(svint32_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_s32(op);
}

__aio __attribute__((target("sve"))) svfloat64_t svreinterpret_f64(svuint32_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_u32(op);
}

__aio __attribute__((target("sve"))) svfloat64_t svreinterpret_f64(svint64_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_s64(op);
}

__aio __attribute__((target("sve"))) svfloat64_t svreinterpret_f64(svuint64_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_u64(op);
}

__aio __attribute__((target("sve"))) svfloat64_t svreinterpret_f64(svfloat16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_f16(op);
}

__aio __attribute__((target("sve"))) svfloat64_t svreinterpret_f64(svbfloat16_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_bf16(op);
}

__aio __attribute__((target("sve"))) svfloat64_t svreinterpret_f64(svfloat32_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_f32(op);
}

__aio __attribute__((target("sve"))) svfloat64_t svreinterpret_f64(svfloat64_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_f64(op);
}

#define svreinterpret_s8_s8_x2(...) __builtin_sve_reinterpret_s8_s8_x2(__VA_ARGS__)
#define svreinterpret_s8_u8_x2(...) __builtin_sve_reinterpret_s8_u8_x2(__VA_ARGS__)
#define svreinterpret_s8_s16_x2(...) __builtin_sve_reinterpret_s8_s16_x2(__VA_ARGS__)
#define svreinterpret_s8_u16_x2(...) __builtin_sve_reinterpret_s8_u16_x2(__VA_ARGS__)
#define svreinterpret_s8_s32_x2(...) __builtin_sve_reinterpret_s8_s32_x2(__VA_ARGS__)
#define svreinterpret_s8_u32_x2(...) __builtin_sve_reinterpret_s8_u32_x2(__VA_ARGS__)
#define svreinterpret_s8_s64_x2(...) __builtin_sve_reinterpret_s8_s64_x2(__VA_ARGS__)
#define svreinterpret_s8_u64_x2(...) __builtin_sve_reinterpret_s8_u64_x2(__VA_ARGS__)
#define svreinterpret_s8_f16_x2(...) __builtin_sve_reinterpret_s8_f16_x2(__VA_ARGS__)
#define svreinterpret_s8_bf16_x2(...) __builtin_sve_reinterpret_s8_bf16_x2(__VA_ARGS__)
#define svreinterpret_s8_f32_x2(...) __builtin_sve_reinterpret_s8_f32_x2(__VA_ARGS__)
#define svreinterpret_s8_f64_x2(...) __builtin_sve_reinterpret_s8_f64_x2(__VA_ARGS__)
#define svreinterpret_u8_s8_x2(...) __builtin_sve_reinterpret_u8_s8_x2(__VA_ARGS__)
#define svreinterpret_u8_u8_x2(...) __builtin_sve_reinterpret_u8_u8_x2(__VA_ARGS__)
#define svreinterpret_u8_s16_x2(...) __builtin_sve_reinterpret_u8_s16_x2(__VA_ARGS__)
#define svreinterpret_u8_u16_x2(...) __builtin_sve_reinterpret_u8_u16_x2(__VA_ARGS__)
#define svreinterpret_u8_s32_x2(...) __builtin_sve_reinterpret_u8_s32_x2(__VA_ARGS__)
#define svreinterpret_u8_u32_x2(...) __builtin_sve_reinterpret_u8_u32_x2(__VA_ARGS__)
#define svreinterpret_u8_s64_x2(...) __builtin_sve_reinterpret_u8_s64_x2(__VA_ARGS__)
#define svreinterpret_u8_u64_x2(...) __builtin_sve_reinterpret_u8_u64_x2(__VA_ARGS__)
#define svreinterpret_u8_f16_x2(...) __builtin_sve_reinterpret_u8_f16_x2(__VA_ARGS__)
#define svreinterpret_u8_bf16_x2(...) __builtin_sve_reinterpret_u8_bf16_x2(__VA_ARGS__)
#define svreinterpret_u8_f32_x2(...) __builtin_sve_reinterpret_u8_f32_x2(__VA_ARGS__)
#define svreinterpret_u8_f64_x2(...) __builtin_sve_reinterpret_u8_f64_x2(__VA_ARGS__)
#define svreinterpret_s16_s8_x2(...) __builtin_sve_reinterpret_s16_s8_x2(__VA_ARGS__)
#define svreinterpret_s16_u8_x2(...) __builtin_sve_reinterpret_s16_u8_x2(__VA_ARGS__)
#define svreinterpret_s16_s16_x2(...) __builtin_sve_reinterpret_s16_s16_x2(__VA_ARGS__)
#define svreinterpret_s16_u16_x2(...) __builtin_sve_reinterpret_s16_u16_x2(__VA_ARGS__)
#define svreinterpret_s16_s32_x2(...) __builtin_sve_reinterpret_s16_s32_x2(__VA_ARGS__)
#define svreinterpret_s16_u32_x2(...) __builtin_sve_reinterpret_s16_u32_x2(__VA_ARGS__)
#define svreinterpret_s16_s64_x2(...) __builtin_sve_reinterpret_s16_s64_x2(__VA_ARGS__)
#define svreinterpret_s16_u64_x2(...) __builtin_sve_reinterpret_s16_u64_x2(__VA_ARGS__)
#define svreinterpret_s16_f16_x2(...) __builtin_sve_reinterpret_s16_f16_x2(__VA_ARGS__)
#define svreinterpret_s16_bf16_x2(...) __builtin_sve_reinterpret_s16_bf16_x2(__VA_ARGS__)
#define svreinterpret_s16_f32_x2(...) __builtin_sve_reinterpret_s16_f32_x2(__VA_ARGS__)
#define svreinterpret_s16_f64_x2(...) __builtin_sve_reinterpret_s16_f64_x2(__VA_ARGS__)
#define svreinterpret_u16_s8_x2(...) __builtin_sve_reinterpret_u16_s8_x2(__VA_ARGS__)
#define svreinterpret_u16_u8_x2(...) __builtin_sve_reinterpret_u16_u8_x2(__VA_ARGS__)
#define svreinterpret_u16_s16_x2(...) __builtin_sve_reinterpret_u16_s16_x2(__VA_ARGS__)
#define svreinterpret_u16_u16_x2(...) __builtin_sve_reinterpret_u16_u16_x2(__VA_ARGS__)
#define svreinterpret_u16_s32_x2(...) __builtin_sve_reinterpret_u16_s32_x2(__VA_ARGS__)
#define svreinterpret_u16_u32_x2(...) __builtin_sve_reinterpret_u16_u32_x2(__VA_ARGS__)
#define svreinterpret_u16_s64_x2(...) __builtin_sve_reinterpret_u16_s64_x2(__VA_ARGS__)
#define svreinterpret_u16_u64_x2(...) __builtin_sve_reinterpret_u16_u64_x2(__VA_ARGS__)
#define svreinterpret_u16_f16_x2(...) __builtin_sve_reinterpret_u16_f16_x2(__VA_ARGS__)
#define svreinterpret_u16_bf16_x2(...) __builtin_sve_reinterpret_u16_bf16_x2(__VA_ARGS__)
#define svreinterpret_u16_f32_x2(...) __builtin_sve_reinterpret_u16_f32_x2(__VA_ARGS__)
#define svreinterpret_u16_f64_x2(...) __builtin_sve_reinterpret_u16_f64_x2(__VA_ARGS__)
#define svreinterpret_s32_s8_x2(...) __builtin_sve_reinterpret_s32_s8_x2(__VA_ARGS__)
#define svreinterpret_s32_u8_x2(...) __builtin_sve_reinterpret_s32_u8_x2(__VA_ARGS__)
#define svreinterpret_s32_s16_x2(...) __builtin_sve_reinterpret_s32_s16_x2(__VA_ARGS__)
#define svreinterpret_s32_u16_x2(...) __builtin_sve_reinterpret_s32_u16_x2(__VA_ARGS__)
#define svreinterpret_s32_s32_x2(...) __builtin_sve_reinterpret_s32_s32_x2(__VA_ARGS__)
#define svreinterpret_s32_u32_x2(...) __builtin_sve_reinterpret_s32_u32_x2(__VA_ARGS__)
#define svreinterpret_s32_s64_x2(...) __builtin_sve_reinterpret_s32_s64_x2(__VA_ARGS__)
#define svreinterpret_s32_u64_x2(...) __builtin_sve_reinterpret_s32_u64_x2(__VA_ARGS__)
#define svreinterpret_s32_f16_x2(...) __builtin_sve_reinterpret_s32_f16_x2(__VA_ARGS__)
#define svreinterpret_s32_bf16_x2(...) __builtin_sve_reinterpret_s32_bf16_x2(__VA_ARGS__)
#define svreinterpret_s32_f32_x2(...) __builtin_sve_reinterpret_s32_f32_x2(__VA_ARGS__)
#define svreinterpret_s32_f64_x2(...) __builtin_sve_reinterpret_s32_f64_x2(__VA_ARGS__)
#define svreinterpret_u32_s8_x2(...) __builtin_sve_reinterpret_u32_s8_x2(__VA_ARGS__)
#define svreinterpret_u32_u8_x2(...) __builtin_sve_reinterpret_u32_u8_x2(__VA_ARGS__)
#define svreinterpret_u32_s16_x2(...) __builtin_sve_reinterpret_u32_s16_x2(__VA_ARGS__)
#define svreinterpret_u32_u16_x2(...) __builtin_sve_reinterpret_u32_u16_x2(__VA_ARGS__)
#define svreinterpret_u32_s32_x2(...) __builtin_sve_reinterpret_u32_s32_x2(__VA_ARGS__)
#define svreinterpret_u32_u32_x2(...) __builtin_sve_reinterpret_u32_u32_x2(__VA_ARGS__)
#define svreinterpret_u32_s64_x2(...) __builtin_sve_reinterpret_u32_s64_x2(__VA_ARGS__)
#define svreinterpret_u32_u64_x2(...) __builtin_sve_reinterpret_u32_u64_x2(__VA_ARGS__)
#define svreinterpret_u32_f16_x2(...) __builtin_sve_reinterpret_u32_f16_x2(__VA_ARGS__)
#define svreinterpret_u32_bf16_x2(...) __builtin_sve_reinterpret_u32_bf16_x2(__VA_ARGS__)
#define svreinterpret_u32_f32_x2(...) __builtin_sve_reinterpret_u32_f32_x2(__VA_ARGS__)
#define svreinterpret_u32_f64_x2(...) __builtin_sve_reinterpret_u32_f64_x2(__VA_ARGS__)
#define svreinterpret_s64_s8_x2(...) __builtin_sve_reinterpret_s64_s8_x2(__VA_ARGS__)
#define svreinterpret_s64_u8_x2(...) __builtin_sve_reinterpret_s64_u8_x2(__VA_ARGS__)
#define svreinterpret_s64_s16_x2(...) __builtin_sve_reinterpret_s64_s16_x2(__VA_ARGS__)
#define svreinterpret_s64_u16_x2(...) __builtin_sve_reinterpret_s64_u16_x2(__VA_ARGS__)
#define svreinterpret_s64_s32_x2(...) __builtin_sve_reinterpret_s64_s32_x2(__VA_ARGS__)
#define svreinterpret_s64_u32_x2(...) __builtin_sve_reinterpret_s64_u32_x2(__VA_ARGS__)
#define svreinterpret_s64_s64_x2(...) __builtin_sve_reinterpret_s64_s64_x2(__VA_ARGS__)
#define svreinterpret_s64_u64_x2(...) __builtin_sve_reinterpret_s64_u64_x2(__VA_ARGS__)
#define svreinterpret_s64_f16_x2(...) __builtin_sve_reinterpret_s64_f16_x2(__VA_ARGS__)
#define svreinterpret_s64_bf16_x2(...) __builtin_sve_reinterpret_s64_bf16_x2(__VA_ARGS__)
#define svreinterpret_s64_f32_x2(...) __builtin_sve_reinterpret_s64_f32_x2(__VA_ARGS__)
#define svreinterpret_s64_f64_x2(...) __builtin_sve_reinterpret_s64_f64_x2(__VA_ARGS__)
#define svreinterpret_u64_s8_x2(...) __builtin_sve_reinterpret_u64_s8_x2(__VA_ARGS__)
#define svreinterpret_u64_u8_x2(...) __builtin_sve_reinterpret_u64_u8_x2(__VA_ARGS__)
#define svreinterpret_u64_s16_x2(...) __builtin_sve_reinterpret_u64_s16_x2(__VA_ARGS__)
#define svreinterpret_u64_u16_x2(...) __builtin_sve_reinterpret_u64_u16_x2(__VA_ARGS__)
#define svreinterpret_u64_s32_x2(...) __builtin_sve_reinterpret_u64_s32_x2(__VA_ARGS__)
#define svreinterpret_u64_u32_x2(...) __builtin_sve_reinterpret_u64_u32_x2(__VA_ARGS__)
#define svreinterpret_u64_s64_x2(...) __builtin_sve_reinterpret_u64_s64_x2(__VA_ARGS__)
#define svreinterpret_u64_u64_x2(...) __builtin_sve_reinterpret_u64_u64_x2(__VA_ARGS__)
#define svreinterpret_u64_f16_x2(...) __builtin_sve_reinterpret_u64_f16_x2(__VA_ARGS__)
#define svreinterpret_u64_bf16_x2(...) __builtin_sve_reinterpret_u64_bf16_x2(__VA_ARGS__)
#define svreinterpret_u64_f32_x2(...) __builtin_sve_reinterpret_u64_f32_x2(__VA_ARGS__)
#define svreinterpret_u64_f64_x2(...) __builtin_sve_reinterpret_u64_f64_x2(__VA_ARGS__)
#define svreinterpret_f16_s8_x2(...) __builtin_sve_reinterpret_f16_s8_x2(__VA_ARGS__)
#define svreinterpret_f16_u8_x2(...) __builtin_sve_reinterpret_f16_u8_x2(__VA_ARGS__)
#define svreinterpret_f16_s16_x2(...) __builtin_sve_reinterpret_f16_s16_x2(__VA_ARGS__)
#define svreinterpret_f16_u16_x2(...) __builtin_sve_reinterpret_f16_u16_x2(__VA_ARGS__)
#define svreinterpret_f16_s32_x2(...) __builtin_sve_reinterpret_f16_s32_x2(__VA_ARGS__)
#define svreinterpret_f16_u32_x2(...) __builtin_sve_reinterpret_f16_u32_x2(__VA_ARGS__)
#define svreinterpret_f16_s64_x2(...) __builtin_sve_reinterpret_f16_s64_x2(__VA_ARGS__)
#define svreinterpret_f16_u64_x2(...) __builtin_sve_reinterpret_f16_u64_x2(__VA_ARGS__)
#define svreinterpret_f16_f16_x2(...) __builtin_sve_reinterpret_f16_f16_x2(__VA_ARGS__)
#define svreinterpret_f16_bf16_x2(...) __builtin_sve_reinterpret_f16_bf16_x2(__VA_ARGS__)
#define svreinterpret_f16_f32_x2(...) __builtin_sve_reinterpret_f16_f32_x2(__VA_ARGS__)
#define svreinterpret_f16_f64_x2(...) __builtin_sve_reinterpret_f16_f64_x2(__VA_ARGS__)
#define svreinterpret_bf16_s8_x2(...) __builtin_sve_reinterpret_bf16_s8_x2(__VA_ARGS__)
#define svreinterpret_bf16_u8_x2(...) __builtin_sve_reinterpret_bf16_u8_x2(__VA_ARGS__)
#define svreinterpret_bf16_s16_x2(...) __builtin_sve_reinterpret_bf16_s16_x2(__VA_ARGS__)
#define svreinterpret_bf16_u16_x2(...) __builtin_sve_reinterpret_bf16_u16_x2(__VA_ARGS__)
#define svreinterpret_bf16_s32_x2(...) __builtin_sve_reinterpret_bf16_s32_x2(__VA_ARGS__)
#define svreinterpret_bf16_u32_x2(...) __builtin_sve_reinterpret_bf16_u32_x2(__VA_ARGS__)
#define svreinterpret_bf16_s64_x2(...) __builtin_sve_reinterpret_bf16_s64_x2(__VA_ARGS__)
#define svreinterpret_bf16_u64_x2(...) __builtin_sve_reinterpret_bf16_u64_x2(__VA_ARGS__)
#define svreinterpret_bf16_f16_x2(...) __builtin_sve_reinterpret_bf16_f16_x2(__VA_ARGS__)
#define svreinterpret_bf16_bf16_x2(...) __builtin_sve_reinterpret_bf16_bf16_x2(__VA_ARGS__)
#define svreinterpret_bf16_f32_x2(...) __builtin_sve_reinterpret_bf16_f32_x2(__VA_ARGS__)
#define svreinterpret_bf16_f64_x2(...) __builtin_sve_reinterpret_bf16_f64_x2(__VA_ARGS__)
#define svreinterpret_f32_s8_x2(...) __builtin_sve_reinterpret_f32_s8_x2(__VA_ARGS__)
#define svreinterpret_f32_u8_x2(...) __builtin_sve_reinterpret_f32_u8_x2(__VA_ARGS__)
#define svreinterpret_f32_s16_x2(...) __builtin_sve_reinterpret_f32_s16_x2(__VA_ARGS__)
#define svreinterpret_f32_u16_x2(...) __builtin_sve_reinterpret_f32_u16_x2(__VA_ARGS__)
#define svreinterpret_f32_s32_x2(...) __builtin_sve_reinterpret_f32_s32_x2(__VA_ARGS__)
#define svreinterpret_f32_u32_x2(...) __builtin_sve_reinterpret_f32_u32_x2(__VA_ARGS__)
#define svreinterpret_f32_s64_x2(...) __builtin_sve_reinterpret_f32_s64_x2(__VA_ARGS__)
#define svreinterpret_f32_u64_x2(...) __builtin_sve_reinterpret_f32_u64_x2(__VA_ARGS__)
#define svreinterpret_f32_f16_x2(...) __builtin_sve_reinterpret_f32_f16_x2(__VA_ARGS__)
#define svreinterpret_f32_bf16_x2(...) __builtin_sve_reinterpret_f32_bf16_x2(__VA_ARGS__)
#define svreinterpret_f32_f32_x2(...) __builtin_sve_reinterpret_f32_f32_x2(__VA_ARGS__)
#define svreinterpret_f32_f64_x2(...) __builtin_sve_reinterpret_f32_f64_x2(__VA_ARGS__)
#define svreinterpret_f64_s8_x2(...) __builtin_sve_reinterpret_f64_s8_x2(__VA_ARGS__)
#define svreinterpret_f64_u8_x2(...) __builtin_sve_reinterpret_f64_u8_x2(__VA_ARGS__)
#define svreinterpret_f64_s16_x2(...) __builtin_sve_reinterpret_f64_s16_x2(__VA_ARGS__)
#define svreinterpret_f64_u16_x2(...) __builtin_sve_reinterpret_f64_u16_x2(__VA_ARGS__)
#define svreinterpret_f64_s32_x2(...) __builtin_sve_reinterpret_f64_s32_x2(__VA_ARGS__)
#define svreinterpret_f64_u32_x2(...) __builtin_sve_reinterpret_f64_u32_x2(__VA_ARGS__)
#define svreinterpret_f64_s64_x2(...) __builtin_sve_reinterpret_f64_s64_x2(__VA_ARGS__)
#define svreinterpret_f64_u64_x2(...) __builtin_sve_reinterpret_f64_u64_x2(__VA_ARGS__)
#define svreinterpret_f64_f16_x2(...) __builtin_sve_reinterpret_f64_f16_x2(__VA_ARGS__)
#define svreinterpret_f64_bf16_x2(...) __builtin_sve_reinterpret_f64_bf16_x2(__VA_ARGS__)
#define svreinterpret_f64_f32_x2(...) __builtin_sve_reinterpret_f64_f32_x2(__VA_ARGS__)
#define svreinterpret_f64_f64_x2(...) __builtin_sve_reinterpret_f64_f64_x2(__VA_ARGS__)
__aio __attribute__((target("sve"))) svint8x2_t svreinterpret_s8(svint8x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_s8_x2(op);
}

__aio __attribute__((target("sve"))) svint8x2_t svreinterpret_s8(svuint8x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_u8_x2(op);
}

__aio __attribute__((target("sve"))) svint8x2_t svreinterpret_s8(svint16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_s16_x2(op);
}

__aio __attribute__((target("sve"))) svint8x2_t svreinterpret_s8(svuint16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_u16_x2(op);
}

__aio __attribute__((target("sve"))) svint8x2_t svreinterpret_s8(svint32x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_s32_x2(op);
}

__aio __attribute__((target("sve"))) svint8x2_t svreinterpret_s8(svuint32x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_u32_x2(op);
}

__aio __attribute__((target("sve"))) svint8x2_t svreinterpret_s8(svint64x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_s64_x2(op);
}

__aio __attribute__((target("sve"))) svint8x2_t svreinterpret_s8(svuint64x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_u64_x2(op);
}

__aio __attribute__((target("sve"))) svint8x2_t svreinterpret_s8(svfloat16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_f16_x2(op);
}

__aio __attribute__((target("sve"))) svint8x2_t svreinterpret_s8(svbfloat16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_bf16_x2(op);
}

__aio __attribute__((target("sve"))) svint8x2_t svreinterpret_s8(svfloat32x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_f32_x2(op);
}

__aio __attribute__((target("sve"))) svint8x2_t svreinterpret_s8(svfloat64x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_f64_x2(op);
}

__aio __attribute__((target("sve"))) svuint8x2_t svreinterpret_u8(svint8x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_s8_x2(op);
}

__aio __attribute__((target("sve"))) svuint8x2_t svreinterpret_u8(svuint8x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_u8_x2(op);
}

__aio __attribute__((target("sve"))) svuint8x2_t svreinterpret_u8(svint16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_s16_x2(op);
}

__aio __attribute__((target("sve"))) svuint8x2_t svreinterpret_u8(svuint16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_u16_x2(op);
}

__aio __attribute__((target("sve"))) svuint8x2_t svreinterpret_u8(svint32x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_s32_x2(op);
}

__aio __attribute__((target("sve"))) svuint8x2_t svreinterpret_u8(svuint32x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_u32_x2(op);
}

__aio __attribute__((target("sve"))) svuint8x2_t svreinterpret_u8(svint64x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_s64_x2(op);
}

__aio __attribute__((target("sve"))) svuint8x2_t svreinterpret_u8(svuint64x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_u64_x2(op);
}

__aio __attribute__((target("sve"))) svuint8x2_t svreinterpret_u8(svfloat16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_f16_x2(op);
}

__aio __attribute__((target("sve"))) svuint8x2_t svreinterpret_u8(svbfloat16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_bf16_x2(op);
}

__aio __attribute__((target("sve"))) svuint8x2_t svreinterpret_u8(svfloat32x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_f32_x2(op);
}

__aio __attribute__((target("sve"))) svuint8x2_t svreinterpret_u8(svfloat64x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_f64_x2(op);
}

__aio __attribute__((target("sve"))) svint16x2_t svreinterpret_s16(svint8x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_s8_x2(op);
}

__aio __attribute__((target("sve"))) svint16x2_t svreinterpret_s16(svuint8x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_u8_x2(op);
}

__aio __attribute__((target("sve"))) svint16x2_t svreinterpret_s16(svint16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_s16_x2(op);
}

__aio __attribute__((target("sve"))) svint16x2_t svreinterpret_s16(svuint16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_u16_x2(op);
}

__aio __attribute__((target("sve"))) svint16x2_t svreinterpret_s16(svint32x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_s32_x2(op);
}

__aio __attribute__((target("sve"))) svint16x2_t svreinterpret_s16(svuint32x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_u32_x2(op);
}

__aio __attribute__((target("sve"))) svint16x2_t svreinterpret_s16(svint64x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_s64_x2(op);
}

__aio __attribute__((target("sve"))) svint16x2_t svreinterpret_s16(svuint64x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_u64_x2(op);
}

__aio __attribute__((target("sve"))) svint16x2_t svreinterpret_s16(svfloat16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_f16_x2(op);
}

__aio __attribute__((target("sve"))) svint16x2_t svreinterpret_s16(svbfloat16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_bf16_x2(op);
}

__aio __attribute__((target("sve"))) svint16x2_t svreinterpret_s16(svfloat32x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_f32_x2(op);
}

__aio __attribute__((target("sve"))) svint16x2_t svreinterpret_s16(svfloat64x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_f64_x2(op);
}

__aio __attribute__((target("sve"))) svuint16x2_t svreinterpret_u16(svint8x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_s8_x2(op);
}

__aio __attribute__((target("sve"))) svuint16x2_t svreinterpret_u16(svuint8x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_u8_x2(op);
}

__aio __attribute__((target("sve"))) svuint16x2_t svreinterpret_u16(svint16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_s16_x2(op);
}

__aio __attribute__((target("sve"))) svuint16x2_t svreinterpret_u16(svuint16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_u16_x2(op);
}

__aio __attribute__((target("sve"))) svuint16x2_t svreinterpret_u16(svint32x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_s32_x2(op);
}

__aio __attribute__((target("sve"))) svuint16x2_t svreinterpret_u16(svuint32x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_u32_x2(op);
}

__aio __attribute__((target("sve"))) svuint16x2_t svreinterpret_u16(svint64x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_s64_x2(op);
}

__aio __attribute__((target("sve"))) svuint16x2_t svreinterpret_u16(svuint64x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_u64_x2(op);
}

__aio __attribute__((target("sve"))) svuint16x2_t svreinterpret_u16(svfloat16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_f16_x2(op);
}

__aio __attribute__((target("sve"))) svuint16x2_t svreinterpret_u16(svbfloat16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_bf16_x2(op);
}

__aio __attribute__((target("sve"))) svuint16x2_t svreinterpret_u16(svfloat32x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_f32_x2(op);
}

__aio __attribute__((target("sve"))) svuint16x2_t svreinterpret_u16(svfloat64x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_f64_x2(op);
}

__aio __attribute__((target("sve"))) svint32x2_t svreinterpret_s32(svint8x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_s8_x2(op);
}

__aio __attribute__((target("sve"))) svint32x2_t svreinterpret_s32(svuint8x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_u8_x2(op);
}

__aio __attribute__((target("sve"))) svint32x2_t svreinterpret_s32(svint16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_s16_x2(op);
}

__aio __attribute__((target("sve"))) svint32x2_t svreinterpret_s32(svuint16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_u16_x2(op);
}

__aio __attribute__((target("sve"))) svint32x2_t svreinterpret_s32(svint32x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_s32_x2(op);
}

__aio __attribute__((target("sve"))) svint32x2_t svreinterpret_s32(svuint32x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_u32_x2(op);
}

__aio __attribute__((target("sve"))) svint32x2_t svreinterpret_s32(svint64x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_s64_x2(op);
}

__aio __attribute__((target("sve"))) svint32x2_t svreinterpret_s32(svuint64x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_u64_x2(op);
}

__aio __attribute__((target("sve"))) svint32x2_t svreinterpret_s32(svfloat16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_f16_x2(op);
}

__aio __attribute__((target("sve"))) svint32x2_t svreinterpret_s32(svbfloat16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_bf16_x2(op);
}

__aio __attribute__((target("sve"))) svint32x2_t svreinterpret_s32(svfloat32x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_f32_x2(op);
}

__aio __attribute__((target("sve"))) svint32x2_t svreinterpret_s32(svfloat64x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_f64_x2(op);
}

__aio __attribute__((target("sve"))) svuint32x2_t svreinterpret_u32(svint8x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_s8_x2(op);
}

__aio __attribute__((target("sve"))) svuint32x2_t svreinterpret_u32(svuint8x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_u8_x2(op);
}

__aio __attribute__((target("sve"))) svuint32x2_t svreinterpret_u32(svint16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_s16_x2(op);
}

__aio __attribute__((target("sve"))) svuint32x2_t svreinterpret_u32(svuint16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_u16_x2(op);
}

__aio __attribute__((target("sve"))) svuint32x2_t svreinterpret_u32(svint32x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_s32_x2(op);
}

__aio __attribute__((target("sve"))) svuint32x2_t svreinterpret_u32(svuint32x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_u32_x2(op);
}

__aio __attribute__((target("sve"))) svuint32x2_t svreinterpret_u32(svint64x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_s64_x2(op);
}

__aio __attribute__((target("sve"))) svuint32x2_t svreinterpret_u32(svuint64x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_u64_x2(op);
}

__aio __attribute__((target("sve"))) svuint32x2_t svreinterpret_u32(svfloat16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_f16_x2(op);
}

__aio __attribute__((target("sve"))) svuint32x2_t svreinterpret_u32(svbfloat16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_bf16_x2(op);
}

__aio __attribute__((target("sve"))) svuint32x2_t svreinterpret_u32(svfloat32x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_f32_x2(op);
}

__aio __attribute__((target("sve"))) svuint32x2_t svreinterpret_u32(svfloat64x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_f64_x2(op);
}

__aio __attribute__((target("sve"))) svint64x2_t svreinterpret_s64(svint8x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_s8_x2(op);
}

__aio __attribute__((target("sve"))) svint64x2_t svreinterpret_s64(svuint8x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_u8_x2(op);
}

__aio __attribute__((target("sve"))) svint64x2_t svreinterpret_s64(svint16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_s16_x2(op);
}

__aio __attribute__((target("sve"))) svint64x2_t svreinterpret_s64(svuint16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_u16_x2(op);
}

__aio __attribute__((target("sve"))) svint64x2_t svreinterpret_s64(svint32x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_s32_x2(op);
}

__aio __attribute__((target("sve"))) svint64x2_t svreinterpret_s64(svuint32x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_u32_x2(op);
}

__aio __attribute__((target("sve"))) svint64x2_t svreinterpret_s64(svint64x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_s64_x2(op);
}

__aio __attribute__((target("sve"))) svint64x2_t svreinterpret_s64(svuint64x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_u64_x2(op);
}

__aio __attribute__((target("sve"))) svint64x2_t svreinterpret_s64(svfloat16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_f16_x2(op);
}

__aio __attribute__((target("sve"))) svint64x2_t svreinterpret_s64(svbfloat16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_bf16_x2(op);
}

__aio __attribute__((target("sve"))) svint64x2_t svreinterpret_s64(svfloat32x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_f32_x2(op);
}

__aio __attribute__((target("sve"))) svint64x2_t svreinterpret_s64(svfloat64x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_f64_x2(op);
}

__aio __attribute__((target("sve"))) svuint64x2_t svreinterpret_u64(svint8x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_s8_x2(op);
}

__aio __attribute__((target("sve"))) svuint64x2_t svreinterpret_u64(svuint8x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_u8_x2(op);
}

__aio __attribute__((target("sve"))) svuint64x2_t svreinterpret_u64(svint16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_s16_x2(op);
}

__aio __attribute__((target("sve"))) svuint64x2_t svreinterpret_u64(svuint16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_u16_x2(op);
}

__aio __attribute__((target("sve"))) svuint64x2_t svreinterpret_u64(svint32x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_s32_x2(op);
}

__aio __attribute__((target("sve"))) svuint64x2_t svreinterpret_u64(svuint32x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_u32_x2(op);
}

__aio __attribute__((target("sve"))) svuint64x2_t svreinterpret_u64(svint64x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_s64_x2(op);
}

__aio __attribute__((target("sve"))) svuint64x2_t svreinterpret_u64(svuint64x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_u64_x2(op);
}

__aio __attribute__((target("sve"))) svuint64x2_t svreinterpret_u64(svfloat16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_f16_x2(op);
}

__aio __attribute__((target("sve"))) svuint64x2_t svreinterpret_u64(svbfloat16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_bf16_x2(op);
}

__aio __attribute__((target("sve"))) svuint64x2_t svreinterpret_u64(svfloat32x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_f32_x2(op);
}

__aio __attribute__((target("sve"))) svuint64x2_t svreinterpret_u64(svfloat64x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_f64_x2(op);
}

__aio __attribute__((target("sve"))) svfloat16x2_t svreinterpret_f16(svint8x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_s8_x2(op);
}

__aio __attribute__((target("sve"))) svfloat16x2_t svreinterpret_f16(svuint8x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_u8_x2(op);
}

__aio __attribute__((target("sve"))) svfloat16x2_t svreinterpret_f16(svint16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_s16_x2(op);
}

__aio __attribute__((target("sve"))) svfloat16x2_t svreinterpret_f16(svuint16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_u16_x2(op);
}

__aio __attribute__((target("sve"))) svfloat16x2_t svreinterpret_f16(svint32x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_s32_x2(op);
}

__aio __attribute__((target("sve"))) svfloat16x2_t svreinterpret_f16(svuint32x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_u32_x2(op);
}

__aio __attribute__((target("sve"))) svfloat16x2_t svreinterpret_f16(svint64x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_s64_x2(op);
}

__aio __attribute__((target("sve"))) svfloat16x2_t svreinterpret_f16(svuint64x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_u64_x2(op);
}

__aio __attribute__((target("sve"))) svfloat16x2_t svreinterpret_f16(svfloat16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_f16_x2(op);
}

__aio __attribute__((target("sve"))) svfloat16x2_t svreinterpret_f16(svbfloat16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_bf16_x2(op);
}

__aio __attribute__((target("sve"))) svfloat16x2_t svreinterpret_f16(svfloat32x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_f32_x2(op);
}

__aio __attribute__((target("sve"))) svfloat16x2_t svreinterpret_f16(svfloat64x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_f64_x2(op);
}

__aio __attribute__((target("sve"))) svbfloat16x2_t svreinterpret_bf16(svint8x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_s8_x2(op);
}

__aio __attribute__((target("sve"))) svbfloat16x2_t svreinterpret_bf16(svuint8x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_u8_x2(op);
}

__aio __attribute__((target("sve"))) svbfloat16x2_t svreinterpret_bf16(svint16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_s16_x2(op);
}

__aio __attribute__((target("sve"))) svbfloat16x2_t svreinterpret_bf16(svuint16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_u16_x2(op);
}

__aio __attribute__((target("sve"))) svbfloat16x2_t svreinterpret_bf16(svint32x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_s32_x2(op);
}

__aio __attribute__((target("sve"))) svbfloat16x2_t svreinterpret_bf16(svuint32x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_u32_x2(op);
}

__aio __attribute__((target("sve"))) svbfloat16x2_t svreinterpret_bf16(svint64x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_s64_x2(op);
}

__aio __attribute__((target("sve"))) svbfloat16x2_t svreinterpret_bf16(svuint64x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_u64_x2(op);
}

__aio __attribute__((target("sve"))) svbfloat16x2_t svreinterpret_bf16(svfloat16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_f16_x2(op);
}

__aio __attribute__((target("sve"))) svbfloat16x2_t svreinterpret_bf16(svbfloat16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_bf16_x2(op);
}

__aio __attribute__((target("sve"))) svbfloat16x2_t svreinterpret_bf16(svfloat32x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_f32_x2(op);
}

__aio __attribute__((target("sve"))) svbfloat16x2_t svreinterpret_bf16(svfloat64x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_f64_x2(op);
}

__aio __attribute__((target("sve"))) svfloat32x2_t svreinterpret_f32(svint8x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_s8_x2(op);
}

__aio __attribute__((target("sve"))) svfloat32x2_t svreinterpret_f32(svuint8x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_u8_x2(op);
}

__aio __attribute__((target("sve"))) svfloat32x2_t svreinterpret_f32(svint16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_s16_x2(op);
}

__aio __attribute__((target("sve"))) svfloat32x2_t svreinterpret_f32(svuint16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_u16_x2(op);
}

__aio __attribute__((target("sve"))) svfloat32x2_t svreinterpret_f32(svint32x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_s32_x2(op);
}

__aio __attribute__((target("sve"))) svfloat32x2_t svreinterpret_f32(svuint32x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_u32_x2(op);
}

__aio __attribute__((target("sve"))) svfloat32x2_t svreinterpret_f32(svint64x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_s64_x2(op);
}

__aio __attribute__((target("sve"))) svfloat32x2_t svreinterpret_f32(svuint64x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_u64_x2(op);
}

__aio __attribute__((target("sve"))) svfloat32x2_t svreinterpret_f32(svfloat16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_f16_x2(op);
}

__aio __attribute__((target("sve"))) svfloat32x2_t svreinterpret_f32(svbfloat16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_bf16_x2(op);
}

__aio __attribute__((target("sve"))) svfloat32x2_t svreinterpret_f32(svfloat32x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_f32_x2(op);
}

__aio __attribute__((target("sve"))) svfloat32x2_t svreinterpret_f32(svfloat64x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_f64_x2(op);
}

__aio __attribute__((target("sve"))) svfloat64x2_t svreinterpret_f64(svint8x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_s8_x2(op);
}

__aio __attribute__((target("sve"))) svfloat64x2_t svreinterpret_f64(svuint8x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_u8_x2(op);
}

__aio __attribute__((target("sve"))) svfloat64x2_t svreinterpret_f64(svint16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_s16_x2(op);
}

__aio __attribute__((target("sve"))) svfloat64x2_t svreinterpret_f64(svuint16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_u16_x2(op);
}

__aio __attribute__((target("sve"))) svfloat64x2_t svreinterpret_f64(svint32x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_s32_x2(op);
}

__aio __attribute__((target("sve"))) svfloat64x2_t svreinterpret_f64(svuint32x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_u32_x2(op);
}

__aio __attribute__((target("sve"))) svfloat64x2_t svreinterpret_f64(svint64x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_s64_x2(op);
}

__aio __attribute__((target("sve"))) svfloat64x2_t svreinterpret_f64(svuint64x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_u64_x2(op);
}

__aio __attribute__((target("sve"))) svfloat64x2_t svreinterpret_f64(svfloat16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_f16_x2(op);
}

__aio __attribute__((target("sve"))) svfloat64x2_t svreinterpret_f64(svbfloat16x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_bf16_x2(op);
}

__aio __attribute__((target("sve"))) svfloat64x2_t svreinterpret_f64(svfloat32x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_f32_x2(op);
}

__aio __attribute__((target("sve"))) svfloat64x2_t svreinterpret_f64(svfloat64x2_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_f64_x2(op);
}

#define svreinterpret_s8_s8_x3(...) __builtin_sve_reinterpret_s8_s8_x3(__VA_ARGS__)
#define svreinterpret_s8_u8_x3(...) __builtin_sve_reinterpret_s8_u8_x3(__VA_ARGS__)
#define svreinterpret_s8_s16_x3(...) __builtin_sve_reinterpret_s8_s16_x3(__VA_ARGS__)
#define svreinterpret_s8_u16_x3(...) __builtin_sve_reinterpret_s8_u16_x3(__VA_ARGS__)
#define svreinterpret_s8_s32_x3(...) __builtin_sve_reinterpret_s8_s32_x3(__VA_ARGS__)
#define svreinterpret_s8_u32_x3(...) __builtin_sve_reinterpret_s8_u32_x3(__VA_ARGS__)
#define svreinterpret_s8_s64_x3(...) __builtin_sve_reinterpret_s8_s64_x3(__VA_ARGS__)
#define svreinterpret_s8_u64_x3(...) __builtin_sve_reinterpret_s8_u64_x3(__VA_ARGS__)
#define svreinterpret_s8_f16_x3(...) __builtin_sve_reinterpret_s8_f16_x3(__VA_ARGS__)
#define svreinterpret_s8_bf16_x3(...) __builtin_sve_reinterpret_s8_bf16_x3(__VA_ARGS__)
#define svreinterpret_s8_f32_x3(...) __builtin_sve_reinterpret_s8_f32_x3(__VA_ARGS__)
#define svreinterpret_s8_f64_x3(...) __builtin_sve_reinterpret_s8_f64_x3(__VA_ARGS__)
#define svreinterpret_u8_s8_x3(...) __builtin_sve_reinterpret_u8_s8_x3(__VA_ARGS__)
#define svreinterpret_u8_u8_x3(...) __builtin_sve_reinterpret_u8_u8_x3(__VA_ARGS__)
#define svreinterpret_u8_s16_x3(...) __builtin_sve_reinterpret_u8_s16_x3(__VA_ARGS__)
#define svreinterpret_u8_u16_x3(...) __builtin_sve_reinterpret_u8_u16_x3(__VA_ARGS__)
#define svreinterpret_u8_s32_x3(...) __builtin_sve_reinterpret_u8_s32_x3(__VA_ARGS__)
#define svreinterpret_u8_u32_x3(...) __builtin_sve_reinterpret_u8_u32_x3(__VA_ARGS__)
#define svreinterpret_u8_s64_x3(...) __builtin_sve_reinterpret_u8_s64_x3(__VA_ARGS__)
#define svreinterpret_u8_u64_x3(...) __builtin_sve_reinterpret_u8_u64_x3(__VA_ARGS__)
#define svreinterpret_u8_f16_x3(...) __builtin_sve_reinterpret_u8_f16_x3(__VA_ARGS__)
#define svreinterpret_u8_bf16_x3(...) __builtin_sve_reinterpret_u8_bf16_x3(__VA_ARGS__)
#define svreinterpret_u8_f32_x3(...) __builtin_sve_reinterpret_u8_f32_x3(__VA_ARGS__)
#define svreinterpret_u8_f64_x3(...) __builtin_sve_reinterpret_u8_f64_x3(__VA_ARGS__)
#define svreinterpret_s16_s8_x3(...) __builtin_sve_reinterpret_s16_s8_x3(__VA_ARGS__)
#define svreinterpret_s16_u8_x3(...) __builtin_sve_reinterpret_s16_u8_x3(__VA_ARGS__)
#define svreinterpret_s16_s16_x3(...) __builtin_sve_reinterpret_s16_s16_x3(__VA_ARGS__)
#define svreinterpret_s16_u16_x3(...) __builtin_sve_reinterpret_s16_u16_x3(__VA_ARGS__)
#define svreinterpret_s16_s32_x3(...) __builtin_sve_reinterpret_s16_s32_x3(__VA_ARGS__)
#define svreinterpret_s16_u32_x3(...) __builtin_sve_reinterpret_s16_u32_x3(__VA_ARGS__)
#define svreinterpret_s16_s64_x3(...) __builtin_sve_reinterpret_s16_s64_x3(__VA_ARGS__)
#define svreinterpret_s16_u64_x3(...) __builtin_sve_reinterpret_s16_u64_x3(__VA_ARGS__)
#define svreinterpret_s16_f16_x3(...) __builtin_sve_reinterpret_s16_f16_x3(__VA_ARGS__)
#define svreinterpret_s16_bf16_x3(...) __builtin_sve_reinterpret_s16_bf16_x3(__VA_ARGS__)
#define svreinterpret_s16_f32_x3(...) __builtin_sve_reinterpret_s16_f32_x3(__VA_ARGS__)
#define svreinterpret_s16_f64_x3(...) __builtin_sve_reinterpret_s16_f64_x3(__VA_ARGS__)
#define svreinterpret_u16_s8_x3(...) __builtin_sve_reinterpret_u16_s8_x3(__VA_ARGS__)
#define svreinterpret_u16_u8_x3(...) __builtin_sve_reinterpret_u16_u8_x3(__VA_ARGS__)
#define svreinterpret_u16_s16_x3(...) __builtin_sve_reinterpret_u16_s16_x3(__VA_ARGS__)
#define svreinterpret_u16_u16_x3(...) __builtin_sve_reinterpret_u16_u16_x3(__VA_ARGS__)
#define svreinterpret_u16_s32_x3(...) __builtin_sve_reinterpret_u16_s32_x3(__VA_ARGS__)
#define svreinterpret_u16_u32_x3(...) __builtin_sve_reinterpret_u16_u32_x3(__VA_ARGS__)
#define svreinterpret_u16_s64_x3(...) __builtin_sve_reinterpret_u16_s64_x3(__VA_ARGS__)
#define svreinterpret_u16_u64_x3(...) __builtin_sve_reinterpret_u16_u64_x3(__VA_ARGS__)
#define svreinterpret_u16_f16_x3(...) __builtin_sve_reinterpret_u16_f16_x3(__VA_ARGS__)
#define svreinterpret_u16_bf16_x3(...) __builtin_sve_reinterpret_u16_bf16_x3(__VA_ARGS__)
#define svreinterpret_u16_f32_x3(...) __builtin_sve_reinterpret_u16_f32_x3(__VA_ARGS__)
#define svreinterpret_u16_f64_x3(...) __builtin_sve_reinterpret_u16_f64_x3(__VA_ARGS__)
#define svreinterpret_s32_s8_x3(...) __builtin_sve_reinterpret_s32_s8_x3(__VA_ARGS__)
#define svreinterpret_s32_u8_x3(...) __builtin_sve_reinterpret_s32_u8_x3(__VA_ARGS__)
#define svreinterpret_s32_s16_x3(...) __builtin_sve_reinterpret_s32_s16_x3(__VA_ARGS__)
#define svreinterpret_s32_u16_x3(...) __builtin_sve_reinterpret_s32_u16_x3(__VA_ARGS__)
#define svreinterpret_s32_s32_x3(...) __builtin_sve_reinterpret_s32_s32_x3(__VA_ARGS__)
#define svreinterpret_s32_u32_x3(...) __builtin_sve_reinterpret_s32_u32_x3(__VA_ARGS__)
#define svreinterpret_s32_s64_x3(...) __builtin_sve_reinterpret_s32_s64_x3(__VA_ARGS__)
#define svreinterpret_s32_u64_x3(...) __builtin_sve_reinterpret_s32_u64_x3(__VA_ARGS__)
#define svreinterpret_s32_f16_x3(...) __builtin_sve_reinterpret_s32_f16_x3(__VA_ARGS__)
#define svreinterpret_s32_bf16_x3(...) __builtin_sve_reinterpret_s32_bf16_x3(__VA_ARGS__)
#define svreinterpret_s32_f32_x3(...) __builtin_sve_reinterpret_s32_f32_x3(__VA_ARGS__)
#define svreinterpret_s32_f64_x3(...) __builtin_sve_reinterpret_s32_f64_x3(__VA_ARGS__)
#define svreinterpret_u32_s8_x3(...) __builtin_sve_reinterpret_u32_s8_x3(__VA_ARGS__)
#define svreinterpret_u32_u8_x3(...) __builtin_sve_reinterpret_u32_u8_x3(__VA_ARGS__)
#define svreinterpret_u32_s16_x3(...) __builtin_sve_reinterpret_u32_s16_x3(__VA_ARGS__)
#define svreinterpret_u32_u16_x3(...) __builtin_sve_reinterpret_u32_u16_x3(__VA_ARGS__)
#define svreinterpret_u32_s32_x3(...) __builtin_sve_reinterpret_u32_s32_x3(__VA_ARGS__)
#define svreinterpret_u32_u32_x3(...) __builtin_sve_reinterpret_u32_u32_x3(__VA_ARGS__)
#define svreinterpret_u32_s64_x3(...) __builtin_sve_reinterpret_u32_s64_x3(__VA_ARGS__)
#define svreinterpret_u32_u64_x3(...) __builtin_sve_reinterpret_u32_u64_x3(__VA_ARGS__)
#define svreinterpret_u32_f16_x3(...) __builtin_sve_reinterpret_u32_f16_x3(__VA_ARGS__)
#define svreinterpret_u32_bf16_x3(...) __builtin_sve_reinterpret_u32_bf16_x3(__VA_ARGS__)
#define svreinterpret_u32_f32_x3(...) __builtin_sve_reinterpret_u32_f32_x3(__VA_ARGS__)
#define svreinterpret_u32_f64_x3(...) __builtin_sve_reinterpret_u32_f64_x3(__VA_ARGS__)
#define svreinterpret_s64_s8_x3(...) __builtin_sve_reinterpret_s64_s8_x3(__VA_ARGS__)
#define svreinterpret_s64_u8_x3(...) __builtin_sve_reinterpret_s64_u8_x3(__VA_ARGS__)
#define svreinterpret_s64_s16_x3(...) __builtin_sve_reinterpret_s64_s16_x3(__VA_ARGS__)
#define svreinterpret_s64_u16_x3(...) __builtin_sve_reinterpret_s64_u16_x3(__VA_ARGS__)
#define svreinterpret_s64_s32_x3(...) __builtin_sve_reinterpret_s64_s32_x3(__VA_ARGS__)
#define svreinterpret_s64_u32_x3(...) __builtin_sve_reinterpret_s64_u32_x3(__VA_ARGS__)
#define svreinterpret_s64_s64_x3(...) __builtin_sve_reinterpret_s64_s64_x3(__VA_ARGS__)
#define svreinterpret_s64_u64_x3(...) __builtin_sve_reinterpret_s64_u64_x3(__VA_ARGS__)
#define svreinterpret_s64_f16_x3(...) __builtin_sve_reinterpret_s64_f16_x3(__VA_ARGS__)
#define svreinterpret_s64_bf16_x3(...) __builtin_sve_reinterpret_s64_bf16_x3(__VA_ARGS__)
#define svreinterpret_s64_f32_x3(...) __builtin_sve_reinterpret_s64_f32_x3(__VA_ARGS__)
#define svreinterpret_s64_f64_x3(...) __builtin_sve_reinterpret_s64_f64_x3(__VA_ARGS__)
#define svreinterpret_u64_s8_x3(...) __builtin_sve_reinterpret_u64_s8_x3(__VA_ARGS__)
#define svreinterpret_u64_u8_x3(...) __builtin_sve_reinterpret_u64_u8_x3(__VA_ARGS__)
#define svreinterpret_u64_s16_x3(...) __builtin_sve_reinterpret_u64_s16_x3(__VA_ARGS__)
#define svreinterpret_u64_u16_x3(...) __builtin_sve_reinterpret_u64_u16_x3(__VA_ARGS__)
#define svreinterpret_u64_s32_x3(...) __builtin_sve_reinterpret_u64_s32_x3(__VA_ARGS__)
#define svreinterpret_u64_u32_x3(...) __builtin_sve_reinterpret_u64_u32_x3(__VA_ARGS__)
#define svreinterpret_u64_s64_x3(...) __builtin_sve_reinterpret_u64_s64_x3(__VA_ARGS__)
#define svreinterpret_u64_u64_x3(...) __builtin_sve_reinterpret_u64_u64_x3(__VA_ARGS__)
#define svreinterpret_u64_f16_x3(...) __builtin_sve_reinterpret_u64_f16_x3(__VA_ARGS__)
#define svreinterpret_u64_bf16_x3(...) __builtin_sve_reinterpret_u64_bf16_x3(__VA_ARGS__)
#define svreinterpret_u64_f32_x3(...) __builtin_sve_reinterpret_u64_f32_x3(__VA_ARGS__)
#define svreinterpret_u64_f64_x3(...) __builtin_sve_reinterpret_u64_f64_x3(__VA_ARGS__)
#define svreinterpret_f16_s8_x3(...) __builtin_sve_reinterpret_f16_s8_x3(__VA_ARGS__)
#define svreinterpret_f16_u8_x3(...) __builtin_sve_reinterpret_f16_u8_x3(__VA_ARGS__)
#define svreinterpret_f16_s16_x3(...) __builtin_sve_reinterpret_f16_s16_x3(__VA_ARGS__)
#define svreinterpret_f16_u16_x3(...) __builtin_sve_reinterpret_f16_u16_x3(__VA_ARGS__)
#define svreinterpret_f16_s32_x3(...) __builtin_sve_reinterpret_f16_s32_x3(__VA_ARGS__)
#define svreinterpret_f16_u32_x3(...) __builtin_sve_reinterpret_f16_u32_x3(__VA_ARGS__)
#define svreinterpret_f16_s64_x3(...) __builtin_sve_reinterpret_f16_s64_x3(__VA_ARGS__)
#define svreinterpret_f16_u64_x3(...) __builtin_sve_reinterpret_f16_u64_x3(__VA_ARGS__)
#define svreinterpret_f16_f16_x3(...) __builtin_sve_reinterpret_f16_f16_x3(__VA_ARGS__)
#define svreinterpret_f16_bf16_x3(...) __builtin_sve_reinterpret_f16_bf16_x3(__VA_ARGS__)
#define svreinterpret_f16_f32_x3(...) __builtin_sve_reinterpret_f16_f32_x3(__VA_ARGS__)
#define svreinterpret_f16_f64_x3(...) __builtin_sve_reinterpret_f16_f64_x3(__VA_ARGS__)
#define svreinterpret_bf16_s8_x3(...) __builtin_sve_reinterpret_bf16_s8_x3(__VA_ARGS__)
#define svreinterpret_bf16_u8_x3(...) __builtin_sve_reinterpret_bf16_u8_x3(__VA_ARGS__)
#define svreinterpret_bf16_s16_x3(...) __builtin_sve_reinterpret_bf16_s16_x3(__VA_ARGS__)
#define svreinterpret_bf16_u16_x3(...) __builtin_sve_reinterpret_bf16_u16_x3(__VA_ARGS__)
#define svreinterpret_bf16_s32_x3(...) __builtin_sve_reinterpret_bf16_s32_x3(__VA_ARGS__)
#define svreinterpret_bf16_u32_x3(...) __builtin_sve_reinterpret_bf16_u32_x3(__VA_ARGS__)
#define svreinterpret_bf16_s64_x3(...) __builtin_sve_reinterpret_bf16_s64_x3(__VA_ARGS__)
#define svreinterpret_bf16_u64_x3(...) __builtin_sve_reinterpret_bf16_u64_x3(__VA_ARGS__)
#define svreinterpret_bf16_f16_x3(...) __builtin_sve_reinterpret_bf16_f16_x3(__VA_ARGS__)
#define svreinterpret_bf16_bf16_x3(...) __builtin_sve_reinterpret_bf16_bf16_x3(__VA_ARGS__)
#define svreinterpret_bf16_f32_x3(...) __builtin_sve_reinterpret_bf16_f32_x3(__VA_ARGS__)
#define svreinterpret_bf16_f64_x3(...) __builtin_sve_reinterpret_bf16_f64_x3(__VA_ARGS__)
#define svreinterpret_f32_s8_x3(...) __builtin_sve_reinterpret_f32_s8_x3(__VA_ARGS__)
#define svreinterpret_f32_u8_x3(...) __builtin_sve_reinterpret_f32_u8_x3(__VA_ARGS__)
#define svreinterpret_f32_s16_x3(...) __builtin_sve_reinterpret_f32_s16_x3(__VA_ARGS__)
#define svreinterpret_f32_u16_x3(...) __builtin_sve_reinterpret_f32_u16_x3(__VA_ARGS__)
#define svreinterpret_f32_s32_x3(...) __builtin_sve_reinterpret_f32_s32_x3(__VA_ARGS__)
#define svreinterpret_f32_u32_x3(...) __builtin_sve_reinterpret_f32_u32_x3(__VA_ARGS__)
#define svreinterpret_f32_s64_x3(...) __builtin_sve_reinterpret_f32_s64_x3(__VA_ARGS__)
#define svreinterpret_f32_u64_x3(...) __builtin_sve_reinterpret_f32_u64_x3(__VA_ARGS__)
#define svreinterpret_f32_f16_x3(...) __builtin_sve_reinterpret_f32_f16_x3(__VA_ARGS__)
#define svreinterpret_f32_bf16_x3(...) __builtin_sve_reinterpret_f32_bf16_x3(__VA_ARGS__)
#define svreinterpret_f32_f32_x3(...) __builtin_sve_reinterpret_f32_f32_x3(__VA_ARGS__)
#define svreinterpret_f32_f64_x3(...) __builtin_sve_reinterpret_f32_f64_x3(__VA_ARGS__)
#define svreinterpret_f64_s8_x3(...) __builtin_sve_reinterpret_f64_s8_x3(__VA_ARGS__)
#define svreinterpret_f64_u8_x3(...) __builtin_sve_reinterpret_f64_u8_x3(__VA_ARGS__)
#define svreinterpret_f64_s16_x3(...) __builtin_sve_reinterpret_f64_s16_x3(__VA_ARGS__)
#define svreinterpret_f64_u16_x3(...) __builtin_sve_reinterpret_f64_u16_x3(__VA_ARGS__)
#define svreinterpret_f64_s32_x3(...) __builtin_sve_reinterpret_f64_s32_x3(__VA_ARGS__)
#define svreinterpret_f64_u32_x3(...) __builtin_sve_reinterpret_f64_u32_x3(__VA_ARGS__)
#define svreinterpret_f64_s64_x3(...) __builtin_sve_reinterpret_f64_s64_x3(__VA_ARGS__)
#define svreinterpret_f64_u64_x3(...) __builtin_sve_reinterpret_f64_u64_x3(__VA_ARGS__)
#define svreinterpret_f64_f16_x3(...) __builtin_sve_reinterpret_f64_f16_x3(__VA_ARGS__)
#define svreinterpret_f64_bf16_x3(...) __builtin_sve_reinterpret_f64_bf16_x3(__VA_ARGS__)
#define svreinterpret_f64_f32_x3(...) __builtin_sve_reinterpret_f64_f32_x3(__VA_ARGS__)
#define svreinterpret_f64_f64_x3(...) __builtin_sve_reinterpret_f64_f64_x3(__VA_ARGS__)
__aio __attribute__((target("sve"))) svint8x3_t svreinterpret_s8(svint8x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_s8_x3(op);
}

__aio __attribute__((target("sve"))) svint8x3_t svreinterpret_s8(svuint8x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_u8_x3(op);
}

__aio __attribute__((target("sve"))) svint8x3_t svreinterpret_s8(svint16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_s16_x3(op);
}

__aio __attribute__((target("sve"))) svint8x3_t svreinterpret_s8(svuint16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_u16_x3(op);
}

__aio __attribute__((target("sve"))) svint8x3_t svreinterpret_s8(svint32x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_s32_x3(op);
}

__aio __attribute__((target("sve"))) svint8x3_t svreinterpret_s8(svuint32x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_u32_x3(op);
}

__aio __attribute__((target("sve"))) svint8x3_t svreinterpret_s8(svint64x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_s64_x3(op);
}

__aio __attribute__((target("sve"))) svint8x3_t svreinterpret_s8(svuint64x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_u64_x3(op);
}

__aio __attribute__((target("sve"))) svint8x3_t svreinterpret_s8(svfloat16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_f16_x3(op);
}

__aio __attribute__((target("sve"))) svint8x3_t svreinterpret_s8(svbfloat16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_bf16_x3(op);
}

__aio __attribute__((target("sve"))) svint8x3_t svreinterpret_s8(svfloat32x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_f32_x3(op);
}

__aio __attribute__((target("sve"))) svint8x3_t svreinterpret_s8(svfloat64x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_f64_x3(op);
}

__aio __attribute__((target("sve"))) svuint8x3_t svreinterpret_u8(svint8x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_s8_x3(op);
}

__aio __attribute__((target("sve"))) svuint8x3_t svreinterpret_u8(svuint8x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_u8_x3(op);
}

__aio __attribute__((target("sve"))) svuint8x3_t svreinterpret_u8(svint16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_s16_x3(op);
}

__aio __attribute__((target("sve"))) svuint8x3_t svreinterpret_u8(svuint16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_u16_x3(op);
}

__aio __attribute__((target("sve"))) svuint8x3_t svreinterpret_u8(svint32x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_s32_x3(op);
}

__aio __attribute__((target("sve"))) svuint8x3_t svreinterpret_u8(svuint32x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_u32_x3(op);
}

__aio __attribute__((target("sve"))) svuint8x3_t svreinterpret_u8(svint64x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_s64_x3(op);
}

__aio __attribute__((target("sve"))) svuint8x3_t svreinterpret_u8(svuint64x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_u64_x3(op);
}

__aio __attribute__((target("sve"))) svuint8x3_t svreinterpret_u8(svfloat16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_f16_x3(op);
}

__aio __attribute__((target("sve"))) svuint8x3_t svreinterpret_u8(svbfloat16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_bf16_x3(op);
}

__aio __attribute__((target("sve"))) svuint8x3_t svreinterpret_u8(svfloat32x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_f32_x3(op);
}

__aio __attribute__((target("sve"))) svuint8x3_t svreinterpret_u8(svfloat64x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_f64_x3(op);
}

__aio __attribute__((target("sve"))) svint16x3_t svreinterpret_s16(svint8x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_s8_x3(op);
}

__aio __attribute__((target("sve"))) svint16x3_t svreinterpret_s16(svuint8x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_u8_x3(op);
}

__aio __attribute__((target("sve"))) svint16x3_t svreinterpret_s16(svint16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_s16_x3(op);
}

__aio __attribute__((target("sve"))) svint16x3_t svreinterpret_s16(svuint16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_u16_x3(op);
}

__aio __attribute__((target("sve"))) svint16x3_t svreinterpret_s16(svint32x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_s32_x3(op);
}

__aio __attribute__((target("sve"))) svint16x3_t svreinterpret_s16(svuint32x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_u32_x3(op);
}

__aio __attribute__((target("sve"))) svint16x3_t svreinterpret_s16(svint64x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_s64_x3(op);
}

__aio __attribute__((target("sve"))) svint16x3_t svreinterpret_s16(svuint64x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_u64_x3(op);
}

__aio __attribute__((target("sve"))) svint16x3_t svreinterpret_s16(svfloat16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_f16_x3(op);
}

__aio __attribute__((target("sve"))) svint16x3_t svreinterpret_s16(svbfloat16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_bf16_x3(op);
}

__aio __attribute__((target("sve"))) svint16x3_t svreinterpret_s16(svfloat32x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_f32_x3(op);
}

__aio __attribute__((target("sve"))) svint16x3_t svreinterpret_s16(svfloat64x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_f64_x3(op);
}

__aio __attribute__((target("sve"))) svuint16x3_t svreinterpret_u16(svint8x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_s8_x3(op);
}

__aio __attribute__((target("sve"))) svuint16x3_t svreinterpret_u16(svuint8x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_u8_x3(op);
}

__aio __attribute__((target("sve"))) svuint16x3_t svreinterpret_u16(svint16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_s16_x3(op);
}

__aio __attribute__((target("sve"))) svuint16x3_t svreinterpret_u16(svuint16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_u16_x3(op);
}

__aio __attribute__((target("sve"))) svuint16x3_t svreinterpret_u16(svint32x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_s32_x3(op);
}

__aio __attribute__((target("sve"))) svuint16x3_t svreinterpret_u16(svuint32x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_u32_x3(op);
}

__aio __attribute__((target("sve"))) svuint16x3_t svreinterpret_u16(svint64x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_s64_x3(op);
}

__aio __attribute__((target("sve"))) svuint16x3_t svreinterpret_u16(svuint64x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_u64_x3(op);
}

__aio __attribute__((target("sve"))) svuint16x3_t svreinterpret_u16(svfloat16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_f16_x3(op);
}

__aio __attribute__((target("sve"))) svuint16x3_t svreinterpret_u16(svbfloat16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_bf16_x3(op);
}

__aio __attribute__((target("sve"))) svuint16x3_t svreinterpret_u16(svfloat32x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_f32_x3(op);
}

__aio __attribute__((target("sve"))) svuint16x3_t svreinterpret_u16(svfloat64x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_f64_x3(op);
}

__aio __attribute__((target("sve"))) svint32x3_t svreinterpret_s32(svint8x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_s8_x3(op);
}

__aio __attribute__((target("sve"))) svint32x3_t svreinterpret_s32(svuint8x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_u8_x3(op);
}

__aio __attribute__((target("sve"))) svint32x3_t svreinterpret_s32(svint16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_s16_x3(op);
}

__aio __attribute__((target("sve"))) svint32x3_t svreinterpret_s32(svuint16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_u16_x3(op);
}

__aio __attribute__((target("sve"))) svint32x3_t svreinterpret_s32(svint32x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_s32_x3(op);
}

__aio __attribute__((target("sve"))) svint32x3_t svreinterpret_s32(svuint32x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_u32_x3(op);
}

__aio __attribute__((target("sve"))) svint32x3_t svreinterpret_s32(svint64x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_s64_x3(op);
}

__aio __attribute__((target("sve"))) svint32x3_t svreinterpret_s32(svuint64x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_u64_x3(op);
}

__aio __attribute__((target("sve"))) svint32x3_t svreinterpret_s32(svfloat16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_f16_x3(op);
}

__aio __attribute__((target("sve"))) svint32x3_t svreinterpret_s32(svbfloat16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_bf16_x3(op);
}

__aio __attribute__((target("sve"))) svint32x3_t svreinterpret_s32(svfloat32x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_f32_x3(op);
}

__aio __attribute__((target("sve"))) svint32x3_t svreinterpret_s32(svfloat64x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_f64_x3(op);
}

__aio __attribute__((target("sve"))) svuint32x3_t svreinterpret_u32(svint8x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_s8_x3(op);
}

__aio __attribute__((target("sve"))) svuint32x3_t svreinterpret_u32(svuint8x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_u8_x3(op);
}

__aio __attribute__((target("sve"))) svuint32x3_t svreinterpret_u32(svint16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_s16_x3(op);
}

__aio __attribute__((target("sve"))) svuint32x3_t svreinterpret_u32(svuint16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_u16_x3(op);
}

__aio __attribute__((target("sve"))) svuint32x3_t svreinterpret_u32(svint32x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_s32_x3(op);
}

__aio __attribute__((target("sve"))) svuint32x3_t svreinterpret_u32(svuint32x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_u32_x3(op);
}

__aio __attribute__((target("sve"))) svuint32x3_t svreinterpret_u32(svint64x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_s64_x3(op);
}

__aio __attribute__((target("sve"))) svuint32x3_t svreinterpret_u32(svuint64x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_u64_x3(op);
}

__aio __attribute__((target("sve"))) svuint32x3_t svreinterpret_u32(svfloat16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_f16_x3(op);
}

__aio __attribute__((target("sve"))) svuint32x3_t svreinterpret_u32(svbfloat16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_bf16_x3(op);
}

__aio __attribute__((target("sve"))) svuint32x3_t svreinterpret_u32(svfloat32x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_f32_x3(op);
}

__aio __attribute__((target("sve"))) svuint32x3_t svreinterpret_u32(svfloat64x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_f64_x3(op);
}

__aio __attribute__((target("sve"))) svint64x3_t svreinterpret_s64(svint8x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_s8_x3(op);
}

__aio __attribute__((target("sve"))) svint64x3_t svreinterpret_s64(svuint8x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_u8_x3(op);
}

__aio __attribute__((target("sve"))) svint64x3_t svreinterpret_s64(svint16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_s16_x3(op);
}

__aio __attribute__((target("sve"))) svint64x3_t svreinterpret_s64(svuint16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_u16_x3(op);
}

__aio __attribute__((target("sve"))) svint64x3_t svreinterpret_s64(svint32x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_s32_x3(op);
}

__aio __attribute__((target("sve"))) svint64x3_t svreinterpret_s64(svuint32x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_u32_x3(op);
}

__aio __attribute__((target("sve"))) svint64x3_t svreinterpret_s64(svint64x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_s64_x3(op);
}

__aio __attribute__((target("sve"))) svint64x3_t svreinterpret_s64(svuint64x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_u64_x3(op);
}

__aio __attribute__((target("sve"))) svint64x3_t svreinterpret_s64(svfloat16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_f16_x3(op);
}

__aio __attribute__((target("sve"))) svint64x3_t svreinterpret_s64(svbfloat16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_bf16_x3(op);
}

__aio __attribute__((target("sve"))) svint64x3_t svreinterpret_s64(svfloat32x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_f32_x3(op);
}

__aio __attribute__((target("sve"))) svint64x3_t svreinterpret_s64(svfloat64x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_f64_x3(op);
}

__aio __attribute__((target("sve"))) svuint64x3_t svreinterpret_u64(svint8x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_s8_x3(op);
}

__aio __attribute__((target("sve"))) svuint64x3_t svreinterpret_u64(svuint8x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_u8_x3(op);
}

__aio __attribute__((target("sve"))) svuint64x3_t svreinterpret_u64(svint16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_s16_x3(op);
}

__aio __attribute__((target("sve"))) svuint64x3_t svreinterpret_u64(svuint16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_u16_x3(op);
}

__aio __attribute__((target("sve"))) svuint64x3_t svreinterpret_u64(svint32x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_s32_x3(op);
}

__aio __attribute__((target("sve"))) svuint64x3_t svreinterpret_u64(svuint32x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_u32_x3(op);
}

__aio __attribute__((target("sve"))) svuint64x3_t svreinterpret_u64(svint64x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_s64_x3(op);
}

__aio __attribute__((target("sve"))) svuint64x3_t svreinterpret_u64(svuint64x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_u64_x3(op);
}

__aio __attribute__((target("sve"))) svuint64x3_t svreinterpret_u64(svfloat16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_f16_x3(op);
}

__aio __attribute__((target("sve"))) svuint64x3_t svreinterpret_u64(svbfloat16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_bf16_x3(op);
}

__aio __attribute__((target("sve"))) svuint64x3_t svreinterpret_u64(svfloat32x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_f32_x3(op);
}

__aio __attribute__((target("sve"))) svuint64x3_t svreinterpret_u64(svfloat64x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_f64_x3(op);
}

__aio __attribute__((target("sve"))) svfloat16x3_t svreinterpret_f16(svint8x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_s8_x3(op);
}

__aio __attribute__((target("sve"))) svfloat16x3_t svreinterpret_f16(svuint8x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_u8_x3(op);
}

__aio __attribute__((target("sve"))) svfloat16x3_t svreinterpret_f16(svint16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_s16_x3(op);
}

__aio __attribute__((target("sve"))) svfloat16x3_t svreinterpret_f16(svuint16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_u16_x3(op);
}

__aio __attribute__((target("sve"))) svfloat16x3_t svreinterpret_f16(svint32x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_s32_x3(op);
}

__aio __attribute__((target("sve"))) svfloat16x3_t svreinterpret_f16(svuint32x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_u32_x3(op);
}

__aio __attribute__((target("sve"))) svfloat16x3_t svreinterpret_f16(svint64x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_s64_x3(op);
}

__aio __attribute__((target("sve"))) svfloat16x3_t svreinterpret_f16(svuint64x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_u64_x3(op);
}

__aio __attribute__((target("sve"))) svfloat16x3_t svreinterpret_f16(svfloat16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_f16_x3(op);
}

__aio __attribute__((target("sve"))) svfloat16x3_t svreinterpret_f16(svbfloat16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_bf16_x3(op);
}

__aio __attribute__((target("sve"))) svfloat16x3_t svreinterpret_f16(svfloat32x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_f32_x3(op);
}

__aio __attribute__((target("sve"))) svfloat16x3_t svreinterpret_f16(svfloat64x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_f64_x3(op);
}

__aio __attribute__((target("sve"))) svbfloat16x3_t svreinterpret_bf16(svint8x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_s8_x3(op);
}

__aio __attribute__((target("sve"))) svbfloat16x3_t svreinterpret_bf16(svuint8x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_u8_x3(op);
}

__aio __attribute__((target("sve"))) svbfloat16x3_t svreinterpret_bf16(svint16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_s16_x3(op);
}

__aio __attribute__((target("sve"))) svbfloat16x3_t svreinterpret_bf16(svuint16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_u16_x3(op);
}

__aio __attribute__((target("sve"))) svbfloat16x3_t svreinterpret_bf16(svint32x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_s32_x3(op);
}

__aio __attribute__((target("sve"))) svbfloat16x3_t svreinterpret_bf16(svuint32x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_u32_x3(op);
}

__aio __attribute__((target("sve"))) svbfloat16x3_t svreinterpret_bf16(svint64x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_s64_x3(op);
}

__aio __attribute__((target("sve"))) svbfloat16x3_t svreinterpret_bf16(svuint64x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_u64_x3(op);
}

__aio __attribute__((target("sve"))) svbfloat16x3_t svreinterpret_bf16(svfloat16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_f16_x3(op);
}

__aio __attribute__((target("sve"))) svbfloat16x3_t svreinterpret_bf16(svbfloat16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_bf16_x3(op);
}

__aio __attribute__((target("sve"))) svbfloat16x3_t svreinterpret_bf16(svfloat32x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_f32_x3(op);
}

__aio __attribute__((target("sve"))) svbfloat16x3_t svreinterpret_bf16(svfloat64x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_f64_x3(op);
}

__aio __attribute__((target("sve"))) svfloat32x3_t svreinterpret_f32(svint8x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_s8_x3(op);
}

__aio __attribute__((target("sve"))) svfloat32x3_t svreinterpret_f32(svuint8x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_u8_x3(op);
}

__aio __attribute__((target("sve"))) svfloat32x3_t svreinterpret_f32(svint16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_s16_x3(op);
}

__aio __attribute__((target("sve"))) svfloat32x3_t svreinterpret_f32(svuint16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_u16_x3(op);
}

__aio __attribute__((target("sve"))) svfloat32x3_t svreinterpret_f32(svint32x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_s32_x3(op);
}

__aio __attribute__((target("sve"))) svfloat32x3_t svreinterpret_f32(svuint32x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_u32_x3(op);
}

__aio __attribute__((target("sve"))) svfloat32x3_t svreinterpret_f32(svint64x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_s64_x3(op);
}

__aio __attribute__((target("sve"))) svfloat32x3_t svreinterpret_f32(svuint64x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_u64_x3(op);
}

__aio __attribute__((target("sve"))) svfloat32x3_t svreinterpret_f32(svfloat16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_f16_x3(op);
}

__aio __attribute__((target("sve"))) svfloat32x3_t svreinterpret_f32(svbfloat16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_bf16_x3(op);
}

__aio __attribute__((target("sve"))) svfloat32x3_t svreinterpret_f32(svfloat32x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_f32_x3(op);
}

__aio __attribute__((target("sve"))) svfloat32x3_t svreinterpret_f32(svfloat64x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_f64_x3(op);
}

__aio __attribute__((target("sve"))) svfloat64x3_t svreinterpret_f64(svint8x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_s8_x3(op);
}

__aio __attribute__((target("sve"))) svfloat64x3_t svreinterpret_f64(svuint8x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_u8_x3(op);
}

__aio __attribute__((target("sve"))) svfloat64x3_t svreinterpret_f64(svint16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_s16_x3(op);
}

__aio __attribute__((target("sve"))) svfloat64x3_t svreinterpret_f64(svuint16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_u16_x3(op);
}

__aio __attribute__((target("sve"))) svfloat64x3_t svreinterpret_f64(svint32x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_s32_x3(op);
}

__aio __attribute__((target("sve"))) svfloat64x3_t svreinterpret_f64(svuint32x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_u32_x3(op);
}

__aio __attribute__((target("sve"))) svfloat64x3_t svreinterpret_f64(svint64x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_s64_x3(op);
}

__aio __attribute__((target("sve"))) svfloat64x3_t svreinterpret_f64(svuint64x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_u64_x3(op);
}

__aio __attribute__((target("sve"))) svfloat64x3_t svreinterpret_f64(svfloat16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_f16_x3(op);
}

__aio __attribute__((target("sve"))) svfloat64x3_t svreinterpret_f64(svbfloat16x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_bf16_x3(op);
}

__aio __attribute__((target("sve"))) svfloat64x3_t svreinterpret_f64(svfloat32x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_f32_x3(op);
}

__aio __attribute__((target("sve"))) svfloat64x3_t svreinterpret_f64(svfloat64x3_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_f64_x3(op);
}

#define svreinterpret_s8_s8_x4(...) __builtin_sve_reinterpret_s8_s8_x4(__VA_ARGS__)
#define svreinterpret_s8_u8_x4(...) __builtin_sve_reinterpret_s8_u8_x4(__VA_ARGS__)
#define svreinterpret_s8_s16_x4(...) __builtin_sve_reinterpret_s8_s16_x4(__VA_ARGS__)
#define svreinterpret_s8_u16_x4(...) __builtin_sve_reinterpret_s8_u16_x4(__VA_ARGS__)
#define svreinterpret_s8_s32_x4(...) __builtin_sve_reinterpret_s8_s32_x4(__VA_ARGS__)
#define svreinterpret_s8_u32_x4(...) __builtin_sve_reinterpret_s8_u32_x4(__VA_ARGS__)
#define svreinterpret_s8_s64_x4(...) __builtin_sve_reinterpret_s8_s64_x4(__VA_ARGS__)
#define svreinterpret_s8_u64_x4(...) __builtin_sve_reinterpret_s8_u64_x4(__VA_ARGS__)
#define svreinterpret_s8_f16_x4(...) __builtin_sve_reinterpret_s8_f16_x4(__VA_ARGS__)
#define svreinterpret_s8_bf16_x4(...) __builtin_sve_reinterpret_s8_bf16_x4(__VA_ARGS__)
#define svreinterpret_s8_f32_x4(...) __builtin_sve_reinterpret_s8_f32_x4(__VA_ARGS__)
#define svreinterpret_s8_f64_x4(...) __builtin_sve_reinterpret_s8_f64_x4(__VA_ARGS__)
#define svreinterpret_u8_s8_x4(...) __builtin_sve_reinterpret_u8_s8_x4(__VA_ARGS__)
#define svreinterpret_u8_u8_x4(...) __builtin_sve_reinterpret_u8_u8_x4(__VA_ARGS__)
#define svreinterpret_u8_s16_x4(...) __builtin_sve_reinterpret_u8_s16_x4(__VA_ARGS__)
#define svreinterpret_u8_u16_x4(...) __builtin_sve_reinterpret_u8_u16_x4(__VA_ARGS__)
#define svreinterpret_u8_s32_x4(...) __builtin_sve_reinterpret_u8_s32_x4(__VA_ARGS__)
#define svreinterpret_u8_u32_x4(...) __builtin_sve_reinterpret_u8_u32_x4(__VA_ARGS__)
#define svreinterpret_u8_s64_x4(...) __builtin_sve_reinterpret_u8_s64_x4(__VA_ARGS__)
#define svreinterpret_u8_u64_x4(...) __builtin_sve_reinterpret_u8_u64_x4(__VA_ARGS__)
#define svreinterpret_u8_f16_x4(...) __builtin_sve_reinterpret_u8_f16_x4(__VA_ARGS__)
#define svreinterpret_u8_bf16_x4(...) __builtin_sve_reinterpret_u8_bf16_x4(__VA_ARGS__)
#define svreinterpret_u8_f32_x4(...) __builtin_sve_reinterpret_u8_f32_x4(__VA_ARGS__)
#define svreinterpret_u8_f64_x4(...) __builtin_sve_reinterpret_u8_f64_x4(__VA_ARGS__)
#define svreinterpret_s16_s8_x4(...) __builtin_sve_reinterpret_s16_s8_x4(__VA_ARGS__)
#define svreinterpret_s16_u8_x4(...) __builtin_sve_reinterpret_s16_u8_x4(__VA_ARGS__)
#define svreinterpret_s16_s16_x4(...) __builtin_sve_reinterpret_s16_s16_x4(__VA_ARGS__)
#define svreinterpret_s16_u16_x4(...) __builtin_sve_reinterpret_s16_u16_x4(__VA_ARGS__)
#define svreinterpret_s16_s32_x4(...) __builtin_sve_reinterpret_s16_s32_x4(__VA_ARGS__)
#define svreinterpret_s16_u32_x4(...) __builtin_sve_reinterpret_s16_u32_x4(__VA_ARGS__)
#define svreinterpret_s16_s64_x4(...) __builtin_sve_reinterpret_s16_s64_x4(__VA_ARGS__)
#define svreinterpret_s16_u64_x4(...) __builtin_sve_reinterpret_s16_u64_x4(__VA_ARGS__)
#define svreinterpret_s16_f16_x4(...) __builtin_sve_reinterpret_s16_f16_x4(__VA_ARGS__)
#define svreinterpret_s16_bf16_x4(...) __builtin_sve_reinterpret_s16_bf16_x4(__VA_ARGS__)
#define svreinterpret_s16_f32_x4(...) __builtin_sve_reinterpret_s16_f32_x4(__VA_ARGS__)
#define svreinterpret_s16_f64_x4(...) __builtin_sve_reinterpret_s16_f64_x4(__VA_ARGS__)
#define svreinterpret_u16_s8_x4(...) __builtin_sve_reinterpret_u16_s8_x4(__VA_ARGS__)
#define svreinterpret_u16_u8_x4(...) __builtin_sve_reinterpret_u16_u8_x4(__VA_ARGS__)
#define svreinterpret_u16_s16_x4(...) __builtin_sve_reinterpret_u16_s16_x4(__VA_ARGS__)
#define svreinterpret_u16_u16_x4(...) __builtin_sve_reinterpret_u16_u16_x4(__VA_ARGS__)
#define svreinterpret_u16_s32_x4(...) __builtin_sve_reinterpret_u16_s32_x4(__VA_ARGS__)
#define svreinterpret_u16_u32_x4(...) __builtin_sve_reinterpret_u16_u32_x4(__VA_ARGS__)
#define svreinterpret_u16_s64_x4(...) __builtin_sve_reinterpret_u16_s64_x4(__VA_ARGS__)
#define svreinterpret_u16_u64_x4(...) __builtin_sve_reinterpret_u16_u64_x4(__VA_ARGS__)
#define svreinterpret_u16_f16_x4(...) __builtin_sve_reinterpret_u16_f16_x4(__VA_ARGS__)
#define svreinterpret_u16_bf16_x4(...) __builtin_sve_reinterpret_u16_bf16_x4(__VA_ARGS__)
#define svreinterpret_u16_f32_x4(...) __builtin_sve_reinterpret_u16_f32_x4(__VA_ARGS__)
#define svreinterpret_u16_f64_x4(...) __builtin_sve_reinterpret_u16_f64_x4(__VA_ARGS__)
#define svreinterpret_s32_s8_x4(...) __builtin_sve_reinterpret_s32_s8_x4(__VA_ARGS__)
#define svreinterpret_s32_u8_x4(...) __builtin_sve_reinterpret_s32_u8_x4(__VA_ARGS__)
#define svreinterpret_s32_s16_x4(...) __builtin_sve_reinterpret_s32_s16_x4(__VA_ARGS__)
#define svreinterpret_s32_u16_x4(...) __builtin_sve_reinterpret_s32_u16_x4(__VA_ARGS__)
#define svreinterpret_s32_s32_x4(...) __builtin_sve_reinterpret_s32_s32_x4(__VA_ARGS__)
#define svreinterpret_s32_u32_x4(...) __builtin_sve_reinterpret_s32_u32_x4(__VA_ARGS__)
#define svreinterpret_s32_s64_x4(...) __builtin_sve_reinterpret_s32_s64_x4(__VA_ARGS__)
#define svreinterpret_s32_u64_x4(...) __builtin_sve_reinterpret_s32_u64_x4(__VA_ARGS__)
#define svreinterpret_s32_f16_x4(...) __builtin_sve_reinterpret_s32_f16_x4(__VA_ARGS__)
#define svreinterpret_s32_bf16_x4(...) __builtin_sve_reinterpret_s32_bf16_x4(__VA_ARGS__)
#define svreinterpret_s32_f32_x4(...) __builtin_sve_reinterpret_s32_f32_x4(__VA_ARGS__)
#define svreinterpret_s32_f64_x4(...) __builtin_sve_reinterpret_s32_f64_x4(__VA_ARGS__)
#define svreinterpret_u32_s8_x4(...) __builtin_sve_reinterpret_u32_s8_x4(__VA_ARGS__)
#define svreinterpret_u32_u8_x4(...) __builtin_sve_reinterpret_u32_u8_x4(__VA_ARGS__)
#define svreinterpret_u32_s16_x4(...) __builtin_sve_reinterpret_u32_s16_x4(__VA_ARGS__)
#define svreinterpret_u32_u16_x4(...) __builtin_sve_reinterpret_u32_u16_x4(__VA_ARGS__)
#define svreinterpret_u32_s32_x4(...) __builtin_sve_reinterpret_u32_s32_x4(__VA_ARGS__)
#define svreinterpret_u32_u32_x4(...) __builtin_sve_reinterpret_u32_u32_x4(__VA_ARGS__)
#define svreinterpret_u32_s64_x4(...) __builtin_sve_reinterpret_u32_s64_x4(__VA_ARGS__)
#define svreinterpret_u32_u64_x4(...) __builtin_sve_reinterpret_u32_u64_x4(__VA_ARGS__)
#define svreinterpret_u32_f16_x4(...) __builtin_sve_reinterpret_u32_f16_x4(__VA_ARGS__)
#define svreinterpret_u32_bf16_x4(...) __builtin_sve_reinterpret_u32_bf16_x4(__VA_ARGS__)
#define svreinterpret_u32_f32_x4(...) __builtin_sve_reinterpret_u32_f32_x4(__VA_ARGS__)
#define svreinterpret_u32_f64_x4(...) __builtin_sve_reinterpret_u32_f64_x4(__VA_ARGS__)
#define svreinterpret_s64_s8_x4(...) __builtin_sve_reinterpret_s64_s8_x4(__VA_ARGS__)
#define svreinterpret_s64_u8_x4(...) __builtin_sve_reinterpret_s64_u8_x4(__VA_ARGS__)
#define svreinterpret_s64_s16_x4(...) __builtin_sve_reinterpret_s64_s16_x4(__VA_ARGS__)
#define svreinterpret_s64_u16_x4(...) __builtin_sve_reinterpret_s64_u16_x4(__VA_ARGS__)
#define svreinterpret_s64_s32_x4(...) __builtin_sve_reinterpret_s64_s32_x4(__VA_ARGS__)
#define svreinterpret_s64_u32_x4(...) __builtin_sve_reinterpret_s64_u32_x4(__VA_ARGS__)
#define svreinterpret_s64_s64_x4(...) __builtin_sve_reinterpret_s64_s64_x4(__VA_ARGS__)
#define svreinterpret_s64_u64_x4(...) __builtin_sve_reinterpret_s64_u64_x4(__VA_ARGS__)
#define svreinterpret_s64_f16_x4(...) __builtin_sve_reinterpret_s64_f16_x4(__VA_ARGS__)
#define svreinterpret_s64_bf16_x4(...) __builtin_sve_reinterpret_s64_bf16_x4(__VA_ARGS__)
#define svreinterpret_s64_f32_x4(...) __builtin_sve_reinterpret_s64_f32_x4(__VA_ARGS__)
#define svreinterpret_s64_f64_x4(...) __builtin_sve_reinterpret_s64_f64_x4(__VA_ARGS__)
#define svreinterpret_u64_s8_x4(...) __builtin_sve_reinterpret_u64_s8_x4(__VA_ARGS__)
#define svreinterpret_u64_u8_x4(...) __builtin_sve_reinterpret_u64_u8_x4(__VA_ARGS__)
#define svreinterpret_u64_s16_x4(...) __builtin_sve_reinterpret_u64_s16_x4(__VA_ARGS__)
#define svreinterpret_u64_u16_x4(...) __builtin_sve_reinterpret_u64_u16_x4(__VA_ARGS__)
#define svreinterpret_u64_s32_x4(...) __builtin_sve_reinterpret_u64_s32_x4(__VA_ARGS__)
#define svreinterpret_u64_u32_x4(...) __builtin_sve_reinterpret_u64_u32_x4(__VA_ARGS__)
#define svreinterpret_u64_s64_x4(...) __builtin_sve_reinterpret_u64_s64_x4(__VA_ARGS__)
#define svreinterpret_u64_u64_x4(...) __builtin_sve_reinterpret_u64_u64_x4(__VA_ARGS__)
#define svreinterpret_u64_f16_x4(...) __builtin_sve_reinterpret_u64_f16_x4(__VA_ARGS__)
#define svreinterpret_u64_bf16_x4(...) __builtin_sve_reinterpret_u64_bf16_x4(__VA_ARGS__)
#define svreinterpret_u64_f32_x4(...) __builtin_sve_reinterpret_u64_f32_x4(__VA_ARGS__)
#define svreinterpret_u64_f64_x4(...) __builtin_sve_reinterpret_u64_f64_x4(__VA_ARGS__)
#define svreinterpret_f16_s8_x4(...) __builtin_sve_reinterpret_f16_s8_x4(__VA_ARGS__)
#define svreinterpret_f16_u8_x4(...) __builtin_sve_reinterpret_f16_u8_x4(__VA_ARGS__)
#define svreinterpret_f16_s16_x4(...) __builtin_sve_reinterpret_f16_s16_x4(__VA_ARGS__)
#define svreinterpret_f16_u16_x4(...) __builtin_sve_reinterpret_f16_u16_x4(__VA_ARGS__)
#define svreinterpret_f16_s32_x4(...) __builtin_sve_reinterpret_f16_s32_x4(__VA_ARGS__)
#define svreinterpret_f16_u32_x4(...) __builtin_sve_reinterpret_f16_u32_x4(__VA_ARGS__)
#define svreinterpret_f16_s64_x4(...) __builtin_sve_reinterpret_f16_s64_x4(__VA_ARGS__)
#define svreinterpret_f16_u64_x4(...) __builtin_sve_reinterpret_f16_u64_x4(__VA_ARGS__)
#define svreinterpret_f16_f16_x4(...) __builtin_sve_reinterpret_f16_f16_x4(__VA_ARGS__)
#define svreinterpret_f16_bf16_x4(...) __builtin_sve_reinterpret_f16_bf16_x4(__VA_ARGS__)
#define svreinterpret_f16_f32_x4(...) __builtin_sve_reinterpret_f16_f32_x4(__VA_ARGS__)
#define svreinterpret_f16_f64_x4(...) __builtin_sve_reinterpret_f16_f64_x4(__VA_ARGS__)
#define svreinterpret_bf16_s8_x4(...) __builtin_sve_reinterpret_bf16_s8_x4(__VA_ARGS__)
#define svreinterpret_bf16_u8_x4(...) __builtin_sve_reinterpret_bf16_u8_x4(__VA_ARGS__)
#define svreinterpret_bf16_s16_x4(...) __builtin_sve_reinterpret_bf16_s16_x4(__VA_ARGS__)
#define svreinterpret_bf16_u16_x4(...) __builtin_sve_reinterpret_bf16_u16_x4(__VA_ARGS__)
#define svreinterpret_bf16_s32_x4(...) __builtin_sve_reinterpret_bf16_s32_x4(__VA_ARGS__)
#define svreinterpret_bf16_u32_x4(...) __builtin_sve_reinterpret_bf16_u32_x4(__VA_ARGS__)
#define svreinterpret_bf16_s64_x4(...) __builtin_sve_reinterpret_bf16_s64_x4(__VA_ARGS__)
#define svreinterpret_bf16_u64_x4(...) __builtin_sve_reinterpret_bf16_u64_x4(__VA_ARGS__)
#define svreinterpret_bf16_f16_x4(...) __builtin_sve_reinterpret_bf16_f16_x4(__VA_ARGS__)
#define svreinterpret_bf16_bf16_x4(...) __builtin_sve_reinterpret_bf16_bf16_x4(__VA_ARGS__)
#define svreinterpret_bf16_f32_x4(...) __builtin_sve_reinterpret_bf16_f32_x4(__VA_ARGS__)
#define svreinterpret_bf16_f64_x4(...) __builtin_sve_reinterpret_bf16_f64_x4(__VA_ARGS__)
#define svreinterpret_f32_s8_x4(...) __builtin_sve_reinterpret_f32_s8_x4(__VA_ARGS__)
#define svreinterpret_f32_u8_x4(...) __builtin_sve_reinterpret_f32_u8_x4(__VA_ARGS__)
#define svreinterpret_f32_s16_x4(...) __builtin_sve_reinterpret_f32_s16_x4(__VA_ARGS__)
#define svreinterpret_f32_u16_x4(...) __builtin_sve_reinterpret_f32_u16_x4(__VA_ARGS__)
#define svreinterpret_f32_s32_x4(...) __builtin_sve_reinterpret_f32_s32_x4(__VA_ARGS__)
#define svreinterpret_f32_u32_x4(...) __builtin_sve_reinterpret_f32_u32_x4(__VA_ARGS__)
#define svreinterpret_f32_s64_x4(...) __builtin_sve_reinterpret_f32_s64_x4(__VA_ARGS__)
#define svreinterpret_f32_u64_x4(...) __builtin_sve_reinterpret_f32_u64_x4(__VA_ARGS__)
#define svreinterpret_f32_f16_x4(...) __builtin_sve_reinterpret_f32_f16_x4(__VA_ARGS__)
#define svreinterpret_f32_bf16_x4(...) __builtin_sve_reinterpret_f32_bf16_x4(__VA_ARGS__)
#define svreinterpret_f32_f32_x4(...) __builtin_sve_reinterpret_f32_f32_x4(__VA_ARGS__)
#define svreinterpret_f32_f64_x4(...) __builtin_sve_reinterpret_f32_f64_x4(__VA_ARGS__)
#define svreinterpret_f64_s8_x4(...) __builtin_sve_reinterpret_f64_s8_x4(__VA_ARGS__)
#define svreinterpret_f64_u8_x4(...) __builtin_sve_reinterpret_f64_u8_x4(__VA_ARGS__)
#define svreinterpret_f64_s16_x4(...) __builtin_sve_reinterpret_f64_s16_x4(__VA_ARGS__)
#define svreinterpret_f64_u16_x4(...) __builtin_sve_reinterpret_f64_u16_x4(__VA_ARGS__)
#define svreinterpret_f64_s32_x4(...) __builtin_sve_reinterpret_f64_s32_x4(__VA_ARGS__)
#define svreinterpret_f64_u32_x4(...) __builtin_sve_reinterpret_f64_u32_x4(__VA_ARGS__)
#define svreinterpret_f64_s64_x4(...) __builtin_sve_reinterpret_f64_s64_x4(__VA_ARGS__)
#define svreinterpret_f64_u64_x4(...) __builtin_sve_reinterpret_f64_u64_x4(__VA_ARGS__)
#define svreinterpret_f64_f16_x4(...) __builtin_sve_reinterpret_f64_f16_x4(__VA_ARGS__)
#define svreinterpret_f64_bf16_x4(...) __builtin_sve_reinterpret_f64_bf16_x4(__VA_ARGS__)
#define svreinterpret_f64_f32_x4(...) __builtin_sve_reinterpret_f64_f32_x4(__VA_ARGS__)
#define svreinterpret_f64_f64_x4(...) __builtin_sve_reinterpret_f64_f64_x4(__VA_ARGS__)
__aio __attribute__((target("sve"))) svint8x4_t svreinterpret_s8(svint8x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_s8_x4(op);
}

__aio __attribute__((target("sve"))) svint8x4_t svreinterpret_s8(svuint8x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_u8_x4(op);
}

__aio __attribute__((target("sve"))) svint8x4_t svreinterpret_s8(svint16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_s16_x4(op);
}

__aio __attribute__((target("sve"))) svint8x4_t svreinterpret_s8(svuint16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_u16_x4(op);
}

__aio __attribute__((target("sve"))) svint8x4_t svreinterpret_s8(svint32x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_s32_x4(op);
}

__aio __attribute__((target("sve"))) svint8x4_t svreinterpret_s8(svuint32x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_u32_x4(op);
}

__aio __attribute__((target("sve"))) svint8x4_t svreinterpret_s8(svint64x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_s64_x4(op);
}

__aio __attribute__((target("sve"))) svint8x4_t svreinterpret_s8(svuint64x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_u64_x4(op);
}

__aio __attribute__((target("sve"))) svint8x4_t svreinterpret_s8(svfloat16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_f16_x4(op);
}

__aio __attribute__((target("sve"))) svint8x4_t svreinterpret_s8(svbfloat16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_bf16_x4(op);
}

__aio __attribute__((target("sve"))) svint8x4_t svreinterpret_s8(svfloat32x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_f32_x4(op);
}

__aio __attribute__((target("sve"))) svint8x4_t svreinterpret_s8(svfloat64x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s8_f64_x4(op);
}

__aio __attribute__((target("sve"))) svuint8x4_t svreinterpret_u8(svint8x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_s8_x4(op);
}

__aio __attribute__((target("sve"))) svuint8x4_t svreinterpret_u8(svuint8x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_u8_x4(op);
}

__aio __attribute__((target("sve"))) svuint8x4_t svreinterpret_u8(svint16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_s16_x4(op);
}

__aio __attribute__((target("sve"))) svuint8x4_t svreinterpret_u8(svuint16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_u16_x4(op);
}

__aio __attribute__((target("sve"))) svuint8x4_t svreinterpret_u8(svint32x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_s32_x4(op);
}

__aio __attribute__((target("sve"))) svuint8x4_t svreinterpret_u8(svuint32x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_u32_x4(op);
}

__aio __attribute__((target("sve"))) svuint8x4_t svreinterpret_u8(svint64x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_s64_x4(op);
}

__aio __attribute__((target("sve"))) svuint8x4_t svreinterpret_u8(svuint64x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_u64_x4(op);
}

__aio __attribute__((target("sve"))) svuint8x4_t svreinterpret_u8(svfloat16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_f16_x4(op);
}

__aio __attribute__((target("sve"))) svuint8x4_t svreinterpret_u8(svbfloat16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_bf16_x4(op);
}

__aio __attribute__((target("sve"))) svuint8x4_t svreinterpret_u8(svfloat32x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_f32_x4(op);
}

__aio __attribute__((target("sve"))) svuint8x4_t svreinterpret_u8(svfloat64x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u8_f64_x4(op);
}

__aio __attribute__((target("sve"))) svint16x4_t svreinterpret_s16(svint8x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_s8_x4(op);
}

__aio __attribute__((target("sve"))) svint16x4_t svreinterpret_s16(svuint8x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_u8_x4(op);
}

__aio __attribute__((target("sve"))) svint16x4_t svreinterpret_s16(svint16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_s16_x4(op);
}

__aio __attribute__((target("sve"))) svint16x4_t svreinterpret_s16(svuint16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_u16_x4(op);
}

__aio __attribute__((target("sve"))) svint16x4_t svreinterpret_s16(svint32x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_s32_x4(op);
}

__aio __attribute__((target("sve"))) svint16x4_t svreinterpret_s16(svuint32x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_u32_x4(op);
}

__aio __attribute__((target("sve"))) svint16x4_t svreinterpret_s16(svint64x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_s64_x4(op);
}

__aio __attribute__((target("sve"))) svint16x4_t svreinterpret_s16(svuint64x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_u64_x4(op);
}

__aio __attribute__((target("sve"))) svint16x4_t svreinterpret_s16(svfloat16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_f16_x4(op);
}

__aio __attribute__((target("sve"))) svint16x4_t svreinterpret_s16(svbfloat16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_bf16_x4(op);
}

__aio __attribute__((target("sve"))) svint16x4_t svreinterpret_s16(svfloat32x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_f32_x4(op);
}

__aio __attribute__((target("sve"))) svint16x4_t svreinterpret_s16(svfloat64x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s16_f64_x4(op);
}

__aio __attribute__((target("sve"))) svuint16x4_t svreinterpret_u16(svint8x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_s8_x4(op);
}

__aio __attribute__((target("sve"))) svuint16x4_t svreinterpret_u16(svuint8x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_u8_x4(op);
}

__aio __attribute__((target("sve"))) svuint16x4_t svreinterpret_u16(svint16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_s16_x4(op);
}

__aio __attribute__((target("sve"))) svuint16x4_t svreinterpret_u16(svuint16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_u16_x4(op);
}

__aio __attribute__((target("sve"))) svuint16x4_t svreinterpret_u16(svint32x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_s32_x4(op);
}

__aio __attribute__((target("sve"))) svuint16x4_t svreinterpret_u16(svuint32x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_u32_x4(op);
}

__aio __attribute__((target("sve"))) svuint16x4_t svreinterpret_u16(svint64x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_s64_x4(op);
}

__aio __attribute__((target("sve"))) svuint16x4_t svreinterpret_u16(svuint64x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_u64_x4(op);
}

__aio __attribute__((target("sve"))) svuint16x4_t svreinterpret_u16(svfloat16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_f16_x4(op);
}

__aio __attribute__((target("sve"))) svuint16x4_t svreinterpret_u16(svbfloat16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_bf16_x4(op);
}

__aio __attribute__((target("sve"))) svuint16x4_t svreinterpret_u16(svfloat32x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_f32_x4(op);
}

__aio __attribute__((target("sve"))) svuint16x4_t svreinterpret_u16(svfloat64x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u16_f64_x4(op);
}

__aio __attribute__((target("sve"))) svint32x4_t svreinterpret_s32(svint8x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_s8_x4(op);
}

__aio __attribute__((target("sve"))) svint32x4_t svreinterpret_s32(svuint8x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_u8_x4(op);
}

__aio __attribute__((target("sve"))) svint32x4_t svreinterpret_s32(svint16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_s16_x4(op);
}

__aio __attribute__((target("sve"))) svint32x4_t svreinterpret_s32(svuint16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_u16_x4(op);
}

__aio __attribute__((target("sve"))) svint32x4_t svreinterpret_s32(svint32x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_s32_x4(op);
}

__aio __attribute__((target("sve"))) svint32x4_t svreinterpret_s32(svuint32x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_u32_x4(op);
}

__aio __attribute__((target("sve"))) svint32x4_t svreinterpret_s32(svint64x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_s64_x4(op);
}

__aio __attribute__((target("sve"))) svint32x4_t svreinterpret_s32(svuint64x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_u64_x4(op);
}

__aio __attribute__((target("sve"))) svint32x4_t svreinterpret_s32(svfloat16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_f16_x4(op);
}

__aio __attribute__((target("sve"))) svint32x4_t svreinterpret_s32(svbfloat16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_bf16_x4(op);
}

__aio __attribute__((target("sve"))) svint32x4_t svreinterpret_s32(svfloat32x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_f32_x4(op);
}

__aio __attribute__((target("sve"))) svint32x4_t svreinterpret_s32(svfloat64x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s32_f64_x4(op);
}

__aio __attribute__((target("sve"))) svuint32x4_t svreinterpret_u32(svint8x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_s8_x4(op);
}

__aio __attribute__((target("sve"))) svuint32x4_t svreinterpret_u32(svuint8x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_u8_x4(op);
}

__aio __attribute__((target("sve"))) svuint32x4_t svreinterpret_u32(svint16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_s16_x4(op);
}

__aio __attribute__((target("sve"))) svuint32x4_t svreinterpret_u32(svuint16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_u16_x4(op);
}

__aio __attribute__((target("sve"))) svuint32x4_t svreinterpret_u32(svint32x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_s32_x4(op);
}

__aio __attribute__((target("sve"))) svuint32x4_t svreinterpret_u32(svuint32x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_u32_x4(op);
}

__aio __attribute__((target("sve"))) svuint32x4_t svreinterpret_u32(svint64x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_s64_x4(op);
}

__aio __attribute__((target("sve"))) svuint32x4_t svreinterpret_u32(svuint64x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_u64_x4(op);
}

__aio __attribute__((target("sve"))) svuint32x4_t svreinterpret_u32(svfloat16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_f16_x4(op);
}

__aio __attribute__((target("sve"))) svuint32x4_t svreinterpret_u32(svbfloat16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_bf16_x4(op);
}

__aio __attribute__((target("sve"))) svuint32x4_t svreinterpret_u32(svfloat32x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_f32_x4(op);
}

__aio __attribute__((target("sve"))) svuint32x4_t svreinterpret_u32(svfloat64x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u32_f64_x4(op);
}

__aio __attribute__((target("sve"))) svint64x4_t svreinterpret_s64(svint8x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_s8_x4(op);
}

__aio __attribute__((target("sve"))) svint64x4_t svreinterpret_s64(svuint8x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_u8_x4(op);
}

__aio __attribute__((target("sve"))) svint64x4_t svreinterpret_s64(svint16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_s16_x4(op);
}

__aio __attribute__((target("sve"))) svint64x4_t svreinterpret_s64(svuint16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_u16_x4(op);
}

__aio __attribute__((target("sve"))) svint64x4_t svreinterpret_s64(svint32x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_s32_x4(op);
}

__aio __attribute__((target("sve"))) svint64x4_t svreinterpret_s64(svuint32x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_u32_x4(op);
}

__aio __attribute__((target("sve"))) svint64x4_t svreinterpret_s64(svint64x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_s64_x4(op);
}

__aio __attribute__((target("sve"))) svint64x4_t svreinterpret_s64(svuint64x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_u64_x4(op);
}

__aio __attribute__((target("sve"))) svint64x4_t svreinterpret_s64(svfloat16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_f16_x4(op);
}

__aio __attribute__((target("sve"))) svint64x4_t svreinterpret_s64(svbfloat16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_bf16_x4(op);
}

__aio __attribute__((target("sve"))) svint64x4_t svreinterpret_s64(svfloat32x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_f32_x4(op);
}

__aio __attribute__((target("sve"))) svint64x4_t svreinterpret_s64(svfloat64x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_s64_f64_x4(op);
}

__aio __attribute__((target("sve"))) svuint64x4_t svreinterpret_u64(svint8x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_s8_x4(op);
}

__aio __attribute__((target("sve"))) svuint64x4_t svreinterpret_u64(svuint8x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_u8_x4(op);
}

__aio __attribute__((target("sve"))) svuint64x4_t svreinterpret_u64(svint16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_s16_x4(op);
}

__aio __attribute__((target("sve"))) svuint64x4_t svreinterpret_u64(svuint16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_u16_x4(op);
}

__aio __attribute__((target("sve"))) svuint64x4_t svreinterpret_u64(svint32x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_s32_x4(op);
}

__aio __attribute__((target("sve"))) svuint64x4_t svreinterpret_u64(svuint32x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_u32_x4(op);
}

__aio __attribute__((target("sve"))) svuint64x4_t svreinterpret_u64(svint64x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_s64_x4(op);
}

__aio __attribute__((target("sve"))) svuint64x4_t svreinterpret_u64(svuint64x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_u64_x4(op);
}

__aio __attribute__((target("sve"))) svuint64x4_t svreinterpret_u64(svfloat16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_f16_x4(op);
}

__aio __attribute__((target("sve"))) svuint64x4_t svreinterpret_u64(svbfloat16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_bf16_x4(op);
}

__aio __attribute__((target("sve"))) svuint64x4_t svreinterpret_u64(svfloat32x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_f32_x4(op);
}

__aio __attribute__((target("sve"))) svuint64x4_t svreinterpret_u64(svfloat64x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_u64_f64_x4(op);
}

__aio __attribute__((target("sve"))) svfloat16x4_t svreinterpret_f16(svint8x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_s8_x4(op);
}

__aio __attribute__((target("sve"))) svfloat16x4_t svreinterpret_f16(svuint8x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_u8_x4(op);
}

__aio __attribute__((target("sve"))) svfloat16x4_t svreinterpret_f16(svint16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_s16_x4(op);
}

__aio __attribute__((target("sve"))) svfloat16x4_t svreinterpret_f16(svuint16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_u16_x4(op);
}

__aio __attribute__((target("sve"))) svfloat16x4_t svreinterpret_f16(svint32x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_s32_x4(op);
}

__aio __attribute__((target("sve"))) svfloat16x4_t svreinterpret_f16(svuint32x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_u32_x4(op);
}

__aio __attribute__((target("sve"))) svfloat16x4_t svreinterpret_f16(svint64x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_s64_x4(op);
}

__aio __attribute__((target("sve"))) svfloat16x4_t svreinterpret_f16(svuint64x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_u64_x4(op);
}

__aio __attribute__((target("sve"))) svfloat16x4_t svreinterpret_f16(svfloat16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_f16_x4(op);
}

__aio __attribute__((target("sve"))) svfloat16x4_t svreinterpret_f16(svbfloat16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_bf16_x4(op);
}

__aio __attribute__((target("sve"))) svfloat16x4_t svreinterpret_f16(svfloat32x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_f32_x4(op);
}

__aio __attribute__((target("sve"))) svfloat16x4_t svreinterpret_f16(svfloat64x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f16_f64_x4(op);
}

__aio __attribute__((target("sve"))) svbfloat16x4_t svreinterpret_bf16(svint8x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_s8_x4(op);
}

__aio __attribute__((target("sve"))) svbfloat16x4_t svreinterpret_bf16(svuint8x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_u8_x4(op);
}

__aio __attribute__((target("sve"))) svbfloat16x4_t svreinterpret_bf16(svint16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_s16_x4(op);
}

__aio __attribute__((target("sve"))) svbfloat16x4_t svreinterpret_bf16(svuint16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_u16_x4(op);
}

__aio __attribute__((target("sve"))) svbfloat16x4_t svreinterpret_bf16(svint32x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_s32_x4(op);
}

__aio __attribute__((target("sve"))) svbfloat16x4_t svreinterpret_bf16(svuint32x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_u32_x4(op);
}

__aio __attribute__((target("sve"))) svbfloat16x4_t svreinterpret_bf16(svint64x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_s64_x4(op);
}

__aio __attribute__((target("sve"))) svbfloat16x4_t svreinterpret_bf16(svuint64x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_u64_x4(op);
}

__aio __attribute__((target("sve"))) svbfloat16x4_t svreinterpret_bf16(svfloat16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_f16_x4(op);
}

__aio __attribute__((target("sve"))) svbfloat16x4_t svreinterpret_bf16(svbfloat16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_bf16_x4(op);
}

__aio __attribute__((target("sve"))) svbfloat16x4_t svreinterpret_bf16(svfloat32x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_f32_x4(op);
}

__aio __attribute__((target("sve"))) svbfloat16x4_t svreinterpret_bf16(svfloat64x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_bf16_f64_x4(op);
}

__aio __attribute__((target("sve"))) svfloat32x4_t svreinterpret_f32(svint8x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_s8_x4(op);
}

__aio __attribute__((target("sve"))) svfloat32x4_t svreinterpret_f32(svuint8x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_u8_x4(op);
}

__aio __attribute__((target("sve"))) svfloat32x4_t svreinterpret_f32(svint16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_s16_x4(op);
}

__aio __attribute__((target("sve"))) svfloat32x4_t svreinterpret_f32(svuint16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_u16_x4(op);
}

__aio __attribute__((target("sve"))) svfloat32x4_t svreinterpret_f32(svint32x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_s32_x4(op);
}

__aio __attribute__((target("sve"))) svfloat32x4_t svreinterpret_f32(svuint32x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_u32_x4(op);
}

__aio __attribute__((target("sve"))) svfloat32x4_t svreinterpret_f32(svint64x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_s64_x4(op);
}

__aio __attribute__((target("sve"))) svfloat32x4_t svreinterpret_f32(svuint64x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_u64_x4(op);
}

__aio __attribute__((target("sve"))) svfloat32x4_t svreinterpret_f32(svfloat16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_f16_x4(op);
}

__aio __attribute__((target("sve"))) svfloat32x4_t svreinterpret_f32(svbfloat16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_bf16_x4(op);
}

__aio __attribute__((target("sve"))) svfloat32x4_t svreinterpret_f32(svfloat32x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_f32_x4(op);
}

__aio __attribute__((target("sve"))) svfloat32x4_t svreinterpret_f32(svfloat64x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f32_f64_x4(op);
}

__aio __attribute__((target("sve"))) svfloat64x4_t svreinterpret_f64(svint8x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_s8_x4(op);
}

__aio __attribute__((target("sve"))) svfloat64x4_t svreinterpret_f64(svuint8x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_u8_x4(op);
}

__aio __attribute__((target("sve"))) svfloat64x4_t svreinterpret_f64(svint16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_s16_x4(op);
}

__aio __attribute__((target("sve"))) svfloat64x4_t svreinterpret_f64(svuint16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_u16_x4(op);
}

__aio __attribute__((target("sve"))) svfloat64x4_t svreinterpret_f64(svint32x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_s32_x4(op);
}

__aio __attribute__((target("sve"))) svfloat64x4_t svreinterpret_f64(svuint32x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_u32_x4(op);
}

__aio __attribute__((target("sve"))) svfloat64x4_t svreinterpret_f64(svint64x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_s64_x4(op);
}

__aio __attribute__((target("sve"))) svfloat64x4_t svreinterpret_f64(svuint64x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_u64_x4(op);
}

__aio __attribute__((target("sve"))) svfloat64x4_t svreinterpret_f64(svfloat16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_f16_x4(op);
}

__aio __attribute__((target("sve"))) svfloat64x4_t svreinterpret_f64(svbfloat16x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_bf16_x4(op);
}

__aio __attribute__((target("sve"))) svfloat64x4_t svreinterpret_f64(svfloat32x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_f32_x4(op);
}

__aio __attribute__((target("sve"))) svfloat64x4_t svreinterpret_f64(svfloat64x4_t op) __arm_streaming_compatible {
  return __builtin_sve_reinterpret_f64_f64_x4(op);
}

__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_bf16_m), arm_streaming_compatible))
svbfloat16_t svadd_n_bf16_m(svbool_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_bf16_x), arm_streaming_compatible))
svbfloat16_t svadd_n_bf16_x(svbool_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_bf16_z), arm_streaming_compatible))
svbfloat16_t svadd_n_bf16_z(svbool_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_bf16_m), arm_streaming_compatible))
svbfloat16_t svadd_bf16_m(svbool_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_bf16_x), arm_streaming_compatible))
svbfloat16_t svadd_bf16_x(svbool_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_bf16_z), arm_streaming_compatible))
svbfloat16_t svadd_bf16_z(svbool_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_bf16), arm_streaming_compatible))
svbfloat16_t svclamp_bf16(svbfloat16_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_bf16_m), arm_streaming_compatible))
svbfloat16_t svmax_n_bf16_m(svbool_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_bf16_x), arm_streaming_compatible))
svbfloat16_t svmax_n_bf16_x(svbool_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_bf16_z), arm_streaming_compatible))
svbfloat16_t svmax_n_bf16_z(svbool_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_bf16_m), arm_streaming_compatible))
svbfloat16_t svmax_bf16_m(svbool_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_bf16_x), arm_streaming_compatible))
svbfloat16_t svmax_bf16_x(svbool_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_bf16_z), arm_streaming_compatible))
svbfloat16_t svmax_bf16_z(svbool_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_n_bf16_m), arm_streaming_compatible))
svbfloat16_t svmaxnm_n_bf16_m(svbool_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_n_bf16_x), arm_streaming_compatible))
svbfloat16_t svmaxnm_n_bf16_x(svbool_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_n_bf16_z), arm_streaming_compatible))
svbfloat16_t svmaxnm_n_bf16_z(svbool_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_bf16_m), arm_streaming_compatible))
svbfloat16_t svmaxnm_bf16_m(svbool_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_bf16_x), arm_streaming_compatible))
svbfloat16_t svmaxnm_bf16_x(svbool_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_bf16_z), arm_streaming_compatible))
svbfloat16_t svmaxnm_bf16_z(svbool_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_bf16_m), arm_streaming_compatible))
svbfloat16_t svmin_n_bf16_m(svbool_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_bf16_x), arm_streaming_compatible))
svbfloat16_t svmin_n_bf16_x(svbool_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_bf16_z), arm_streaming_compatible))
svbfloat16_t svmin_n_bf16_z(svbool_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_bf16_m), arm_streaming_compatible))
svbfloat16_t svmin_bf16_m(svbool_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_bf16_x), arm_streaming_compatible))
svbfloat16_t svmin_bf16_x(svbool_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_bf16_z), arm_streaming_compatible))
svbfloat16_t svmin_bf16_z(svbool_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_n_bf16_m), arm_streaming_compatible))
svbfloat16_t svminnm_n_bf16_m(svbool_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_n_bf16_x), arm_streaming_compatible))
svbfloat16_t svminnm_n_bf16_x(svbool_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_n_bf16_z), arm_streaming_compatible))
svbfloat16_t svminnm_n_bf16_z(svbool_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_bf16_m), arm_streaming_compatible))
svbfloat16_t svminnm_bf16_m(svbool_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_bf16_x), arm_streaming_compatible))
svbfloat16_t svminnm_bf16_x(svbool_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_bf16_z), arm_streaming_compatible))
svbfloat16_t svminnm_bf16_z(svbool_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_bf16_m), arm_streaming_compatible))
svbfloat16_t svmla_n_bf16_m(svbool_t, svbfloat16_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_bf16_x), arm_streaming_compatible))
svbfloat16_t svmla_n_bf16_x(svbool_t, svbfloat16_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_bf16_z), arm_streaming_compatible))
svbfloat16_t svmla_n_bf16_z(svbool_t, svbfloat16_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_bf16_m), arm_streaming_compatible))
svbfloat16_t svmla_bf16_m(svbool_t, svbfloat16_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_bf16_x), arm_streaming_compatible))
svbfloat16_t svmla_bf16_x(svbool_t, svbfloat16_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_bf16_z), arm_streaming_compatible))
svbfloat16_t svmla_bf16_z(svbool_t, svbfloat16_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_lane_bf16), arm_streaming_compatible))
svbfloat16_t svmla_lane_bf16(svbfloat16_t, svbfloat16_t, svbfloat16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_bf16_m), arm_streaming_compatible))
svbfloat16_t svmls_n_bf16_m(svbool_t, svbfloat16_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_bf16_x), arm_streaming_compatible))
svbfloat16_t svmls_n_bf16_x(svbool_t, svbfloat16_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_bf16_z), arm_streaming_compatible))
svbfloat16_t svmls_n_bf16_z(svbool_t, svbfloat16_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_bf16_m), arm_streaming_compatible))
svbfloat16_t svmls_bf16_m(svbool_t, svbfloat16_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_bf16_x), arm_streaming_compatible))
svbfloat16_t svmls_bf16_x(svbool_t, svbfloat16_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_bf16_z), arm_streaming_compatible))
svbfloat16_t svmls_bf16_z(svbool_t, svbfloat16_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_lane_bf16), arm_streaming_compatible))
svbfloat16_t svmls_lane_bf16(svbfloat16_t, svbfloat16_t, svbfloat16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_bf16_m), arm_streaming_compatible))
svbfloat16_t svmul_n_bf16_m(svbool_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_bf16_x), arm_streaming_compatible))
svbfloat16_t svmul_n_bf16_x(svbool_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_bf16_z), arm_streaming_compatible))
svbfloat16_t svmul_n_bf16_z(svbool_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_bf16_m), arm_streaming_compatible))
svbfloat16_t svmul_bf16_m(svbool_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_bf16_x), arm_streaming_compatible))
svbfloat16_t svmul_bf16_x(svbool_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_bf16_z), arm_streaming_compatible))
svbfloat16_t svmul_bf16_z(svbool_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_lane_bf16), arm_streaming_compatible))
svbfloat16_t svmul_lane_bf16(svbfloat16_t, svbfloat16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_bf16_m), arm_streaming_compatible))
svbfloat16_t svsub_n_bf16_m(svbool_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_bf16_x), arm_streaming_compatible))
svbfloat16_t svsub_n_bf16_x(svbool_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_bf16_z), arm_streaming_compatible))
svbfloat16_t svsub_n_bf16_z(svbool_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_bf16_m), arm_streaming_compatible))
svbfloat16_t svsub_bf16_m(svbool_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_bf16_x), arm_streaming_compatible))
svbfloat16_t svsub_bf16_x(svbool_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_bf16_z), arm_streaming_compatible))
svbfloat16_t svsub_bf16_z(svbool_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_bf16_m), arm_streaming_compatible))
svbfloat16_t svadd_m(svbool_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_bf16_x), arm_streaming_compatible))
svbfloat16_t svadd_x(svbool_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_bf16_z), arm_streaming_compatible))
svbfloat16_t svadd_z(svbool_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_bf16_m), arm_streaming_compatible))
svbfloat16_t svadd_m(svbool_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_bf16_x), arm_streaming_compatible))
svbfloat16_t svadd_x(svbool_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_bf16_z), arm_streaming_compatible))
svbfloat16_t svadd_z(svbool_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_bf16), arm_streaming_compatible))
svbfloat16_t svclamp(svbfloat16_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_bf16_m), arm_streaming_compatible))
svbfloat16_t svmax_m(svbool_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_bf16_x), arm_streaming_compatible))
svbfloat16_t svmax_x(svbool_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_bf16_z), arm_streaming_compatible))
svbfloat16_t svmax_z(svbool_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_bf16_m), arm_streaming_compatible))
svbfloat16_t svmax_m(svbool_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_bf16_x), arm_streaming_compatible))
svbfloat16_t svmax_x(svbool_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_bf16_z), arm_streaming_compatible))
svbfloat16_t svmax_z(svbool_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_n_bf16_m), arm_streaming_compatible))
svbfloat16_t svmaxnm_m(svbool_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_n_bf16_x), arm_streaming_compatible))
svbfloat16_t svmaxnm_x(svbool_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_n_bf16_z), arm_streaming_compatible))
svbfloat16_t svmaxnm_z(svbool_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_bf16_m), arm_streaming_compatible))
svbfloat16_t svmaxnm_m(svbool_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_bf16_x), arm_streaming_compatible))
svbfloat16_t svmaxnm_x(svbool_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_bf16_z), arm_streaming_compatible))
svbfloat16_t svmaxnm_z(svbool_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_bf16_m), arm_streaming_compatible))
svbfloat16_t svmin_m(svbool_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_bf16_x), arm_streaming_compatible))
svbfloat16_t svmin_x(svbool_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_bf16_z), arm_streaming_compatible))
svbfloat16_t svmin_z(svbool_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_bf16_m), arm_streaming_compatible))
svbfloat16_t svmin_m(svbool_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_bf16_x), arm_streaming_compatible))
svbfloat16_t svmin_x(svbool_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_bf16_z), arm_streaming_compatible))
svbfloat16_t svmin_z(svbool_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_n_bf16_m), arm_streaming_compatible))
svbfloat16_t svminnm_m(svbool_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_n_bf16_x), arm_streaming_compatible))
svbfloat16_t svminnm_x(svbool_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_n_bf16_z), arm_streaming_compatible))
svbfloat16_t svminnm_z(svbool_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_bf16_m), arm_streaming_compatible))
svbfloat16_t svminnm_m(svbool_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_bf16_x), arm_streaming_compatible))
svbfloat16_t svminnm_x(svbool_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_bf16_z), arm_streaming_compatible))
svbfloat16_t svminnm_z(svbool_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_bf16_m), arm_streaming_compatible))
svbfloat16_t svmla_m(svbool_t, svbfloat16_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_bf16_x), arm_streaming_compatible))
svbfloat16_t svmla_x(svbool_t, svbfloat16_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_bf16_z), arm_streaming_compatible))
svbfloat16_t svmla_z(svbool_t, svbfloat16_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_bf16_m), arm_streaming_compatible))
svbfloat16_t svmla_m(svbool_t, svbfloat16_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_bf16_x), arm_streaming_compatible))
svbfloat16_t svmla_x(svbool_t, svbfloat16_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_bf16_z), arm_streaming_compatible))
svbfloat16_t svmla_z(svbool_t, svbfloat16_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_lane_bf16), arm_streaming_compatible))
svbfloat16_t svmla_lane(svbfloat16_t, svbfloat16_t, svbfloat16_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_bf16_m), arm_streaming_compatible))
svbfloat16_t svmls_m(svbool_t, svbfloat16_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_bf16_x), arm_streaming_compatible))
svbfloat16_t svmls_x(svbool_t, svbfloat16_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_bf16_z), arm_streaming_compatible))
svbfloat16_t svmls_z(svbool_t, svbfloat16_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_bf16_m), arm_streaming_compatible))
svbfloat16_t svmls_m(svbool_t, svbfloat16_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_bf16_x), arm_streaming_compatible))
svbfloat16_t svmls_x(svbool_t, svbfloat16_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_bf16_z), arm_streaming_compatible))
svbfloat16_t svmls_z(svbool_t, svbfloat16_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_lane_bf16), arm_streaming_compatible))
svbfloat16_t svmls_lane(svbfloat16_t, svbfloat16_t, svbfloat16_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_bf16_m), arm_streaming_compatible))
svbfloat16_t svmul_m(svbool_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_bf16_x), arm_streaming_compatible))
svbfloat16_t svmul_x(svbool_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_bf16_z), arm_streaming_compatible))
svbfloat16_t svmul_z(svbool_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_bf16_m), arm_streaming_compatible))
svbfloat16_t svmul_m(svbool_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_bf16_x), arm_streaming_compatible))
svbfloat16_t svmul_x(svbool_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_bf16_z), arm_streaming_compatible))
svbfloat16_t svmul_z(svbool_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_lane_bf16), arm_streaming_compatible))
svbfloat16_t svmul_lane(svbfloat16_t, svbfloat16_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_bf16_m), arm_streaming_compatible))
svbfloat16_t svsub_m(svbool_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_bf16_x), arm_streaming_compatible))
svbfloat16_t svsub_x(svbool_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_bf16_z), arm_streaming_compatible))
svbfloat16_t svsub_z(svbool_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_bf16_m), arm_streaming_compatible))
svbfloat16_t svsub_m(svbool_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_bf16_x), arm_streaming_compatible))
svbfloat16_t svsub_x(svbool_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_bf16_z), arm_streaming_compatible))
svbfloat16_t svsub_z(svbool_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_u8_x2), arm_streaming))
svuint8x2_t svadd_single_u8_x2(svuint8x2_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_u32_x2), arm_streaming))
svuint32x2_t svadd_single_u32_x2(svuint32x2_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_u64_x2), arm_streaming))
svuint64x2_t svadd_single_u64_x2(svuint64x2_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_u16_x2), arm_streaming))
svuint16x2_t svadd_single_u16_x2(svuint16x2_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_s8_x2), arm_streaming))
svint8x2_t svadd_single_s8_x2(svint8x2_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_s32_x2), arm_streaming))
svint32x2_t svadd_single_s32_x2(svint32x2_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_s64_x2), arm_streaming))
svint64x2_t svadd_single_s64_x2(svint64x2_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_s16_x2), arm_streaming))
svint16x2_t svadd_single_s16_x2(svint16x2_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_u8_x4), arm_streaming))
svuint8x4_t svadd_single_u8_x4(svuint8x4_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_u32_x4), arm_streaming))
svuint32x4_t svadd_single_u32_x4(svuint32x4_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_u64_x4), arm_streaming))
svuint64x4_t svadd_single_u64_x4(svuint64x4_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_u16_x4), arm_streaming))
svuint16x4_t svadd_single_u16_x4(svuint16x4_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_s8_x4), arm_streaming))
svint8x4_t svadd_single_s8_x4(svint8x4_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_s32_x4), arm_streaming))
svint32x4_t svadd_single_s32_x4(svint32x4_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_s64_x4), arm_streaming))
svint64x4_t svadd_single_s64_x4(svint64x4_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_s16_x4), arm_streaming))
svint16x4_t svadd_single_s16_x4(svint16x4_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_f64_x2), arm_streaming))
svfloat64x2_t svclamp_single_f64_x2(svfloat64x2_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_f32_x2), arm_streaming))
svfloat32x2_t svclamp_single_f32_x2(svfloat32x2_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_f16_x2), arm_streaming))
svfloat16x2_t svclamp_single_f16_x2(svfloat16x2_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_s8_x2), arm_streaming))
svint8x2_t svclamp_single_s8_x2(svint8x2_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_s32_x2), arm_streaming))
svint32x2_t svclamp_single_s32_x2(svint32x2_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_s64_x2), arm_streaming))
svint64x2_t svclamp_single_s64_x2(svint64x2_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_s16_x2), arm_streaming))
svint16x2_t svclamp_single_s16_x2(svint16x2_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_u8_x2), arm_streaming))
svuint8x2_t svclamp_single_u8_x2(svuint8x2_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_u32_x2), arm_streaming))
svuint32x2_t svclamp_single_u32_x2(svuint32x2_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_u64_x2), arm_streaming))
svuint64x2_t svclamp_single_u64_x2(svuint64x2_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_u16_x2), arm_streaming))
svuint16x2_t svclamp_single_u16_x2(svuint16x2_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_f64_x4), arm_streaming))
svfloat64x4_t svclamp_single_f64_x4(svfloat64x4_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_f32_x4), arm_streaming))
svfloat32x4_t svclamp_single_f32_x4(svfloat32x4_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_f16_x4), arm_streaming))
svfloat16x4_t svclamp_single_f16_x4(svfloat16x4_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_s8_x4), arm_streaming))
svint8x4_t svclamp_single_s8_x4(svint8x4_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_s32_x4), arm_streaming))
svint32x4_t svclamp_single_s32_x4(svint32x4_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_s64_x4), arm_streaming))
svint64x4_t svclamp_single_s64_x4(svint64x4_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_s16_x4), arm_streaming))
svint16x4_t svclamp_single_s16_x4(svint16x4_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_u8_x4), arm_streaming))
svuint8x4_t svclamp_single_u8_x4(svuint8x4_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_u32_x4), arm_streaming))
svuint32x4_t svclamp_single_u32_x4(svuint32x4_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_u64_x4), arm_streaming))
svuint64x4_t svclamp_single_u64_x4(svuint64x4_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_u16_x4), arm_streaming))
svuint16x4_t svclamp_single_u16_x4(svuint16x4_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_bf16_f32_x2), arm_streaming))
svbfloat16_t svcvt_bf16_f32_x2(svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_f32_x2), arm_streaming))
svfloat16_t svcvt_f16_f32_x2(svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_s32_f32_x2), arm_streaming))
svint32x2_t svcvt_s32_f32_x2(svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_s32_f32_x4), arm_streaming))
svint32x4_t svcvt_s32_f32_x4(svfloat32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_u32_f32_x2), arm_streaming))
svuint32x2_t svcvt_u32_f32_x2(svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_u32_f32_x4), arm_streaming))
svuint32x4_t svcvt_u32_f32_x4(svfloat32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_s32_x2), arm_streaming))
svfloat32x2_t svcvt_f32_s32_x2(svint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_s32_x4), arm_streaming))
svfloat32x4_t svcvt_f32_s32_x4(svint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_u32_x2), arm_streaming))
svfloat32x2_t svcvt_f32_u32_x2(svuint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_u32_x4), arm_streaming))
svfloat32x4_t svcvt_f32_u32_x4(svuint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtn_bf16_f32_x2), arm_streaming))
svbfloat16_t svcvtn_bf16_f32_x2(svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtn_f16_f32_x2), arm_streaming))
svfloat16_t svcvtn_f16_f32_x2(svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_f64_x2), arm_streaming))
svfloat64x2_t svmax_single_f64_x2(svfloat64x2_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_f32_x2), arm_streaming))
svfloat32x2_t svmax_single_f32_x2(svfloat32x2_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_f16_x2), arm_streaming))
svfloat16x2_t svmax_single_f16_x2(svfloat16x2_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_s8_x2), arm_streaming))
svint8x2_t svmax_single_s8_x2(svint8x2_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_s32_x2), arm_streaming))
svint32x2_t svmax_single_s32_x2(svint32x2_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_s64_x2), arm_streaming))
svint64x2_t svmax_single_s64_x2(svint64x2_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_s16_x2), arm_streaming))
svint16x2_t svmax_single_s16_x2(svint16x2_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_u8_x2), arm_streaming))
svuint8x2_t svmax_single_u8_x2(svuint8x2_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_u32_x2), arm_streaming))
svuint32x2_t svmax_single_u32_x2(svuint32x2_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_u64_x2), arm_streaming))
svuint64x2_t svmax_single_u64_x2(svuint64x2_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_u16_x2), arm_streaming))
svuint16x2_t svmax_single_u16_x2(svuint16x2_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_f64_x4), arm_streaming))
svfloat64x4_t svmax_single_f64_x4(svfloat64x4_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_f32_x4), arm_streaming))
svfloat32x4_t svmax_single_f32_x4(svfloat32x4_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_f16_x4), arm_streaming))
svfloat16x4_t svmax_single_f16_x4(svfloat16x4_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_s8_x4), arm_streaming))
svint8x4_t svmax_single_s8_x4(svint8x4_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_s32_x4), arm_streaming))
svint32x4_t svmax_single_s32_x4(svint32x4_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_s64_x4), arm_streaming))
svint64x4_t svmax_single_s64_x4(svint64x4_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_s16_x4), arm_streaming))
svint16x4_t svmax_single_s16_x4(svint16x4_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_u8_x4), arm_streaming))
svuint8x4_t svmax_single_u8_x4(svuint8x4_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_u32_x4), arm_streaming))
svuint32x4_t svmax_single_u32_x4(svuint32x4_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_u64_x4), arm_streaming))
svuint64x4_t svmax_single_u64_x4(svuint64x4_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_u16_x4), arm_streaming))
svuint16x4_t svmax_single_u16_x4(svuint16x4_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_f64_x2), arm_streaming))
svfloat64x2_t svmax_f64_x2(svfloat64x2_t, svfloat64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_f32_x2), arm_streaming))
svfloat32x2_t svmax_f32_x2(svfloat32x2_t, svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_f16_x2), arm_streaming))
svfloat16x2_t svmax_f16_x2(svfloat16x2_t, svfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s8_x2), arm_streaming))
svint8x2_t svmax_s8_x2(svint8x2_t, svint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s32_x2), arm_streaming))
svint32x2_t svmax_s32_x2(svint32x2_t, svint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s64_x2), arm_streaming))
svint64x2_t svmax_s64_x2(svint64x2_t, svint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s16_x2), arm_streaming))
svint16x2_t svmax_s16_x2(svint16x2_t, svint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u8_x2), arm_streaming))
svuint8x2_t svmax_u8_x2(svuint8x2_t, svuint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u32_x2), arm_streaming))
svuint32x2_t svmax_u32_x2(svuint32x2_t, svuint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u64_x2), arm_streaming))
svuint64x2_t svmax_u64_x2(svuint64x2_t, svuint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u16_x2), arm_streaming))
svuint16x2_t svmax_u16_x2(svuint16x2_t, svuint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_f64_x4), arm_streaming))
svfloat64x4_t svmax_f64_x4(svfloat64x4_t, svfloat64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_f32_x4), arm_streaming))
svfloat32x4_t svmax_f32_x4(svfloat32x4_t, svfloat32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_f16_x4), arm_streaming))
svfloat16x4_t svmax_f16_x4(svfloat16x4_t, svfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s8_x4), arm_streaming))
svint8x4_t svmax_s8_x4(svint8x4_t, svint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s32_x4), arm_streaming))
svint32x4_t svmax_s32_x4(svint32x4_t, svint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s64_x4), arm_streaming))
svint64x4_t svmax_s64_x4(svint64x4_t, svint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s16_x4), arm_streaming))
svint16x4_t svmax_s16_x4(svint16x4_t, svint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u8_x4), arm_streaming))
svuint8x4_t svmax_u8_x4(svuint8x4_t, svuint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u32_x4), arm_streaming))
svuint32x4_t svmax_u32_x4(svuint32x4_t, svuint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u64_x4), arm_streaming))
svuint64x4_t svmax_u64_x4(svuint64x4_t, svuint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u16_x4), arm_streaming))
svuint16x4_t svmax_u16_x4(svuint16x4_t, svuint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_single_f64_x2), arm_streaming))
svfloat64x2_t svmaxnm_single_f64_x2(svfloat64x2_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_single_f32_x2), arm_streaming))
svfloat32x2_t svmaxnm_single_f32_x2(svfloat32x2_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_single_f16_x2), arm_streaming))
svfloat16x2_t svmaxnm_single_f16_x2(svfloat16x2_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_single_f64_x4), arm_streaming))
svfloat64x4_t svmaxnm_single_f64_x4(svfloat64x4_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_single_f32_x4), arm_streaming))
svfloat32x4_t svmaxnm_single_f32_x4(svfloat32x4_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_single_f16_x4), arm_streaming))
svfloat16x4_t svmaxnm_single_f16_x4(svfloat16x4_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_f64_x2), arm_streaming))
svfloat64x2_t svmaxnm_f64_x2(svfloat64x2_t, svfloat64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_f32_x2), arm_streaming))
svfloat32x2_t svmaxnm_f32_x2(svfloat32x2_t, svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_f16_x2), arm_streaming))
svfloat16x2_t svmaxnm_f16_x2(svfloat16x2_t, svfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_f64_x4), arm_streaming))
svfloat64x4_t svmaxnm_f64_x4(svfloat64x4_t, svfloat64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_f32_x4), arm_streaming))
svfloat32x4_t svmaxnm_f32_x4(svfloat32x4_t, svfloat32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_f16_x4), arm_streaming))
svfloat16x4_t svmaxnm_f16_x4(svfloat16x4_t, svfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_f64_x2), arm_streaming))
svfloat64x2_t svmin_single_f64_x2(svfloat64x2_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_f32_x2), arm_streaming))
svfloat32x2_t svmin_single_f32_x2(svfloat32x2_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_f16_x2), arm_streaming))
svfloat16x2_t svmin_single_f16_x2(svfloat16x2_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_s8_x2), arm_streaming))
svint8x2_t svmin_single_s8_x2(svint8x2_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_s32_x2), arm_streaming))
svint32x2_t svmin_single_s32_x2(svint32x2_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_s64_x2), arm_streaming))
svint64x2_t svmin_single_s64_x2(svint64x2_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_s16_x2), arm_streaming))
svint16x2_t svmin_single_s16_x2(svint16x2_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_u8_x2), arm_streaming))
svuint8x2_t svmin_single_u8_x2(svuint8x2_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_u32_x2), arm_streaming))
svuint32x2_t svmin_single_u32_x2(svuint32x2_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_u64_x2), arm_streaming))
svuint64x2_t svmin_single_u64_x2(svuint64x2_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_u16_x2), arm_streaming))
svuint16x2_t svmin_single_u16_x2(svuint16x2_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_f64_x4), arm_streaming))
svfloat64x4_t svmin_single_f64_x4(svfloat64x4_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_f32_x4), arm_streaming))
svfloat32x4_t svmin_single_f32_x4(svfloat32x4_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_f16_x4), arm_streaming))
svfloat16x4_t svmin_single_f16_x4(svfloat16x4_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_s8_x4), arm_streaming))
svint8x4_t svmin_single_s8_x4(svint8x4_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_s32_x4), arm_streaming))
svint32x4_t svmin_single_s32_x4(svint32x4_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_s64_x4), arm_streaming))
svint64x4_t svmin_single_s64_x4(svint64x4_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_s16_x4), arm_streaming))
svint16x4_t svmin_single_s16_x4(svint16x4_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_u8_x4), arm_streaming))
svuint8x4_t svmin_single_u8_x4(svuint8x4_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_u32_x4), arm_streaming))
svuint32x4_t svmin_single_u32_x4(svuint32x4_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_u64_x4), arm_streaming))
svuint64x4_t svmin_single_u64_x4(svuint64x4_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_u16_x4), arm_streaming))
svuint16x4_t svmin_single_u16_x4(svuint16x4_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_f64_x2), arm_streaming))
svfloat64x2_t svmin_f64_x2(svfloat64x2_t, svfloat64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_f32_x2), arm_streaming))
svfloat32x2_t svmin_f32_x2(svfloat32x2_t, svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_f16_x2), arm_streaming))
svfloat16x2_t svmin_f16_x2(svfloat16x2_t, svfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s8_x2), arm_streaming))
svint8x2_t svmin_s8_x2(svint8x2_t, svint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s32_x2), arm_streaming))
svint32x2_t svmin_s32_x2(svint32x2_t, svint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s64_x2), arm_streaming))
svint64x2_t svmin_s64_x2(svint64x2_t, svint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s16_x2), arm_streaming))
svint16x2_t svmin_s16_x2(svint16x2_t, svint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u8_x2), arm_streaming))
svuint8x2_t svmin_u8_x2(svuint8x2_t, svuint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u32_x2), arm_streaming))
svuint32x2_t svmin_u32_x2(svuint32x2_t, svuint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u64_x2), arm_streaming))
svuint64x2_t svmin_u64_x2(svuint64x2_t, svuint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u16_x2), arm_streaming))
svuint16x2_t svmin_u16_x2(svuint16x2_t, svuint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_f64_x4), arm_streaming))
svfloat64x4_t svmin_f64_x4(svfloat64x4_t, svfloat64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_f32_x4), arm_streaming))
svfloat32x4_t svmin_f32_x4(svfloat32x4_t, svfloat32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_f16_x4), arm_streaming))
svfloat16x4_t svmin_f16_x4(svfloat16x4_t, svfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s8_x4), arm_streaming))
svint8x4_t svmin_s8_x4(svint8x4_t, svint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s32_x4), arm_streaming))
svint32x4_t svmin_s32_x4(svint32x4_t, svint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s64_x4), arm_streaming))
svint64x4_t svmin_s64_x4(svint64x4_t, svint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s16_x4), arm_streaming))
svint16x4_t svmin_s16_x4(svint16x4_t, svint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u8_x4), arm_streaming))
svuint8x4_t svmin_u8_x4(svuint8x4_t, svuint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u32_x4), arm_streaming))
svuint32x4_t svmin_u32_x4(svuint32x4_t, svuint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u64_x4), arm_streaming))
svuint64x4_t svmin_u64_x4(svuint64x4_t, svuint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u16_x4), arm_streaming))
svuint16x4_t svmin_u16_x4(svuint16x4_t, svuint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_single_f64_x2), arm_streaming))
svfloat64x2_t svminnm_single_f64_x2(svfloat64x2_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_single_f32_x2), arm_streaming))
svfloat32x2_t svminnm_single_f32_x2(svfloat32x2_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_single_f16_x2), arm_streaming))
svfloat16x2_t svminnm_single_f16_x2(svfloat16x2_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_single_f64_x4), arm_streaming))
svfloat64x4_t svminnm_single_f64_x4(svfloat64x4_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_single_f32_x4), arm_streaming))
svfloat32x4_t svminnm_single_f32_x4(svfloat32x4_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_single_f16_x4), arm_streaming))
svfloat16x4_t svminnm_single_f16_x4(svfloat16x4_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_f64_x2), arm_streaming))
svfloat64x2_t svminnm_f64_x2(svfloat64x2_t, svfloat64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_f32_x2), arm_streaming))
svfloat32x2_t svminnm_f32_x2(svfloat32x2_t, svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_f16_x2), arm_streaming))
svfloat16x2_t svminnm_f16_x2(svfloat16x2_t, svfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_f64_x4), arm_streaming))
svfloat64x4_t svminnm_f64_x4(svfloat64x4_t, svfloat64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_f32_x4), arm_streaming))
svfloat32x4_t svminnm_f32_x4(svfloat32x4_t, svfloat32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_f16_x4), arm_streaming))
svfloat16x4_t svminnm_f16_x4(svfloat16x4_t, svfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvt_s16_s32_x2), arm_streaming))
svint16_t svqcvt_s16_s32_x2(svint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvt_s16_s64_x4), arm_streaming))
svint16_t svqcvt_s16_s64_x4(svint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvt_s8_s32_x4), arm_streaming))
svint8_t svqcvt_s8_s32_x4(svint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvt_u16_s32_x2), arm_streaming))
svuint16_t svqcvt_u16_s32_x2(svint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvt_u16_u32_x2), arm_streaming))
svuint16_t svqcvt_u16_u32_x2(svuint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvt_u16_s64_x4), arm_streaming))
svuint16_t svqcvt_u16_s64_x4(svint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvt_u16_u64_x4), arm_streaming))
svuint16_t svqcvt_u16_u64_x4(svuint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvt_u8_s32_x4), arm_streaming))
svuint8_t svqcvt_u8_s32_x4(svint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvt_u8_u32_x4), arm_streaming))
svuint8_t svqcvt_u8_u32_x4(svuint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvtn_s16_s64_x4), arm_streaming))
svint16_t svqcvtn_s16_s64_x4(svint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvtn_s8_s32_x4), arm_streaming))
svint8_t svqcvtn_s8_s32_x4(svint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvtn_u16_s64_x4), arm_streaming))
svuint16_t svqcvtn_u16_s64_x4(svint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvtn_u16_u64_x4), arm_streaming))
svuint16_t svqcvtn_u16_u64_x4(svuint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvtn_u8_s32_x4), arm_streaming))
svuint8_t svqcvtn_u8_s32_x4(svint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvtn_u8_u32_x4), arm_streaming))
svuint8_t svqcvtn_u8_u32_x4(svuint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_single_s8_x2), arm_streaming))
svint8x2_t svqdmulh_single_s8_x2(svint8x2_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_single_s32_x2), arm_streaming))
svint32x2_t svqdmulh_single_s32_x2(svint32x2_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_single_s64_x2), arm_streaming))
svint64x2_t svqdmulh_single_s64_x2(svint64x2_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_single_s16_x2), arm_streaming))
svint16x2_t svqdmulh_single_s16_x2(svint16x2_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_single_s8_x4), arm_streaming))
svint8x4_t svqdmulh_single_s8_x4(svint8x4_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_single_s32_x4), arm_streaming))
svint32x4_t svqdmulh_single_s32_x4(svint32x4_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_single_s64_x4), arm_streaming))
svint64x4_t svqdmulh_single_s64_x4(svint64x4_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_single_s16_x4), arm_streaming))
svint16x4_t svqdmulh_single_s16_x4(svint16x4_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_s8_x2), arm_streaming))
svint8x2_t svqdmulh_s8_x2(svint8x2_t, svint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_s32_x2), arm_streaming))
svint32x2_t svqdmulh_s32_x2(svint32x2_t, svint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_s64_x2), arm_streaming))
svint64x2_t svqdmulh_s64_x2(svint64x2_t, svint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_s16_x2), arm_streaming))
svint16x2_t svqdmulh_s16_x2(svint16x2_t, svint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_s8_x4), arm_streaming))
svint8x4_t svqdmulh_s8_x4(svint8x4_t, svint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_s32_x4), arm_streaming))
svint32x4_t svqdmulh_s32_x4(svint32x4_t, svint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_s64_x4), arm_streaming))
svint64x4_t svqdmulh_s64_x4(svint64x4_t, svint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_s16_x4), arm_streaming))
svint16x4_t svqdmulh_s16_x4(svint16x4_t, svint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshr_n_s16_s32_x2), arm_streaming))
svint16_t svqrshr_n_s16_s32_x2(svint32x2_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshr_n_u16_u32_x2), arm_streaming))
svuint16_t svqrshr_n_u16_u32_x2(svuint32x2_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshr_n_s8_s32_x4), arm_streaming))
svint8_t svqrshr_n_s8_s32_x4(svint32x4_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshr_n_s16_s64_x4), arm_streaming))
svint16_t svqrshr_n_s16_s64_x4(svint64x4_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshr_n_u8_u32_x4), arm_streaming))
svuint8_t svqrshr_n_u8_u32_x4(svuint32x4_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshr_n_u16_u64_x4), arm_streaming))
svuint16_t svqrshr_n_u16_u64_x4(svuint64x4_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshrn_n_s8_s32_x4), arm_streaming))
svint8_t svqrshrn_n_s8_s32_x4(svint32x4_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshrn_n_s16_s64_x4), arm_streaming))
svint16_t svqrshrn_n_s16_s64_x4(svint64x4_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshrn_n_u8_u32_x4), arm_streaming))
svuint8_t svqrshrn_n_u8_u32_x4(svuint32x4_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshrn_n_u16_u64_x4), arm_streaming))
svuint16_t svqrshrn_n_u16_u64_x4(svuint64x4_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshru_n_u16_s32_x2), arm_streaming))
svuint16_t svqrshru_n_u16_s32_x2(svint32x2_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshru_n_u8_s32_x4), arm_streaming))
svuint8_t svqrshru_n_u8_s32_x4(svint32x4_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshru_n_u16_s64_x4), arm_streaming))
svuint16_t svqrshru_n_u16_s64_x4(svint64x4_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshrun_n_u8_s32_x4), arm_streaming))
svuint8_t svqrshrun_n_u8_s32_x4(svint32x4_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshrun_n_u16_s64_x4), arm_streaming))
svuint16_t svqrshrun_n_u16_s64_x4(svint64x4_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svreinterpret_b), arm_streaming_compatible))
svbool_t svreinterpret_b(svcount_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svreinterpret_c), arm_streaming_compatible))
svcount_t svreinterpret_c(svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrinta_f32_x2), arm_streaming))
svfloat32x2_t svrinta_f32_x2(svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrinta_f32_x4), arm_streaming))
svfloat32x4_t svrinta_f32_x4(svfloat32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintm_f32_x2), arm_streaming))
svfloat32x2_t svrintm_f32_x2(svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintm_f32_x4), arm_streaming))
svfloat32x4_t svrintm_f32_x4(svfloat32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintn_f32_x2), arm_streaming))
svfloat32x2_t svrintn_f32_x2(svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintn_f32_x4), arm_streaming))
svfloat32x4_t svrintn_f32_x4(svfloat32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintp_f32_x2), arm_streaming))
svfloat32x2_t svrintp_f32_x2(svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintp_f32_x4), arm_streaming))
svfloat32x4_t svrintp_f32_x4(svfloat32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_s8_x2), arm_streaming))
svint8x2_t svrshl_single_s8_x2(svint8x2_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_s32_x2), arm_streaming))
svint32x2_t svrshl_single_s32_x2(svint32x2_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_s64_x2), arm_streaming))
svint64x2_t svrshl_single_s64_x2(svint64x2_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_s16_x2), arm_streaming))
svint16x2_t svrshl_single_s16_x2(svint16x2_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_u8_x2), arm_streaming))
svuint8x2_t svrshl_single_u8_x2(svuint8x2_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_u32_x2), arm_streaming))
svuint32x2_t svrshl_single_u32_x2(svuint32x2_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_u64_x2), arm_streaming))
svuint64x2_t svrshl_single_u64_x2(svuint64x2_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_u16_x2), arm_streaming))
svuint16x2_t svrshl_single_u16_x2(svuint16x2_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_s8_x4), arm_streaming))
svint8x4_t svrshl_single_s8_x4(svint8x4_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_s32_x4), arm_streaming))
svint32x4_t svrshl_single_s32_x4(svint32x4_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_s64_x4), arm_streaming))
svint64x4_t svrshl_single_s64_x4(svint64x4_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_s16_x4), arm_streaming))
svint16x4_t svrshl_single_s16_x4(svint16x4_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_u8_x4), arm_streaming))
svuint8x4_t svrshl_single_u8_x4(svuint8x4_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_u32_x4), arm_streaming))
svuint32x4_t svrshl_single_u32_x4(svuint32x4_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_u64_x4), arm_streaming))
svuint64x4_t svrshl_single_u64_x4(svuint64x4_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_u16_x4), arm_streaming))
svuint16x4_t svrshl_single_u16_x4(svuint16x4_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_s8_x2), arm_streaming))
svint8x2_t svrshl_s8_x2(svint8x2_t, svint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_s32_x2), arm_streaming))
svint32x2_t svrshl_s32_x2(svint32x2_t, svint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_s64_x2), arm_streaming))
svint64x2_t svrshl_s64_x2(svint64x2_t, svint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_s16_x2), arm_streaming))
svint16x2_t svrshl_s16_x2(svint16x2_t, svint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_u8_x2), arm_streaming))
svuint8x2_t svrshl_u8_x2(svuint8x2_t, svuint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_u32_x2), arm_streaming))
svuint32x2_t svrshl_u32_x2(svuint32x2_t, svuint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_u64_x2), arm_streaming))
svuint64x2_t svrshl_u64_x2(svuint64x2_t, svuint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_u16_x2), arm_streaming))
svuint16x2_t svrshl_u16_x2(svuint16x2_t, svuint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_s8_x4), arm_streaming))
svint8x4_t svrshl_s8_x4(svint8x4_t, svint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_s32_x4), arm_streaming))
svint32x4_t svrshl_s32_x4(svint32x4_t, svint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_s64_x4), arm_streaming))
svint64x4_t svrshl_s64_x4(svint64x4_t, svint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_s16_x4), arm_streaming))
svint16x4_t svrshl_s16_x4(svint16x4_t, svint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_u8_x4), arm_streaming))
svuint8x4_t svrshl_u8_x4(svuint8x4_t, svuint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_u32_x4), arm_streaming))
svuint32x4_t svrshl_u32_x4(svuint32x4_t, svuint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_u64_x4), arm_streaming))
svuint64x4_t svrshl_u64_x4(svuint64x4_t, svuint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_u16_x4), arm_streaming))
svuint16x4_t svrshl_u16_x4(svuint16x4_t, svuint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_u8_x2), arm_streaming))
svuint8x2_t svsel_u8_x2(svcount_t, svuint8x2_t, svuint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_u32_x2), arm_streaming))
svuint32x2_t svsel_u32_x2(svcount_t, svuint32x2_t, svuint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_u64_x2), arm_streaming))
svuint64x2_t svsel_u64_x2(svcount_t, svuint64x2_t, svuint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_u16_x2), arm_streaming))
svuint16x2_t svsel_u16_x2(svcount_t, svuint16x2_t, svuint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_bf16_x2), arm_streaming))
svbfloat16x2_t svsel_bf16_x2(svcount_t, svbfloat16x2_t, svbfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_s8_x2), arm_streaming))
svint8x2_t svsel_s8_x2(svcount_t, svint8x2_t, svint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_f64_x2), arm_streaming))
svfloat64x2_t svsel_f64_x2(svcount_t, svfloat64x2_t, svfloat64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_f32_x2), arm_streaming))
svfloat32x2_t svsel_f32_x2(svcount_t, svfloat32x2_t, svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_f16_x2), arm_streaming))
svfloat16x2_t svsel_f16_x2(svcount_t, svfloat16x2_t, svfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_s32_x2), arm_streaming))
svint32x2_t svsel_s32_x2(svcount_t, svint32x2_t, svint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_s64_x2), arm_streaming))
svint64x2_t svsel_s64_x2(svcount_t, svint64x2_t, svint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_s16_x2), arm_streaming))
svint16x2_t svsel_s16_x2(svcount_t, svint16x2_t, svint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_u8_x4), arm_streaming))
svuint8x4_t svsel_u8_x4(svcount_t, svuint8x4_t, svuint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_u32_x4), arm_streaming))
svuint32x4_t svsel_u32_x4(svcount_t, svuint32x4_t, svuint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_u64_x4), arm_streaming))
svuint64x4_t svsel_u64_x4(svcount_t, svuint64x4_t, svuint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_u16_x4), arm_streaming))
svuint16x4_t svsel_u16_x4(svcount_t, svuint16x4_t, svuint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_bf16_x4), arm_streaming))
svbfloat16x4_t svsel_bf16_x4(svcount_t, svbfloat16x4_t, svbfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_s8_x4), arm_streaming))
svint8x4_t svsel_s8_x4(svcount_t, svint8x4_t, svint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_f64_x4), arm_streaming))
svfloat64x4_t svsel_f64_x4(svcount_t, svfloat64x4_t, svfloat64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_f32_x4), arm_streaming))
svfloat32x4_t svsel_f32_x4(svcount_t, svfloat32x4_t, svfloat32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_f16_x4), arm_streaming))
svfloat16x4_t svsel_f16_x4(svcount_t, svfloat16x4_t, svfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_s32_x4), arm_streaming))
svint32x4_t svsel_s32_x4(svcount_t, svint32x4_t, svint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_s64_x4), arm_streaming))
svint64x4_t svsel_s64_x4(svcount_t, svint64x4_t, svint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_s16_x4), arm_streaming))
svint16x4_t svsel_s16_x4(svcount_t, svint16x4_t, svint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_s32_s16_x2), arm_streaming))
svint32x2_t svunpk_s32_s16_x2(svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_s64_s32_x2), arm_streaming))
svint64x2_t svunpk_s64_s32_x2(svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_s16_s8_x2), arm_streaming))
svint16x2_t svunpk_s16_s8_x2(svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_u32_u16_x2), arm_streaming))
svuint32x2_t svunpk_u32_u16_x2(svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_u64_u32_x2), arm_streaming))
svuint64x2_t svunpk_u64_u32_x2(svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_u16_u8_x2), arm_streaming))
svuint16x2_t svunpk_u16_u8_x2(svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_s32_s16_x4), arm_streaming))
svint32x4_t svunpk_s32_s16_x4(svint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_s64_s32_x4), arm_streaming))
svint64x4_t svunpk_s64_s32_x4(svint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_s16_s8_x4), arm_streaming))
svint16x4_t svunpk_s16_s8_x4(svint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_u32_u16_x4), arm_streaming))
svuint32x4_t svunpk_u32_u16_x4(svuint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_u64_u32_x4), arm_streaming))
svuint64x4_t svunpk_u64_u32_x4(svuint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_u16_u8_x4), arm_streaming))
svuint16x4_t svunpk_u16_u8_x4(svuint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_u8_x2), arm_streaming))
svuint8x2_t svuzp_u8_x2(svuint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_u32_x2), arm_streaming))
svuint32x2_t svuzp_u32_x2(svuint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_u64_x2), arm_streaming))
svuint64x2_t svuzp_u64_x2(svuint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_u16_x2), arm_streaming))
svuint16x2_t svuzp_u16_x2(svuint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_bf16_x2), arm_streaming))
svbfloat16x2_t svuzp_bf16_x2(svbfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_s8_x2), arm_streaming))
svint8x2_t svuzp_s8_x2(svint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_f64_x2), arm_streaming))
svfloat64x2_t svuzp_f64_x2(svfloat64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_f32_x2), arm_streaming))
svfloat32x2_t svuzp_f32_x2(svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_f16_x2), arm_streaming))
svfloat16x2_t svuzp_f16_x2(svfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_s32_x2), arm_streaming))
svint32x2_t svuzp_s32_x2(svint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_s64_x2), arm_streaming))
svint64x2_t svuzp_s64_x2(svint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_s16_x2), arm_streaming))
svint16x2_t svuzp_s16_x2(svint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_u8_x4), arm_streaming))
svuint8x4_t svuzp_u8_x4(svuint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_u32_x4), arm_streaming))
svuint32x4_t svuzp_u32_x4(svuint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_u64_x4), arm_streaming))
svuint64x4_t svuzp_u64_x4(svuint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_u16_x4), arm_streaming))
svuint16x4_t svuzp_u16_x4(svuint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_bf16_x4), arm_streaming))
svbfloat16x4_t svuzp_bf16_x4(svbfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_s8_x4), arm_streaming))
svint8x4_t svuzp_s8_x4(svint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_f64_x4), arm_streaming))
svfloat64x4_t svuzp_f64_x4(svfloat64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_f32_x4), arm_streaming))
svfloat32x4_t svuzp_f32_x4(svfloat32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_f16_x4), arm_streaming))
svfloat16x4_t svuzp_f16_x4(svfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_s32_x4), arm_streaming))
svint32x4_t svuzp_s32_x4(svint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_s64_x4), arm_streaming))
svint64x4_t svuzp_s64_x4(svint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_s16_x4), arm_streaming))
svint16x4_t svuzp_s16_x4(svint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_u8_x2), arm_streaming))
svuint8x2_t svuzpq_u8_x2(svuint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_u32_x2), arm_streaming))
svuint32x2_t svuzpq_u32_x2(svuint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_u64_x2), arm_streaming))
svuint64x2_t svuzpq_u64_x2(svuint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_u16_x2), arm_streaming))
svuint16x2_t svuzpq_u16_x2(svuint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_bf16_x2), arm_streaming))
svbfloat16x2_t svuzpq_bf16_x2(svbfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_s8_x2), arm_streaming))
svint8x2_t svuzpq_s8_x2(svint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_f64_x2), arm_streaming))
svfloat64x2_t svuzpq_f64_x2(svfloat64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_f32_x2), arm_streaming))
svfloat32x2_t svuzpq_f32_x2(svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_f16_x2), arm_streaming))
svfloat16x2_t svuzpq_f16_x2(svfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_s32_x2), arm_streaming))
svint32x2_t svuzpq_s32_x2(svint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_s64_x2), arm_streaming))
svint64x2_t svuzpq_s64_x2(svint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_s16_x2), arm_streaming))
svint16x2_t svuzpq_s16_x2(svint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_u8_x4), arm_streaming))
svuint8x4_t svuzpq_u8_x4(svuint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_u32_x4), arm_streaming))
svuint32x4_t svuzpq_u32_x4(svuint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_u64_x4), arm_streaming))
svuint64x4_t svuzpq_u64_x4(svuint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_u16_x4), arm_streaming))
svuint16x4_t svuzpq_u16_x4(svuint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_bf16_x4), arm_streaming))
svbfloat16x4_t svuzpq_bf16_x4(svbfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_s8_x4), arm_streaming))
svint8x4_t svuzpq_s8_x4(svint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_f64_x4), arm_streaming))
svfloat64x4_t svuzpq_f64_x4(svfloat64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_f32_x4), arm_streaming))
svfloat32x4_t svuzpq_f32_x4(svfloat32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_f16_x4), arm_streaming))
svfloat16x4_t svuzpq_f16_x4(svfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_s32_x4), arm_streaming))
svint32x4_t svuzpq_s32_x4(svint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_s64_x4), arm_streaming))
svint64x4_t svuzpq_s64_x4(svint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_s16_x4), arm_streaming))
svint16x4_t svuzpq_s16_x4(svint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_u8_x2), arm_streaming))
svuint8x2_t svzip_u8_x2(svuint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_u32_x2), arm_streaming))
svuint32x2_t svzip_u32_x2(svuint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_u64_x2), arm_streaming))
svuint64x2_t svzip_u64_x2(svuint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_u16_x2), arm_streaming))
svuint16x2_t svzip_u16_x2(svuint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_bf16_x2), arm_streaming))
svbfloat16x2_t svzip_bf16_x2(svbfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_s8_x2), arm_streaming))
svint8x2_t svzip_s8_x2(svint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_f64_x2), arm_streaming))
svfloat64x2_t svzip_f64_x2(svfloat64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_f32_x2), arm_streaming))
svfloat32x2_t svzip_f32_x2(svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_f16_x2), arm_streaming))
svfloat16x2_t svzip_f16_x2(svfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_s32_x2), arm_streaming))
svint32x2_t svzip_s32_x2(svint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_s64_x2), arm_streaming))
svint64x2_t svzip_s64_x2(svint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_s16_x2), arm_streaming))
svint16x2_t svzip_s16_x2(svint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_u8_x4), arm_streaming))
svuint8x4_t svzip_u8_x4(svuint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_u32_x4), arm_streaming))
svuint32x4_t svzip_u32_x4(svuint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_u64_x4), arm_streaming))
svuint64x4_t svzip_u64_x4(svuint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_u16_x4), arm_streaming))
svuint16x4_t svzip_u16_x4(svuint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_bf16_x4), arm_streaming))
svbfloat16x4_t svzip_bf16_x4(svbfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_s8_x4), arm_streaming))
svint8x4_t svzip_s8_x4(svint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_f64_x4), arm_streaming))
svfloat64x4_t svzip_f64_x4(svfloat64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_f32_x4), arm_streaming))
svfloat32x4_t svzip_f32_x4(svfloat32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_f16_x4), arm_streaming))
svfloat16x4_t svzip_f16_x4(svfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_s32_x4), arm_streaming))
svint32x4_t svzip_s32_x4(svint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_s64_x4), arm_streaming))
svint64x4_t svzip_s64_x4(svint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_s16_x4), arm_streaming))
svint16x4_t svzip_s16_x4(svint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_u8_x2), arm_streaming))
svuint8x2_t svzipq_u8_x2(svuint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_u32_x2), arm_streaming))
svuint32x2_t svzipq_u32_x2(svuint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_u64_x2), arm_streaming))
svuint64x2_t svzipq_u64_x2(svuint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_u16_x2), arm_streaming))
svuint16x2_t svzipq_u16_x2(svuint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_bf16_x2), arm_streaming))
svbfloat16x2_t svzipq_bf16_x2(svbfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_s8_x2), arm_streaming))
svint8x2_t svzipq_s8_x2(svint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_f64_x2), arm_streaming))
svfloat64x2_t svzipq_f64_x2(svfloat64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_f32_x2), arm_streaming))
svfloat32x2_t svzipq_f32_x2(svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_f16_x2), arm_streaming))
svfloat16x2_t svzipq_f16_x2(svfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_s32_x2), arm_streaming))
svint32x2_t svzipq_s32_x2(svint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_s64_x2), arm_streaming))
svint64x2_t svzipq_s64_x2(svint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_s16_x2), arm_streaming))
svint16x2_t svzipq_s16_x2(svint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_u8_x4), arm_streaming))
svuint8x4_t svzipq_u8_x4(svuint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_u32_x4), arm_streaming))
svuint32x4_t svzipq_u32_x4(svuint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_u64_x4), arm_streaming))
svuint64x4_t svzipq_u64_x4(svuint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_u16_x4), arm_streaming))
svuint16x4_t svzipq_u16_x4(svuint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_bf16_x4), arm_streaming))
svbfloat16x4_t svzipq_bf16_x4(svbfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_s8_x4), arm_streaming))
svint8x4_t svzipq_s8_x4(svint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_f64_x4), arm_streaming))
svfloat64x4_t svzipq_f64_x4(svfloat64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_f32_x4), arm_streaming))
svfloat32x4_t svzipq_f32_x4(svfloat32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_f16_x4), arm_streaming))
svfloat16x4_t svzipq_f16_x4(svfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_s32_x4), arm_streaming))
svint32x4_t svzipq_s32_x4(svint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_s64_x4), arm_streaming))
svint64x4_t svzipq_s64_x4(svint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_s16_x4), arm_streaming))
svint16x4_t svzipq_s16_x4(svint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_u8_x2), arm_streaming))
svuint8x2_t svadd(svuint8x2_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_u32_x2), arm_streaming))
svuint32x2_t svadd(svuint32x2_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_u64_x2), arm_streaming))
svuint64x2_t svadd(svuint64x2_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_u16_x2), arm_streaming))
svuint16x2_t svadd(svuint16x2_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_s8_x2), arm_streaming))
svint8x2_t svadd(svint8x2_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_s32_x2), arm_streaming))
svint32x2_t svadd(svint32x2_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_s64_x2), arm_streaming))
svint64x2_t svadd(svint64x2_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_s16_x2), arm_streaming))
svint16x2_t svadd(svint16x2_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_u8_x4), arm_streaming))
svuint8x4_t svadd(svuint8x4_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_u32_x4), arm_streaming))
svuint32x4_t svadd(svuint32x4_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_u64_x4), arm_streaming))
svuint64x4_t svadd(svuint64x4_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_u16_x4), arm_streaming))
svuint16x4_t svadd(svuint16x4_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_s8_x4), arm_streaming))
svint8x4_t svadd(svint8x4_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_s32_x4), arm_streaming))
svint32x4_t svadd(svint32x4_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_s64_x4), arm_streaming))
svint64x4_t svadd(svint64x4_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_s16_x4), arm_streaming))
svint16x4_t svadd(svint16x4_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_f64_x2), arm_streaming))
svfloat64x2_t svclamp(svfloat64x2_t, svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_f32_x2), arm_streaming))
svfloat32x2_t svclamp(svfloat32x2_t, svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_f16_x2), arm_streaming))
svfloat16x2_t svclamp(svfloat16x2_t, svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_s8_x2), arm_streaming))
svint8x2_t svclamp(svint8x2_t, svint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_s32_x2), arm_streaming))
svint32x2_t svclamp(svint32x2_t, svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_s64_x2), arm_streaming))
svint64x2_t svclamp(svint64x2_t, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_s16_x2), arm_streaming))
svint16x2_t svclamp(svint16x2_t, svint16_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_u8_x2), arm_streaming))
svuint8x2_t svclamp(svuint8x2_t, svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_u32_x2), arm_streaming))
svuint32x2_t svclamp(svuint32x2_t, svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_u64_x2), arm_streaming))
svuint64x2_t svclamp(svuint64x2_t, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_u16_x2), arm_streaming))
svuint16x2_t svclamp(svuint16x2_t, svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_f64_x4), arm_streaming))
svfloat64x4_t svclamp(svfloat64x4_t, svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_f32_x4), arm_streaming))
svfloat32x4_t svclamp(svfloat32x4_t, svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_f16_x4), arm_streaming))
svfloat16x4_t svclamp(svfloat16x4_t, svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_s8_x4), arm_streaming))
svint8x4_t svclamp(svint8x4_t, svint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_s32_x4), arm_streaming))
svint32x4_t svclamp(svint32x4_t, svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_s64_x4), arm_streaming))
svint64x4_t svclamp(svint64x4_t, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_s16_x4), arm_streaming))
svint16x4_t svclamp(svint16x4_t, svint16_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_u8_x4), arm_streaming))
svuint8x4_t svclamp(svuint8x4_t, svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_u32_x4), arm_streaming))
svuint32x4_t svclamp(svuint32x4_t, svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_u64_x4), arm_streaming))
svuint64x4_t svclamp(svuint64x4_t, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_u16_x4), arm_streaming))
svuint16x4_t svclamp(svuint16x4_t, svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_bf16_f32_x2), arm_streaming))
svbfloat16_t svcvt_bf16(svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_f32_x2), arm_streaming))
svfloat16_t svcvt_f16(svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_s32_f32_x2), arm_streaming))
svint32x2_t svcvt_s32(svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_s32_f32_x4), arm_streaming))
svint32x4_t svcvt_s32(svfloat32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_u32_f32_x2), arm_streaming))
svuint32x2_t svcvt_u32(svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_u32_f32_x4), arm_streaming))
svuint32x4_t svcvt_u32(svfloat32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_s32_x2), arm_streaming))
svfloat32x2_t svcvt_f32(svint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_s32_x4), arm_streaming))
svfloat32x4_t svcvt_f32(svint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_u32_x2), arm_streaming))
svfloat32x2_t svcvt_f32(svuint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_u32_x4), arm_streaming))
svfloat32x4_t svcvt_f32(svuint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtn_bf16_f32_x2), arm_streaming))
svbfloat16_t svcvtn_bf16(svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtn_f16_f32_x2), arm_streaming))
svfloat16_t svcvtn_f16(svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_f64_x2), arm_streaming))
svfloat64x2_t svmax(svfloat64x2_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_f32_x2), arm_streaming))
svfloat32x2_t svmax(svfloat32x2_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_f16_x2), arm_streaming))
svfloat16x2_t svmax(svfloat16x2_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_s8_x2), arm_streaming))
svint8x2_t svmax(svint8x2_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_s32_x2), arm_streaming))
svint32x2_t svmax(svint32x2_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_s64_x2), arm_streaming))
svint64x2_t svmax(svint64x2_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_s16_x2), arm_streaming))
svint16x2_t svmax(svint16x2_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_u8_x2), arm_streaming))
svuint8x2_t svmax(svuint8x2_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_u32_x2), arm_streaming))
svuint32x2_t svmax(svuint32x2_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_u64_x2), arm_streaming))
svuint64x2_t svmax(svuint64x2_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_u16_x2), arm_streaming))
svuint16x2_t svmax(svuint16x2_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_f64_x4), arm_streaming))
svfloat64x4_t svmax(svfloat64x4_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_f32_x4), arm_streaming))
svfloat32x4_t svmax(svfloat32x4_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_f16_x4), arm_streaming))
svfloat16x4_t svmax(svfloat16x4_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_s8_x4), arm_streaming))
svint8x4_t svmax(svint8x4_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_s32_x4), arm_streaming))
svint32x4_t svmax(svint32x4_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_s64_x4), arm_streaming))
svint64x4_t svmax(svint64x4_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_s16_x4), arm_streaming))
svint16x4_t svmax(svint16x4_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_u8_x4), arm_streaming))
svuint8x4_t svmax(svuint8x4_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_u32_x4), arm_streaming))
svuint32x4_t svmax(svuint32x4_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_u64_x4), arm_streaming))
svuint64x4_t svmax(svuint64x4_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_u16_x4), arm_streaming))
svuint16x4_t svmax(svuint16x4_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_f64_x2), arm_streaming))
svfloat64x2_t svmax(svfloat64x2_t, svfloat64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_f32_x2), arm_streaming))
svfloat32x2_t svmax(svfloat32x2_t, svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_f16_x2), arm_streaming))
svfloat16x2_t svmax(svfloat16x2_t, svfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s8_x2), arm_streaming))
svint8x2_t svmax(svint8x2_t, svint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s32_x2), arm_streaming))
svint32x2_t svmax(svint32x2_t, svint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s64_x2), arm_streaming))
svint64x2_t svmax(svint64x2_t, svint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s16_x2), arm_streaming))
svint16x2_t svmax(svint16x2_t, svint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u8_x2), arm_streaming))
svuint8x2_t svmax(svuint8x2_t, svuint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u32_x2), arm_streaming))
svuint32x2_t svmax(svuint32x2_t, svuint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u64_x2), arm_streaming))
svuint64x2_t svmax(svuint64x2_t, svuint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u16_x2), arm_streaming))
svuint16x2_t svmax(svuint16x2_t, svuint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_f64_x4), arm_streaming))
svfloat64x4_t svmax(svfloat64x4_t, svfloat64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_f32_x4), arm_streaming))
svfloat32x4_t svmax(svfloat32x4_t, svfloat32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_f16_x4), arm_streaming))
svfloat16x4_t svmax(svfloat16x4_t, svfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s8_x4), arm_streaming))
svint8x4_t svmax(svint8x4_t, svint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s32_x4), arm_streaming))
svint32x4_t svmax(svint32x4_t, svint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s64_x4), arm_streaming))
svint64x4_t svmax(svint64x4_t, svint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s16_x4), arm_streaming))
svint16x4_t svmax(svint16x4_t, svint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u8_x4), arm_streaming))
svuint8x4_t svmax(svuint8x4_t, svuint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u32_x4), arm_streaming))
svuint32x4_t svmax(svuint32x4_t, svuint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u64_x4), arm_streaming))
svuint64x4_t svmax(svuint64x4_t, svuint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u16_x4), arm_streaming))
svuint16x4_t svmax(svuint16x4_t, svuint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_single_f64_x2), arm_streaming))
svfloat64x2_t svmaxnm(svfloat64x2_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_single_f32_x2), arm_streaming))
svfloat32x2_t svmaxnm(svfloat32x2_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_single_f16_x2), arm_streaming))
svfloat16x2_t svmaxnm(svfloat16x2_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_single_f64_x4), arm_streaming))
svfloat64x4_t svmaxnm(svfloat64x4_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_single_f32_x4), arm_streaming))
svfloat32x4_t svmaxnm(svfloat32x4_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_single_f16_x4), arm_streaming))
svfloat16x4_t svmaxnm(svfloat16x4_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_f64_x2), arm_streaming))
svfloat64x2_t svmaxnm(svfloat64x2_t, svfloat64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_f32_x2), arm_streaming))
svfloat32x2_t svmaxnm(svfloat32x2_t, svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_f16_x2), arm_streaming))
svfloat16x2_t svmaxnm(svfloat16x2_t, svfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_f64_x4), arm_streaming))
svfloat64x4_t svmaxnm(svfloat64x4_t, svfloat64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_f32_x4), arm_streaming))
svfloat32x4_t svmaxnm(svfloat32x4_t, svfloat32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_f16_x4), arm_streaming))
svfloat16x4_t svmaxnm(svfloat16x4_t, svfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_f64_x2), arm_streaming))
svfloat64x2_t svmin(svfloat64x2_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_f32_x2), arm_streaming))
svfloat32x2_t svmin(svfloat32x2_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_f16_x2), arm_streaming))
svfloat16x2_t svmin(svfloat16x2_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_s8_x2), arm_streaming))
svint8x2_t svmin(svint8x2_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_s32_x2), arm_streaming))
svint32x2_t svmin(svint32x2_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_s64_x2), arm_streaming))
svint64x2_t svmin(svint64x2_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_s16_x2), arm_streaming))
svint16x2_t svmin(svint16x2_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_u8_x2), arm_streaming))
svuint8x2_t svmin(svuint8x2_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_u32_x2), arm_streaming))
svuint32x2_t svmin(svuint32x2_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_u64_x2), arm_streaming))
svuint64x2_t svmin(svuint64x2_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_u16_x2), arm_streaming))
svuint16x2_t svmin(svuint16x2_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_f64_x4), arm_streaming))
svfloat64x4_t svmin(svfloat64x4_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_f32_x4), arm_streaming))
svfloat32x4_t svmin(svfloat32x4_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_f16_x4), arm_streaming))
svfloat16x4_t svmin(svfloat16x4_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_s8_x4), arm_streaming))
svint8x4_t svmin(svint8x4_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_s32_x4), arm_streaming))
svint32x4_t svmin(svint32x4_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_s64_x4), arm_streaming))
svint64x4_t svmin(svint64x4_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_s16_x4), arm_streaming))
svint16x4_t svmin(svint16x4_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_u8_x4), arm_streaming))
svuint8x4_t svmin(svuint8x4_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_u32_x4), arm_streaming))
svuint32x4_t svmin(svuint32x4_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_u64_x4), arm_streaming))
svuint64x4_t svmin(svuint64x4_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_u16_x4), arm_streaming))
svuint16x4_t svmin(svuint16x4_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_f64_x2), arm_streaming))
svfloat64x2_t svmin(svfloat64x2_t, svfloat64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_f32_x2), arm_streaming))
svfloat32x2_t svmin(svfloat32x2_t, svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_f16_x2), arm_streaming))
svfloat16x2_t svmin(svfloat16x2_t, svfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s8_x2), arm_streaming))
svint8x2_t svmin(svint8x2_t, svint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s32_x2), arm_streaming))
svint32x2_t svmin(svint32x2_t, svint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s64_x2), arm_streaming))
svint64x2_t svmin(svint64x2_t, svint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s16_x2), arm_streaming))
svint16x2_t svmin(svint16x2_t, svint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u8_x2), arm_streaming))
svuint8x2_t svmin(svuint8x2_t, svuint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u32_x2), arm_streaming))
svuint32x2_t svmin(svuint32x2_t, svuint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u64_x2), arm_streaming))
svuint64x2_t svmin(svuint64x2_t, svuint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u16_x2), arm_streaming))
svuint16x2_t svmin(svuint16x2_t, svuint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_f64_x4), arm_streaming))
svfloat64x4_t svmin(svfloat64x4_t, svfloat64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_f32_x4), arm_streaming))
svfloat32x4_t svmin(svfloat32x4_t, svfloat32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_f16_x4), arm_streaming))
svfloat16x4_t svmin(svfloat16x4_t, svfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s8_x4), arm_streaming))
svint8x4_t svmin(svint8x4_t, svint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s32_x4), arm_streaming))
svint32x4_t svmin(svint32x4_t, svint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s64_x4), arm_streaming))
svint64x4_t svmin(svint64x4_t, svint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s16_x4), arm_streaming))
svint16x4_t svmin(svint16x4_t, svint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u8_x4), arm_streaming))
svuint8x4_t svmin(svuint8x4_t, svuint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u32_x4), arm_streaming))
svuint32x4_t svmin(svuint32x4_t, svuint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u64_x4), arm_streaming))
svuint64x4_t svmin(svuint64x4_t, svuint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u16_x4), arm_streaming))
svuint16x4_t svmin(svuint16x4_t, svuint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_single_f64_x2), arm_streaming))
svfloat64x2_t svminnm(svfloat64x2_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_single_f32_x2), arm_streaming))
svfloat32x2_t svminnm(svfloat32x2_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_single_f16_x2), arm_streaming))
svfloat16x2_t svminnm(svfloat16x2_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_single_f64_x4), arm_streaming))
svfloat64x4_t svminnm(svfloat64x4_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_single_f32_x4), arm_streaming))
svfloat32x4_t svminnm(svfloat32x4_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_single_f16_x4), arm_streaming))
svfloat16x4_t svminnm(svfloat16x4_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_f64_x2), arm_streaming))
svfloat64x2_t svminnm(svfloat64x2_t, svfloat64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_f32_x2), arm_streaming))
svfloat32x2_t svminnm(svfloat32x2_t, svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_f16_x2), arm_streaming))
svfloat16x2_t svminnm(svfloat16x2_t, svfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_f64_x4), arm_streaming))
svfloat64x4_t svminnm(svfloat64x4_t, svfloat64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_f32_x4), arm_streaming))
svfloat32x4_t svminnm(svfloat32x4_t, svfloat32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_f16_x4), arm_streaming))
svfloat16x4_t svminnm(svfloat16x4_t, svfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvt_s16_s32_x2), arm_streaming))
svint16_t svqcvt_s16(svint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvt_s16_s64_x4), arm_streaming))
svint16_t svqcvt_s16(svint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvt_s8_s32_x4), arm_streaming))
svint8_t svqcvt_s8(svint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvt_u16_s32_x2), arm_streaming))
svuint16_t svqcvt_u16(svint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvt_u16_u32_x2), arm_streaming))
svuint16_t svqcvt_u16(svuint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvt_u16_s64_x4), arm_streaming))
svuint16_t svqcvt_u16(svint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvt_u16_u64_x4), arm_streaming))
svuint16_t svqcvt_u16(svuint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvt_u8_s32_x4), arm_streaming))
svuint8_t svqcvt_u8(svint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvt_u8_u32_x4), arm_streaming))
svuint8_t svqcvt_u8(svuint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvtn_s16_s64_x4), arm_streaming))
svint16_t svqcvtn_s16(svint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvtn_s8_s32_x4), arm_streaming))
svint8_t svqcvtn_s8(svint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvtn_u16_s64_x4), arm_streaming))
svuint16_t svqcvtn_u16(svint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvtn_u16_u64_x4), arm_streaming))
svuint16_t svqcvtn_u16(svuint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvtn_u8_s32_x4), arm_streaming))
svuint8_t svqcvtn_u8(svint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvtn_u8_u32_x4), arm_streaming))
svuint8_t svqcvtn_u8(svuint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_single_s8_x2), arm_streaming))
svint8x2_t svqdmulh(svint8x2_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_single_s32_x2), arm_streaming))
svint32x2_t svqdmulh(svint32x2_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_single_s64_x2), arm_streaming))
svint64x2_t svqdmulh(svint64x2_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_single_s16_x2), arm_streaming))
svint16x2_t svqdmulh(svint16x2_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_single_s8_x4), arm_streaming))
svint8x4_t svqdmulh(svint8x4_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_single_s32_x4), arm_streaming))
svint32x4_t svqdmulh(svint32x4_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_single_s64_x4), arm_streaming))
svint64x4_t svqdmulh(svint64x4_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_single_s16_x4), arm_streaming))
svint16x4_t svqdmulh(svint16x4_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_s8_x2), arm_streaming))
svint8x2_t svqdmulh(svint8x2_t, svint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_s32_x2), arm_streaming))
svint32x2_t svqdmulh(svint32x2_t, svint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_s64_x2), arm_streaming))
svint64x2_t svqdmulh(svint64x2_t, svint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_s16_x2), arm_streaming))
svint16x2_t svqdmulh(svint16x2_t, svint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_s8_x4), arm_streaming))
svint8x4_t svqdmulh(svint8x4_t, svint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_s32_x4), arm_streaming))
svint32x4_t svqdmulh(svint32x4_t, svint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_s64_x4), arm_streaming))
svint64x4_t svqdmulh(svint64x4_t, svint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_s16_x4), arm_streaming))
svint16x4_t svqdmulh(svint16x4_t, svint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshr_n_s16_s32_x2), arm_streaming))
svint16_t svqrshr_s16(svint32x2_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshr_n_u16_u32_x2), arm_streaming))
svuint16_t svqrshr_u16(svuint32x2_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshr_n_s8_s32_x4), arm_streaming))
svint8_t svqrshr_s8(svint32x4_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshr_n_s16_s64_x4), arm_streaming))
svint16_t svqrshr_s16(svint64x4_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshr_n_u8_u32_x4), arm_streaming))
svuint8_t svqrshr_u8(svuint32x4_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshr_n_u16_u64_x4), arm_streaming))
svuint16_t svqrshr_u16(svuint64x4_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshrn_n_s8_s32_x4), arm_streaming))
svint8_t svqrshrn_s8(svint32x4_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshrn_n_s16_s64_x4), arm_streaming))
svint16_t svqrshrn_s16(svint64x4_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshrn_n_u8_u32_x4), arm_streaming))
svuint8_t svqrshrn_u8(svuint32x4_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshrn_n_u16_u64_x4), arm_streaming))
svuint16_t svqrshrn_u16(svuint64x4_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshru_n_u16_s32_x2), arm_streaming))
svuint16_t svqrshru_u16(svint32x2_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshru_n_u8_s32_x4), arm_streaming))
svuint8_t svqrshru_u8(svint32x4_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshru_n_u16_s64_x4), arm_streaming))
svuint16_t svqrshru_u16(svint64x4_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshrun_n_u8_s32_x4), arm_streaming))
svuint8_t svqrshrun_u8(svint32x4_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshrun_n_u16_s64_x4), arm_streaming))
svuint16_t svqrshrun_u16(svint64x4_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svreinterpret_b), arm_streaming_compatible))
svbool_t svreinterpret(svcount_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svreinterpret_c), arm_streaming_compatible))
svcount_t svreinterpret(svbool_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrinta_f32_x2), arm_streaming))
svfloat32x2_t svrinta(svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrinta_f32_x4), arm_streaming))
svfloat32x4_t svrinta(svfloat32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintm_f32_x2), arm_streaming))
svfloat32x2_t svrintm(svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintm_f32_x4), arm_streaming))
svfloat32x4_t svrintm(svfloat32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintn_f32_x2), arm_streaming))
svfloat32x2_t svrintn(svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintn_f32_x4), arm_streaming))
svfloat32x4_t svrintn(svfloat32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintp_f32_x2), arm_streaming))
svfloat32x2_t svrintp(svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintp_f32_x4), arm_streaming))
svfloat32x4_t svrintp(svfloat32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_s8_x2), arm_streaming))
svint8x2_t svrshl(svint8x2_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_s32_x2), arm_streaming))
svint32x2_t svrshl(svint32x2_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_s64_x2), arm_streaming))
svint64x2_t svrshl(svint64x2_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_s16_x2), arm_streaming))
svint16x2_t svrshl(svint16x2_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_u8_x2), arm_streaming))
svuint8x2_t svrshl(svuint8x2_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_u32_x2), arm_streaming))
svuint32x2_t svrshl(svuint32x2_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_u64_x2), arm_streaming))
svuint64x2_t svrshl(svuint64x2_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_u16_x2), arm_streaming))
svuint16x2_t svrshl(svuint16x2_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_s8_x4), arm_streaming))
svint8x4_t svrshl(svint8x4_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_s32_x4), arm_streaming))
svint32x4_t svrshl(svint32x4_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_s64_x4), arm_streaming))
svint64x4_t svrshl(svint64x4_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_s16_x4), arm_streaming))
svint16x4_t svrshl(svint16x4_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_u8_x4), arm_streaming))
svuint8x4_t svrshl(svuint8x4_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_u32_x4), arm_streaming))
svuint32x4_t svrshl(svuint32x4_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_u64_x4), arm_streaming))
svuint64x4_t svrshl(svuint64x4_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_u16_x4), arm_streaming))
svuint16x4_t svrshl(svuint16x4_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_s8_x2), arm_streaming))
svint8x2_t svrshl(svint8x2_t, svint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_s32_x2), arm_streaming))
svint32x2_t svrshl(svint32x2_t, svint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_s64_x2), arm_streaming))
svint64x2_t svrshl(svint64x2_t, svint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_s16_x2), arm_streaming))
svint16x2_t svrshl(svint16x2_t, svint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_u8_x2), arm_streaming))
svuint8x2_t svrshl(svuint8x2_t, svuint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_u32_x2), arm_streaming))
svuint32x2_t svrshl(svuint32x2_t, svuint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_u64_x2), arm_streaming))
svuint64x2_t svrshl(svuint64x2_t, svuint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_u16_x2), arm_streaming))
svuint16x2_t svrshl(svuint16x2_t, svuint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_s8_x4), arm_streaming))
svint8x4_t svrshl(svint8x4_t, svint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_s32_x4), arm_streaming))
svint32x4_t svrshl(svint32x4_t, svint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_s64_x4), arm_streaming))
svint64x4_t svrshl(svint64x4_t, svint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_s16_x4), arm_streaming))
svint16x4_t svrshl(svint16x4_t, svint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_u8_x4), arm_streaming))
svuint8x4_t svrshl(svuint8x4_t, svuint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_u32_x4), arm_streaming))
svuint32x4_t svrshl(svuint32x4_t, svuint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_u64_x4), arm_streaming))
svuint64x4_t svrshl(svuint64x4_t, svuint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_u16_x4), arm_streaming))
svuint16x4_t svrshl(svuint16x4_t, svuint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_u8_x2), arm_streaming))
svuint8x2_t svsel(svcount_t, svuint8x2_t, svuint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_u32_x2), arm_streaming))
svuint32x2_t svsel(svcount_t, svuint32x2_t, svuint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_u64_x2), arm_streaming))
svuint64x2_t svsel(svcount_t, svuint64x2_t, svuint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_u16_x2), arm_streaming))
svuint16x2_t svsel(svcount_t, svuint16x2_t, svuint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_bf16_x2), arm_streaming))
svbfloat16x2_t svsel(svcount_t, svbfloat16x2_t, svbfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_s8_x2), arm_streaming))
svint8x2_t svsel(svcount_t, svint8x2_t, svint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_f64_x2), arm_streaming))
svfloat64x2_t svsel(svcount_t, svfloat64x2_t, svfloat64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_f32_x2), arm_streaming))
svfloat32x2_t svsel(svcount_t, svfloat32x2_t, svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_f16_x2), arm_streaming))
svfloat16x2_t svsel(svcount_t, svfloat16x2_t, svfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_s32_x2), arm_streaming))
svint32x2_t svsel(svcount_t, svint32x2_t, svint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_s64_x2), arm_streaming))
svint64x2_t svsel(svcount_t, svint64x2_t, svint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_s16_x2), arm_streaming))
svint16x2_t svsel(svcount_t, svint16x2_t, svint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_u8_x4), arm_streaming))
svuint8x4_t svsel(svcount_t, svuint8x4_t, svuint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_u32_x4), arm_streaming))
svuint32x4_t svsel(svcount_t, svuint32x4_t, svuint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_u64_x4), arm_streaming))
svuint64x4_t svsel(svcount_t, svuint64x4_t, svuint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_u16_x4), arm_streaming))
svuint16x4_t svsel(svcount_t, svuint16x4_t, svuint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_bf16_x4), arm_streaming))
svbfloat16x4_t svsel(svcount_t, svbfloat16x4_t, svbfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_s8_x4), arm_streaming))
svint8x4_t svsel(svcount_t, svint8x4_t, svint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_f64_x4), arm_streaming))
svfloat64x4_t svsel(svcount_t, svfloat64x4_t, svfloat64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_f32_x4), arm_streaming))
svfloat32x4_t svsel(svcount_t, svfloat32x4_t, svfloat32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_f16_x4), arm_streaming))
svfloat16x4_t svsel(svcount_t, svfloat16x4_t, svfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_s32_x4), arm_streaming))
svint32x4_t svsel(svcount_t, svint32x4_t, svint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_s64_x4), arm_streaming))
svint64x4_t svsel(svcount_t, svint64x4_t, svint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_s16_x4), arm_streaming))
svint16x4_t svsel(svcount_t, svint16x4_t, svint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_s32_s16_x2), arm_streaming))
svint32x2_t svunpk_s32(svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_s64_s32_x2), arm_streaming))
svint64x2_t svunpk_s64(svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_s16_s8_x2), arm_streaming))
svint16x2_t svunpk_s16(svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_u32_u16_x2), arm_streaming))
svuint32x2_t svunpk_u32(svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_u64_u32_x2), arm_streaming))
svuint64x2_t svunpk_u64(svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_u16_u8_x2), arm_streaming))
svuint16x2_t svunpk_u16(svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_s32_s16_x4), arm_streaming))
svint32x4_t svunpk_s32(svint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_s64_s32_x4), arm_streaming))
svint64x4_t svunpk_s64(svint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_s16_s8_x4), arm_streaming))
svint16x4_t svunpk_s16(svint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_u32_u16_x4), arm_streaming))
svuint32x4_t svunpk_u32(svuint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_u64_u32_x4), arm_streaming))
svuint64x4_t svunpk_u64(svuint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_u16_u8_x4), arm_streaming))
svuint16x4_t svunpk_u16(svuint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_u8_x2), arm_streaming))
svuint8x2_t svuzp(svuint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_u32_x2), arm_streaming))
svuint32x2_t svuzp(svuint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_u64_x2), arm_streaming))
svuint64x2_t svuzp(svuint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_u16_x2), arm_streaming))
svuint16x2_t svuzp(svuint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_bf16_x2), arm_streaming))
svbfloat16x2_t svuzp(svbfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_s8_x2), arm_streaming))
svint8x2_t svuzp(svint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_f64_x2), arm_streaming))
svfloat64x2_t svuzp(svfloat64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_f32_x2), arm_streaming))
svfloat32x2_t svuzp(svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_f16_x2), arm_streaming))
svfloat16x2_t svuzp(svfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_s32_x2), arm_streaming))
svint32x2_t svuzp(svint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_s64_x2), arm_streaming))
svint64x2_t svuzp(svint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_s16_x2), arm_streaming))
svint16x2_t svuzp(svint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_u8_x4), arm_streaming))
svuint8x4_t svuzp(svuint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_u32_x4), arm_streaming))
svuint32x4_t svuzp(svuint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_u64_x4), arm_streaming))
svuint64x4_t svuzp(svuint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_u16_x4), arm_streaming))
svuint16x4_t svuzp(svuint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_bf16_x4), arm_streaming))
svbfloat16x4_t svuzp(svbfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_s8_x4), arm_streaming))
svint8x4_t svuzp(svint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_f64_x4), arm_streaming))
svfloat64x4_t svuzp(svfloat64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_f32_x4), arm_streaming))
svfloat32x4_t svuzp(svfloat32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_f16_x4), arm_streaming))
svfloat16x4_t svuzp(svfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_s32_x4), arm_streaming))
svint32x4_t svuzp(svint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_s64_x4), arm_streaming))
svint64x4_t svuzp(svint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_s16_x4), arm_streaming))
svint16x4_t svuzp(svint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_u8_x2), arm_streaming))
svuint8x2_t svuzpq(svuint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_u32_x2), arm_streaming))
svuint32x2_t svuzpq(svuint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_u64_x2), arm_streaming))
svuint64x2_t svuzpq(svuint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_u16_x2), arm_streaming))
svuint16x2_t svuzpq(svuint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_bf16_x2), arm_streaming))
svbfloat16x2_t svuzpq(svbfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_s8_x2), arm_streaming))
svint8x2_t svuzpq(svint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_f64_x2), arm_streaming))
svfloat64x2_t svuzpq(svfloat64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_f32_x2), arm_streaming))
svfloat32x2_t svuzpq(svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_f16_x2), arm_streaming))
svfloat16x2_t svuzpq(svfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_s32_x2), arm_streaming))
svint32x2_t svuzpq(svint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_s64_x2), arm_streaming))
svint64x2_t svuzpq(svint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_s16_x2), arm_streaming))
svint16x2_t svuzpq(svint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_u8_x4), arm_streaming))
svuint8x4_t svuzpq(svuint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_u32_x4), arm_streaming))
svuint32x4_t svuzpq(svuint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_u64_x4), arm_streaming))
svuint64x4_t svuzpq(svuint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_u16_x4), arm_streaming))
svuint16x4_t svuzpq(svuint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_bf16_x4), arm_streaming))
svbfloat16x4_t svuzpq(svbfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_s8_x4), arm_streaming))
svint8x4_t svuzpq(svint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_f64_x4), arm_streaming))
svfloat64x4_t svuzpq(svfloat64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_f32_x4), arm_streaming))
svfloat32x4_t svuzpq(svfloat32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_f16_x4), arm_streaming))
svfloat16x4_t svuzpq(svfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_s32_x4), arm_streaming))
svint32x4_t svuzpq(svint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_s64_x4), arm_streaming))
svint64x4_t svuzpq(svint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_s16_x4), arm_streaming))
svint16x4_t svuzpq(svint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_u8_x2), arm_streaming))
svuint8x2_t svzip(svuint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_u32_x2), arm_streaming))
svuint32x2_t svzip(svuint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_u64_x2), arm_streaming))
svuint64x2_t svzip(svuint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_u16_x2), arm_streaming))
svuint16x2_t svzip(svuint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_bf16_x2), arm_streaming))
svbfloat16x2_t svzip(svbfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_s8_x2), arm_streaming))
svint8x2_t svzip(svint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_f64_x2), arm_streaming))
svfloat64x2_t svzip(svfloat64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_f32_x2), arm_streaming))
svfloat32x2_t svzip(svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_f16_x2), arm_streaming))
svfloat16x2_t svzip(svfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_s32_x2), arm_streaming))
svint32x2_t svzip(svint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_s64_x2), arm_streaming))
svint64x2_t svzip(svint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_s16_x2), arm_streaming))
svint16x2_t svzip(svint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_u8_x4), arm_streaming))
svuint8x4_t svzip(svuint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_u32_x4), arm_streaming))
svuint32x4_t svzip(svuint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_u64_x4), arm_streaming))
svuint64x4_t svzip(svuint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_u16_x4), arm_streaming))
svuint16x4_t svzip(svuint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_bf16_x4), arm_streaming))
svbfloat16x4_t svzip(svbfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_s8_x4), arm_streaming))
svint8x4_t svzip(svint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_f64_x4), arm_streaming))
svfloat64x4_t svzip(svfloat64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_f32_x4), arm_streaming))
svfloat32x4_t svzip(svfloat32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_f16_x4), arm_streaming))
svfloat16x4_t svzip(svfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_s32_x4), arm_streaming))
svint32x4_t svzip(svint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_s64_x4), arm_streaming))
svint64x4_t svzip(svint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_s16_x4), arm_streaming))
svint16x4_t svzip(svint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_u8_x2), arm_streaming))
svuint8x2_t svzipq(svuint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_u32_x2), arm_streaming))
svuint32x2_t svzipq(svuint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_u64_x2), arm_streaming))
svuint64x2_t svzipq(svuint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_u16_x2), arm_streaming))
svuint16x2_t svzipq(svuint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_bf16_x2), arm_streaming))
svbfloat16x2_t svzipq(svbfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_s8_x2), arm_streaming))
svint8x2_t svzipq(svint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_f64_x2), arm_streaming))
svfloat64x2_t svzipq(svfloat64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_f32_x2), arm_streaming))
svfloat32x2_t svzipq(svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_f16_x2), arm_streaming))
svfloat16x2_t svzipq(svfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_s32_x2), arm_streaming))
svint32x2_t svzipq(svint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_s64_x2), arm_streaming))
svint64x2_t svzipq(svint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_s16_x2), arm_streaming))
svint16x2_t svzipq(svint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_u8_x4), arm_streaming))
svuint8x4_t svzipq(svuint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_u32_x4), arm_streaming))
svuint32x4_t svzipq(svuint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_u64_x4), arm_streaming))
svuint64x4_t svzipq(svuint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_u16_x4), arm_streaming))
svuint16x4_t svzipq(svuint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_bf16_x4), arm_streaming))
svbfloat16x4_t svzipq(svbfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_s8_x4), arm_streaming))
svint8x4_t svzipq(svint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_f64_x4), arm_streaming))
svfloat64x4_t svzipq(svfloat64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_f32_x4), arm_streaming))
svfloat32x4_t svzipq(svfloat32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_f16_x4), arm_streaming))
svfloat16x4_t svzipq(svfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_s32_x4), arm_streaming))
svint32x4_t svzipq(svint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_s64_x4), arm_streaming))
svint64x4_t svzipq(svint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_s16_x4), arm_streaming))
svint16x4_t svzipq(svint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvtn_s16_s32_x2), arm_streaming_compatible))
svint16_t svqcvtn_s16_s32_x2(svint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvtn_u16_s32_x2), arm_streaming_compatible))
svuint16_t svqcvtn_u16_s32_x2(svint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvtn_u16_u32_x2), arm_streaming_compatible))
svuint16_t svqcvtn_u16_u32_x2(svuint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvtn_s16_s32_x2), arm_streaming_compatible))
svint16_t svqcvtn_s16(svint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvtn_u16_s32_x2), arm_streaming_compatible))
svuint16_t svqcvtn_u16(svint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvtn_u16_u32_x2), arm_streaming_compatible))
svuint16_t svqcvtn_u16(svuint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_f64_m), arm_streaming_compatible))
svfloat64_t svabd_n_f64_m(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_f32_m), arm_streaming_compatible))
svfloat32_t svabd_n_f32_m(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_f16_m), arm_streaming_compatible))
svfloat16_t svabd_n_f16_m(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_f64_x), arm_streaming_compatible))
svfloat64_t svabd_n_f64_x(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_f32_x), arm_streaming_compatible))
svfloat32_t svabd_n_f32_x(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_f16_x), arm_streaming_compatible))
svfloat16_t svabd_n_f16_x(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_f64_z), arm_streaming_compatible))
svfloat64_t svabd_n_f64_z(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_f32_z), arm_streaming_compatible))
svfloat32_t svabd_n_f32_z(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_f16_z), arm_streaming_compatible))
svfloat16_t svabd_n_f16_z(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_s8_m), arm_streaming_compatible))
svint8_t svabd_n_s8_m(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_s32_m), arm_streaming_compatible))
svint32_t svabd_n_s32_m(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_s64_m), arm_streaming_compatible))
svint64_t svabd_n_s64_m(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_s16_m), arm_streaming_compatible))
svint16_t svabd_n_s16_m(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_s8_x), arm_streaming_compatible))
svint8_t svabd_n_s8_x(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_s32_x), arm_streaming_compatible))
svint32_t svabd_n_s32_x(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_s64_x), arm_streaming_compatible))
svint64_t svabd_n_s64_x(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_s16_x), arm_streaming_compatible))
svint16_t svabd_n_s16_x(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_s8_z), arm_streaming_compatible))
svint8_t svabd_n_s8_z(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_s32_z), arm_streaming_compatible))
svint32_t svabd_n_s32_z(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_s64_z), arm_streaming_compatible))
svint64_t svabd_n_s64_z(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_s16_z), arm_streaming_compatible))
svint16_t svabd_n_s16_z(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_u8_m), arm_streaming_compatible))
svuint8_t svabd_n_u8_m(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_u32_m), arm_streaming_compatible))
svuint32_t svabd_n_u32_m(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_u64_m), arm_streaming_compatible))
svuint64_t svabd_n_u64_m(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_u16_m), arm_streaming_compatible))
svuint16_t svabd_n_u16_m(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_u8_x), arm_streaming_compatible))
svuint8_t svabd_n_u8_x(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_u32_x), arm_streaming_compatible))
svuint32_t svabd_n_u32_x(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_u64_x), arm_streaming_compatible))
svuint64_t svabd_n_u64_x(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_u16_x), arm_streaming_compatible))
svuint16_t svabd_n_u16_x(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_u8_z), arm_streaming_compatible))
svuint8_t svabd_n_u8_z(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_u32_z), arm_streaming_compatible))
svuint32_t svabd_n_u32_z(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_u64_z), arm_streaming_compatible))
svuint64_t svabd_n_u64_z(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_u16_z), arm_streaming_compatible))
svuint16_t svabd_n_u16_z(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_f64_m), arm_streaming_compatible))
svfloat64_t svabd_f64_m(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_f32_m), arm_streaming_compatible))
svfloat32_t svabd_f32_m(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_f16_m), arm_streaming_compatible))
svfloat16_t svabd_f16_m(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_f64_x), arm_streaming_compatible))
svfloat64_t svabd_f64_x(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_f32_x), arm_streaming_compatible))
svfloat32_t svabd_f32_x(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_f16_x), arm_streaming_compatible))
svfloat16_t svabd_f16_x(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_f64_z), arm_streaming_compatible))
svfloat64_t svabd_f64_z(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_f32_z), arm_streaming_compatible))
svfloat32_t svabd_f32_z(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_f16_z), arm_streaming_compatible))
svfloat16_t svabd_f16_z(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_s8_m), arm_streaming_compatible))
svint8_t svabd_s8_m(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_s32_m), arm_streaming_compatible))
svint32_t svabd_s32_m(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_s64_m), arm_streaming_compatible))
svint64_t svabd_s64_m(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_s16_m), arm_streaming_compatible))
svint16_t svabd_s16_m(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_s8_x), arm_streaming_compatible))
svint8_t svabd_s8_x(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_s32_x), arm_streaming_compatible))
svint32_t svabd_s32_x(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_s64_x), arm_streaming_compatible))
svint64_t svabd_s64_x(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_s16_x), arm_streaming_compatible))
svint16_t svabd_s16_x(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_s8_z), arm_streaming_compatible))
svint8_t svabd_s8_z(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_s32_z), arm_streaming_compatible))
svint32_t svabd_s32_z(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_s64_z), arm_streaming_compatible))
svint64_t svabd_s64_z(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_s16_z), arm_streaming_compatible))
svint16_t svabd_s16_z(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_u8_m), arm_streaming_compatible))
svuint8_t svabd_u8_m(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_u32_m), arm_streaming_compatible))
svuint32_t svabd_u32_m(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_u64_m), arm_streaming_compatible))
svuint64_t svabd_u64_m(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_u16_m), arm_streaming_compatible))
svuint16_t svabd_u16_m(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_u8_x), arm_streaming_compatible))
svuint8_t svabd_u8_x(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_u32_x), arm_streaming_compatible))
svuint32_t svabd_u32_x(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_u64_x), arm_streaming_compatible))
svuint64_t svabd_u64_x(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_u16_x), arm_streaming_compatible))
svuint16_t svabd_u16_x(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_u8_z), arm_streaming_compatible))
svuint8_t svabd_u8_z(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_u32_z), arm_streaming_compatible))
svuint32_t svabd_u32_z(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_u64_z), arm_streaming_compatible))
svuint64_t svabd_u64_z(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_u16_z), arm_streaming_compatible))
svuint16_t svabd_u16_z(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabs_f64_m), arm_streaming_compatible))
svfloat64_t svabs_f64_m(svfloat64_t, svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabs_f32_m), arm_streaming_compatible))
svfloat32_t svabs_f32_m(svfloat32_t, svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabs_f16_m), arm_streaming_compatible))
svfloat16_t svabs_f16_m(svfloat16_t, svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabs_f64_x), arm_streaming_compatible))
svfloat64_t svabs_f64_x(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabs_f32_x), arm_streaming_compatible))
svfloat32_t svabs_f32_x(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabs_f16_x), arm_streaming_compatible))
svfloat16_t svabs_f16_x(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabs_f64_z), arm_streaming_compatible))
svfloat64_t svabs_f64_z(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabs_f32_z), arm_streaming_compatible))
svfloat32_t svabs_f32_z(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabs_f16_z), arm_streaming_compatible))
svfloat16_t svabs_f16_z(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabs_s8_m), arm_streaming_compatible))
svint8_t svabs_s8_m(svint8_t, svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabs_s32_m), arm_streaming_compatible))
svint32_t svabs_s32_m(svint32_t, svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabs_s64_m), arm_streaming_compatible))
svint64_t svabs_s64_m(svint64_t, svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabs_s16_m), arm_streaming_compatible))
svint16_t svabs_s16_m(svint16_t, svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabs_s8_x), arm_streaming_compatible))
svint8_t svabs_s8_x(svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabs_s32_x), arm_streaming_compatible))
svint32_t svabs_s32_x(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabs_s64_x), arm_streaming_compatible))
svint64_t svabs_s64_x(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabs_s16_x), arm_streaming_compatible))
svint16_t svabs_s16_x(svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabs_s8_z), arm_streaming_compatible))
svint8_t svabs_s8_z(svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabs_s32_z), arm_streaming_compatible))
svint32_t svabs_s32_z(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabs_s64_z), arm_streaming_compatible))
svint64_t svabs_s64_z(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabs_s16_z), arm_streaming_compatible))
svint16_t svabs_s16_z(svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svacge_n_f64)))
svbool_t svacge_n_f64(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svacge_n_f32)))
svbool_t svacge_n_f32(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svacge_n_f16)))
svbool_t svacge_n_f16(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svacge_f64), arm_streaming_compatible))
svbool_t svacge_f64(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svacge_f32), arm_streaming_compatible))
svbool_t svacge_f32(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svacge_f16), arm_streaming_compatible))
svbool_t svacge_f16(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svacgt_n_f64)))
svbool_t svacgt_n_f64(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svacgt_n_f32)))
svbool_t svacgt_n_f32(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svacgt_n_f16)))
svbool_t svacgt_n_f16(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svacgt_f64), arm_streaming_compatible))
svbool_t svacgt_f64(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svacgt_f32), arm_streaming_compatible))
svbool_t svacgt_f32(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svacgt_f16), arm_streaming_compatible))
svbool_t svacgt_f16(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svacle_n_f64)))
svbool_t svacle_n_f64(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svacle_n_f32)))
svbool_t svacle_n_f32(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svacle_n_f16)))
svbool_t svacle_n_f16(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svacle_f64), arm_streaming_compatible))
svbool_t svacle_f64(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svacle_f32), arm_streaming_compatible))
svbool_t svacle_f32(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svacle_f16), arm_streaming_compatible))
svbool_t svacle_f16(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaclt_n_f64)))
svbool_t svaclt_n_f64(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaclt_n_f32)))
svbool_t svaclt_n_f32(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaclt_n_f16)))
svbool_t svaclt_n_f16(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaclt_f64), arm_streaming_compatible))
svbool_t svaclt_f64(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaclt_f32), arm_streaming_compatible))
svbool_t svaclt_f32(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaclt_f16), arm_streaming_compatible))
svbool_t svaclt_f16(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_f64_m), arm_streaming_compatible))
svfloat64_t svadd_n_f64_m(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_f32_m), arm_streaming_compatible))
svfloat32_t svadd_n_f32_m(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_f16_m), arm_streaming_compatible))
svfloat16_t svadd_n_f16_m(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_f64_x), arm_streaming_compatible))
svfloat64_t svadd_n_f64_x(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_f32_x), arm_streaming_compatible))
svfloat32_t svadd_n_f32_x(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_f16_x), arm_streaming_compatible))
svfloat16_t svadd_n_f16_x(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_f64_z), arm_streaming_compatible))
svfloat64_t svadd_n_f64_z(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_f32_z), arm_streaming_compatible))
svfloat32_t svadd_n_f32_z(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_f16_z), arm_streaming_compatible))
svfloat16_t svadd_n_f16_z(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_u8_m), arm_streaming_compatible))
svuint8_t svadd_n_u8_m(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_u32_m), arm_streaming_compatible))
svuint32_t svadd_n_u32_m(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_u64_m), arm_streaming_compatible))
svuint64_t svadd_n_u64_m(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_u16_m), arm_streaming_compatible))
svuint16_t svadd_n_u16_m(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_s8_m), arm_streaming_compatible))
svint8_t svadd_n_s8_m(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_s32_m), arm_streaming_compatible))
svint32_t svadd_n_s32_m(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_s64_m), arm_streaming_compatible))
svint64_t svadd_n_s64_m(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_s16_m), arm_streaming_compatible))
svint16_t svadd_n_s16_m(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_u8_x), arm_streaming_compatible))
svuint8_t svadd_n_u8_x(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_u32_x), arm_streaming_compatible))
svuint32_t svadd_n_u32_x(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_u64_x), arm_streaming_compatible))
svuint64_t svadd_n_u64_x(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_u16_x), arm_streaming_compatible))
svuint16_t svadd_n_u16_x(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_s8_x), arm_streaming_compatible))
svint8_t svadd_n_s8_x(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_s32_x), arm_streaming_compatible))
svint32_t svadd_n_s32_x(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_s64_x), arm_streaming_compatible))
svint64_t svadd_n_s64_x(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_s16_x), arm_streaming_compatible))
svint16_t svadd_n_s16_x(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_u8_z), arm_streaming_compatible))
svuint8_t svadd_n_u8_z(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_u32_z), arm_streaming_compatible))
svuint32_t svadd_n_u32_z(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_u64_z), arm_streaming_compatible))
svuint64_t svadd_n_u64_z(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_u16_z), arm_streaming_compatible))
svuint16_t svadd_n_u16_z(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_s8_z), arm_streaming_compatible))
svint8_t svadd_n_s8_z(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_s32_z), arm_streaming_compatible))
svint32_t svadd_n_s32_z(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_s64_z), arm_streaming_compatible))
svint64_t svadd_n_s64_z(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_s16_z), arm_streaming_compatible))
svint16_t svadd_n_s16_z(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_f64_m), arm_streaming_compatible))
svfloat64_t svadd_f64_m(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_f32_m), arm_streaming_compatible))
svfloat32_t svadd_f32_m(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_f16_m), arm_streaming_compatible))
svfloat16_t svadd_f16_m(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_f64_x), arm_streaming_compatible))
svfloat64_t svadd_f64_x(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_f32_x), arm_streaming_compatible))
svfloat32_t svadd_f32_x(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_f16_x), arm_streaming_compatible))
svfloat16_t svadd_f16_x(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_f64_z), arm_streaming_compatible))
svfloat64_t svadd_f64_z(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_f32_z), arm_streaming_compatible))
svfloat32_t svadd_f32_z(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_f16_z), arm_streaming_compatible))
svfloat16_t svadd_f16_z(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_u8_m), arm_streaming_compatible))
svuint8_t svadd_u8_m(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_u32_m), arm_streaming_compatible))
svuint32_t svadd_u32_m(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_u64_m), arm_streaming_compatible))
svuint64_t svadd_u64_m(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_u16_m), arm_streaming_compatible))
svuint16_t svadd_u16_m(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_s8_m), arm_streaming_compatible))
svint8_t svadd_s8_m(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_s32_m), arm_streaming_compatible))
svint32_t svadd_s32_m(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_s64_m), arm_streaming_compatible))
svint64_t svadd_s64_m(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_s16_m), arm_streaming_compatible))
svint16_t svadd_s16_m(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_u8_x), arm_streaming_compatible))
svuint8_t svadd_u8_x(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_u32_x), arm_streaming_compatible))
svuint32_t svadd_u32_x(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_u64_x), arm_streaming_compatible))
svuint64_t svadd_u64_x(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_u16_x), arm_streaming_compatible))
svuint16_t svadd_u16_x(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_s8_x), arm_streaming_compatible))
svint8_t svadd_s8_x(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_s32_x), arm_streaming_compatible))
svint32_t svadd_s32_x(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_s64_x), arm_streaming_compatible))
svint64_t svadd_s64_x(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_s16_x), arm_streaming_compatible))
svint16_t svadd_s16_x(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_u8_z), arm_streaming_compatible))
svuint8_t svadd_u8_z(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_u32_z), arm_streaming_compatible))
svuint32_t svadd_u32_z(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_u64_z), arm_streaming_compatible))
svuint64_t svadd_u64_z(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_u16_z), arm_streaming_compatible))
svuint16_t svadd_u16_z(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_s8_z), arm_streaming_compatible))
svint8_t svadd_s8_z(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_s32_z), arm_streaming_compatible))
svint32_t svadd_s32_z(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_s64_z), arm_streaming_compatible))
svint64_t svadd_s64_z(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_s16_z), arm_streaming_compatible))
svint16_t svadd_s16_z(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadda_f64), arm_streaming_compatible))
float64_t svadda_f64(svbool_t, float64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadda_f32), arm_streaming_compatible))
float32_t svadda_f32(svbool_t, float32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadda_f16), arm_streaming_compatible))
float16_t svadda_f16(svbool_t, float16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddv_s8), arm_streaming_compatible))
int64_t svaddv_s8(svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddv_s32), arm_streaming_compatible))
int64_t svaddv_s32(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddv_s64), arm_streaming_compatible))
int64_t svaddv_s64(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddv_s16), arm_streaming_compatible))
int64_t svaddv_s16(svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddv_u8), arm_streaming_compatible))
uint64_t svaddv_u8(svbool_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddv_u32), arm_streaming_compatible))
uint64_t svaddv_u32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddv_u64), arm_streaming_compatible))
uint64_t svaddv_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddv_u16), arm_streaming_compatible))
uint64_t svaddv_u16(svbool_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddv_f64), arm_streaming_compatible))
float64_t svaddv_f64(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddv_f32), arm_streaming_compatible))
float32_t svaddv_f32(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddv_f16), arm_streaming_compatible))
float16_t svaddv_f16(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrb_u32base_u32offset)))
svuint32_t svadrb_u32base_u32offset(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrb_u64base_u64offset)))
svuint64_t svadrb_u64base_u64offset(svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrb_u32base_s32offset)))
svuint32_t svadrb_u32base_s32offset(svuint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrb_u64base_s64offset)))
svuint64_t svadrb_u64base_s64offset(svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrd_u32base_u32index)))
svuint32_t svadrd_u32base_u32index(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrd_u64base_u64index)))
svuint64_t svadrd_u64base_u64index(svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrd_u32base_s32index)))
svuint32_t svadrd_u32base_s32index(svuint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrd_u64base_s64index)))
svuint64_t svadrd_u64base_s64index(svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrh_u32base_u32index)))
svuint32_t svadrh_u32base_u32index(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrh_u64base_u64index)))
svuint64_t svadrh_u64base_u64index(svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrh_u32base_s32index)))
svuint32_t svadrh_u32base_s32index(svuint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrh_u64base_s64index)))
svuint64_t svadrh_u64base_s64index(svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrw_u32base_u32index)))
svuint32_t svadrw_u32base_u32index(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrw_u64base_u64index)))
svuint64_t svadrw_u64base_u64index(svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrw_u32base_s32index)))
svuint32_t svadrw_u32base_s32index(svuint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrw_u64base_s64index)))
svuint64_t svadrw_u64base_s64index(svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_b_z), arm_streaming_compatible))
svbool_t svand_b_z(svbool_t, svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_u8_m), arm_streaming_compatible))
svuint8_t svand_n_u8_m(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_u32_m), arm_streaming_compatible))
svuint32_t svand_n_u32_m(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_u64_m), arm_streaming_compatible))
svuint64_t svand_n_u64_m(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_u16_m), arm_streaming_compatible))
svuint16_t svand_n_u16_m(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_s8_m), arm_streaming_compatible))
svint8_t svand_n_s8_m(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_s32_m), arm_streaming_compatible))
svint32_t svand_n_s32_m(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_s64_m), arm_streaming_compatible))
svint64_t svand_n_s64_m(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_s16_m), arm_streaming_compatible))
svint16_t svand_n_s16_m(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_u8_x), arm_streaming_compatible))
svuint8_t svand_n_u8_x(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_u32_x), arm_streaming_compatible))
svuint32_t svand_n_u32_x(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_u64_x), arm_streaming_compatible))
svuint64_t svand_n_u64_x(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_u16_x), arm_streaming_compatible))
svuint16_t svand_n_u16_x(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_s8_x), arm_streaming_compatible))
svint8_t svand_n_s8_x(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_s32_x), arm_streaming_compatible))
svint32_t svand_n_s32_x(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_s64_x), arm_streaming_compatible))
svint64_t svand_n_s64_x(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_s16_x), arm_streaming_compatible))
svint16_t svand_n_s16_x(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_u8_z), arm_streaming_compatible))
svuint8_t svand_n_u8_z(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_u32_z), arm_streaming_compatible))
svuint32_t svand_n_u32_z(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_u64_z), arm_streaming_compatible))
svuint64_t svand_n_u64_z(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_u16_z), arm_streaming_compatible))
svuint16_t svand_n_u16_z(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_s8_z), arm_streaming_compatible))
svint8_t svand_n_s8_z(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_s32_z), arm_streaming_compatible))
svint32_t svand_n_s32_z(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_s64_z), arm_streaming_compatible))
svint64_t svand_n_s64_z(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_s16_z), arm_streaming_compatible))
svint16_t svand_n_s16_z(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_u8_m), arm_streaming_compatible))
svuint8_t svand_u8_m(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_u32_m), arm_streaming_compatible))
svuint32_t svand_u32_m(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_u64_m), arm_streaming_compatible))
svuint64_t svand_u64_m(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_u16_m), arm_streaming_compatible))
svuint16_t svand_u16_m(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_s8_m), arm_streaming_compatible))
svint8_t svand_s8_m(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_s32_m), arm_streaming_compatible))
svint32_t svand_s32_m(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_s64_m), arm_streaming_compatible))
svint64_t svand_s64_m(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_s16_m), arm_streaming_compatible))
svint16_t svand_s16_m(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_u8_x), arm_streaming_compatible))
svuint8_t svand_u8_x(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_u32_x), arm_streaming_compatible))
svuint32_t svand_u32_x(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_u64_x), arm_streaming_compatible))
svuint64_t svand_u64_x(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_u16_x), arm_streaming_compatible))
svuint16_t svand_u16_x(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_s8_x), arm_streaming_compatible))
svint8_t svand_s8_x(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_s32_x), arm_streaming_compatible))
svint32_t svand_s32_x(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_s64_x), arm_streaming_compatible))
svint64_t svand_s64_x(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_s16_x), arm_streaming_compatible))
svint16_t svand_s16_x(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_u8_z), arm_streaming_compatible))
svuint8_t svand_u8_z(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_u32_z), arm_streaming_compatible))
svuint32_t svand_u32_z(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_u64_z), arm_streaming_compatible))
svuint64_t svand_u64_z(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_u16_z), arm_streaming_compatible))
svuint16_t svand_u16_z(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_s8_z), arm_streaming_compatible))
svint8_t svand_s8_z(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_s32_z), arm_streaming_compatible))
svint32_t svand_s32_z(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_s64_z), arm_streaming_compatible))
svint64_t svand_s64_z(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_s16_z), arm_streaming_compatible))
svint16_t svand_s16_z(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svandv_u8), arm_streaming_compatible))
uint8_t svandv_u8(svbool_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svandv_u32), arm_streaming_compatible))
uint32_t svandv_u32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svandv_u64), arm_streaming_compatible))
uint64_t svandv_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svandv_u16), arm_streaming_compatible))
uint16_t svandv_u16(svbool_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svandv_s8), arm_streaming_compatible))
int8_t svandv_s8(svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svandv_s32), arm_streaming_compatible))
int32_t svandv_s32(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svandv_s64), arm_streaming_compatible))
int64_t svandv_s64(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svandv_s16), arm_streaming_compatible))
int16_t svandv_s16(svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_n_s8_m), arm_streaming_compatible))
svint8_t svasr_n_s8_m(svbool_t, svint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_n_s32_m), arm_streaming_compatible))
svint32_t svasr_n_s32_m(svbool_t, svint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_n_s64_m), arm_streaming_compatible))
svint64_t svasr_n_s64_m(svbool_t, svint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_n_s16_m), arm_streaming_compatible))
svint16_t svasr_n_s16_m(svbool_t, svint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_n_s8_x), arm_streaming_compatible))
svint8_t svasr_n_s8_x(svbool_t, svint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_n_s32_x), arm_streaming_compatible))
svint32_t svasr_n_s32_x(svbool_t, svint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_n_s64_x), arm_streaming_compatible))
svint64_t svasr_n_s64_x(svbool_t, svint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_n_s16_x), arm_streaming_compatible))
svint16_t svasr_n_s16_x(svbool_t, svint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_n_s8_z), arm_streaming_compatible))
svint8_t svasr_n_s8_z(svbool_t, svint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_n_s32_z), arm_streaming_compatible))
svint32_t svasr_n_s32_z(svbool_t, svint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_n_s64_z), arm_streaming_compatible))
svint64_t svasr_n_s64_z(svbool_t, svint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_n_s16_z), arm_streaming_compatible))
svint16_t svasr_n_s16_z(svbool_t, svint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_s8_m), arm_streaming_compatible))
svint8_t svasr_s8_m(svbool_t, svint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_s32_m), arm_streaming_compatible))
svint32_t svasr_s32_m(svbool_t, svint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_s64_m), arm_streaming_compatible))
svint64_t svasr_s64_m(svbool_t, svint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_s16_m), arm_streaming_compatible))
svint16_t svasr_s16_m(svbool_t, svint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_s8_x), arm_streaming_compatible))
svint8_t svasr_s8_x(svbool_t, svint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_s32_x), arm_streaming_compatible))
svint32_t svasr_s32_x(svbool_t, svint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_s64_x), arm_streaming_compatible))
svint64_t svasr_s64_x(svbool_t, svint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_s16_x), arm_streaming_compatible))
svint16_t svasr_s16_x(svbool_t, svint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_s8_z), arm_streaming_compatible))
svint8_t svasr_s8_z(svbool_t, svint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_s32_z), arm_streaming_compatible))
svint32_t svasr_s32_z(svbool_t, svint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_s64_z), arm_streaming_compatible))
svint64_t svasr_s64_z(svbool_t, svint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_s16_z), arm_streaming_compatible))
svint16_t svasr_s16_z(svbool_t, svint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_wide_n_s8_m), arm_streaming_compatible))
svint8_t svasr_wide_n_s8_m(svbool_t, svint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_wide_n_s32_m), arm_streaming_compatible))
svint32_t svasr_wide_n_s32_m(svbool_t, svint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_wide_n_s16_m), arm_streaming_compatible))
svint16_t svasr_wide_n_s16_m(svbool_t, svint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_wide_n_s8_x), arm_streaming_compatible))
svint8_t svasr_wide_n_s8_x(svbool_t, svint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_wide_n_s32_x), arm_streaming_compatible))
svint32_t svasr_wide_n_s32_x(svbool_t, svint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_wide_n_s16_x), arm_streaming_compatible))
svint16_t svasr_wide_n_s16_x(svbool_t, svint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_wide_n_s8_z), arm_streaming_compatible))
svint8_t svasr_wide_n_s8_z(svbool_t, svint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_wide_n_s32_z), arm_streaming_compatible))
svint32_t svasr_wide_n_s32_z(svbool_t, svint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_wide_n_s16_z), arm_streaming_compatible))
svint16_t svasr_wide_n_s16_z(svbool_t, svint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_wide_s8_m), arm_streaming_compatible))
svint8_t svasr_wide_s8_m(svbool_t, svint8_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_wide_s32_m), arm_streaming_compatible))
svint32_t svasr_wide_s32_m(svbool_t, svint32_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_wide_s16_m), arm_streaming_compatible))
svint16_t svasr_wide_s16_m(svbool_t, svint16_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_wide_s8_x), arm_streaming_compatible))
svint8_t svasr_wide_s8_x(svbool_t, svint8_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_wide_s32_x), arm_streaming_compatible))
svint32_t svasr_wide_s32_x(svbool_t, svint32_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_wide_s16_x), arm_streaming_compatible))
svint16_t svasr_wide_s16_x(svbool_t, svint16_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_wide_s8_z), arm_streaming_compatible))
svint8_t svasr_wide_s8_z(svbool_t, svint8_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_wide_s32_z), arm_streaming_compatible))
svint32_t svasr_wide_s32_z(svbool_t, svint32_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_wide_s16_z), arm_streaming_compatible))
svint16_t svasr_wide_s16_z(svbool_t, svint16_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasrd_n_s8_m), arm_streaming_compatible))
svint8_t svasrd_n_s8_m(svbool_t, svint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasrd_n_s32_m), arm_streaming_compatible))
svint32_t svasrd_n_s32_m(svbool_t, svint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasrd_n_s64_m), arm_streaming_compatible))
svint64_t svasrd_n_s64_m(svbool_t, svint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasrd_n_s16_m), arm_streaming_compatible))
svint16_t svasrd_n_s16_m(svbool_t, svint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasrd_n_s8_x), arm_streaming_compatible))
svint8_t svasrd_n_s8_x(svbool_t, svint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasrd_n_s32_x), arm_streaming_compatible))
svint32_t svasrd_n_s32_x(svbool_t, svint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasrd_n_s64_x), arm_streaming_compatible))
svint64_t svasrd_n_s64_x(svbool_t, svint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasrd_n_s16_x), arm_streaming_compatible))
svint16_t svasrd_n_s16_x(svbool_t, svint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasrd_n_s8_z), arm_streaming_compatible))
svint8_t svasrd_n_s8_z(svbool_t, svint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasrd_n_s32_z), arm_streaming_compatible))
svint32_t svasrd_n_s32_z(svbool_t, svint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasrd_n_s64_z), arm_streaming_compatible))
svint64_t svasrd_n_s64_z(svbool_t, svint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasrd_n_s16_z), arm_streaming_compatible))
svint16_t svasrd_n_s16_z(svbool_t, svint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_b_z), arm_streaming_compatible))
svbool_t svbic_b_z(svbool_t, svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_u8_m), arm_streaming_compatible))
svuint8_t svbic_n_u8_m(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_u32_m), arm_streaming_compatible))
svuint32_t svbic_n_u32_m(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_u64_m), arm_streaming_compatible))
svuint64_t svbic_n_u64_m(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_u16_m), arm_streaming_compatible))
svuint16_t svbic_n_u16_m(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_s8_m), arm_streaming_compatible))
svint8_t svbic_n_s8_m(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_s32_m), arm_streaming_compatible))
svint32_t svbic_n_s32_m(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_s64_m), arm_streaming_compatible))
svint64_t svbic_n_s64_m(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_s16_m), arm_streaming_compatible))
svint16_t svbic_n_s16_m(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_u8_x), arm_streaming_compatible))
svuint8_t svbic_n_u8_x(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_u32_x), arm_streaming_compatible))
svuint32_t svbic_n_u32_x(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_u64_x), arm_streaming_compatible))
svuint64_t svbic_n_u64_x(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_u16_x), arm_streaming_compatible))
svuint16_t svbic_n_u16_x(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_s8_x), arm_streaming_compatible))
svint8_t svbic_n_s8_x(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_s32_x), arm_streaming_compatible))
svint32_t svbic_n_s32_x(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_s64_x), arm_streaming_compatible))
svint64_t svbic_n_s64_x(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_s16_x), arm_streaming_compatible))
svint16_t svbic_n_s16_x(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_u8_z), arm_streaming_compatible))
svuint8_t svbic_n_u8_z(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_u32_z), arm_streaming_compatible))
svuint32_t svbic_n_u32_z(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_u64_z), arm_streaming_compatible))
svuint64_t svbic_n_u64_z(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_u16_z), arm_streaming_compatible))
svuint16_t svbic_n_u16_z(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_s8_z), arm_streaming_compatible))
svint8_t svbic_n_s8_z(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_s32_z), arm_streaming_compatible))
svint32_t svbic_n_s32_z(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_s64_z), arm_streaming_compatible))
svint64_t svbic_n_s64_z(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_s16_z), arm_streaming_compatible))
svint16_t svbic_n_s16_z(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_u8_m), arm_streaming_compatible))
svuint8_t svbic_u8_m(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_u32_m), arm_streaming_compatible))
svuint32_t svbic_u32_m(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_u64_m), arm_streaming_compatible))
svuint64_t svbic_u64_m(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_u16_m), arm_streaming_compatible))
svuint16_t svbic_u16_m(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_s8_m), arm_streaming_compatible))
svint8_t svbic_s8_m(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_s32_m), arm_streaming_compatible))
svint32_t svbic_s32_m(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_s64_m), arm_streaming_compatible))
svint64_t svbic_s64_m(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_s16_m), arm_streaming_compatible))
svint16_t svbic_s16_m(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_u8_x), arm_streaming_compatible))
svuint8_t svbic_u8_x(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_u32_x), arm_streaming_compatible))
svuint32_t svbic_u32_x(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_u64_x), arm_streaming_compatible))
svuint64_t svbic_u64_x(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_u16_x), arm_streaming_compatible))
svuint16_t svbic_u16_x(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_s8_x), arm_streaming_compatible))
svint8_t svbic_s8_x(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_s32_x), arm_streaming_compatible))
svint32_t svbic_s32_x(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_s64_x), arm_streaming_compatible))
svint64_t svbic_s64_x(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_s16_x), arm_streaming_compatible))
svint16_t svbic_s16_x(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_u8_z), arm_streaming_compatible))
svuint8_t svbic_u8_z(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_u32_z), arm_streaming_compatible))
svuint32_t svbic_u32_z(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_u64_z), arm_streaming_compatible))
svuint64_t svbic_u64_z(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_u16_z), arm_streaming_compatible))
svuint16_t svbic_u16_z(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_s8_z), arm_streaming_compatible))
svint8_t svbic_s8_z(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_s32_z), arm_streaming_compatible))
svint32_t svbic_s32_z(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_s64_z), arm_streaming_compatible))
svint64_t svbic_s64_z(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_s16_z), arm_streaming_compatible))
svint16_t svbic_s16_z(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbrka_b_m), arm_streaming_compatible))
svbool_t svbrka_b_m(svbool_t, svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbrka_b_z), arm_streaming_compatible))
svbool_t svbrka_b_z(svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbrkb_b_m), arm_streaming_compatible))
svbool_t svbrkb_b_m(svbool_t, svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbrkb_b_z), arm_streaming_compatible))
svbool_t svbrkb_b_z(svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbrkn_b_z), arm_streaming_compatible))
svbool_t svbrkn_b_z(svbool_t, svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbrkpa_b_z), arm_streaming_compatible))
svbool_t svbrkpa_b_z(svbool_t, svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbrkpb_b_z), arm_streaming_compatible))
svbool_t svbrkpb_b_z(svbool_t, svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcadd_f64_m), arm_streaming_compatible))
svfloat64_t svcadd_f64_m(svbool_t, svfloat64_t, svfloat64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcadd_f32_m), arm_streaming_compatible))
svfloat32_t svcadd_f32_m(svbool_t, svfloat32_t, svfloat32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcadd_f16_m), arm_streaming_compatible))
svfloat16_t svcadd_f16_m(svbool_t, svfloat16_t, svfloat16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcadd_f64_x), arm_streaming_compatible))
svfloat64_t svcadd_f64_x(svbool_t, svfloat64_t, svfloat64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcadd_f32_x), arm_streaming_compatible))
svfloat32_t svcadd_f32_x(svbool_t, svfloat32_t, svfloat32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcadd_f16_x), arm_streaming_compatible))
svfloat16_t svcadd_f16_x(svbool_t, svfloat16_t, svfloat16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcadd_f64_z), arm_streaming_compatible))
svfloat64_t svcadd_f64_z(svbool_t, svfloat64_t, svfloat64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcadd_f32_z), arm_streaming_compatible))
svfloat32_t svcadd_f32_z(svbool_t, svfloat32_t, svfloat32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcadd_f16_z), arm_streaming_compatible))
svfloat16_t svcadd_f16_z(svbool_t, svfloat16_t, svfloat16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_n_u8), arm_streaming_compatible))
uint8_t svclasta_n_u8(svbool_t, uint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_n_u32), arm_streaming_compatible))
uint32_t svclasta_n_u32(svbool_t, uint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_n_u64), arm_streaming_compatible))
uint64_t svclasta_n_u64(svbool_t, uint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_n_u16), arm_streaming_compatible))
uint16_t svclasta_n_u16(svbool_t, uint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_n_s8), arm_streaming_compatible))
int8_t svclasta_n_s8(svbool_t, int8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_n_f64), arm_streaming_compatible))
float64_t svclasta_n_f64(svbool_t, float64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_n_f32), arm_streaming_compatible))
float32_t svclasta_n_f32(svbool_t, float32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_n_f16), arm_streaming_compatible))
float16_t svclasta_n_f16(svbool_t, float16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_n_s32), arm_streaming_compatible))
int32_t svclasta_n_s32(svbool_t, int32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_n_s64), arm_streaming_compatible))
int64_t svclasta_n_s64(svbool_t, int64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_n_s16), arm_streaming_compatible))
int16_t svclasta_n_s16(svbool_t, int16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_u8), arm_streaming_compatible))
svuint8_t svclasta_u8(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_u32), arm_streaming_compatible))
svuint32_t svclasta_u32(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_u64), arm_streaming_compatible))
svuint64_t svclasta_u64(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_u16), arm_streaming_compatible))
svuint16_t svclasta_u16(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_s8), arm_streaming_compatible))
svint8_t svclasta_s8(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_f64), arm_streaming_compatible))
svfloat64_t svclasta_f64(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_f32), arm_streaming_compatible))
svfloat32_t svclasta_f32(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_f16), arm_streaming_compatible))
svfloat16_t svclasta_f16(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_s32), arm_streaming_compatible))
svint32_t svclasta_s32(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_s64), arm_streaming_compatible))
svint64_t svclasta_s64(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_s16), arm_streaming_compatible))
svint16_t svclasta_s16(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_n_u8), arm_streaming_compatible))
uint8_t svclastb_n_u8(svbool_t, uint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_n_u32), arm_streaming_compatible))
uint32_t svclastb_n_u32(svbool_t, uint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_n_u64), arm_streaming_compatible))
uint64_t svclastb_n_u64(svbool_t, uint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_n_u16), arm_streaming_compatible))
uint16_t svclastb_n_u16(svbool_t, uint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_n_s8), arm_streaming_compatible))
int8_t svclastb_n_s8(svbool_t, int8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_n_f64), arm_streaming_compatible))
float64_t svclastb_n_f64(svbool_t, float64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_n_f32), arm_streaming_compatible))
float32_t svclastb_n_f32(svbool_t, float32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_n_f16), arm_streaming_compatible))
float16_t svclastb_n_f16(svbool_t, float16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_n_s32), arm_streaming_compatible))
int32_t svclastb_n_s32(svbool_t, int32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_n_s64), arm_streaming_compatible))
int64_t svclastb_n_s64(svbool_t, int64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_n_s16), arm_streaming_compatible))
int16_t svclastb_n_s16(svbool_t, int16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_u8), arm_streaming_compatible))
svuint8_t svclastb_u8(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_u32), arm_streaming_compatible))
svuint32_t svclastb_u32(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_u64), arm_streaming_compatible))
svuint64_t svclastb_u64(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_u16), arm_streaming_compatible))
svuint16_t svclastb_u16(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_s8), arm_streaming_compatible))
svint8_t svclastb_s8(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_f64), arm_streaming_compatible))
svfloat64_t svclastb_f64(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_f32), arm_streaming_compatible))
svfloat32_t svclastb_f32(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_f16), arm_streaming_compatible))
svfloat16_t svclastb_f16(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_s32), arm_streaming_compatible))
svint32_t svclastb_s32(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_s64), arm_streaming_compatible))
svint64_t svclastb_s64(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_s16), arm_streaming_compatible))
svint16_t svclastb_s16(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcls_s8_m), arm_streaming_compatible))
svuint8_t svcls_s8_m(svuint8_t, svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcls_s32_m), arm_streaming_compatible))
svuint32_t svcls_s32_m(svuint32_t, svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcls_s64_m), arm_streaming_compatible))
svuint64_t svcls_s64_m(svuint64_t, svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcls_s16_m), arm_streaming_compatible))
svuint16_t svcls_s16_m(svuint16_t, svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcls_s8_x), arm_streaming_compatible))
svuint8_t svcls_s8_x(svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcls_s32_x), arm_streaming_compatible))
svuint32_t svcls_s32_x(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcls_s64_x), arm_streaming_compatible))
svuint64_t svcls_s64_x(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcls_s16_x), arm_streaming_compatible))
svuint16_t svcls_s16_x(svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcls_s8_z), arm_streaming_compatible))
svuint8_t svcls_s8_z(svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcls_s32_z), arm_streaming_compatible))
svuint32_t svcls_s32_z(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcls_s64_z), arm_streaming_compatible))
svuint64_t svcls_s64_z(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcls_s16_z), arm_streaming_compatible))
svuint16_t svcls_s16_z(svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_u8_m), arm_streaming_compatible))
svuint8_t svclz_u8_m(svuint8_t, svbool_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_u32_m), arm_streaming_compatible))
svuint32_t svclz_u32_m(svuint32_t, svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_u64_m), arm_streaming_compatible))
svuint64_t svclz_u64_m(svuint64_t, svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_u16_m), arm_streaming_compatible))
svuint16_t svclz_u16_m(svuint16_t, svbool_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_s8_m), arm_streaming_compatible))
svuint8_t svclz_s8_m(svuint8_t, svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_s32_m), arm_streaming_compatible))
svuint32_t svclz_s32_m(svuint32_t, svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_s64_m), arm_streaming_compatible))
svuint64_t svclz_s64_m(svuint64_t, svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_s16_m), arm_streaming_compatible))
svuint16_t svclz_s16_m(svuint16_t, svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_u8_x), arm_streaming_compatible))
svuint8_t svclz_u8_x(svbool_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_u32_x), arm_streaming_compatible))
svuint32_t svclz_u32_x(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_u64_x), arm_streaming_compatible))
svuint64_t svclz_u64_x(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_u16_x), arm_streaming_compatible))
svuint16_t svclz_u16_x(svbool_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_s8_x), arm_streaming_compatible))
svuint8_t svclz_s8_x(svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_s32_x), arm_streaming_compatible))
svuint32_t svclz_s32_x(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_s64_x), arm_streaming_compatible))
svuint64_t svclz_s64_x(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_s16_x), arm_streaming_compatible))
svuint16_t svclz_s16_x(svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_u8_z), arm_streaming_compatible))
svuint8_t svclz_u8_z(svbool_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_u32_z), arm_streaming_compatible))
svuint32_t svclz_u32_z(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_u64_z), arm_streaming_compatible))
svuint64_t svclz_u64_z(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_u16_z), arm_streaming_compatible))
svuint16_t svclz_u16_z(svbool_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_s8_z), arm_streaming_compatible))
svuint8_t svclz_s8_z(svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_s32_z), arm_streaming_compatible))
svuint32_t svclz_s32_z(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_s64_z), arm_streaming_compatible))
svuint64_t svclz_s64_z(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_s16_z), arm_streaming_compatible))
svuint16_t svclz_s16_z(svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmla_f64_m), arm_streaming_compatible))
svfloat64_t svcmla_f64_m(svbool_t, svfloat64_t, svfloat64_t, svfloat64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmla_f32_m), arm_streaming_compatible))
svfloat32_t svcmla_f32_m(svbool_t, svfloat32_t, svfloat32_t, svfloat32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmla_f16_m), arm_streaming_compatible))
svfloat16_t svcmla_f16_m(svbool_t, svfloat16_t, svfloat16_t, svfloat16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmla_f64_x), arm_streaming_compatible))
svfloat64_t svcmla_f64_x(svbool_t, svfloat64_t, svfloat64_t, svfloat64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmla_f32_x), arm_streaming_compatible))
svfloat32_t svcmla_f32_x(svbool_t, svfloat32_t, svfloat32_t, svfloat32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmla_f16_x), arm_streaming_compatible))
svfloat16_t svcmla_f16_x(svbool_t, svfloat16_t, svfloat16_t, svfloat16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmla_f64_z), arm_streaming_compatible))
svfloat64_t svcmla_f64_z(svbool_t, svfloat64_t, svfloat64_t, svfloat64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmla_f32_z), arm_streaming_compatible))
svfloat32_t svcmla_f32_z(svbool_t, svfloat32_t, svfloat32_t, svfloat32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmla_f16_z), arm_streaming_compatible))
svfloat16_t svcmla_f16_z(svbool_t, svfloat16_t, svfloat16_t, svfloat16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmla_lane_f32), arm_streaming_compatible))
svfloat32_t svcmla_lane_f32(svfloat32_t, svfloat32_t, svfloat32_t, uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmla_lane_f16), arm_streaming_compatible))
svfloat16_t svcmla_lane_f16(svfloat16_t, svfloat16_t, svfloat16_t, uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_n_f64), arm_streaming_compatible))
svbool_t svcmpeq_n_f64(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_n_f32), arm_streaming_compatible))
svbool_t svcmpeq_n_f32(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_n_f16), arm_streaming_compatible))
svbool_t svcmpeq_n_f16(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_n_u8), arm_streaming_compatible))
svbool_t svcmpeq_n_u8(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_n_u32), arm_streaming_compatible))
svbool_t svcmpeq_n_u32(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_n_u64), arm_streaming_compatible))
svbool_t svcmpeq_n_u64(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_n_u16), arm_streaming_compatible))
svbool_t svcmpeq_n_u16(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_n_s8), arm_streaming_compatible))
svbool_t svcmpeq_n_s8(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_n_s32), arm_streaming_compatible))
svbool_t svcmpeq_n_s32(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_n_s64), arm_streaming_compatible))
svbool_t svcmpeq_n_s64(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_n_s16), arm_streaming_compatible))
svbool_t svcmpeq_n_s16(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_u8), arm_streaming_compatible))
svbool_t svcmpeq_u8(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_u32), arm_streaming_compatible))
svbool_t svcmpeq_u32(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_u64), arm_streaming_compatible))
svbool_t svcmpeq_u64(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_u16), arm_streaming_compatible))
svbool_t svcmpeq_u16(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_s8), arm_streaming_compatible))
svbool_t svcmpeq_s8(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_s32), arm_streaming_compatible))
svbool_t svcmpeq_s32(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_s64), arm_streaming_compatible))
svbool_t svcmpeq_s64(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_s16), arm_streaming_compatible))
svbool_t svcmpeq_s16(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_f64), arm_streaming_compatible))
svbool_t svcmpeq_f64(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_f32), arm_streaming_compatible))
svbool_t svcmpeq_f32(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_f16), arm_streaming_compatible))
svbool_t svcmpeq_f16(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_wide_n_s8), arm_streaming_compatible))
svbool_t svcmpeq_wide_n_s8(svbool_t, svint8_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_wide_n_s32), arm_streaming_compatible))
svbool_t svcmpeq_wide_n_s32(svbool_t, svint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_wide_n_s16), arm_streaming_compatible))
svbool_t svcmpeq_wide_n_s16(svbool_t, svint16_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_wide_s8), arm_streaming_compatible))
svbool_t svcmpeq_wide_s8(svbool_t, svint8_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_wide_s32), arm_streaming_compatible))
svbool_t svcmpeq_wide_s32(svbool_t, svint32_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_wide_s16), arm_streaming_compatible))
svbool_t svcmpeq_wide_s16(svbool_t, svint16_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_n_f64), arm_streaming_compatible))
svbool_t svcmpge_n_f64(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_n_f32), arm_streaming_compatible))
svbool_t svcmpge_n_f32(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_n_f16), arm_streaming_compatible))
svbool_t svcmpge_n_f16(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_n_s8), arm_streaming_compatible))
svbool_t svcmpge_n_s8(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_n_s32), arm_streaming_compatible))
svbool_t svcmpge_n_s32(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_n_s64), arm_streaming_compatible))
svbool_t svcmpge_n_s64(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_n_s16), arm_streaming_compatible))
svbool_t svcmpge_n_s16(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_n_u8), arm_streaming_compatible))
svbool_t svcmpge_n_u8(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_n_u32), arm_streaming_compatible))
svbool_t svcmpge_n_u32(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_n_u64), arm_streaming_compatible))
svbool_t svcmpge_n_u64(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_n_u16), arm_streaming_compatible))
svbool_t svcmpge_n_u16(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_s8), arm_streaming_compatible))
svbool_t svcmpge_s8(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_s32), arm_streaming_compatible))
svbool_t svcmpge_s32(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_s64), arm_streaming_compatible))
svbool_t svcmpge_s64(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_s16), arm_streaming_compatible))
svbool_t svcmpge_s16(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_f64), arm_streaming_compatible))
svbool_t svcmpge_f64(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_f32), arm_streaming_compatible))
svbool_t svcmpge_f32(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_f16), arm_streaming_compatible))
svbool_t svcmpge_f16(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_u8), arm_streaming_compatible))
svbool_t svcmpge_u8(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_u32), arm_streaming_compatible))
svbool_t svcmpge_u32(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_u64), arm_streaming_compatible))
svbool_t svcmpge_u64(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_u16), arm_streaming_compatible))
svbool_t svcmpge_u16(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_wide_n_s8), arm_streaming_compatible))
svbool_t svcmpge_wide_n_s8(svbool_t, svint8_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_wide_n_s32), arm_streaming_compatible))
svbool_t svcmpge_wide_n_s32(svbool_t, svint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_wide_n_s16), arm_streaming_compatible))
svbool_t svcmpge_wide_n_s16(svbool_t, svint16_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_wide_n_u8), arm_streaming_compatible))
svbool_t svcmpge_wide_n_u8(svbool_t, svuint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_wide_n_u32), arm_streaming_compatible))
svbool_t svcmpge_wide_n_u32(svbool_t, svuint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_wide_n_u16), arm_streaming_compatible))
svbool_t svcmpge_wide_n_u16(svbool_t, svuint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_wide_s8), arm_streaming_compatible))
svbool_t svcmpge_wide_s8(svbool_t, svint8_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_wide_s32), arm_streaming_compatible))
svbool_t svcmpge_wide_s32(svbool_t, svint32_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_wide_s16), arm_streaming_compatible))
svbool_t svcmpge_wide_s16(svbool_t, svint16_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_wide_u8), arm_streaming_compatible))
svbool_t svcmpge_wide_u8(svbool_t, svuint8_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_wide_u32), arm_streaming_compatible))
svbool_t svcmpge_wide_u32(svbool_t, svuint32_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_wide_u16), arm_streaming_compatible))
svbool_t svcmpge_wide_u16(svbool_t, svuint16_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_n_f64), arm_streaming_compatible))
svbool_t svcmpgt_n_f64(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_n_f32), arm_streaming_compatible))
svbool_t svcmpgt_n_f32(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_n_f16), arm_streaming_compatible))
svbool_t svcmpgt_n_f16(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_n_s8), arm_streaming_compatible))
svbool_t svcmpgt_n_s8(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_n_s32), arm_streaming_compatible))
svbool_t svcmpgt_n_s32(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_n_s64), arm_streaming_compatible))
svbool_t svcmpgt_n_s64(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_n_s16), arm_streaming_compatible))
svbool_t svcmpgt_n_s16(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_n_u8), arm_streaming_compatible))
svbool_t svcmpgt_n_u8(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_n_u32), arm_streaming_compatible))
svbool_t svcmpgt_n_u32(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_n_u64), arm_streaming_compatible))
svbool_t svcmpgt_n_u64(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_n_u16), arm_streaming_compatible))
svbool_t svcmpgt_n_u16(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_s8), arm_streaming_compatible))
svbool_t svcmpgt_s8(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_s32), arm_streaming_compatible))
svbool_t svcmpgt_s32(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_s64), arm_streaming_compatible))
svbool_t svcmpgt_s64(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_s16), arm_streaming_compatible))
svbool_t svcmpgt_s16(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_f64), arm_streaming_compatible))
svbool_t svcmpgt_f64(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_f32), arm_streaming_compatible))
svbool_t svcmpgt_f32(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_f16), arm_streaming_compatible))
svbool_t svcmpgt_f16(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_u8), arm_streaming_compatible))
svbool_t svcmpgt_u8(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_u32), arm_streaming_compatible))
svbool_t svcmpgt_u32(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_u64), arm_streaming_compatible))
svbool_t svcmpgt_u64(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_u16), arm_streaming_compatible))
svbool_t svcmpgt_u16(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_wide_n_s8), arm_streaming_compatible))
svbool_t svcmpgt_wide_n_s8(svbool_t, svint8_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_wide_n_s32), arm_streaming_compatible))
svbool_t svcmpgt_wide_n_s32(svbool_t, svint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_wide_n_s16), arm_streaming_compatible))
svbool_t svcmpgt_wide_n_s16(svbool_t, svint16_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_wide_n_u8), arm_streaming_compatible))
svbool_t svcmpgt_wide_n_u8(svbool_t, svuint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_wide_n_u32), arm_streaming_compatible))
svbool_t svcmpgt_wide_n_u32(svbool_t, svuint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_wide_n_u16), arm_streaming_compatible))
svbool_t svcmpgt_wide_n_u16(svbool_t, svuint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_wide_s8), arm_streaming_compatible))
svbool_t svcmpgt_wide_s8(svbool_t, svint8_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_wide_s32), arm_streaming_compatible))
svbool_t svcmpgt_wide_s32(svbool_t, svint32_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_wide_s16), arm_streaming_compatible))
svbool_t svcmpgt_wide_s16(svbool_t, svint16_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_wide_u8), arm_streaming_compatible))
svbool_t svcmpgt_wide_u8(svbool_t, svuint8_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_wide_u32), arm_streaming_compatible))
svbool_t svcmpgt_wide_u32(svbool_t, svuint32_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_wide_u16), arm_streaming_compatible))
svbool_t svcmpgt_wide_u16(svbool_t, svuint16_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_n_f64), arm_streaming_compatible))
svbool_t svcmple_n_f64(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_n_f32), arm_streaming_compatible))
svbool_t svcmple_n_f32(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_n_f16), arm_streaming_compatible))
svbool_t svcmple_n_f16(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_n_s8), arm_streaming_compatible))
svbool_t svcmple_n_s8(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_n_s32), arm_streaming_compatible))
svbool_t svcmple_n_s32(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_n_s64), arm_streaming_compatible))
svbool_t svcmple_n_s64(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_n_s16), arm_streaming_compatible))
svbool_t svcmple_n_s16(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_n_u8), arm_streaming_compatible))
svbool_t svcmple_n_u8(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_n_u32), arm_streaming_compatible))
svbool_t svcmple_n_u32(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_n_u64), arm_streaming_compatible))
svbool_t svcmple_n_u64(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_n_u16), arm_streaming_compatible))
svbool_t svcmple_n_u16(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_s8), arm_streaming_compatible))
svbool_t svcmple_s8(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_s32), arm_streaming_compatible))
svbool_t svcmple_s32(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_s64), arm_streaming_compatible))
svbool_t svcmple_s64(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_s16), arm_streaming_compatible))
svbool_t svcmple_s16(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_f64), arm_streaming_compatible))
svbool_t svcmple_f64(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_f32), arm_streaming_compatible))
svbool_t svcmple_f32(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_f16), arm_streaming_compatible))
svbool_t svcmple_f16(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_u8), arm_streaming_compatible))
svbool_t svcmple_u8(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_u32), arm_streaming_compatible))
svbool_t svcmple_u32(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_u64), arm_streaming_compatible))
svbool_t svcmple_u64(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_u16), arm_streaming_compatible))
svbool_t svcmple_u16(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_wide_n_s8), arm_streaming_compatible))
svbool_t svcmple_wide_n_s8(svbool_t, svint8_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_wide_n_s32), arm_streaming_compatible))
svbool_t svcmple_wide_n_s32(svbool_t, svint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_wide_n_s16), arm_streaming_compatible))
svbool_t svcmple_wide_n_s16(svbool_t, svint16_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_wide_n_u8), arm_streaming_compatible))
svbool_t svcmple_wide_n_u8(svbool_t, svuint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_wide_n_u32), arm_streaming_compatible))
svbool_t svcmple_wide_n_u32(svbool_t, svuint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_wide_n_u16), arm_streaming_compatible))
svbool_t svcmple_wide_n_u16(svbool_t, svuint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_wide_s8), arm_streaming_compatible))
svbool_t svcmple_wide_s8(svbool_t, svint8_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_wide_s32), arm_streaming_compatible))
svbool_t svcmple_wide_s32(svbool_t, svint32_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_wide_s16), arm_streaming_compatible))
svbool_t svcmple_wide_s16(svbool_t, svint16_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_wide_u8), arm_streaming_compatible))
svbool_t svcmple_wide_u8(svbool_t, svuint8_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_wide_u32), arm_streaming_compatible))
svbool_t svcmple_wide_u32(svbool_t, svuint32_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_wide_u16), arm_streaming_compatible))
svbool_t svcmple_wide_u16(svbool_t, svuint16_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_n_u8), arm_streaming_compatible))
svbool_t svcmplt_n_u8(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_n_u32), arm_streaming_compatible))
svbool_t svcmplt_n_u32(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_n_u64), arm_streaming_compatible))
svbool_t svcmplt_n_u64(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_n_u16), arm_streaming_compatible))
svbool_t svcmplt_n_u16(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_n_f64), arm_streaming_compatible))
svbool_t svcmplt_n_f64(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_n_f32), arm_streaming_compatible))
svbool_t svcmplt_n_f32(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_n_f16), arm_streaming_compatible))
svbool_t svcmplt_n_f16(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_n_s8), arm_streaming_compatible))
svbool_t svcmplt_n_s8(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_n_s32), arm_streaming_compatible))
svbool_t svcmplt_n_s32(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_n_s64), arm_streaming_compatible))
svbool_t svcmplt_n_s64(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_n_s16), arm_streaming_compatible))
svbool_t svcmplt_n_s16(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_u8), arm_streaming_compatible))
svbool_t svcmplt_u8(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_u32), arm_streaming_compatible))
svbool_t svcmplt_u32(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_u64), arm_streaming_compatible))
svbool_t svcmplt_u64(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_u16), arm_streaming_compatible))
svbool_t svcmplt_u16(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_s8), arm_streaming_compatible))
svbool_t svcmplt_s8(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_s32), arm_streaming_compatible))
svbool_t svcmplt_s32(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_s64), arm_streaming_compatible))
svbool_t svcmplt_s64(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_s16), arm_streaming_compatible))
svbool_t svcmplt_s16(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_f64), arm_streaming_compatible))
svbool_t svcmplt_f64(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_f32), arm_streaming_compatible))
svbool_t svcmplt_f32(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_f16), arm_streaming_compatible))
svbool_t svcmplt_f16(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_wide_n_u8), arm_streaming_compatible))
svbool_t svcmplt_wide_n_u8(svbool_t, svuint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_wide_n_u32), arm_streaming_compatible))
svbool_t svcmplt_wide_n_u32(svbool_t, svuint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_wide_n_u16), arm_streaming_compatible))
svbool_t svcmplt_wide_n_u16(svbool_t, svuint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_wide_n_s8), arm_streaming_compatible))
svbool_t svcmplt_wide_n_s8(svbool_t, svint8_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_wide_n_s32), arm_streaming_compatible))
svbool_t svcmplt_wide_n_s32(svbool_t, svint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_wide_n_s16), arm_streaming_compatible))
svbool_t svcmplt_wide_n_s16(svbool_t, svint16_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_wide_u8), arm_streaming_compatible))
svbool_t svcmplt_wide_u8(svbool_t, svuint8_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_wide_u32), arm_streaming_compatible))
svbool_t svcmplt_wide_u32(svbool_t, svuint32_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_wide_u16), arm_streaming_compatible))
svbool_t svcmplt_wide_u16(svbool_t, svuint16_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_wide_s8), arm_streaming_compatible))
svbool_t svcmplt_wide_s8(svbool_t, svint8_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_wide_s32), arm_streaming_compatible))
svbool_t svcmplt_wide_s32(svbool_t, svint32_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_wide_s16), arm_streaming_compatible))
svbool_t svcmplt_wide_s16(svbool_t, svint16_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_n_f64), arm_streaming_compatible))
svbool_t svcmpne_n_f64(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_n_f32), arm_streaming_compatible))
svbool_t svcmpne_n_f32(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_n_f16), arm_streaming_compatible))
svbool_t svcmpne_n_f16(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_n_u8), arm_streaming_compatible))
svbool_t svcmpne_n_u8(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_n_u32), arm_streaming_compatible))
svbool_t svcmpne_n_u32(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_n_u64), arm_streaming_compatible))
svbool_t svcmpne_n_u64(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_n_u16), arm_streaming_compatible))
svbool_t svcmpne_n_u16(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_n_s8), arm_streaming_compatible))
svbool_t svcmpne_n_s8(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_n_s32), arm_streaming_compatible))
svbool_t svcmpne_n_s32(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_n_s64), arm_streaming_compatible))
svbool_t svcmpne_n_s64(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_n_s16), arm_streaming_compatible))
svbool_t svcmpne_n_s16(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_u8), arm_streaming_compatible))
svbool_t svcmpne_u8(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_u32), arm_streaming_compatible))
svbool_t svcmpne_u32(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_u64), arm_streaming_compatible))
svbool_t svcmpne_u64(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_u16), arm_streaming_compatible))
svbool_t svcmpne_u16(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_s8), arm_streaming_compatible))
svbool_t svcmpne_s8(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_s32), arm_streaming_compatible))
svbool_t svcmpne_s32(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_s64), arm_streaming_compatible))
svbool_t svcmpne_s64(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_s16), arm_streaming_compatible))
svbool_t svcmpne_s16(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_f64), arm_streaming_compatible))
svbool_t svcmpne_f64(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_f32), arm_streaming_compatible))
svbool_t svcmpne_f32(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_f16), arm_streaming_compatible))
svbool_t svcmpne_f16(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_wide_n_s8), arm_streaming_compatible))
svbool_t svcmpne_wide_n_s8(svbool_t, svint8_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_wide_n_s32), arm_streaming_compatible))
svbool_t svcmpne_wide_n_s32(svbool_t, svint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_wide_n_s16), arm_streaming_compatible))
svbool_t svcmpne_wide_n_s16(svbool_t, svint16_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_wide_s8), arm_streaming_compatible))
svbool_t svcmpne_wide_s8(svbool_t, svint8_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_wide_s32), arm_streaming_compatible))
svbool_t svcmpne_wide_s32(svbool_t, svint32_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_wide_s16), arm_streaming_compatible))
svbool_t svcmpne_wide_s16(svbool_t, svint16_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpuo_n_f64)))
svbool_t svcmpuo_n_f64(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpuo_n_f32)))
svbool_t svcmpuo_n_f32(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpuo_n_f16)))
svbool_t svcmpuo_n_f16(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpuo_f64), arm_streaming_compatible))
svbool_t svcmpuo_f64(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpuo_f32), arm_streaming_compatible))
svbool_t svcmpuo_f32(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpuo_f16), arm_streaming_compatible))
svbool_t svcmpuo_f16(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_u8_m), arm_streaming_compatible))
svuint8_t svcnot_u8_m(svuint8_t, svbool_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_u32_m), arm_streaming_compatible))
svuint32_t svcnot_u32_m(svuint32_t, svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_u64_m), arm_streaming_compatible))
svuint64_t svcnot_u64_m(svuint64_t, svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_u16_m), arm_streaming_compatible))
svuint16_t svcnot_u16_m(svuint16_t, svbool_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_s8_m), arm_streaming_compatible))
svint8_t svcnot_s8_m(svint8_t, svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_s32_m), arm_streaming_compatible))
svint32_t svcnot_s32_m(svint32_t, svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_s64_m), arm_streaming_compatible))
svint64_t svcnot_s64_m(svint64_t, svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_s16_m), arm_streaming_compatible))
svint16_t svcnot_s16_m(svint16_t, svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_u8_x), arm_streaming_compatible))
svuint8_t svcnot_u8_x(svbool_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_u32_x), arm_streaming_compatible))
svuint32_t svcnot_u32_x(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_u64_x), arm_streaming_compatible))
svuint64_t svcnot_u64_x(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_u16_x), arm_streaming_compatible))
svuint16_t svcnot_u16_x(svbool_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_s8_x), arm_streaming_compatible))
svint8_t svcnot_s8_x(svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_s32_x), arm_streaming_compatible))
svint32_t svcnot_s32_x(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_s64_x), arm_streaming_compatible))
svint64_t svcnot_s64_x(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_s16_x), arm_streaming_compatible))
svint16_t svcnot_s16_x(svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_u8_z), arm_streaming_compatible))
svuint8_t svcnot_u8_z(svbool_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_u32_z), arm_streaming_compatible))
svuint32_t svcnot_u32_z(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_u64_z), arm_streaming_compatible))
svuint64_t svcnot_u64_z(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_u16_z), arm_streaming_compatible))
svuint16_t svcnot_u16_z(svbool_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_s8_z), arm_streaming_compatible))
svint8_t svcnot_s8_z(svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_s32_z), arm_streaming_compatible))
svint32_t svcnot_s32_z(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_s64_z), arm_streaming_compatible))
svint64_t svcnot_s64_z(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_s16_z), arm_streaming_compatible))
svint16_t svcnot_s16_z(svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_u8_m), arm_streaming_compatible))
svuint8_t svcnt_u8_m(svuint8_t, svbool_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_u32_m), arm_streaming_compatible))
svuint32_t svcnt_u32_m(svuint32_t, svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_u64_m), arm_streaming_compatible))
svuint64_t svcnt_u64_m(svuint64_t, svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_u16_m), arm_streaming_compatible))
svuint16_t svcnt_u16_m(svuint16_t, svbool_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_s8_m), arm_streaming_compatible))
svuint8_t svcnt_s8_m(svuint8_t, svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_f64_m), arm_streaming_compatible))
svuint64_t svcnt_f64_m(svuint64_t, svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_f32_m), arm_streaming_compatible))
svuint32_t svcnt_f32_m(svuint32_t, svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_f16_m), arm_streaming_compatible))
svuint16_t svcnt_f16_m(svuint16_t, svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_s32_m), arm_streaming_compatible))
svuint32_t svcnt_s32_m(svuint32_t, svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_s64_m), arm_streaming_compatible))
svuint64_t svcnt_s64_m(svuint64_t, svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_s16_m), arm_streaming_compatible))
svuint16_t svcnt_s16_m(svuint16_t, svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_u8_x), arm_streaming_compatible))
svuint8_t svcnt_u8_x(svbool_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_u32_x), arm_streaming_compatible))
svuint32_t svcnt_u32_x(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_u64_x), arm_streaming_compatible))
svuint64_t svcnt_u64_x(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_u16_x), arm_streaming_compatible))
svuint16_t svcnt_u16_x(svbool_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_s8_x), arm_streaming_compatible))
svuint8_t svcnt_s8_x(svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_f64_x), arm_streaming_compatible))
svuint64_t svcnt_f64_x(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_f32_x), arm_streaming_compatible))
svuint32_t svcnt_f32_x(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_f16_x), arm_streaming_compatible))
svuint16_t svcnt_f16_x(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_s32_x), arm_streaming_compatible))
svuint32_t svcnt_s32_x(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_s64_x), arm_streaming_compatible))
svuint64_t svcnt_s64_x(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_s16_x), arm_streaming_compatible))
svuint16_t svcnt_s16_x(svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_u8_z), arm_streaming_compatible))
svuint8_t svcnt_u8_z(svbool_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_u32_z), arm_streaming_compatible))
svuint32_t svcnt_u32_z(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_u64_z), arm_streaming_compatible))
svuint64_t svcnt_u64_z(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_u16_z), arm_streaming_compatible))
svuint16_t svcnt_u16_z(svbool_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_s8_z), arm_streaming_compatible))
svuint8_t svcnt_s8_z(svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_f64_z), arm_streaming_compatible))
svuint64_t svcnt_f64_z(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_f32_z), arm_streaming_compatible))
svuint32_t svcnt_f32_z(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_f16_z), arm_streaming_compatible))
svuint16_t svcnt_f16_z(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_s32_z), arm_streaming_compatible))
svuint32_t svcnt_s32_z(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_s64_z), arm_streaming_compatible))
svuint64_t svcnt_s64_z(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_s16_z), arm_streaming_compatible))
svuint16_t svcnt_s16_z(svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcntb), arm_streaming_compatible))
uint64_t svcntb(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcntb_pat), arm_streaming_compatible))
uint64_t svcntb_pat(enum svpattern);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcntd), arm_streaming_compatible))
uint64_t svcntd(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcntd_pat), arm_streaming_compatible))
uint64_t svcntd_pat(enum svpattern);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnth), arm_streaming_compatible))
uint64_t svcnth(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnth_pat), arm_streaming_compatible))
uint64_t svcnth_pat(enum svpattern);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcntp_b8), arm_streaming_compatible))
uint64_t svcntp_b8(svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcntp_b32), arm_streaming_compatible))
uint64_t svcntp_b32(svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcntp_b64), arm_streaming_compatible))
uint64_t svcntp_b64(svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcntp_b16), arm_streaming_compatible))
uint64_t svcntp_b16(svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcntw), arm_streaming_compatible))
uint64_t svcntw(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcntw_pat), arm_streaming_compatible))
uint64_t svcntw_pat(enum svpattern);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcompact_u32)))
svuint32_t svcompact_u32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcompact_u64)))
svuint64_t svcompact_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcompact_f64)))
svfloat64_t svcompact_f64(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcompact_f32)))
svfloat32_t svcompact_f32(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcompact_s32)))
svint32_t svcompact_s32(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcompact_s64)))
svint64_t svcompact_s64(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate2_u8)))
svuint8x2_t svcreate2_u8(svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate2_u32)))
svuint32x2_t svcreate2_u32(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate2_u64)))
svuint64x2_t svcreate2_u64(svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate2_u16)))
svuint16x2_t svcreate2_u16(svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate2_s8)))
svint8x2_t svcreate2_s8(svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate2_f64)))
svfloat64x2_t svcreate2_f64(svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate2_f32)))
svfloat32x2_t svcreate2_f32(svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate2_f16)))
svfloat16x2_t svcreate2_f16(svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate2_s32)))
svint32x2_t svcreate2_s32(svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate2_s64)))
svint64x2_t svcreate2_s64(svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate2_s16)))
svint16x2_t svcreate2_s16(svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate3_u8)))
svuint8x3_t svcreate3_u8(svuint8_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate3_u32)))
svuint32x3_t svcreate3_u32(svuint32_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate3_u64)))
svuint64x3_t svcreate3_u64(svuint64_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate3_u16)))
svuint16x3_t svcreate3_u16(svuint16_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate3_s8)))
svint8x3_t svcreate3_s8(svint8_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate3_f64)))
svfloat64x3_t svcreate3_f64(svfloat64_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate3_f32)))
svfloat32x3_t svcreate3_f32(svfloat32_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate3_f16)))
svfloat16x3_t svcreate3_f16(svfloat16_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate3_s32)))
svint32x3_t svcreate3_s32(svint32_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate3_s64)))
svint64x3_t svcreate3_s64(svint64_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate3_s16)))
svint16x3_t svcreate3_s16(svint16_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate4_u8)))
svuint8x4_t svcreate4_u8(svuint8_t, svuint8_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate4_u32)))
svuint32x4_t svcreate4_u32(svuint32_t, svuint32_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate4_u64)))
svuint64x4_t svcreate4_u64(svuint64_t, svuint64_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate4_u16)))
svuint16x4_t svcreate4_u16(svuint16_t, svuint16_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate4_s8)))
svint8x4_t svcreate4_s8(svint8_t, svint8_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate4_f64)))
svfloat64x4_t svcreate4_f64(svfloat64_t, svfloat64_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate4_f32)))
svfloat32x4_t svcreate4_f32(svfloat32_t, svfloat32_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate4_f16)))
svfloat16x4_t svcreate4_f16(svfloat16_t, svfloat16_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate4_s32)))
svint32x4_t svcreate4_s32(svint32_t, svint32_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate4_s64)))
svint64x4_t svcreate4_s64(svint64_t, svint64_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate4_s16)))
svint16x4_t svcreate4_s16(svint16_t, svint16_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_f32_m), arm_streaming_compatible))
svfloat16_t svcvt_f16_f32_m(svfloat16_t, svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_f32_x), arm_streaming_compatible))
svfloat16_t svcvt_f16_f32_x(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_f32_z), arm_streaming_compatible))
svfloat16_t svcvt_f16_f32_z(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_f64_m), arm_streaming_compatible))
svfloat16_t svcvt_f16_f64_m(svfloat16_t, svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_f64_x), arm_streaming_compatible))
svfloat16_t svcvt_f16_f64_x(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_f64_z), arm_streaming_compatible))
svfloat16_t svcvt_f16_f64_z(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_s16_m), arm_streaming_compatible))
svfloat16_t svcvt_f16_s16_m(svfloat16_t, svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_s16_x), arm_streaming_compatible))
svfloat16_t svcvt_f16_s16_x(svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_s16_z), arm_streaming_compatible))
svfloat16_t svcvt_f16_s16_z(svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_s32_m), arm_streaming_compatible))
svfloat16_t svcvt_f16_s32_m(svfloat16_t, svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_s32_x), arm_streaming_compatible))
svfloat16_t svcvt_f16_s32_x(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_s32_z), arm_streaming_compatible))
svfloat16_t svcvt_f16_s32_z(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_s64_m), arm_streaming_compatible))
svfloat16_t svcvt_f16_s64_m(svfloat16_t, svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_s64_x), arm_streaming_compatible))
svfloat16_t svcvt_f16_s64_x(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_s64_z), arm_streaming_compatible))
svfloat16_t svcvt_f16_s64_z(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_u16_m), arm_streaming_compatible))
svfloat16_t svcvt_f16_u16_m(svfloat16_t, svbool_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_u16_x), arm_streaming_compatible))
svfloat16_t svcvt_f16_u16_x(svbool_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_u16_z), arm_streaming_compatible))
svfloat16_t svcvt_f16_u16_z(svbool_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_u32_m), arm_streaming_compatible))
svfloat16_t svcvt_f16_u32_m(svfloat16_t, svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_u32_x), arm_streaming_compatible))
svfloat16_t svcvt_f16_u32_x(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_u32_z), arm_streaming_compatible))
svfloat16_t svcvt_f16_u32_z(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_u64_m), arm_streaming_compatible))
svfloat16_t svcvt_f16_u64_m(svfloat16_t, svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_u64_x), arm_streaming_compatible))
svfloat16_t svcvt_f16_u64_x(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_u64_z), arm_streaming_compatible))
svfloat16_t svcvt_f16_u64_z(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_f16_m), arm_streaming_compatible))
svfloat32_t svcvt_f32_f16_m(svfloat32_t, svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_f16_x), arm_streaming_compatible))
svfloat32_t svcvt_f32_f16_x(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_f16_z), arm_streaming_compatible))
svfloat32_t svcvt_f32_f16_z(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_f64_m), arm_streaming_compatible))
svfloat32_t svcvt_f32_f64_m(svfloat32_t, svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_f64_x), arm_streaming_compatible))
svfloat32_t svcvt_f32_f64_x(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_f64_z), arm_streaming_compatible))
svfloat32_t svcvt_f32_f64_z(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_s32_m), arm_streaming_compatible))
svfloat32_t svcvt_f32_s32_m(svfloat32_t, svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_s32_x), arm_streaming_compatible))
svfloat32_t svcvt_f32_s32_x(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_s32_z), arm_streaming_compatible))
svfloat32_t svcvt_f32_s32_z(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_s64_m), arm_streaming_compatible))
svfloat32_t svcvt_f32_s64_m(svfloat32_t, svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_s64_x), arm_streaming_compatible))
svfloat32_t svcvt_f32_s64_x(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_s64_z), arm_streaming_compatible))
svfloat32_t svcvt_f32_s64_z(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_u32_m), arm_streaming_compatible))
svfloat32_t svcvt_f32_u32_m(svfloat32_t, svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_u32_x), arm_streaming_compatible))
svfloat32_t svcvt_f32_u32_x(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_u32_z), arm_streaming_compatible))
svfloat32_t svcvt_f32_u32_z(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_u64_m), arm_streaming_compatible))
svfloat32_t svcvt_f32_u64_m(svfloat32_t, svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_u64_x), arm_streaming_compatible))
svfloat32_t svcvt_f32_u64_x(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_u64_z), arm_streaming_compatible))
svfloat32_t svcvt_f32_u64_z(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f64_f16_m), arm_streaming_compatible))
svfloat64_t svcvt_f64_f16_m(svfloat64_t, svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f64_f16_x), arm_streaming_compatible))
svfloat64_t svcvt_f64_f16_x(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f64_f16_z), arm_streaming_compatible))
svfloat64_t svcvt_f64_f16_z(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f64_f32_m), arm_streaming_compatible))
svfloat64_t svcvt_f64_f32_m(svfloat64_t, svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f64_f32_x), arm_streaming_compatible))
svfloat64_t svcvt_f64_f32_x(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f64_f32_z), arm_streaming_compatible))
svfloat64_t svcvt_f64_f32_z(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f64_s32_m), arm_streaming_compatible))
svfloat64_t svcvt_f64_s32_m(svfloat64_t, svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f64_s32_x), arm_streaming_compatible))
svfloat64_t svcvt_f64_s32_x(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f64_s32_z), arm_streaming_compatible))
svfloat64_t svcvt_f64_s32_z(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f64_s64_m), arm_streaming_compatible))
svfloat64_t svcvt_f64_s64_m(svfloat64_t, svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f64_s64_x), arm_streaming_compatible))
svfloat64_t svcvt_f64_s64_x(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f64_s64_z), arm_streaming_compatible))
svfloat64_t svcvt_f64_s64_z(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f64_u32_m), arm_streaming_compatible))
svfloat64_t svcvt_f64_u32_m(svfloat64_t, svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f64_u32_x), arm_streaming_compatible))
svfloat64_t svcvt_f64_u32_x(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f64_u32_z), arm_streaming_compatible))
svfloat64_t svcvt_f64_u32_z(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f64_u64_m), arm_streaming_compatible))
svfloat64_t svcvt_f64_u64_m(svfloat64_t, svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f64_u64_x), arm_streaming_compatible))
svfloat64_t svcvt_f64_u64_x(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f64_u64_z), arm_streaming_compatible))
svfloat64_t svcvt_f64_u64_z(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_s16_f16_m), arm_streaming_compatible))
svint16_t svcvt_s16_f16_m(svint16_t, svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_s16_f16_x), arm_streaming_compatible))
svint16_t svcvt_s16_f16_x(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_s16_f16_z), arm_streaming_compatible))
svint16_t svcvt_s16_f16_z(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_s32_f16_m), arm_streaming_compatible))
svint32_t svcvt_s32_f16_m(svint32_t, svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_s32_f16_x), arm_streaming_compatible))
svint32_t svcvt_s32_f16_x(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_s32_f16_z), arm_streaming_compatible))
svint32_t svcvt_s32_f16_z(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_s32_f32_m), arm_streaming_compatible))
svint32_t svcvt_s32_f32_m(svint32_t, svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_s32_f32_x), arm_streaming_compatible))
svint32_t svcvt_s32_f32_x(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_s32_f32_z), arm_streaming_compatible))
svint32_t svcvt_s32_f32_z(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_s32_f64_m), arm_streaming_compatible))
svint32_t svcvt_s32_f64_m(svint32_t, svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_s32_f64_x), arm_streaming_compatible))
svint32_t svcvt_s32_f64_x(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_s32_f64_z), arm_streaming_compatible))
svint32_t svcvt_s32_f64_z(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_s64_f16_m), arm_streaming_compatible))
svint64_t svcvt_s64_f16_m(svint64_t, svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_s64_f16_x), arm_streaming_compatible))
svint64_t svcvt_s64_f16_x(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_s64_f16_z), arm_streaming_compatible))
svint64_t svcvt_s64_f16_z(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_s64_f32_m), arm_streaming_compatible))
svint64_t svcvt_s64_f32_m(svint64_t, svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_s64_f32_x), arm_streaming_compatible))
svint64_t svcvt_s64_f32_x(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_s64_f32_z), arm_streaming_compatible))
svint64_t svcvt_s64_f32_z(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_s64_f64_m), arm_streaming_compatible))
svint64_t svcvt_s64_f64_m(svint64_t, svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_s64_f64_x), arm_streaming_compatible))
svint64_t svcvt_s64_f64_x(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_s64_f64_z), arm_streaming_compatible))
svint64_t svcvt_s64_f64_z(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_u16_f16_m), arm_streaming_compatible))
svuint16_t svcvt_u16_f16_m(svuint16_t, svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_u16_f16_x), arm_streaming_compatible))
svuint16_t svcvt_u16_f16_x(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_u16_f16_z), arm_streaming_compatible))
svuint16_t svcvt_u16_f16_z(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_u32_f16_m), arm_streaming_compatible))
svuint32_t svcvt_u32_f16_m(svuint32_t, svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_u32_f16_x), arm_streaming_compatible))
svuint32_t svcvt_u32_f16_x(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_u32_f16_z), arm_streaming_compatible))
svuint32_t svcvt_u32_f16_z(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_u32_f32_m), arm_streaming_compatible))
svuint32_t svcvt_u32_f32_m(svuint32_t, svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_u32_f32_x), arm_streaming_compatible))
svuint32_t svcvt_u32_f32_x(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_u32_f32_z), arm_streaming_compatible))
svuint32_t svcvt_u32_f32_z(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_u32_f64_m), arm_streaming_compatible))
svuint32_t svcvt_u32_f64_m(svuint32_t, svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_u32_f64_x), arm_streaming_compatible))
svuint32_t svcvt_u32_f64_x(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_u32_f64_z), arm_streaming_compatible))
svuint32_t svcvt_u32_f64_z(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_u64_f16_m), arm_streaming_compatible))
svuint64_t svcvt_u64_f16_m(svuint64_t, svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_u64_f16_x), arm_streaming_compatible))
svuint64_t svcvt_u64_f16_x(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_u64_f16_z), arm_streaming_compatible))
svuint64_t svcvt_u64_f16_z(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_u64_f32_m), arm_streaming_compatible))
svuint64_t svcvt_u64_f32_m(svuint64_t, svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_u64_f32_x), arm_streaming_compatible))
svuint64_t svcvt_u64_f32_x(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_u64_f32_z), arm_streaming_compatible))
svuint64_t svcvt_u64_f32_z(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_u64_f64_m), arm_streaming_compatible))
svuint64_t svcvt_u64_f64_m(svuint64_t, svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_u64_f64_x), arm_streaming_compatible))
svuint64_t svcvt_u64_f64_x(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_u64_f64_z), arm_streaming_compatible))
svuint64_t svcvt_u64_f64_z(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdiv_n_f64_m), arm_streaming_compatible))
svfloat64_t svdiv_n_f64_m(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdiv_n_f32_m), arm_streaming_compatible))
svfloat32_t svdiv_n_f32_m(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdiv_n_f16_m), arm_streaming_compatible))
svfloat16_t svdiv_n_f16_m(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdiv_n_f64_x), arm_streaming_compatible))
svfloat64_t svdiv_n_f64_x(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdiv_n_f32_x), arm_streaming_compatible))
svfloat32_t svdiv_n_f32_x(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdiv_n_f16_x), arm_streaming_compatible))
svfloat16_t svdiv_n_f16_x(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdiv_n_f64_z), arm_streaming_compatible))
svfloat64_t svdiv_n_f64_z(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdiv_n_f32_z), arm_streaming_compatible))
svfloat32_t svdiv_n_f32_z(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdiv_n_f16_z), arm_streaming_compatible))
svfloat16_t svdiv_n_f16_z(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdiv_n_s32_m), arm_streaming_compatible))
svint32_t svdiv_n_s32_m(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdiv_n_s64_m), arm_streaming_compatible))
svint64_t svdiv_n_s64_m(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdiv_n_s32_x), arm_streaming_compatible))
svint32_t svdiv_n_s32_x(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdiv_n_s64_x), arm_streaming_compatible))
svint64_t svdiv_n_s64_x(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdiv_n_s32_z), arm_streaming_compatible))
svint32_t svdiv_n_s32_z(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdiv_n_s64_z), arm_streaming_compatible))
svint64_t svdiv_n_s64_z(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdiv_n_u32_m), arm_streaming_compatible))
svuint32_t svdiv_n_u32_m(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdiv_n_u64_m), arm_streaming_compatible))
svuint64_t svdiv_n_u64_m(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdiv_n_u32_x), arm_streaming_compatible))
svuint32_t svdiv_n_u32_x(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdiv_n_u64_x), arm_streaming_compatible))
svuint64_t svdiv_n_u64_x(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdiv_n_u32_z), arm_streaming_compatible))
svuint32_t svdiv_n_u32_z(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdiv_n_u64_z), arm_streaming_compatible))
svuint64_t svdiv_n_u64_z(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdiv_f64_m), arm_streaming_compatible))
svfloat64_t svdiv_f64_m(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdiv_f32_m), arm_streaming_compatible))
svfloat32_t svdiv_f32_m(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdiv_f16_m), arm_streaming_compatible))
svfloat16_t svdiv_f16_m(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdiv_f64_x), arm_streaming_compatible))
svfloat64_t svdiv_f64_x(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdiv_f32_x), arm_streaming_compatible))
svfloat32_t svdiv_f32_x(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdiv_f16_x), arm_streaming_compatible))
svfloat16_t svdiv_f16_x(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdiv_f64_z), arm_streaming_compatible))
svfloat64_t svdiv_f64_z(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdiv_f32_z), arm_streaming_compatible))
svfloat32_t svdiv_f32_z(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdiv_f16_z), arm_streaming_compatible))
svfloat16_t svdiv_f16_z(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdiv_s32_m), arm_streaming_compatible))
svint32_t svdiv_s32_m(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdiv_s64_m), arm_streaming_compatible))
svint64_t svdiv_s64_m(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdiv_s32_x), arm_streaming_compatible))
svint32_t svdiv_s32_x(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdiv_s64_x), arm_streaming_compatible))
svint64_t svdiv_s64_x(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdiv_s32_z), arm_streaming_compatible))
svint32_t svdiv_s32_z(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdiv_s64_z), arm_streaming_compatible))
svint64_t svdiv_s64_z(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdiv_u32_m), arm_streaming_compatible))
svuint32_t svdiv_u32_m(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdiv_u64_m), arm_streaming_compatible))
svuint64_t svdiv_u64_m(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdiv_u32_x), arm_streaming_compatible))
svuint32_t svdiv_u32_x(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdiv_u64_x), arm_streaming_compatible))
svuint64_t svdiv_u64_x(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdiv_u32_z), arm_streaming_compatible))
svuint32_t svdiv_u32_z(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdiv_u64_z), arm_streaming_compatible))
svuint64_t svdiv_u64_z(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdivr_n_f64_m), arm_streaming_compatible))
svfloat64_t svdivr_n_f64_m(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdivr_n_f32_m), arm_streaming_compatible))
svfloat32_t svdivr_n_f32_m(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdivr_n_f16_m), arm_streaming_compatible))
svfloat16_t svdivr_n_f16_m(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdivr_n_f64_x), arm_streaming_compatible))
svfloat64_t svdivr_n_f64_x(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdivr_n_f32_x), arm_streaming_compatible))
svfloat32_t svdivr_n_f32_x(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdivr_n_f16_x), arm_streaming_compatible))
svfloat16_t svdivr_n_f16_x(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdivr_n_f64_z), arm_streaming_compatible))
svfloat64_t svdivr_n_f64_z(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdivr_n_f32_z), arm_streaming_compatible))
svfloat32_t svdivr_n_f32_z(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdivr_n_f16_z), arm_streaming_compatible))
svfloat16_t svdivr_n_f16_z(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdivr_n_s32_m), arm_streaming_compatible))
svint32_t svdivr_n_s32_m(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdivr_n_s64_m), arm_streaming_compatible))
svint64_t svdivr_n_s64_m(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdivr_n_s32_x), arm_streaming_compatible))
svint32_t svdivr_n_s32_x(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdivr_n_s64_x), arm_streaming_compatible))
svint64_t svdivr_n_s64_x(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdivr_n_s32_z), arm_streaming_compatible))
svint32_t svdivr_n_s32_z(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdivr_n_s64_z), arm_streaming_compatible))
svint64_t svdivr_n_s64_z(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdivr_n_u32_m), arm_streaming_compatible))
svuint32_t svdivr_n_u32_m(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdivr_n_u64_m), arm_streaming_compatible))
svuint64_t svdivr_n_u64_m(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdivr_n_u32_x), arm_streaming_compatible))
svuint32_t svdivr_n_u32_x(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdivr_n_u64_x), arm_streaming_compatible))
svuint64_t svdivr_n_u64_x(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdivr_n_u32_z), arm_streaming_compatible))
svuint32_t svdivr_n_u32_z(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdivr_n_u64_z), arm_streaming_compatible))
svuint64_t svdivr_n_u64_z(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdivr_f64_m), arm_streaming_compatible))
svfloat64_t svdivr_f64_m(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdivr_f32_m), arm_streaming_compatible))
svfloat32_t svdivr_f32_m(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdivr_f16_m), arm_streaming_compatible))
svfloat16_t svdivr_f16_m(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdivr_f64_x), arm_streaming_compatible))
svfloat64_t svdivr_f64_x(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdivr_f32_x), arm_streaming_compatible))
svfloat32_t svdivr_f32_x(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdivr_f16_x), arm_streaming_compatible))
svfloat16_t svdivr_f16_x(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdivr_f64_z), arm_streaming_compatible))
svfloat64_t svdivr_f64_z(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdivr_f32_z), arm_streaming_compatible))
svfloat32_t svdivr_f32_z(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdivr_f16_z), arm_streaming_compatible))
svfloat16_t svdivr_f16_z(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdivr_s32_m), arm_streaming_compatible))
svint32_t svdivr_s32_m(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdivr_s64_m), arm_streaming_compatible))
svint64_t svdivr_s64_m(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdivr_s32_x), arm_streaming_compatible))
svint32_t svdivr_s32_x(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdivr_s64_x), arm_streaming_compatible))
svint64_t svdivr_s64_x(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdivr_s32_z), arm_streaming_compatible))
svint32_t svdivr_s32_z(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdivr_s64_z), arm_streaming_compatible))
svint64_t svdivr_s64_z(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdivr_u32_m), arm_streaming_compatible))
svuint32_t svdivr_u32_m(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdivr_u64_m), arm_streaming_compatible))
svuint64_t svdivr_u64_m(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdivr_u32_x), arm_streaming_compatible))
svuint32_t svdivr_u32_x(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdivr_u64_x), arm_streaming_compatible))
svuint64_t svdivr_u64_x(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdivr_u32_z), arm_streaming_compatible))
svuint32_t svdivr_u32_z(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdivr_u64_z), arm_streaming_compatible))
svuint64_t svdivr_u64_z(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdot_n_s32), arm_streaming_compatible))
svint32_t svdot_n_s32(svint32_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdot_n_s64), arm_streaming_compatible))
svint64_t svdot_n_s64(svint64_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdot_n_u32), arm_streaming_compatible))
svuint32_t svdot_n_u32(svuint32_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdot_n_u64), arm_streaming_compatible))
svuint64_t svdot_n_u64(svuint64_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdot_s32), arm_streaming_compatible))
svint32_t svdot_s32(svint32_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdot_s64), arm_streaming_compatible))
svint64_t svdot_s64(svint64_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdot_u32), arm_streaming_compatible))
svuint32_t svdot_u32(svuint32_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdot_u64), arm_streaming_compatible))
svuint64_t svdot_u64(svuint64_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdot_lane_s32)))
svint32_t svdot_lane_s32(svint32_t, svint8_t, svint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdot_lane_s64)))
svint64_t svdot_lane_s64(svint64_t, svint16_t, svint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdot_lane_u32)))
svuint32_t svdot_lane_u32(svuint32_t, svuint8_t, svuint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdot_lane_u64)))
svuint64_t svdot_lane_u64(svuint64_t, svuint16_t, svuint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_u8), arm_streaming_compatible))
svuint8_t svdup_n_u8(uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_u32), arm_streaming_compatible))
svuint32_t svdup_n_u32(uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_u64), arm_streaming_compatible))
svuint64_t svdup_n_u64(uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_u16), arm_streaming_compatible))
svuint16_t svdup_n_u16(uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_s8), arm_streaming_compatible))
svint8_t svdup_n_s8(int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_f64), arm_streaming_compatible))
svfloat64_t svdup_n_f64(float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_f32), arm_streaming_compatible))
svfloat32_t svdup_n_f32(float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_f16), arm_streaming_compatible))
svfloat16_t svdup_n_f16(float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_s32), arm_streaming_compatible))
svint32_t svdup_n_s32(int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_s64), arm_streaming_compatible))
svint64_t svdup_n_s64(int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_s16), arm_streaming_compatible))
svint16_t svdup_n_s16(int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_u8_m), arm_streaming_compatible))
svuint8_t svdup_n_u8_m(svuint8_t, svbool_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_u32_m), arm_streaming_compatible))
svuint32_t svdup_n_u32_m(svuint32_t, svbool_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_u64_m), arm_streaming_compatible))
svuint64_t svdup_n_u64_m(svuint64_t, svbool_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_u16_m), arm_streaming_compatible))
svuint16_t svdup_n_u16_m(svuint16_t, svbool_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_s8_m), arm_streaming_compatible))
svint8_t svdup_n_s8_m(svint8_t, svbool_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_f64_m), arm_streaming_compatible))
svfloat64_t svdup_n_f64_m(svfloat64_t, svbool_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_f32_m), arm_streaming_compatible))
svfloat32_t svdup_n_f32_m(svfloat32_t, svbool_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_f16_m), arm_streaming_compatible))
svfloat16_t svdup_n_f16_m(svfloat16_t, svbool_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_s32_m), arm_streaming_compatible))
svint32_t svdup_n_s32_m(svint32_t, svbool_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_s64_m), arm_streaming_compatible))
svint64_t svdup_n_s64_m(svint64_t, svbool_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_s16_m), arm_streaming_compatible))
svint16_t svdup_n_s16_m(svint16_t, svbool_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_b8)))
svbool_t svdup_n_b8(bool);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_b32)))
svbool_t svdup_n_b32(bool);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_b64)))
svbool_t svdup_n_b64(bool);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_b16)))
svbool_t svdup_n_b16(bool);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_u8_x), arm_streaming_compatible))
svuint8_t svdup_n_u8_x(svbool_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_u32_x), arm_streaming_compatible))
svuint32_t svdup_n_u32_x(svbool_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_u64_x), arm_streaming_compatible))
svuint64_t svdup_n_u64_x(svbool_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_u16_x), arm_streaming_compatible))
svuint16_t svdup_n_u16_x(svbool_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_s8_x), arm_streaming_compatible))
svint8_t svdup_n_s8_x(svbool_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_f64_x), arm_streaming_compatible))
svfloat64_t svdup_n_f64_x(svbool_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_f32_x), arm_streaming_compatible))
svfloat32_t svdup_n_f32_x(svbool_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_f16_x), arm_streaming_compatible))
svfloat16_t svdup_n_f16_x(svbool_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_s32_x), arm_streaming_compatible))
svint32_t svdup_n_s32_x(svbool_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_s64_x), arm_streaming_compatible))
svint64_t svdup_n_s64_x(svbool_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_s16_x), arm_streaming_compatible))
svint16_t svdup_n_s16_x(svbool_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_u8_z), arm_streaming_compatible))
svuint8_t svdup_n_u8_z(svbool_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_u32_z), arm_streaming_compatible))
svuint32_t svdup_n_u32_z(svbool_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_u64_z), arm_streaming_compatible))
svuint64_t svdup_n_u64_z(svbool_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_u16_z), arm_streaming_compatible))
svuint16_t svdup_n_u16_z(svbool_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_s8_z), arm_streaming_compatible))
svint8_t svdup_n_s8_z(svbool_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_f64_z), arm_streaming_compatible))
svfloat64_t svdup_n_f64_z(svbool_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_f32_z), arm_streaming_compatible))
svfloat32_t svdup_n_f32_z(svbool_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_f16_z), arm_streaming_compatible))
svfloat16_t svdup_n_f16_z(svbool_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_s32_z), arm_streaming_compatible))
svint32_t svdup_n_s32_z(svbool_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_s64_z), arm_streaming_compatible))
svint64_t svdup_n_s64_z(svbool_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_n_s16_z), arm_streaming_compatible))
svint16_t svdup_n_s16_z(svbool_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_lane_u8)))
svuint8_t svdup_lane_u8(svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_lane_u32)))
svuint32_t svdup_lane_u32(svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_lane_u64)))
svuint64_t svdup_lane_u64(svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_lane_u16)))
svuint16_t svdup_lane_u16(svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_lane_s8)))
svint8_t svdup_lane_s8(svint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_lane_f64)))
svfloat64_t svdup_lane_f64(svfloat64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_lane_f32)))
svfloat32_t svdup_lane_f32(svfloat32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_lane_f16)))
svfloat16_t svdup_lane_f16(svfloat16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_lane_s32)))
svint32_t svdup_lane_s32(svint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_lane_s64)))
svint64_t svdup_lane_s64(svint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_lane_s16)))
svint16_t svdup_lane_s16(svint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdupq_n_u8)))
svuint8_t svdupq_n_u8(uint8_t, uint8_t, uint8_t, uint8_t, uint8_t, uint8_t, uint8_t, uint8_t, uint8_t, uint8_t, uint8_t, uint8_t, uint8_t, uint8_t, uint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdupq_n_s8)))
svint8_t svdupq_n_s8(int8_t, int8_t, int8_t, int8_t, int8_t, int8_t, int8_t, int8_t, int8_t, int8_t, int8_t, int8_t, int8_t, int8_t, int8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdupq_n_u16)))
svuint16_t svdupq_n_u16(uint16_t, uint16_t, uint16_t, uint16_t, uint16_t, uint16_t, uint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdupq_n_f16)))
svfloat16_t svdupq_n_f16(float16_t, float16_t, float16_t, float16_t, float16_t, float16_t, float16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdupq_n_s16)))
svint16_t svdupq_n_s16(int16_t, int16_t, int16_t, int16_t, int16_t, int16_t, int16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdupq_n_u32)))
svuint32_t svdupq_n_u32(uint32_t, uint32_t, uint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdupq_n_f32)))
svfloat32_t svdupq_n_f32(float32_t, float32_t, float32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdupq_n_s32)))
svint32_t svdupq_n_s32(int32_t, int32_t, int32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdupq_n_u64)))
svuint64_t svdupq_n_u64(uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdupq_n_f64)))
svfloat64_t svdupq_n_f64(float64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdupq_n_s64)))
svint64_t svdupq_n_s64(int64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdupq_n_b8)))
svbool_t svdupq_n_b8(bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdupq_n_b16)))
svbool_t svdupq_n_b16(bool, bool, bool, bool, bool, bool, bool, bool);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdupq_n_b32)))
svbool_t svdupq_n_b32(bool, bool, bool, bool);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdupq_n_b64)))
svbool_t svdupq_n_b64(bool, bool);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdupq_lane_u8)))
svuint8_t svdupq_lane_u8(svuint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdupq_lane_u32)))
svuint32_t svdupq_lane_u32(svuint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdupq_lane_u64)))
svuint64_t svdupq_lane_u64(svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdupq_lane_u16)))
svuint16_t svdupq_lane_u16(svuint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdupq_lane_s8)))
svint8_t svdupq_lane_s8(svint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdupq_lane_f64)))
svfloat64_t svdupq_lane_f64(svfloat64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdupq_lane_f32)))
svfloat32_t svdupq_lane_f32(svfloat32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdupq_lane_f16)))
svfloat16_t svdupq_lane_f16(svfloat16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdupq_lane_s32)))
svint32_t svdupq_lane_s32(svint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdupq_lane_s64)))
svint64_t svdupq_lane_s64(svint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdupq_lane_s16)))
svint16_t svdupq_lane_s16(svint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_b_z), arm_streaming_compatible))
svbool_t sveor_b_z(svbool_t, svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_n_u8_m), arm_streaming_compatible))
svuint8_t sveor_n_u8_m(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_n_u32_m), arm_streaming_compatible))
svuint32_t sveor_n_u32_m(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_n_u64_m), arm_streaming_compatible))
svuint64_t sveor_n_u64_m(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_n_u16_m), arm_streaming_compatible))
svuint16_t sveor_n_u16_m(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_n_s8_m), arm_streaming_compatible))
svint8_t sveor_n_s8_m(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_n_s32_m), arm_streaming_compatible))
svint32_t sveor_n_s32_m(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_n_s64_m), arm_streaming_compatible))
svint64_t sveor_n_s64_m(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_n_s16_m), arm_streaming_compatible))
svint16_t sveor_n_s16_m(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_n_u8_x), arm_streaming_compatible))
svuint8_t sveor_n_u8_x(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_n_u32_x), arm_streaming_compatible))
svuint32_t sveor_n_u32_x(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_n_u64_x), arm_streaming_compatible))
svuint64_t sveor_n_u64_x(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_n_u16_x), arm_streaming_compatible))
svuint16_t sveor_n_u16_x(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_n_s8_x), arm_streaming_compatible))
svint8_t sveor_n_s8_x(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_n_s32_x), arm_streaming_compatible))
svint32_t sveor_n_s32_x(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_n_s64_x), arm_streaming_compatible))
svint64_t sveor_n_s64_x(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_n_s16_x), arm_streaming_compatible))
svint16_t sveor_n_s16_x(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_n_u8_z), arm_streaming_compatible))
svuint8_t sveor_n_u8_z(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_n_u32_z), arm_streaming_compatible))
svuint32_t sveor_n_u32_z(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_n_u64_z), arm_streaming_compatible))
svuint64_t sveor_n_u64_z(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_n_u16_z), arm_streaming_compatible))
svuint16_t sveor_n_u16_z(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_n_s8_z), arm_streaming_compatible))
svint8_t sveor_n_s8_z(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_n_s32_z), arm_streaming_compatible))
svint32_t sveor_n_s32_z(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_n_s64_z), arm_streaming_compatible))
svint64_t sveor_n_s64_z(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_n_s16_z), arm_streaming_compatible))
svint16_t sveor_n_s16_z(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_u8_m), arm_streaming_compatible))
svuint8_t sveor_u8_m(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_u32_m), arm_streaming_compatible))
svuint32_t sveor_u32_m(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_u64_m), arm_streaming_compatible))
svuint64_t sveor_u64_m(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_u16_m), arm_streaming_compatible))
svuint16_t sveor_u16_m(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_s8_m), arm_streaming_compatible))
svint8_t sveor_s8_m(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_s32_m), arm_streaming_compatible))
svint32_t sveor_s32_m(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_s64_m), arm_streaming_compatible))
svint64_t sveor_s64_m(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_s16_m), arm_streaming_compatible))
svint16_t sveor_s16_m(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_u8_x), arm_streaming_compatible))
svuint8_t sveor_u8_x(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_u32_x), arm_streaming_compatible))
svuint32_t sveor_u32_x(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_u64_x), arm_streaming_compatible))
svuint64_t sveor_u64_x(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_u16_x), arm_streaming_compatible))
svuint16_t sveor_u16_x(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_s8_x), arm_streaming_compatible))
svint8_t sveor_s8_x(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_s32_x), arm_streaming_compatible))
svint32_t sveor_s32_x(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_s64_x), arm_streaming_compatible))
svint64_t sveor_s64_x(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_s16_x), arm_streaming_compatible))
svint16_t sveor_s16_x(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_u8_z), arm_streaming_compatible))
svuint8_t sveor_u8_z(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_u32_z), arm_streaming_compatible))
svuint32_t sveor_u32_z(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_u64_z), arm_streaming_compatible))
svuint64_t sveor_u64_z(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_u16_z), arm_streaming_compatible))
svuint16_t sveor_u16_z(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_s8_z), arm_streaming_compatible))
svint8_t sveor_s8_z(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_s32_z), arm_streaming_compatible))
svint32_t sveor_s32_z(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_s64_z), arm_streaming_compatible))
svint64_t sveor_s64_z(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor_s16_z), arm_streaming_compatible))
svint16_t sveor_s16_z(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveorv_u8), arm_streaming_compatible))
uint8_t sveorv_u8(svbool_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveorv_u32), arm_streaming_compatible))
uint32_t sveorv_u32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveorv_u64), arm_streaming_compatible))
uint64_t sveorv_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveorv_u16), arm_streaming_compatible))
uint16_t sveorv_u16(svbool_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveorv_s8), arm_streaming_compatible))
int8_t sveorv_s8(svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveorv_s32), arm_streaming_compatible))
int32_t sveorv_s32(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveorv_s64), arm_streaming_compatible))
int64_t sveorv_s64(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveorv_s16), arm_streaming_compatible))
int16_t sveorv_s16(svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svexpa_f64)))
svfloat64_t svexpa_f64(svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svexpa_f32)))
svfloat32_t svexpa_f32(svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svexpa_f16)))
svfloat16_t svexpa_f16(svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svext_u8), arm_streaming_compatible))
svuint8_t svext_u8(svuint8_t, svuint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svext_u32), arm_streaming_compatible))
svuint32_t svext_u32(svuint32_t, svuint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svext_u64), arm_streaming_compatible))
svuint64_t svext_u64(svuint64_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svext_u16), arm_streaming_compatible))
svuint16_t svext_u16(svuint16_t, svuint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svext_s8), arm_streaming_compatible))
svint8_t svext_s8(svint8_t, svint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svext_f64), arm_streaming_compatible))
svfloat64_t svext_f64(svfloat64_t, svfloat64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svext_f32), arm_streaming_compatible))
svfloat32_t svext_f32(svfloat32_t, svfloat32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svext_f16), arm_streaming_compatible))
svfloat16_t svext_f16(svfloat16_t, svfloat16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svext_s32), arm_streaming_compatible))
svint32_t svext_s32(svint32_t, svint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svext_s64), arm_streaming_compatible))
svint64_t svext_s64(svint64_t, svint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svext_s16), arm_streaming_compatible))
svint16_t svext_s16(svint16_t, svint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextb_s32_m), arm_streaming_compatible))
svint32_t svextb_s32_m(svint32_t, svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextb_s64_m), arm_streaming_compatible))
svint64_t svextb_s64_m(svint64_t, svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextb_s16_m), arm_streaming_compatible))
svint16_t svextb_s16_m(svint16_t, svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextb_s32_x), arm_streaming_compatible))
svint32_t svextb_s32_x(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextb_s64_x), arm_streaming_compatible))
svint64_t svextb_s64_x(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextb_s16_x), arm_streaming_compatible))
svint16_t svextb_s16_x(svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextb_s32_z), arm_streaming_compatible))
svint32_t svextb_s32_z(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextb_s64_z), arm_streaming_compatible))
svint64_t svextb_s64_z(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextb_s16_z), arm_streaming_compatible))
svint16_t svextb_s16_z(svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextb_u32_m), arm_streaming_compatible))
svuint32_t svextb_u32_m(svuint32_t, svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextb_u64_m), arm_streaming_compatible))
svuint64_t svextb_u64_m(svuint64_t, svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextb_u16_m), arm_streaming_compatible))
svuint16_t svextb_u16_m(svuint16_t, svbool_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextb_u32_x), arm_streaming_compatible))
svuint32_t svextb_u32_x(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextb_u64_x), arm_streaming_compatible))
svuint64_t svextb_u64_x(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextb_u16_x), arm_streaming_compatible))
svuint16_t svextb_u16_x(svbool_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextb_u32_z), arm_streaming_compatible))
svuint32_t svextb_u32_z(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextb_u64_z), arm_streaming_compatible))
svuint64_t svextb_u64_z(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextb_u16_z), arm_streaming_compatible))
svuint16_t svextb_u16_z(svbool_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svexth_s32_m), arm_streaming_compatible))
svint32_t svexth_s32_m(svint32_t, svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svexth_s64_m), arm_streaming_compatible))
svint64_t svexth_s64_m(svint64_t, svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svexth_s32_x), arm_streaming_compatible))
svint32_t svexth_s32_x(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svexth_s64_x), arm_streaming_compatible))
svint64_t svexth_s64_x(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svexth_s32_z), arm_streaming_compatible))
svint32_t svexth_s32_z(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svexth_s64_z), arm_streaming_compatible))
svint64_t svexth_s64_z(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svexth_u32_m), arm_streaming_compatible))
svuint32_t svexth_u32_m(svuint32_t, svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svexth_u64_m), arm_streaming_compatible))
svuint64_t svexth_u64_m(svuint64_t, svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svexth_u32_x), arm_streaming_compatible))
svuint32_t svexth_u32_x(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svexth_u64_x), arm_streaming_compatible))
svuint64_t svexth_u64_x(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svexth_u32_z), arm_streaming_compatible))
svuint32_t svexth_u32_z(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svexth_u64_z), arm_streaming_compatible))
svuint64_t svexth_u64_z(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextw_s64_m), arm_streaming_compatible))
svint64_t svextw_s64_m(svint64_t, svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextw_s64_x), arm_streaming_compatible))
svint64_t svextw_s64_x(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextw_s64_z), arm_streaming_compatible))
svint64_t svextw_s64_z(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextw_u64_m), arm_streaming_compatible))
svuint64_t svextw_u64_m(svuint64_t, svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextw_u64_x), arm_streaming_compatible))
svuint64_t svextw_u64_x(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextw_u64_z), arm_streaming_compatible))
svuint64_t svextw_u64_z(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svget2_u8)))
svuint8_t svget2_u8(svuint8x2_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svget2_u32)))
svuint32_t svget2_u32(svuint32x2_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svget2_u64)))
svuint64_t svget2_u64(svuint64x2_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svget2_u16)))
svuint16_t svget2_u16(svuint16x2_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svget2_s8)))
svint8_t svget2_s8(svint8x2_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svget2_f64)))
svfloat64_t svget2_f64(svfloat64x2_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svget2_f32)))
svfloat32_t svget2_f32(svfloat32x2_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svget2_f16)))
svfloat16_t svget2_f16(svfloat16x2_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svget2_s32)))
svint32_t svget2_s32(svint32x2_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svget2_s64)))
svint64_t svget2_s64(svint64x2_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svget2_s16)))
svint16_t svget2_s16(svint16x2_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svget3_u8)))
svuint8_t svget3_u8(svuint8x3_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svget3_u32)))
svuint32_t svget3_u32(svuint32x3_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svget3_u64)))
svuint64_t svget3_u64(svuint64x3_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svget3_u16)))
svuint16_t svget3_u16(svuint16x3_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svget3_s8)))
svint8_t svget3_s8(svint8x3_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svget3_f64)))
svfloat64_t svget3_f64(svfloat64x3_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svget3_f32)))
svfloat32_t svget3_f32(svfloat32x3_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svget3_f16)))
svfloat16_t svget3_f16(svfloat16x3_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svget3_s32)))
svint32_t svget3_s32(svint32x3_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svget3_s64)))
svint64_t svget3_s64(svint64x3_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svget3_s16)))
svint16_t svget3_s16(svint16x3_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svget4_u8)))
svuint8_t svget4_u8(svuint8x4_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svget4_u32)))
svuint32_t svget4_u32(svuint32x4_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svget4_u64)))
svuint64_t svget4_u64(svuint64x4_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svget4_u16)))
svuint16_t svget4_u16(svuint16x4_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svget4_s8)))
svint8_t svget4_s8(svint8x4_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svget4_f64)))
svfloat64_t svget4_f64(svfloat64x4_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svget4_f32)))
svfloat32_t svget4_f32(svfloat32x4_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svget4_f16)))
svfloat16_t svget4_f16(svfloat16x4_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svget4_s32)))
svint32_t svget4_s32(svint32x4_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svget4_s64)))
svint64_t svget4_s64(svint64x4_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svget4_s16)))
svint16_t svget4_s16(svint16x4_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svindex_u8), arm_streaming_compatible))
svuint8_t svindex_u8(uint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svindex_u32), arm_streaming_compatible))
svuint32_t svindex_u32(uint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svindex_u64), arm_streaming_compatible))
svuint64_t svindex_u64(uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svindex_u16), arm_streaming_compatible))
svuint16_t svindex_u16(uint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svindex_s8), arm_streaming_compatible))
svint8_t svindex_s8(int8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svindex_s32), arm_streaming_compatible))
svint32_t svindex_s32(int32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svindex_s64), arm_streaming_compatible))
svint64_t svindex_s64(int64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svindex_s16), arm_streaming_compatible))
svint16_t svindex_s16(int16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svinsr_n_u8), arm_streaming_compatible))
svuint8_t svinsr_n_u8(svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svinsr_n_u32), arm_streaming_compatible))
svuint32_t svinsr_n_u32(svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svinsr_n_u64), arm_streaming_compatible))
svuint64_t svinsr_n_u64(svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svinsr_n_u16), arm_streaming_compatible))
svuint16_t svinsr_n_u16(svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svinsr_n_s8), arm_streaming_compatible))
svint8_t svinsr_n_s8(svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svinsr_n_f64), arm_streaming_compatible))
svfloat64_t svinsr_n_f64(svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svinsr_n_f32), arm_streaming_compatible))
svfloat32_t svinsr_n_f32(svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svinsr_n_f16), arm_streaming_compatible))
svfloat16_t svinsr_n_f16(svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svinsr_n_s32), arm_streaming_compatible))
svint32_t svinsr_n_s32(svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svinsr_n_s64), arm_streaming_compatible))
svint64_t svinsr_n_s64(svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svinsr_n_s16), arm_streaming_compatible))
svint16_t svinsr_n_s16(svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlasta_u8), arm_streaming_compatible))
uint8_t svlasta_u8(svbool_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlasta_u32), arm_streaming_compatible))
uint32_t svlasta_u32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlasta_u64), arm_streaming_compatible))
uint64_t svlasta_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlasta_u16), arm_streaming_compatible))
uint16_t svlasta_u16(svbool_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlasta_s8), arm_streaming_compatible))
int8_t svlasta_s8(svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlasta_f64), arm_streaming_compatible))
float64_t svlasta_f64(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlasta_f32), arm_streaming_compatible))
float32_t svlasta_f32(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlasta_f16), arm_streaming_compatible))
float16_t svlasta_f16(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlasta_s32), arm_streaming_compatible))
int32_t svlasta_s32(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlasta_s64), arm_streaming_compatible))
int64_t svlasta_s64(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlasta_s16), arm_streaming_compatible))
int16_t svlasta_s16(svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlastb_u8), arm_streaming_compatible))
uint8_t svlastb_u8(svbool_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlastb_u32), arm_streaming_compatible))
uint32_t svlastb_u32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlastb_u64), arm_streaming_compatible))
uint64_t svlastb_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlastb_u16), arm_streaming_compatible))
uint16_t svlastb_u16(svbool_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlastb_s8), arm_streaming_compatible))
int8_t svlastb_s8(svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlastb_f64), arm_streaming_compatible))
float64_t svlastb_f64(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlastb_f32), arm_streaming_compatible))
float32_t svlastb_f32(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlastb_f16), arm_streaming_compatible))
float16_t svlastb_f16(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlastb_s32), arm_streaming_compatible))
int32_t svlastb_s32(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlastb_s64), arm_streaming_compatible))
int64_t svlastb_s64(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlastb_s16), arm_streaming_compatible))
int16_t svlastb_s16(svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_u8), arm_streaming_compatible))
svuint8_t svld1_u8(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_u32), arm_streaming_compatible))
svuint32_t svld1_u32(svbool_t, uint32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_u64), arm_streaming_compatible))
svuint64_t svld1_u64(svbool_t, uint64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_u16), arm_streaming_compatible))
svuint16_t svld1_u16(svbool_t, uint16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_s8), arm_streaming_compatible))
svint8_t svld1_s8(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_f64), arm_streaming_compatible))
svfloat64_t svld1_f64(svbool_t, float64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_f32), arm_streaming_compatible))
svfloat32_t svld1_f32(svbool_t, float32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_f16), arm_streaming_compatible))
svfloat16_t svld1_f16(svbool_t, float16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_s32), arm_streaming_compatible))
svint32_t svld1_s32(svbool_t, int32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_s64), arm_streaming_compatible))
svint64_t svld1_s64(svbool_t, int64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_s16), arm_streaming_compatible))
svint16_t svld1_s16(svbool_t, int16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32base_index_u32)))
svuint32_t svld1_gather_u32base_index_u32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64base_index_u64)))
svuint64_t svld1_gather_u64base_index_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64base_index_f64)))
svfloat64_t svld1_gather_u64base_index_f64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32base_index_f32)))
svfloat32_t svld1_gather_u32base_index_f32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32base_index_s32)))
svint32_t svld1_gather_u32base_index_s32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64base_index_s64)))
svint64_t svld1_gather_u64base_index_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32base_offset_u32)))
svuint32_t svld1_gather_u32base_offset_u32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64base_offset_u64)))
svuint64_t svld1_gather_u64base_offset_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64base_offset_f64)))
svfloat64_t svld1_gather_u64base_offset_f64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32base_offset_f32)))
svfloat32_t svld1_gather_u32base_offset_f32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32base_offset_s32)))
svint32_t svld1_gather_u32base_offset_s32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64base_offset_s64)))
svint64_t svld1_gather_u64base_offset_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32base_u32)))
svuint32_t svld1_gather_u32base_u32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64base_u64)))
svuint64_t svld1_gather_u64base_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64base_f64)))
svfloat64_t svld1_gather_u64base_f64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32base_f32)))
svfloat32_t svld1_gather_u32base_f32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32base_s32)))
svint32_t svld1_gather_u32base_s32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64base_s64)))
svint64_t svld1_gather_u64base_s64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_s32index_u32)))
svuint32_t svld1_gather_s32index_u32(svbool_t, uint32_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_s32index_f32)))
svfloat32_t svld1_gather_s32index_f32(svbool_t, float32_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_s32index_s32)))
svint32_t svld1_gather_s32index_s32(svbool_t, int32_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32index_u32)))
svuint32_t svld1_gather_u32index_u32(svbool_t, uint32_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32index_f32)))
svfloat32_t svld1_gather_u32index_f32(svbool_t, float32_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32index_s32)))
svint32_t svld1_gather_u32index_s32(svbool_t, int32_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_s64index_u64)))
svuint64_t svld1_gather_s64index_u64(svbool_t, uint64_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_s64index_f64)))
svfloat64_t svld1_gather_s64index_f64(svbool_t, float64_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_s64index_s64)))
svint64_t svld1_gather_s64index_s64(svbool_t, int64_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64index_u64)))
svuint64_t svld1_gather_u64index_u64(svbool_t, uint64_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64index_f64)))
svfloat64_t svld1_gather_u64index_f64(svbool_t, float64_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64index_s64)))
svint64_t svld1_gather_u64index_s64(svbool_t, int64_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_s32offset_u32)))
svuint32_t svld1_gather_s32offset_u32(svbool_t, uint32_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_s32offset_f32)))
svfloat32_t svld1_gather_s32offset_f32(svbool_t, float32_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_s32offset_s32)))
svint32_t svld1_gather_s32offset_s32(svbool_t, int32_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32offset_u32)))
svuint32_t svld1_gather_u32offset_u32(svbool_t, uint32_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32offset_f32)))
svfloat32_t svld1_gather_u32offset_f32(svbool_t, float32_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32offset_s32)))
svint32_t svld1_gather_u32offset_s32(svbool_t, int32_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_s64offset_u64)))
svuint64_t svld1_gather_s64offset_u64(svbool_t, uint64_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_s64offset_f64)))
svfloat64_t svld1_gather_s64offset_f64(svbool_t, float64_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_s64offset_s64)))
svint64_t svld1_gather_s64offset_s64(svbool_t, int64_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64offset_u64)))
svuint64_t svld1_gather_u64offset_u64(svbool_t, uint64_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64offset_f64)))
svfloat64_t svld1_gather_u64offset_f64(svbool_t, float64_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64offset_s64)))
svint64_t svld1_gather_u64offset_s64(svbool_t, int64_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_u8), arm_streaming_compatible))
svuint8_t svld1_vnum_u8(svbool_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_u32), arm_streaming_compatible))
svuint32_t svld1_vnum_u32(svbool_t, uint32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_u64), arm_streaming_compatible))
svuint64_t svld1_vnum_u64(svbool_t, uint64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_u16), arm_streaming_compatible))
svuint16_t svld1_vnum_u16(svbool_t, uint16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_s8), arm_streaming_compatible))
svint8_t svld1_vnum_s8(svbool_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_f64), arm_streaming_compatible))
svfloat64_t svld1_vnum_f64(svbool_t, float64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_f32), arm_streaming_compatible))
svfloat32_t svld1_vnum_f32(svbool_t, float32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_f16), arm_streaming_compatible))
svfloat16_t svld1_vnum_f16(svbool_t, float16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_s32), arm_streaming_compatible))
svint32_t svld1_vnum_s32(svbool_t, int32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_s64), arm_streaming_compatible))
svint64_t svld1_vnum_s64(svbool_t, int64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_s16), arm_streaming_compatible))
svint16_t svld1_vnum_s16(svbool_t, int16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1rq_u8), arm_streaming_compatible))
svuint8_t svld1rq_u8(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1rq_u32), arm_streaming_compatible))
svuint32_t svld1rq_u32(svbool_t, uint32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1rq_u64), arm_streaming_compatible))
svuint64_t svld1rq_u64(svbool_t, uint64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1rq_u16), arm_streaming_compatible))
svuint16_t svld1rq_u16(svbool_t, uint16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1rq_s8), arm_streaming_compatible))
svint8_t svld1rq_s8(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1rq_f64), arm_streaming_compatible))
svfloat64_t svld1rq_f64(svbool_t, float64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1rq_f32), arm_streaming_compatible))
svfloat32_t svld1rq_f32(svbool_t, float32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1rq_f16), arm_streaming_compatible))
svfloat16_t svld1rq_f16(svbool_t, float16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1rq_s32), arm_streaming_compatible))
svint32_t svld1rq_s32(svbool_t, int32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1rq_s64), arm_streaming_compatible))
svint64_t svld1rq_s64(svbool_t, int64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1rq_s16), arm_streaming_compatible))
svint16_t svld1rq_s16(svbool_t, int16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_u32base_offset_u32)))
svuint32_t svld1sb_gather_u32base_offset_u32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_u64base_offset_u64)))
svuint64_t svld1sb_gather_u64base_offset_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_u32base_offset_s32)))
svint32_t svld1sb_gather_u32base_offset_s32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_u64base_offset_s64)))
svint64_t svld1sb_gather_u64base_offset_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_u32base_u32)))
svuint32_t svld1sb_gather_u32base_u32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_u64base_u64)))
svuint64_t svld1sb_gather_u64base_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_u32base_s32)))
svint32_t svld1sb_gather_u32base_s32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_u64base_s64)))
svint64_t svld1sb_gather_u64base_s64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_s32offset_u32)))
svuint32_t svld1sb_gather_s32offset_u32(svbool_t, int8_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_s32offset_s32)))
svint32_t svld1sb_gather_s32offset_s32(svbool_t, int8_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_u32offset_u32)))
svuint32_t svld1sb_gather_u32offset_u32(svbool_t, int8_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_u32offset_s32)))
svint32_t svld1sb_gather_u32offset_s32(svbool_t, int8_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_s64offset_u64)))
svuint64_t svld1sb_gather_s64offset_u64(svbool_t, int8_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_s64offset_s64)))
svint64_t svld1sb_gather_s64offset_s64(svbool_t, int8_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_u64offset_u64)))
svuint64_t svld1sb_gather_u64offset_u64(svbool_t, int8_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_u64offset_s64)))
svint64_t svld1sb_gather_u64offset_s64(svbool_t, int8_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_vnum_u32), arm_streaming_compatible))
svuint32_t svld1sb_vnum_u32(svbool_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_vnum_u64), arm_streaming_compatible))
svuint64_t svld1sb_vnum_u64(svbool_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_vnum_u16), arm_streaming_compatible))
svuint16_t svld1sb_vnum_u16(svbool_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_vnum_s32), arm_streaming_compatible))
svint32_t svld1sb_vnum_s32(svbool_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_vnum_s64), arm_streaming_compatible))
svint64_t svld1sb_vnum_s64(svbool_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_vnum_s16), arm_streaming_compatible))
svint16_t svld1sb_vnum_s16(svbool_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_u32), arm_streaming_compatible))
svuint32_t svld1sb_u32(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_u64), arm_streaming_compatible))
svuint64_t svld1sb_u64(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_u16), arm_streaming_compatible))
svuint16_t svld1sb_u16(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_s32), arm_streaming_compatible))
svint32_t svld1sb_s32(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_s64), arm_streaming_compatible))
svint64_t svld1sb_s64(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_s16), arm_streaming_compatible))
svint16_t svld1sb_s16(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u32base_index_u32)))
svuint32_t svld1sh_gather_u32base_index_u32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u64base_index_u64)))
svuint64_t svld1sh_gather_u64base_index_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u32base_index_s32)))
svint32_t svld1sh_gather_u32base_index_s32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u64base_index_s64)))
svint64_t svld1sh_gather_u64base_index_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u32base_offset_u32)))
svuint32_t svld1sh_gather_u32base_offset_u32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u64base_offset_u64)))
svuint64_t svld1sh_gather_u64base_offset_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u32base_offset_s32)))
svint32_t svld1sh_gather_u32base_offset_s32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u64base_offset_s64)))
svint64_t svld1sh_gather_u64base_offset_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u32base_u32)))
svuint32_t svld1sh_gather_u32base_u32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u64base_u64)))
svuint64_t svld1sh_gather_u64base_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u32base_s32)))
svint32_t svld1sh_gather_u32base_s32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u64base_s64)))
svint64_t svld1sh_gather_u64base_s64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_s32index_u32)))
svuint32_t svld1sh_gather_s32index_u32(svbool_t, int16_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_s32index_s32)))
svint32_t svld1sh_gather_s32index_s32(svbool_t, int16_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u32index_u32)))
svuint32_t svld1sh_gather_u32index_u32(svbool_t, int16_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u32index_s32)))
svint32_t svld1sh_gather_u32index_s32(svbool_t, int16_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_s64index_u64)))
svuint64_t svld1sh_gather_s64index_u64(svbool_t, int16_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_s64index_s64)))
svint64_t svld1sh_gather_s64index_s64(svbool_t, int16_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u64index_u64)))
svuint64_t svld1sh_gather_u64index_u64(svbool_t, int16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u64index_s64)))
svint64_t svld1sh_gather_u64index_s64(svbool_t, int16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_s32offset_u32)))
svuint32_t svld1sh_gather_s32offset_u32(svbool_t, int16_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_s32offset_s32)))
svint32_t svld1sh_gather_s32offset_s32(svbool_t, int16_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u32offset_u32)))
svuint32_t svld1sh_gather_u32offset_u32(svbool_t, int16_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u32offset_s32)))
svint32_t svld1sh_gather_u32offset_s32(svbool_t, int16_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_s64offset_u64)))
svuint64_t svld1sh_gather_s64offset_u64(svbool_t, int16_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_s64offset_s64)))
svint64_t svld1sh_gather_s64offset_s64(svbool_t, int16_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u64offset_u64)))
svuint64_t svld1sh_gather_u64offset_u64(svbool_t, int16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u64offset_s64)))
svint64_t svld1sh_gather_u64offset_s64(svbool_t, int16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_vnum_u32), arm_streaming_compatible))
svuint32_t svld1sh_vnum_u32(svbool_t, int16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_vnum_u64), arm_streaming_compatible))
svuint64_t svld1sh_vnum_u64(svbool_t, int16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_vnum_s32), arm_streaming_compatible))
svint32_t svld1sh_vnum_s32(svbool_t, int16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_vnum_s64), arm_streaming_compatible))
svint64_t svld1sh_vnum_s64(svbool_t, int16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_u32), arm_streaming_compatible))
svuint32_t svld1sh_u32(svbool_t, int16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_u64), arm_streaming_compatible))
svuint64_t svld1sh_u64(svbool_t, int16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_s32), arm_streaming_compatible))
svint32_t svld1sh_s32(svbool_t, int16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_s64), arm_streaming_compatible))
svint64_t svld1sh_s64(svbool_t, int16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_gather_u64base_index_u64)))
svuint64_t svld1sw_gather_u64base_index_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_gather_u64base_index_s64)))
svint64_t svld1sw_gather_u64base_index_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_gather_u64base_offset_u64)))
svuint64_t svld1sw_gather_u64base_offset_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_gather_u64base_offset_s64)))
svint64_t svld1sw_gather_u64base_offset_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_gather_u64base_u64)))
svuint64_t svld1sw_gather_u64base_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_gather_u64base_s64)))
svint64_t svld1sw_gather_u64base_s64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_gather_s64index_u64)))
svuint64_t svld1sw_gather_s64index_u64(svbool_t, int32_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_gather_s64index_s64)))
svint64_t svld1sw_gather_s64index_s64(svbool_t, int32_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_gather_u64index_u64)))
svuint64_t svld1sw_gather_u64index_u64(svbool_t, int32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_gather_u64index_s64)))
svint64_t svld1sw_gather_u64index_s64(svbool_t, int32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_gather_s64offset_u64)))
svuint64_t svld1sw_gather_s64offset_u64(svbool_t, int32_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_gather_s64offset_s64)))
svint64_t svld1sw_gather_s64offset_s64(svbool_t, int32_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_gather_u64offset_u64)))
svuint64_t svld1sw_gather_u64offset_u64(svbool_t, int32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_gather_u64offset_s64)))
svint64_t svld1sw_gather_u64offset_s64(svbool_t, int32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_vnum_u64), arm_streaming_compatible))
svuint64_t svld1sw_vnum_u64(svbool_t, int32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_vnum_s64), arm_streaming_compatible))
svint64_t svld1sw_vnum_s64(svbool_t, int32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_u64), arm_streaming_compatible))
svuint64_t svld1sw_u64(svbool_t, int32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_s64), arm_streaming_compatible))
svint64_t svld1sw_s64(svbool_t, int32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_u32base_offset_u32)))
svuint32_t svld1ub_gather_u32base_offset_u32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_u64base_offset_u64)))
svuint64_t svld1ub_gather_u64base_offset_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_u32base_offset_s32)))
svint32_t svld1ub_gather_u32base_offset_s32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_u64base_offset_s64)))
svint64_t svld1ub_gather_u64base_offset_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_u32base_u32)))
svuint32_t svld1ub_gather_u32base_u32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_u64base_u64)))
svuint64_t svld1ub_gather_u64base_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_u32base_s32)))
svint32_t svld1ub_gather_u32base_s32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_u64base_s64)))
svint64_t svld1ub_gather_u64base_s64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_s32offset_u32)))
svuint32_t svld1ub_gather_s32offset_u32(svbool_t, uint8_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_s32offset_s32)))
svint32_t svld1ub_gather_s32offset_s32(svbool_t, uint8_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_u32offset_u32)))
svuint32_t svld1ub_gather_u32offset_u32(svbool_t, uint8_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_u32offset_s32)))
svint32_t svld1ub_gather_u32offset_s32(svbool_t, uint8_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_s64offset_u64)))
svuint64_t svld1ub_gather_s64offset_u64(svbool_t, uint8_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_s64offset_s64)))
svint64_t svld1ub_gather_s64offset_s64(svbool_t, uint8_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_u64offset_u64)))
svuint64_t svld1ub_gather_u64offset_u64(svbool_t, uint8_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_u64offset_s64)))
svint64_t svld1ub_gather_u64offset_s64(svbool_t, uint8_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_vnum_u32), arm_streaming_compatible))
svuint32_t svld1ub_vnum_u32(svbool_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_vnum_u64), arm_streaming_compatible))
svuint64_t svld1ub_vnum_u64(svbool_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_vnum_u16), arm_streaming_compatible))
svuint16_t svld1ub_vnum_u16(svbool_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_vnum_s32), arm_streaming_compatible))
svint32_t svld1ub_vnum_s32(svbool_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_vnum_s64), arm_streaming_compatible))
svint64_t svld1ub_vnum_s64(svbool_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_vnum_s16), arm_streaming_compatible))
svint16_t svld1ub_vnum_s16(svbool_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_u32), arm_streaming_compatible))
svuint32_t svld1ub_u32(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_u64), arm_streaming_compatible))
svuint64_t svld1ub_u64(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_u16), arm_streaming_compatible))
svuint16_t svld1ub_u16(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_s32), arm_streaming_compatible))
svint32_t svld1ub_s32(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_s64), arm_streaming_compatible))
svint64_t svld1ub_s64(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_s16), arm_streaming_compatible))
svint16_t svld1ub_s16(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u32base_index_u32)))
svuint32_t svld1uh_gather_u32base_index_u32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u64base_index_u64)))
svuint64_t svld1uh_gather_u64base_index_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u32base_index_s32)))
svint32_t svld1uh_gather_u32base_index_s32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u64base_index_s64)))
svint64_t svld1uh_gather_u64base_index_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u32base_offset_u32)))
svuint32_t svld1uh_gather_u32base_offset_u32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u64base_offset_u64)))
svuint64_t svld1uh_gather_u64base_offset_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u32base_offset_s32)))
svint32_t svld1uh_gather_u32base_offset_s32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u64base_offset_s64)))
svint64_t svld1uh_gather_u64base_offset_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u32base_u32)))
svuint32_t svld1uh_gather_u32base_u32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u64base_u64)))
svuint64_t svld1uh_gather_u64base_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u32base_s32)))
svint32_t svld1uh_gather_u32base_s32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u64base_s64)))
svint64_t svld1uh_gather_u64base_s64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_s32index_u32)))
svuint32_t svld1uh_gather_s32index_u32(svbool_t, uint16_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_s32index_s32)))
svint32_t svld1uh_gather_s32index_s32(svbool_t, uint16_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u32index_u32)))
svuint32_t svld1uh_gather_u32index_u32(svbool_t, uint16_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u32index_s32)))
svint32_t svld1uh_gather_u32index_s32(svbool_t, uint16_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_s64index_u64)))
svuint64_t svld1uh_gather_s64index_u64(svbool_t, uint16_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_s64index_s64)))
svint64_t svld1uh_gather_s64index_s64(svbool_t, uint16_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u64index_u64)))
svuint64_t svld1uh_gather_u64index_u64(svbool_t, uint16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u64index_s64)))
svint64_t svld1uh_gather_u64index_s64(svbool_t, uint16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_s32offset_u32)))
svuint32_t svld1uh_gather_s32offset_u32(svbool_t, uint16_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_s32offset_s32)))
svint32_t svld1uh_gather_s32offset_s32(svbool_t, uint16_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u32offset_u32)))
svuint32_t svld1uh_gather_u32offset_u32(svbool_t, uint16_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u32offset_s32)))
svint32_t svld1uh_gather_u32offset_s32(svbool_t, uint16_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_s64offset_u64)))
svuint64_t svld1uh_gather_s64offset_u64(svbool_t, uint16_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_s64offset_s64)))
svint64_t svld1uh_gather_s64offset_s64(svbool_t, uint16_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u64offset_u64)))
svuint64_t svld1uh_gather_u64offset_u64(svbool_t, uint16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u64offset_s64)))
svint64_t svld1uh_gather_u64offset_s64(svbool_t, uint16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_vnum_u32), arm_streaming_compatible))
svuint32_t svld1uh_vnum_u32(svbool_t, uint16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_vnum_u64), arm_streaming_compatible))
svuint64_t svld1uh_vnum_u64(svbool_t, uint16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_vnum_s32), arm_streaming_compatible))
svint32_t svld1uh_vnum_s32(svbool_t, uint16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_vnum_s64), arm_streaming_compatible))
svint64_t svld1uh_vnum_s64(svbool_t, uint16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_u32), arm_streaming_compatible))
svuint32_t svld1uh_u32(svbool_t, uint16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_u64), arm_streaming_compatible))
svuint64_t svld1uh_u64(svbool_t, uint16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_s32), arm_streaming_compatible))
svint32_t svld1uh_s32(svbool_t, uint16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_s64), arm_streaming_compatible))
svint64_t svld1uh_s64(svbool_t, uint16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_gather_u64base_index_u64)))
svuint64_t svld1uw_gather_u64base_index_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_gather_u64base_index_s64)))
svint64_t svld1uw_gather_u64base_index_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_gather_u64base_offset_u64)))
svuint64_t svld1uw_gather_u64base_offset_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_gather_u64base_offset_s64)))
svint64_t svld1uw_gather_u64base_offset_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_gather_u64base_u64)))
svuint64_t svld1uw_gather_u64base_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_gather_u64base_s64)))
svint64_t svld1uw_gather_u64base_s64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_gather_s64index_u64)))
svuint64_t svld1uw_gather_s64index_u64(svbool_t, uint32_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_gather_s64index_s64)))
svint64_t svld1uw_gather_s64index_s64(svbool_t, uint32_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_gather_u64index_u64)))
svuint64_t svld1uw_gather_u64index_u64(svbool_t, uint32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_gather_u64index_s64)))
svint64_t svld1uw_gather_u64index_s64(svbool_t, uint32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_gather_s64offset_u64)))
svuint64_t svld1uw_gather_s64offset_u64(svbool_t, uint32_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_gather_s64offset_s64)))
svint64_t svld1uw_gather_s64offset_s64(svbool_t, uint32_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_gather_u64offset_u64)))
svuint64_t svld1uw_gather_u64offset_u64(svbool_t, uint32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_gather_u64offset_s64)))
svint64_t svld1uw_gather_u64offset_s64(svbool_t, uint32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_vnum_u64), arm_streaming_compatible))
svuint64_t svld1uw_vnum_u64(svbool_t, uint32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_vnum_s64), arm_streaming_compatible))
svint64_t svld1uw_vnum_s64(svbool_t, uint32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_u64), arm_streaming_compatible))
svuint64_t svld1uw_u64(svbool_t, uint32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_s64), arm_streaming_compatible))
svint64_t svld1uw_s64(svbool_t, uint32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2_u8), arm_streaming_compatible))
svuint8x2_t svld2_u8(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2_u32), arm_streaming_compatible))
svuint32x2_t svld2_u32(svbool_t, uint32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2_u64), arm_streaming_compatible))
svuint64x2_t svld2_u64(svbool_t, uint64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2_u16), arm_streaming_compatible))
svuint16x2_t svld2_u16(svbool_t, uint16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2_s8), arm_streaming_compatible))
svint8x2_t svld2_s8(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2_f64), arm_streaming_compatible))
svfloat64x2_t svld2_f64(svbool_t, float64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2_f32), arm_streaming_compatible))
svfloat32x2_t svld2_f32(svbool_t, float32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2_f16), arm_streaming_compatible))
svfloat16x2_t svld2_f16(svbool_t, float16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2_s32), arm_streaming_compatible))
svint32x2_t svld2_s32(svbool_t, int32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2_s64), arm_streaming_compatible))
svint64x2_t svld2_s64(svbool_t, int64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2_s16), arm_streaming_compatible))
svint16x2_t svld2_s16(svbool_t, int16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2_vnum_u8), arm_streaming_compatible))
svuint8x2_t svld2_vnum_u8(svbool_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2_vnum_u32), arm_streaming_compatible))
svuint32x2_t svld2_vnum_u32(svbool_t, uint32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2_vnum_u64), arm_streaming_compatible))
svuint64x2_t svld2_vnum_u64(svbool_t, uint64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2_vnum_u16), arm_streaming_compatible))
svuint16x2_t svld2_vnum_u16(svbool_t, uint16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2_vnum_s8), arm_streaming_compatible))
svint8x2_t svld2_vnum_s8(svbool_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2_vnum_f64), arm_streaming_compatible))
svfloat64x2_t svld2_vnum_f64(svbool_t, float64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2_vnum_f32), arm_streaming_compatible))
svfloat32x2_t svld2_vnum_f32(svbool_t, float32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2_vnum_f16), arm_streaming_compatible))
svfloat16x2_t svld2_vnum_f16(svbool_t, float16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2_vnum_s32), arm_streaming_compatible))
svint32x2_t svld2_vnum_s32(svbool_t, int32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2_vnum_s64), arm_streaming_compatible))
svint64x2_t svld2_vnum_s64(svbool_t, int64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2_vnum_s16), arm_streaming_compatible))
svint16x2_t svld2_vnum_s16(svbool_t, int16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3_u8), arm_streaming_compatible))
svuint8x3_t svld3_u8(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3_u32), arm_streaming_compatible))
svuint32x3_t svld3_u32(svbool_t, uint32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3_u64), arm_streaming_compatible))
svuint64x3_t svld3_u64(svbool_t, uint64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3_u16), arm_streaming_compatible))
svuint16x3_t svld3_u16(svbool_t, uint16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3_s8), arm_streaming_compatible))
svint8x3_t svld3_s8(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3_f64), arm_streaming_compatible))
svfloat64x3_t svld3_f64(svbool_t, float64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3_f32), arm_streaming_compatible))
svfloat32x3_t svld3_f32(svbool_t, float32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3_f16), arm_streaming_compatible))
svfloat16x3_t svld3_f16(svbool_t, float16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3_s32), arm_streaming_compatible))
svint32x3_t svld3_s32(svbool_t, int32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3_s64), arm_streaming_compatible))
svint64x3_t svld3_s64(svbool_t, int64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3_s16), arm_streaming_compatible))
svint16x3_t svld3_s16(svbool_t, int16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3_vnum_u8), arm_streaming_compatible))
svuint8x3_t svld3_vnum_u8(svbool_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3_vnum_u32), arm_streaming_compatible))
svuint32x3_t svld3_vnum_u32(svbool_t, uint32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3_vnum_u64), arm_streaming_compatible))
svuint64x3_t svld3_vnum_u64(svbool_t, uint64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3_vnum_u16), arm_streaming_compatible))
svuint16x3_t svld3_vnum_u16(svbool_t, uint16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3_vnum_s8), arm_streaming_compatible))
svint8x3_t svld3_vnum_s8(svbool_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3_vnum_f64), arm_streaming_compatible))
svfloat64x3_t svld3_vnum_f64(svbool_t, float64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3_vnum_f32), arm_streaming_compatible))
svfloat32x3_t svld3_vnum_f32(svbool_t, float32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3_vnum_f16), arm_streaming_compatible))
svfloat16x3_t svld3_vnum_f16(svbool_t, float16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3_vnum_s32), arm_streaming_compatible))
svint32x3_t svld3_vnum_s32(svbool_t, int32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3_vnum_s64), arm_streaming_compatible))
svint64x3_t svld3_vnum_s64(svbool_t, int64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3_vnum_s16), arm_streaming_compatible))
svint16x3_t svld3_vnum_s16(svbool_t, int16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4_u8), arm_streaming_compatible))
svuint8x4_t svld4_u8(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4_u32), arm_streaming_compatible))
svuint32x4_t svld4_u32(svbool_t, uint32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4_u64), arm_streaming_compatible))
svuint64x4_t svld4_u64(svbool_t, uint64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4_u16), arm_streaming_compatible))
svuint16x4_t svld4_u16(svbool_t, uint16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4_s8), arm_streaming_compatible))
svint8x4_t svld4_s8(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4_f64), arm_streaming_compatible))
svfloat64x4_t svld4_f64(svbool_t, float64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4_f32), arm_streaming_compatible))
svfloat32x4_t svld4_f32(svbool_t, float32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4_f16), arm_streaming_compatible))
svfloat16x4_t svld4_f16(svbool_t, float16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4_s32), arm_streaming_compatible))
svint32x4_t svld4_s32(svbool_t, int32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4_s64), arm_streaming_compatible))
svint64x4_t svld4_s64(svbool_t, int64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4_s16), arm_streaming_compatible))
svint16x4_t svld4_s16(svbool_t, int16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4_vnum_u8), arm_streaming_compatible))
svuint8x4_t svld4_vnum_u8(svbool_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4_vnum_u32), arm_streaming_compatible))
svuint32x4_t svld4_vnum_u32(svbool_t, uint32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4_vnum_u64), arm_streaming_compatible))
svuint64x4_t svld4_vnum_u64(svbool_t, uint64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4_vnum_u16), arm_streaming_compatible))
svuint16x4_t svld4_vnum_u16(svbool_t, uint16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4_vnum_s8), arm_streaming_compatible))
svint8x4_t svld4_vnum_s8(svbool_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4_vnum_f64), arm_streaming_compatible))
svfloat64x4_t svld4_vnum_f64(svbool_t, float64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4_vnum_f32), arm_streaming_compatible))
svfloat32x4_t svld4_vnum_f32(svbool_t, float32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4_vnum_f16), arm_streaming_compatible))
svfloat16x4_t svld4_vnum_f16(svbool_t, float16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4_vnum_s32), arm_streaming_compatible))
svint32x4_t svld4_vnum_s32(svbool_t, int32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4_vnum_s64), arm_streaming_compatible))
svint64x4_t svld4_vnum_s64(svbool_t, int64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4_vnum_s16), arm_streaming_compatible))
svint16x4_t svld4_vnum_s16(svbool_t, int16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_u8)))
svuint8_t svldff1_u8(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_u32)))
svuint32_t svldff1_u32(svbool_t, uint32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_u64)))
svuint64_t svldff1_u64(svbool_t, uint64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_u16)))
svuint16_t svldff1_u16(svbool_t, uint16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_s8)))
svint8_t svldff1_s8(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_f64)))
svfloat64_t svldff1_f64(svbool_t, float64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_f32)))
svfloat32_t svldff1_f32(svbool_t, float32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_f16)))
svfloat16_t svldff1_f16(svbool_t, float16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_s32)))
svint32_t svldff1_s32(svbool_t, int32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_s64)))
svint64_t svldff1_s64(svbool_t, int64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_s16)))
svint16_t svldff1_s16(svbool_t, int16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32base_index_u32)))
svuint32_t svldff1_gather_u32base_index_u32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64base_index_u64)))
svuint64_t svldff1_gather_u64base_index_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64base_index_f64)))
svfloat64_t svldff1_gather_u64base_index_f64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32base_index_f32)))
svfloat32_t svldff1_gather_u32base_index_f32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32base_index_s32)))
svint32_t svldff1_gather_u32base_index_s32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64base_index_s64)))
svint64_t svldff1_gather_u64base_index_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32base_offset_u32)))
svuint32_t svldff1_gather_u32base_offset_u32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64base_offset_u64)))
svuint64_t svldff1_gather_u64base_offset_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64base_offset_f64)))
svfloat64_t svldff1_gather_u64base_offset_f64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32base_offset_f32)))
svfloat32_t svldff1_gather_u32base_offset_f32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32base_offset_s32)))
svint32_t svldff1_gather_u32base_offset_s32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64base_offset_s64)))
svint64_t svldff1_gather_u64base_offset_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32base_u32)))
svuint32_t svldff1_gather_u32base_u32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64base_u64)))
svuint64_t svldff1_gather_u64base_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64base_f64)))
svfloat64_t svldff1_gather_u64base_f64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32base_f32)))
svfloat32_t svldff1_gather_u32base_f32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32base_s32)))
svint32_t svldff1_gather_u32base_s32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64base_s64)))
svint64_t svldff1_gather_u64base_s64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_s32index_u32)))
svuint32_t svldff1_gather_s32index_u32(svbool_t, uint32_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_s32index_f32)))
svfloat32_t svldff1_gather_s32index_f32(svbool_t, float32_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_s32index_s32)))
svint32_t svldff1_gather_s32index_s32(svbool_t, int32_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32index_u32)))
svuint32_t svldff1_gather_u32index_u32(svbool_t, uint32_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32index_f32)))
svfloat32_t svldff1_gather_u32index_f32(svbool_t, float32_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32index_s32)))
svint32_t svldff1_gather_u32index_s32(svbool_t, int32_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_s64index_u64)))
svuint64_t svldff1_gather_s64index_u64(svbool_t, uint64_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_s64index_f64)))
svfloat64_t svldff1_gather_s64index_f64(svbool_t, float64_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_s64index_s64)))
svint64_t svldff1_gather_s64index_s64(svbool_t, int64_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64index_u64)))
svuint64_t svldff1_gather_u64index_u64(svbool_t, uint64_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64index_f64)))
svfloat64_t svldff1_gather_u64index_f64(svbool_t, float64_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64index_s64)))
svint64_t svldff1_gather_u64index_s64(svbool_t, int64_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_s32offset_u32)))
svuint32_t svldff1_gather_s32offset_u32(svbool_t, uint32_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_s32offset_f32)))
svfloat32_t svldff1_gather_s32offset_f32(svbool_t, float32_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_s32offset_s32)))
svint32_t svldff1_gather_s32offset_s32(svbool_t, int32_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32offset_u32)))
svuint32_t svldff1_gather_u32offset_u32(svbool_t, uint32_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32offset_f32)))
svfloat32_t svldff1_gather_u32offset_f32(svbool_t, float32_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32offset_s32)))
svint32_t svldff1_gather_u32offset_s32(svbool_t, int32_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_s64offset_u64)))
svuint64_t svldff1_gather_s64offset_u64(svbool_t, uint64_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_s64offset_f64)))
svfloat64_t svldff1_gather_s64offset_f64(svbool_t, float64_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_s64offset_s64)))
svint64_t svldff1_gather_s64offset_s64(svbool_t, int64_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64offset_u64)))
svuint64_t svldff1_gather_u64offset_u64(svbool_t, uint64_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64offset_f64)))
svfloat64_t svldff1_gather_u64offset_f64(svbool_t, float64_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64offset_s64)))
svint64_t svldff1_gather_u64offset_s64(svbool_t, int64_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_vnum_u8)))
svuint8_t svldff1_vnum_u8(svbool_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_vnum_u32)))
svuint32_t svldff1_vnum_u32(svbool_t, uint32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_vnum_u64)))
svuint64_t svldff1_vnum_u64(svbool_t, uint64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_vnum_u16)))
svuint16_t svldff1_vnum_u16(svbool_t, uint16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_vnum_s8)))
svint8_t svldff1_vnum_s8(svbool_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_vnum_f64)))
svfloat64_t svldff1_vnum_f64(svbool_t, float64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_vnum_f32)))
svfloat32_t svldff1_vnum_f32(svbool_t, float32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_vnum_f16)))
svfloat16_t svldff1_vnum_f16(svbool_t, float16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_vnum_s32)))
svint32_t svldff1_vnum_s32(svbool_t, int32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_vnum_s64)))
svint64_t svldff1_vnum_s64(svbool_t, int64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_vnum_s16)))
svint16_t svldff1_vnum_s16(svbool_t, int16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_u32base_offset_u32)))
svuint32_t svldff1sb_gather_u32base_offset_u32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_u64base_offset_u64)))
svuint64_t svldff1sb_gather_u64base_offset_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_u32base_offset_s32)))
svint32_t svldff1sb_gather_u32base_offset_s32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_u64base_offset_s64)))
svint64_t svldff1sb_gather_u64base_offset_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_u32base_u32)))
svuint32_t svldff1sb_gather_u32base_u32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_u64base_u64)))
svuint64_t svldff1sb_gather_u64base_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_u32base_s32)))
svint32_t svldff1sb_gather_u32base_s32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_u64base_s64)))
svint64_t svldff1sb_gather_u64base_s64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_s32offset_u32)))
svuint32_t svldff1sb_gather_s32offset_u32(svbool_t, int8_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_s32offset_s32)))
svint32_t svldff1sb_gather_s32offset_s32(svbool_t, int8_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_u32offset_u32)))
svuint32_t svldff1sb_gather_u32offset_u32(svbool_t, int8_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_u32offset_s32)))
svint32_t svldff1sb_gather_u32offset_s32(svbool_t, int8_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_s64offset_u64)))
svuint64_t svldff1sb_gather_s64offset_u64(svbool_t, int8_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_s64offset_s64)))
svint64_t svldff1sb_gather_s64offset_s64(svbool_t, int8_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_u64offset_u64)))
svuint64_t svldff1sb_gather_u64offset_u64(svbool_t, int8_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_u64offset_s64)))
svint64_t svldff1sb_gather_u64offset_s64(svbool_t, int8_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_vnum_u32)))
svuint32_t svldff1sb_vnum_u32(svbool_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_vnum_u64)))
svuint64_t svldff1sb_vnum_u64(svbool_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_vnum_u16)))
svuint16_t svldff1sb_vnum_u16(svbool_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_vnum_s32)))
svint32_t svldff1sb_vnum_s32(svbool_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_vnum_s64)))
svint64_t svldff1sb_vnum_s64(svbool_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_vnum_s16)))
svint16_t svldff1sb_vnum_s16(svbool_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_u32)))
svuint32_t svldff1sb_u32(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_u64)))
svuint64_t svldff1sb_u64(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_u16)))
svuint16_t svldff1sb_u16(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_s32)))
svint32_t svldff1sb_s32(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_s64)))
svint64_t svldff1sb_s64(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_s16)))
svint16_t svldff1sb_s16(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u32base_index_u32)))
svuint32_t svldff1sh_gather_u32base_index_u32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u64base_index_u64)))
svuint64_t svldff1sh_gather_u64base_index_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u32base_index_s32)))
svint32_t svldff1sh_gather_u32base_index_s32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u64base_index_s64)))
svint64_t svldff1sh_gather_u64base_index_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u32base_offset_u32)))
svuint32_t svldff1sh_gather_u32base_offset_u32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u64base_offset_u64)))
svuint64_t svldff1sh_gather_u64base_offset_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u32base_offset_s32)))
svint32_t svldff1sh_gather_u32base_offset_s32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u64base_offset_s64)))
svint64_t svldff1sh_gather_u64base_offset_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u32base_u32)))
svuint32_t svldff1sh_gather_u32base_u32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u64base_u64)))
svuint64_t svldff1sh_gather_u64base_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u32base_s32)))
svint32_t svldff1sh_gather_u32base_s32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u64base_s64)))
svint64_t svldff1sh_gather_u64base_s64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_s32index_u32)))
svuint32_t svldff1sh_gather_s32index_u32(svbool_t, int16_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_s32index_s32)))
svint32_t svldff1sh_gather_s32index_s32(svbool_t, int16_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u32index_u32)))
svuint32_t svldff1sh_gather_u32index_u32(svbool_t, int16_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u32index_s32)))
svint32_t svldff1sh_gather_u32index_s32(svbool_t, int16_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_s64index_u64)))
svuint64_t svldff1sh_gather_s64index_u64(svbool_t, int16_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_s64index_s64)))
svint64_t svldff1sh_gather_s64index_s64(svbool_t, int16_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u64index_u64)))
svuint64_t svldff1sh_gather_u64index_u64(svbool_t, int16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u64index_s64)))
svint64_t svldff1sh_gather_u64index_s64(svbool_t, int16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_s32offset_u32)))
svuint32_t svldff1sh_gather_s32offset_u32(svbool_t, int16_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_s32offset_s32)))
svint32_t svldff1sh_gather_s32offset_s32(svbool_t, int16_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u32offset_u32)))
svuint32_t svldff1sh_gather_u32offset_u32(svbool_t, int16_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u32offset_s32)))
svint32_t svldff1sh_gather_u32offset_s32(svbool_t, int16_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_s64offset_u64)))
svuint64_t svldff1sh_gather_s64offset_u64(svbool_t, int16_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_s64offset_s64)))
svint64_t svldff1sh_gather_s64offset_s64(svbool_t, int16_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u64offset_u64)))
svuint64_t svldff1sh_gather_u64offset_u64(svbool_t, int16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u64offset_s64)))
svint64_t svldff1sh_gather_u64offset_s64(svbool_t, int16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_vnum_u32)))
svuint32_t svldff1sh_vnum_u32(svbool_t, int16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_vnum_u64)))
svuint64_t svldff1sh_vnum_u64(svbool_t, int16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_vnum_s32)))
svint32_t svldff1sh_vnum_s32(svbool_t, int16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_vnum_s64)))
svint64_t svldff1sh_vnum_s64(svbool_t, int16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_u32)))
svuint32_t svldff1sh_u32(svbool_t, int16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_u64)))
svuint64_t svldff1sh_u64(svbool_t, int16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_s32)))
svint32_t svldff1sh_s32(svbool_t, int16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_s64)))
svint64_t svldff1sh_s64(svbool_t, int16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_gather_u64base_index_u64)))
svuint64_t svldff1sw_gather_u64base_index_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_gather_u64base_index_s64)))
svint64_t svldff1sw_gather_u64base_index_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_gather_u64base_offset_u64)))
svuint64_t svldff1sw_gather_u64base_offset_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_gather_u64base_offset_s64)))
svint64_t svldff1sw_gather_u64base_offset_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_gather_u64base_u64)))
svuint64_t svldff1sw_gather_u64base_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_gather_u64base_s64)))
svint64_t svldff1sw_gather_u64base_s64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_gather_s64index_u64)))
svuint64_t svldff1sw_gather_s64index_u64(svbool_t, int32_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_gather_s64index_s64)))
svint64_t svldff1sw_gather_s64index_s64(svbool_t, int32_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_gather_u64index_u64)))
svuint64_t svldff1sw_gather_u64index_u64(svbool_t, int32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_gather_u64index_s64)))
svint64_t svldff1sw_gather_u64index_s64(svbool_t, int32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_gather_s64offset_u64)))
svuint64_t svldff1sw_gather_s64offset_u64(svbool_t, int32_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_gather_s64offset_s64)))
svint64_t svldff1sw_gather_s64offset_s64(svbool_t, int32_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_gather_u64offset_u64)))
svuint64_t svldff1sw_gather_u64offset_u64(svbool_t, int32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_gather_u64offset_s64)))
svint64_t svldff1sw_gather_u64offset_s64(svbool_t, int32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_vnum_u64)))
svuint64_t svldff1sw_vnum_u64(svbool_t, int32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_vnum_s64)))
svint64_t svldff1sw_vnum_s64(svbool_t, int32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_u64)))
svuint64_t svldff1sw_u64(svbool_t, int32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_s64)))
svint64_t svldff1sw_s64(svbool_t, int32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_u32base_offset_u32)))
svuint32_t svldff1ub_gather_u32base_offset_u32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_u64base_offset_u64)))
svuint64_t svldff1ub_gather_u64base_offset_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_u32base_offset_s32)))
svint32_t svldff1ub_gather_u32base_offset_s32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_u64base_offset_s64)))
svint64_t svldff1ub_gather_u64base_offset_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_u32base_u32)))
svuint32_t svldff1ub_gather_u32base_u32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_u64base_u64)))
svuint64_t svldff1ub_gather_u64base_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_u32base_s32)))
svint32_t svldff1ub_gather_u32base_s32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_u64base_s64)))
svint64_t svldff1ub_gather_u64base_s64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_s32offset_u32)))
svuint32_t svldff1ub_gather_s32offset_u32(svbool_t, uint8_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_s32offset_s32)))
svint32_t svldff1ub_gather_s32offset_s32(svbool_t, uint8_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_u32offset_u32)))
svuint32_t svldff1ub_gather_u32offset_u32(svbool_t, uint8_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_u32offset_s32)))
svint32_t svldff1ub_gather_u32offset_s32(svbool_t, uint8_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_s64offset_u64)))
svuint64_t svldff1ub_gather_s64offset_u64(svbool_t, uint8_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_s64offset_s64)))
svint64_t svldff1ub_gather_s64offset_s64(svbool_t, uint8_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_u64offset_u64)))
svuint64_t svldff1ub_gather_u64offset_u64(svbool_t, uint8_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_u64offset_s64)))
svint64_t svldff1ub_gather_u64offset_s64(svbool_t, uint8_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_vnum_u32)))
svuint32_t svldff1ub_vnum_u32(svbool_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_vnum_u64)))
svuint64_t svldff1ub_vnum_u64(svbool_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_vnum_u16)))
svuint16_t svldff1ub_vnum_u16(svbool_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_vnum_s32)))
svint32_t svldff1ub_vnum_s32(svbool_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_vnum_s64)))
svint64_t svldff1ub_vnum_s64(svbool_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_vnum_s16)))
svint16_t svldff1ub_vnum_s16(svbool_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_u32)))
svuint32_t svldff1ub_u32(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_u64)))
svuint64_t svldff1ub_u64(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_u16)))
svuint16_t svldff1ub_u16(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_s32)))
svint32_t svldff1ub_s32(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_s64)))
svint64_t svldff1ub_s64(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_s16)))
svint16_t svldff1ub_s16(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u32base_index_u32)))
svuint32_t svldff1uh_gather_u32base_index_u32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u64base_index_u64)))
svuint64_t svldff1uh_gather_u64base_index_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u32base_index_s32)))
svint32_t svldff1uh_gather_u32base_index_s32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u64base_index_s64)))
svint64_t svldff1uh_gather_u64base_index_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u32base_offset_u32)))
svuint32_t svldff1uh_gather_u32base_offset_u32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u64base_offset_u64)))
svuint64_t svldff1uh_gather_u64base_offset_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u32base_offset_s32)))
svint32_t svldff1uh_gather_u32base_offset_s32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u64base_offset_s64)))
svint64_t svldff1uh_gather_u64base_offset_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u32base_u32)))
svuint32_t svldff1uh_gather_u32base_u32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u64base_u64)))
svuint64_t svldff1uh_gather_u64base_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u32base_s32)))
svint32_t svldff1uh_gather_u32base_s32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u64base_s64)))
svint64_t svldff1uh_gather_u64base_s64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_s32index_u32)))
svuint32_t svldff1uh_gather_s32index_u32(svbool_t, uint16_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_s32index_s32)))
svint32_t svldff1uh_gather_s32index_s32(svbool_t, uint16_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u32index_u32)))
svuint32_t svldff1uh_gather_u32index_u32(svbool_t, uint16_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u32index_s32)))
svint32_t svldff1uh_gather_u32index_s32(svbool_t, uint16_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_s64index_u64)))
svuint64_t svldff1uh_gather_s64index_u64(svbool_t, uint16_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_s64index_s64)))
svint64_t svldff1uh_gather_s64index_s64(svbool_t, uint16_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u64index_u64)))
svuint64_t svldff1uh_gather_u64index_u64(svbool_t, uint16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u64index_s64)))
svint64_t svldff1uh_gather_u64index_s64(svbool_t, uint16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_s32offset_u32)))
svuint32_t svldff1uh_gather_s32offset_u32(svbool_t, uint16_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_s32offset_s32)))
svint32_t svldff1uh_gather_s32offset_s32(svbool_t, uint16_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u32offset_u32)))
svuint32_t svldff1uh_gather_u32offset_u32(svbool_t, uint16_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u32offset_s32)))
svint32_t svldff1uh_gather_u32offset_s32(svbool_t, uint16_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_s64offset_u64)))
svuint64_t svldff1uh_gather_s64offset_u64(svbool_t, uint16_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_s64offset_s64)))
svint64_t svldff1uh_gather_s64offset_s64(svbool_t, uint16_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u64offset_u64)))
svuint64_t svldff1uh_gather_u64offset_u64(svbool_t, uint16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u64offset_s64)))
svint64_t svldff1uh_gather_u64offset_s64(svbool_t, uint16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_vnum_u32)))
svuint32_t svldff1uh_vnum_u32(svbool_t, uint16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_vnum_u64)))
svuint64_t svldff1uh_vnum_u64(svbool_t, uint16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_vnum_s32)))
svint32_t svldff1uh_vnum_s32(svbool_t, uint16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_vnum_s64)))
svint64_t svldff1uh_vnum_s64(svbool_t, uint16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_u32)))
svuint32_t svldff1uh_u32(svbool_t, uint16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_u64)))
svuint64_t svldff1uh_u64(svbool_t, uint16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_s32)))
svint32_t svldff1uh_s32(svbool_t, uint16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_s64)))
svint64_t svldff1uh_s64(svbool_t, uint16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_gather_u64base_index_u64)))
svuint64_t svldff1uw_gather_u64base_index_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_gather_u64base_index_s64)))
svint64_t svldff1uw_gather_u64base_index_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_gather_u64base_offset_u64)))
svuint64_t svldff1uw_gather_u64base_offset_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_gather_u64base_offset_s64)))
svint64_t svldff1uw_gather_u64base_offset_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_gather_u64base_u64)))
svuint64_t svldff1uw_gather_u64base_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_gather_u64base_s64)))
svint64_t svldff1uw_gather_u64base_s64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_gather_s64index_u64)))
svuint64_t svldff1uw_gather_s64index_u64(svbool_t, uint32_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_gather_s64index_s64)))
svint64_t svldff1uw_gather_s64index_s64(svbool_t, uint32_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_gather_u64index_u64)))
svuint64_t svldff1uw_gather_u64index_u64(svbool_t, uint32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_gather_u64index_s64)))
svint64_t svldff1uw_gather_u64index_s64(svbool_t, uint32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_gather_s64offset_u64)))
svuint64_t svldff1uw_gather_s64offset_u64(svbool_t, uint32_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_gather_s64offset_s64)))
svint64_t svldff1uw_gather_s64offset_s64(svbool_t, uint32_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_gather_u64offset_u64)))
svuint64_t svldff1uw_gather_u64offset_u64(svbool_t, uint32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_gather_u64offset_s64)))
svint64_t svldff1uw_gather_u64offset_s64(svbool_t, uint32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_vnum_u64)))
svuint64_t svldff1uw_vnum_u64(svbool_t, uint32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_vnum_s64)))
svint64_t svldff1uw_vnum_s64(svbool_t, uint32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_u64)))
svuint64_t svldff1uw_u64(svbool_t, uint32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_s64)))
svint64_t svldff1uw_s64(svbool_t, uint32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_u8)))
svuint8_t svldnf1_u8(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_u32)))
svuint32_t svldnf1_u32(svbool_t, uint32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_u64)))
svuint64_t svldnf1_u64(svbool_t, uint64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_u16)))
svuint16_t svldnf1_u16(svbool_t, uint16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_s8)))
svint8_t svldnf1_s8(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_f64)))
svfloat64_t svldnf1_f64(svbool_t, float64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_f32)))
svfloat32_t svldnf1_f32(svbool_t, float32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_f16)))
svfloat16_t svldnf1_f16(svbool_t, float16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_s32)))
svint32_t svldnf1_s32(svbool_t, int32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_s64)))
svint64_t svldnf1_s64(svbool_t, int64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_s16)))
svint16_t svldnf1_s16(svbool_t, int16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_vnum_u8)))
svuint8_t svldnf1_vnum_u8(svbool_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_vnum_u32)))
svuint32_t svldnf1_vnum_u32(svbool_t, uint32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_vnum_u64)))
svuint64_t svldnf1_vnum_u64(svbool_t, uint64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_vnum_u16)))
svuint16_t svldnf1_vnum_u16(svbool_t, uint16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_vnum_s8)))
svint8_t svldnf1_vnum_s8(svbool_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_vnum_f64)))
svfloat64_t svldnf1_vnum_f64(svbool_t, float64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_vnum_f32)))
svfloat32_t svldnf1_vnum_f32(svbool_t, float32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_vnum_f16)))
svfloat16_t svldnf1_vnum_f16(svbool_t, float16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_vnum_s32)))
svint32_t svldnf1_vnum_s32(svbool_t, int32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_vnum_s64)))
svint64_t svldnf1_vnum_s64(svbool_t, int64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_vnum_s16)))
svint16_t svldnf1_vnum_s16(svbool_t, int16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sb_vnum_u32)))
svuint32_t svldnf1sb_vnum_u32(svbool_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sb_vnum_u64)))
svuint64_t svldnf1sb_vnum_u64(svbool_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sb_vnum_u16)))
svuint16_t svldnf1sb_vnum_u16(svbool_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sb_vnum_s32)))
svint32_t svldnf1sb_vnum_s32(svbool_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sb_vnum_s64)))
svint64_t svldnf1sb_vnum_s64(svbool_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sb_vnum_s16)))
svint16_t svldnf1sb_vnum_s16(svbool_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sb_u32)))
svuint32_t svldnf1sb_u32(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sb_u64)))
svuint64_t svldnf1sb_u64(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sb_u16)))
svuint16_t svldnf1sb_u16(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sb_s32)))
svint32_t svldnf1sb_s32(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sb_s64)))
svint64_t svldnf1sb_s64(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sb_s16)))
svint16_t svldnf1sb_s16(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sh_vnum_u32)))
svuint32_t svldnf1sh_vnum_u32(svbool_t, int16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sh_vnum_u64)))
svuint64_t svldnf1sh_vnum_u64(svbool_t, int16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sh_vnum_s32)))
svint32_t svldnf1sh_vnum_s32(svbool_t, int16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sh_vnum_s64)))
svint64_t svldnf1sh_vnum_s64(svbool_t, int16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sh_u32)))
svuint32_t svldnf1sh_u32(svbool_t, int16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sh_u64)))
svuint64_t svldnf1sh_u64(svbool_t, int16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sh_s32)))
svint32_t svldnf1sh_s32(svbool_t, int16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sh_s64)))
svint64_t svldnf1sh_s64(svbool_t, int16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sw_vnum_u64)))
svuint64_t svldnf1sw_vnum_u64(svbool_t, int32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sw_vnum_s64)))
svint64_t svldnf1sw_vnum_s64(svbool_t, int32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sw_u64)))
svuint64_t svldnf1sw_u64(svbool_t, int32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sw_s64)))
svint64_t svldnf1sw_s64(svbool_t, int32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1ub_vnum_u32)))
svuint32_t svldnf1ub_vnum_u32(svbool_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1ub_vnum_u64)))
svuint64_t svldnf1ub_vnum_u64(svbool_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1ub_vnum_u16)))
svuint16_t svldnf1ub_vnum_u16(svbool_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1ub_vnum_s32)))
svint32_t svldnf1ub_vnum_s32(svbool_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1ub_vnum_s64)))
svint64_t svldnf1ub_vnum_s64(svbool_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1ub_vnum_s16)))
svint16_t svldnf1ub_vnum_s16(svbool_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1ub_u32)))
svuint32_t svldnf1ub_u32(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1ub_u64)))
svuint64_t svldnf1ub_u64(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1ub_u16)))
svuint16_t svldnf1ub_u16(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1ub_s32)))
svint32_t svldnf1ub_s32(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1ub_s64)))
svint64_t svldnf1ub_s64(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1ub_s16)))
svint16_t svldnf1ub_s16(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1uh_vnum_u32)))
svuint32_t svldnf1uh_vnum_u32(svbool_t, uint16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1uh_vnum_u64)))
svuint64_t svldnf1uh_vnum_u64(svbool_t, uint16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1uh_vnum_s32)))
svint32_t svldnf1uh_vnum_s32(svbool_t, uint16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1uh_vnum_s64)))
svint64_t svldnf1uh_vnum_s64(svbool_t, uint16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1uh_u32)))
svuint32_t svldnf1uh_u32(svbool_t, uint16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1uh_u64)))
svuint64_t svldnf1uh_u64(svbool_t, uint16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1uh_s32)))
svint32_t svldnf1uh_s32(svbool_t, uint16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1uh_s64)))
svint64_t svldnf1uh_s64(svbool_t, uint16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1uw_vnum_u64)))
svuint64_t svldnf1uw_vnum_u64(svbool_t, uint32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1uw_vnum_s64)))
svint64_t svldnf1uw_vnum_s64(svbool_t, uint32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1uw_u64)))
svuint64_t svldnf1uw_u64(svbool_t, uint32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1uw_s64)))
svint64_t svldnf1uw_s64(svbool_t, uint32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_u8), arm_streaming_compatible))
svuint8_t svldnt1_u8(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_u32), arm_streaming_compatible))
svuint32_t svldnt1_u32(svbool_t, uint32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_u64), arm_streaming_compatible))
svuint64_t svldnt1_u64(svbool_t, uint64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_u16), arm_streaming_compatible))
svuint16_t svldnt1_u16(svbool_t, uint16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_s8), arm_streaming_compatible))
svint8_t svldnt1_s8(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_f64), arm_streaming_compatible))
svfloat64_t svldnt1_f64(svbool_t, float64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_f32), arm_streaming_compatible))
svfloat32_t svldnt1_f32(svbool_t, float32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_f16), arm_streaming_compatible))
svfloat16_t svldnt1_f16(svbool_t, float16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_s32), arm_streaming_compatible))
svint32_t svldnt1_s32(svbool_t, int32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_s64), arm_streaming_compatible))
svint64_t svldnt1_s64(svbool_t, int64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_s16), arm_streaming_compatible))
svint16_t svldnt1_s16(svbool_t, int16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_u8), arm_streaming_compatible))
svuint8_t svldnt1_vnum_u8(svbool_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_u32), arm_streaming_compatible))
svuint32_t svldnt1_vnum_u32(svbool_t, uint32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_u64), arm_streaming_compatible))
svuint64_t svldnt1_vnum_u64(svbool_t, uint64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_u16), arm_streaming_compatible))
svuint16_t svldnt1_vnum_u16(svbool_t, uint16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_s8), arm_streaming_compatible))
svint8_t svldnt1_vnum_s8(svbool_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_f64), arm_streaming_compatible))
svfloat64_t svldnt1_vnum_f64(svbool_t, float64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_f32), arm_streaming_compatible))
svfloat32_t svldnt1_vnum_f32(svbool_t, float32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_f16), arm_streaming_compatible))
svfloat16_t svldnt1_vnum_f16(svbool_t, float16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_s32), arm_streaming_compatible))
svint32_t svldnt1_vnum_s32(svbool_t, int32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_s64), arm_streaming_compatible))
svint64_t svldnt1_vnum_s64(svbool_t, int64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_s16), arm_streaming_compatible))
svint16_t svldnt1_vnum_s16(svbool_t, int16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlen_u8), arm_streaming_compatible))
uint64_t svlen_u8(svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlen_u32), arm_streaming_compatible))
uint64_t svlen_u32(svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlen_u64), arm_streaming_compatible))
uint64_t svlen_u64(svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlen_u16), arm_streaming_compatible))
uint64_t svlen_u16(svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlen_s8), arm_streaming_compatible))
uint64_t svlen_s8(svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlen_f64), arm_streaming_compatible))
uint64_t svlen_f64(svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlen_f32), arm_streaming_compatible))
uint64_t svlen_f32(svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlen_f16), arm_streaming_compatible))
uint64_t svlen_f16(svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlen_s32), arm_streaming_compatible))
uint64_t svlen_s32(svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlen_s64), arm_streaming_compatible))
uint64_t svlen_s64(svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlen_s16), arm_streaming_compatible))
uint64_t svlen_s16(svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_n_u8_m), arm_streaming_compatible))
svuint8_t svlsl_n_u8_m(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_n_u32_m), arm_streaming_compatible))
svuint32_t svlsl_n_u32_m(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_n_u64_m), arm_streaming_compatible))
svuint64_t svlsl_n_u64_m(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_n_u16_m), arm_streaming_compatible))
svuint16_t svlsl_n_u16_m(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_n_s8_m), arm_streaming_compatible))
svint8_t svlsl_n_s8_m(svbool_t, svint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_n_s32_m), arm_streaming_compatible))
svint32_t svlsl_n_s32_m(svbool_t, svint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_n_s64_m), arm_streaming_compatible))
svint64_t svlsl_n_s64_m(svbool_t, svint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_n_s16_m), arm_streaming_compatible))
svint16_t svlsl_n_s16_m(svbool_t, svint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_n_u8_x), arm_streaming_compatible))
svuint8_t svlsl_n_u8_x(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_n_u32_x), arm_streaming_compatible))
svuint32_t svlsl_n_u32_x(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_n_u64_x), arm_streaming_compatible))
svuint64_t svlsl_n_u64_x(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_n_u16_x), arm_streaming_compatible))
svuint16_t svlsl_n_u16_x(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_n_s8_x), arm_streaming_compatible))
svint8_t svlsl_n_s8_x(svbool_t, svint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_n_s32_x), arm_streaming_compatible))
svint32_t svlsl_n_s32_x(svbool_t, svint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_n_s64_x), arm_streaming_compatible))
svint64_t svlsl_n_s64_x(svbool_t, svint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_n_s16_x), arm_streaming_compatible))
svint16_t svlsl_n_s16_x(svbool_t, svint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_n_u8_z), arm_streaming_compatible))
svuint8_t svlsl_n_u8_z(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_n_u32_z), arm_streaming_compatible))
svuint32_t svlsl_n_u32_z(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_n_u64_z), arm_streaming_compatible))
svuint64_t svlsl_n_u64_z(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_n_u16_z), arm_streaming_compatible))
svuint16_t svlsl_n_u16_z(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_n_s8_z), arm_streaming_compatible))
svint8_t svlsl_n_s8_z(svbool_t, svint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_n_s32_z), arm_streaming_compatible))
svint32_t svlsl_n_s32_z(svbool_t, svint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_n_s64_z), arm_streaming_compatible))
svint64_t svlsl_n_s64_z(svbool_t, svint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_n_s16_z), arm_streaming_compatible))
svint16_t svlsl_n_s16_z(svbool_t, svint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_u8_m), arm_streaming_compatible))
svuint8_t svlsl_u8_m(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_u32_m), arm_streaming_compatible))
svuint32_t svlsl_u32_m(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_u64_m), arm_streaming_compatible))
svuint64_t svlsl_u64_m(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_u16_m), arm_streaming_compatible))
svuint16_t svlsl_u16_m(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_s8_m), arm_streaming_compatible))
svint8_t svlsl_s8_m(svbool_t, svint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_s32_m), arm_streaming_compatible))
svint32_t svlsl_s32_m(svbool_t, svint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_s64_m), arm_streaming_compatible))
svint64_t svlsl_s64_m(svbool_t, svint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_s16_m), arm_streaming_compatible))
svint16_t svlsl_s16_m(svbool_t, svint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_u8_x), arm_streaming_compatible))
svuint8_t svlsl_u8_x(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_u32_x), arm_streaming_compatible))
svuint32_t svlsl_u32_x(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_u64_x), arm_streaming_compatible))
svuint64_t svlsl_u64_x(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_u16_x), arm_streaming_compatible))
svuint16_t svlsl_u16_x(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_s8_x), arm_streaming_compatible))
svint8_t svlsl_s8_x(svbool_t, svint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_s32_x), arm_streaming_compatible))
svint32_t svlsl_s32_x(svbool_t, svint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_s64_x), arm_streaming_compatible))
svint64_t svlsl_s64_x(svbool_t, svint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_s16_x), arm_streaming_compatible))
svint16_t svlsl_s16_x(svbool_t, svint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_u8_z), arm_streaming_compatible))
svuint8_t svlsl_u8_z(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_u32_z), arm_streaming_compatible))
svuint32_t svlsl_u32_z(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_u64_z), arm_streaming_compatible))
svuint64_t svlsl_u64_z(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_u16_z), arm_streaming_compatible))
svuint16_t svlsl_u16_z(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_s8_z), arm_streaming_compatible))
svint8_t svlsl_s8_z(svbool_t, svint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_s32_z), arm_streaming_compatible))
svint32_t svlsl_s32_z(svbool_t, svint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_s64_z), arm_streaming_compatible))
svint64_t svlsl_s64_z(svbool_t, svint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_s16_z), arm_streaming_compatible))
svint16_t svlsl_s16_z(svbool_t, svint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_wide_n_u8_m), arm_streaming_compatible))
svuint8_t svlsl_wide_n_u8_m(svbool_t, svuint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_wide_n_u32_m), arm_streaming_compatible))
svuint32_t svlsl_wide_n_u32_m(svbool_t, svuint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_wide_n_u16_m), arm_streaming_compatible))
svuint16_t svlsl_wide_n_u16_m(svbool_t, svuint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_wide_n_s8_m), arm_streaming_compatible))
svint8_t svlsl_wide_n_s8_m(svbool_t, svint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_wide_n_s32_m), arm_streaming_compatible))
svint32_t svlsl_wide_n_s32_m(svbool_t, svint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_wide_n_s16_m), arm_streaming_compatible))
svint16_t svlsl_wide_n_s16_m(svbool_t, svint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_wide_n_u8_x), arm_streaming_compatible))
svuint8_t svlsl_wide_n_u8_x(svbool_t, svuint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_wide_n_u32_x), arm_streaming_compatible))
svuint32_t svlsl_wide_n_u32_x(svbool_t, svuint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_wide_n_u16_x), arm_streaming_compatible))
svuint16_t svlsl_wide_n_u16_x(svbool_t, svuint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_wide_n_s8_x), arm_streaming_compatible))
svint8_t svlsl_wide_n_s8_x(svbool_t, svint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_wide_n_s32_x), arm_streaming_compatible))
svint32_t svlsl_wide_n_s32_x(svbool_t, svint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_wide_n_s16_x), arm_streaming_compatible))
svint16_t svlsl_wide_n_s16_x(svbool_t, svint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_wide_n_u8_z), arm_streaming_compatible))
svuint8_t svlsl_wide_n_u8_z(svbool_t, svuint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_wide_n_u32_z), arm_streaming_compatible))
svuint32_t svlsl_wide_n_u32_z(svbool_t, svuint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_wide_n_u16_z), arm_streaming_compatible))
svuint16_t svlsl_wide_n_u16_z(svbool_t, svuint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_wide_n_s8_z), arm_streaming_compatible))
svint8_t svlsl_wide_n_s8_z(svbool_t, svint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_wide_n_s32_z), arm_streaming_compatible))
svint32_t svlsl_wide_n_s32_z(svbool_t, svint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_wide_n_s16_z), arm_streaming_compatible))
svint16_t svlsl_wide_n_s16_z(svbool_t, svint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_wide_u8_m), arm_streaming_compatible))
svuint8_t svlsl_wide_u8_m(svbool_t, svuint8_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_wide_u32_m), arm_streaming_compatible))
svuint32_t svlsl_wide_u32_m(svbool_t, svuint32_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_wide_u16_m), arm_streaming_compatible))
svuint16_t svlsl_wide_u16_m(svbool_t, svuint16_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_wide_s8_m), arm_streaming_compatible))
svint8_t svlsl_wide_s8_m(svbool_t, svint8_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_wide_s32_m), arm_streaming_compatible))
svint32_t svlsl_wide_s32_m(svbool_t, svint32_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_wide_s16_m), arm_streaming_compatible))
svint16_t svlsl_wide_s16_m(svbool_t, svint16_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_wide_u8_x), arm_streaming_compatible))
svuint8_t svlsl_wide_u8_x(svbool_t, svuint8_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_wide_u32_x), arm_streaming_compatible))
svuint32_t svlsl_wide_u32_x(svbool_t, svuint32_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_wide_u16_x), arm_streaming_compatible))
svuint16_t svlsl_wide_u16_x(svbool_t, svuint16_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_wide_s8_x), arm_streaming_compatible))
svint8_t svlsl_wide_s8_x(svbool_t, svint8_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_wide_s32_x), arm_streaming_compatible))
svint32_t svlsl_wide_s32_x(svbool_t, svint32_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_wide_s16_x), arm_streaming_compatible))
svint16_t svlsl_wide_s16_x(svbool_t, svint16_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_wide_u8_z), arm_streaming_compatible))
svuint8_t svlsl_wide_u8_z(svbool_t, svuint8_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_wide_u32_z), arm_streaming_compatible))
svuint32_t svlsl_wide_u32_z(svbool_t, svuint32_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_wide_u16_z), arm_streaming_compatible))
svuint16_t svlsl_wide_u16_z(svbool_t, svuint16_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_wide_s8_z), arm_streaming_compatible))
svint8_t svlsl_wide_s8_z(svbool_t, svint8_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_wide_s32_z), arm_streaming_compatible))
svint32_t svlsl_wide_s32_z(svbool_t, svint32_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsl_wide_s16_z), arm_streaming_compatible))
svint16_t svlsl_wide_s16_z(svbool_t, svint16_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsr_n_u8_m), arm_streaming_compatible))
svuint8_t svlsr_n_u8_m(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsr_n_u32_m), arm_streaming_compatible))
svuint32_t svlsr_n_u32_m(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsr_n_u64_m), arm_streaming_compatible))
svuint64_t svlsr_n_u64_m(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsr_n_u16_m), arm_streaming_compatible))
svuint16_t svlsr_n_u16_m(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsr_n_u8_x), arm_streaming_compatible))
svuint8_t svlsr_n_u8_x(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsr_n_u32_x), arm_streaming_compatible))
svuint32_t svlsr_n_u32_x(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsr_n_u64_x), arm_streaming_compatible))
svuint64_t svlsr_n_u64_x(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsr_n_u16_x), arm_streaming_compatible))
svuint16_t svlsr_n_u16_x(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsr_n_u8_z), arm_streaming_compatible))
svuint8_t svlsr_n_u8_z(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsr_n_u32_z), arm_streaming_compatible))
svuint32_t svlsr_n_u32_z(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsr_n_u64_z), arm_streaming_compatible))
svuint64_t svlsr_n_u64_z(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsr_n_u16_z), arm_streaming_compatible))
svuint16_t svlsr_n_u16_z(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsr_u8_m), arm_streaming_compatible))
svuint8_t svlsr_u8_m(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsr_u32_m), arm_streaming_compatible))
svuint32_t svlsr_u32_m(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsr_u64_m), arm_streaming_compatible))
svuint64_t svlsr_u64_m(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsr_u16_m), arm_streaming_compatible))
svuint16_t svlsr_u16_m(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsr_u8_x), arm_streaming_compatible))
svuint8_t svlsr_u8_x(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsr_u32_x), arm_streaming_compatible))
svuint32_t svlsr_u32_x(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsr_u64_x), arm_streaming_compatible))
svuint64_t svlsr_u64_x(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsr_u16_x), arm_streaming_compatible))
svuint16_t svlsr_u16_x(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsr_u8_z), arm_streaming_compatible))
svuint8_t svlsr_u8_z(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsr_u32_z), arm_streaming_compatible))
svuint32_t svlsr_u32_z(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsr_u64_z), arm_streaming_compatible))
svuint64_t svlsr_u64_z(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsr_u16_z), arm_streaming_compatible))
svuint16_t svlsr_u16_z(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsr_wide_n_u8_m), arm_streaming_compatible))
svuint8_t svlsr_wide_n_u8_m(svbool_t, svuint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsr_wide_n_u32_m), arm_streaming_compatible))
svuint32_t svlsr_wide_n_u32_m(svbool_t, svuint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsr_wide_n_u16_m), arm_streaming_compatible))
svuint16_t svlsr_wide_n_u16_m(svbool_t, svuint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsr_wide_n_u8_x), arm_streaming_compatible))
svuint8_t svlsr_wide_n_u8_x(svbool_t, svuint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsr_wide_n_u32_x), arm_streaming_compatible))
svuint32_t svlsr_wide_n_u32_x(svbool_t, svuint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsr_wide_n_u16_x), arm_streaming_compatible))
svuint16_t svlsr_wide_n_u16_x(svbool_t, svuint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsr_wide_n_u8_z), arm_streaming_compatible))
svuint8_t svlsr_wide_n_u8_z(svbool_t, svuint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsr_wide_n_u32_z), arm_streaming_compatible))
svuint32_t svlsr_wide_n_u32_z(svbool_t, svuint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsr_wide_n_u16_z), arm_streaming_compatible))
svuint16_t svlsr_wide_n_u16_z(svbool_t, svuint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsr_wide_u8_m), arm_streaming_compatible))
svuint8_t svlsr_wide_u8_m(svbool_t, svuint8_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsr_wide_u32_m), arm_streaming_compatible))
svuint32_t svlsr_wide_u32_m(svbool_t, svuint32_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsr_wide_u16_m), arm_streaming_compatible))
svuint16_t svlsr_wide_u16_m(svbool_t, svuint16_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsr_wide_u8_x), arm_streaming_compatible))
svuint8_t svlsr_wide_u8_x(svbool_t, svuint8_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsr_wide_u32_x), arm_streaming_compatible))
svuint32_t svlsr_wide_u32_x(svbool_t, svuint32_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsr_wide_u16_x), arm_streaming_compatible))
svuint16_t svlsr_wide_u16_x(svbool_t, svuint16_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsr_wide_u8_z), arm_streaming_compatible))
svuint8_t svlsr_wide_u8_z(svbool_t, svuint8_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsr_wide_u32_z), arm_streaming_compatible))
svuint32_t svlsr_wide_u32_z(svbool_t, svuint32_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlsr_wide_u16_z), arm_streaming_compatible))
svuint16_t svlsr_wide_u16_z(svbool_t, svuint16_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_n_f64_m)))
svfloat64_t svmad_n_f64_m(svbool_t, svfloat64_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_n_f32_m)))
svfloat32_t svmad_n_f32_m(svbool_t, svfloat32_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_n_f16_m)))
svfloat16_t svmad_n_f16_m(svbool_t, svfloat16_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_n_f64_x)))
svfloat64_t svmad_n_f64_x(svbool_t, svfloat64_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_n_f32_x)))
svfloat32_t svmad_n_f32_x(svbool_t, svfloat32_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_n_f16_x)))
svfloat16_t svmad_n_f16_x(svbool_t, svfloat16_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_n_f64_z)))
svfloat64_t svmad_n_f64_z(svbool_t, svfloat64_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_n_f32_z)))
svfloat32_t svmad_n_f32_z(svbool_t, svfloat32_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_n_f16_z)))
svfloat16_t svmad_n_f16_z(svbool_t, svfloat16_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_n_u8_m), arm_streaming_compatible))
svuint8_t svmad_n_u8_m(svbool_t, svuint8_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_n_u32_m), arm_streaming_compatible))
svuint32_t svmad_n_u32_m(svbool_t, svuint32_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_n_u64_m), arm_streaming_compatible))
svuint64_t svmad_n_u64_m(svbool_t, svuint64_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_n_u16_m), arm_streaming_compatible))
svuint16_t svmad_n_u16_m(svbool_t, svuint16_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_n_s8_m), arm_streaming_compatible))
svint8_t svmad_n_s8_m(svbool_t, svint8_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_n_s32_m), arm_streaming_compatible))
svint32_t svmad_n_s32_m(svbool_t, svint32_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_n_s64_m), arm_streaming_compatible))
svint64_t svmad_n_s64_m(svbool_t, svint64_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_n_s16_m), arm_streaming_compatible))
svint16_t svmad_n_s16_m(svbool_t, svint16_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_n_u8_x), arm_streaming_compatible))
svuint8_t svmad_n_u8_x(svbool_t, svuint8_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_n_u32_x), arm_streaming_compatible))
svuint32_t svmad_n_u32_x(svbool_t, svuint32_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_n_u64_x), arm_streaming_compatible))
svuint64_t svmad_n_u64_x(svbool_t, svuint64_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_n_u16_x), arm_streaming_compatible))
svuint16_t svmad_n_u16_x(svbool_t, svuint16_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_n_s8_x), arm_streaming_compatible))
svint8_t svmad_n_s8_x(svbool_t, svint8_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_n_s32_x), arm_streaming_compatible))
svint32_t svmad_n_s32_x(svbool_t, svint32_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_n_s64_x), arm_streaming_compatible))
svint64_t svmad_n_s64_x(svbool_t, svint64_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_n_s16_x), arm_streaming_compatible))
svint16_t svmad_n_s16_x(svbool_t, svint16_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_n_u8_z), arm_streaming_compatible))
svuint8_t svmad_n_u8_z(svbool_t, svuint8_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_n_u32_z), arm_streaming_compatible))
svuint32_t svmad_n_u32_z(svbool_t, svuint32_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_n_u64_z), arm_streaming_compatible))
svuint64_t svmad_n_u64_z(svbool_t, svuint64_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_n_u16_z), arm_streaming_compatible))
svuint16_t svmad_n_u16_z(svbool_t, svuint16_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_n_s8_z), arm_streaming_compatible))
svint8_t svmad_n_s8_z(svbool_t, svint8_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_n_s32_z), arm_streaming_compatible))
svint32_t svmad_n_s32_z(svbool_t, svint32_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_n_s64_z), arm_streaming_compatible))
svint64_t svmad_n_s64_z(svbool_t, svint64_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_n_s16_z), arm_streaming_compatible))
svint16_t svmad_n_s16_z(svbool_t, svint16_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_f64_m)))
svfloat64_t svmad_f64_m(svbool_t, svfloat64_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_f32_m)))
svfloat32_t svmad_f32_m(svbool_t, svfloat32_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_f16_m)))
svfloat16_t svmad_f16_m(svbool_t, svfloat16_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_f64_x)))
svfloat64_t svmad_f64_x(svbool_t, svfloat64_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_f32_x)))
svfloat32_t svmad_f32_x(svbool_t, svfloat32_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_f16_x)))
svfloat16_t svmad_f16_x(svbool_t, svfloat16_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_f64_z)))
svfloat64_t svmad_f64_z(svbool_t, svfloat64_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_f32_z)))
svfloat32_t svmad_f32_z(svbool_t, svfloat32_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_f16_z)))
svfloat16_t svmad_f16_z(svbool_t, svfloat16_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_u8_m), arm_streaming_compatible))
svuint8_t svmad_u8_m(svbool_t, svuint8_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_u32_m), arm_streaming_compatible))
svuint32_t svmad_u32_m(svbool_t, svuint32_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_u64_m), arm_streaming_compatible))
svuint64_t svmad_u64_m(svbool_t, svuint64_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_u16_m), arm_streaming_compatible))
svuint16_t svmad_u16_m(svbool_t, svuint16_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_s8_m), arm_streaming_compatible))
svint8_t svmad_s8_m(svbool_t, svint8_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_s32_m), arm_streaming_compatible))
svint32_t svmad_s32_m(svbool_t, svint32_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_s64_m), arm_streaming_compatible))
svint64_t svmad_s64_m(svbool_t, svint64_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_s16_m), arm_streaming_compatible))
svint16_t svmad_s16_m(svbool_t, svint16_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_u8_x), arm_streaming_compatible))
svuint8_t svmad_u8_x(svbool_t, svuint8_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_u32_x), arm_streaming_compatible))
svuint32_t svmad_u32_x(svbool_t, svuint32_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_u64_x), arm_streaming_compatible))
svuint64_t svmad_u64_x(svbool_t, svuint64_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_u16_x), arm_streaming_compatible))
svuint16_t svmad_u16_x(svbool_t, svuint16_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_s8_x), arm_streaming_compatible))
svint8_t svmad_s8_x(svbool_t, svint8_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_s32_x), arm_streaming_compatible))
svint32_t svmad_s32_x(svbool_t, svint32_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_s64_x), arm_streaming_compatible))
svint64_t svmad_s64_x(svbool_t, svint64_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_s16_x), arm_streaming_compatible))
svint16_t svmad_s16_x(svbool_t, svint16_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_u8_z), arm_streaming_compatible))
svuint8_t svmad_u8_z(svbool_t, svuint8_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_u32_z), arm_streaming_compatible))
svuint32_t svmad_u32_z(svbool_t, svuint32_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_u64_z), arm_streaming_compatible))
svuint64_t svmad_u64_z(svbool_t, svuint64_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_u16_z), arm_streaming_compatible))
svuint16_t svmad_u16_z(svbool_t, svuint16_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_s8_z), arm_streaming_compatible))
svint8_t svmad_s8_z(svbool_t, svint8_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_s32_z), arm_streaming_compatible))
svint32_t svmad_s32_z(svbool_t, svint32_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_s64_z), arm_streaming_compatible))
svint64_t svmad_s64_z(svbool_t, svint64_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmad_s16_z), arm_streaming_compatible))
svint16_t svmad_s16_z(svbool_t, svint16_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_f64_m), arm_streaming_compatible))
svfloat64_t svmax_n_f64_m(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_f32_m), arm_streaming_compatible))
svfloat32_t svmax_n_f32_m(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_f16_m), arm_streaming_compatible))
svfloat16_t svmax_n_f16_m(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_f64_x), arm_streaming_compatible))
svfloat64_t svmax_n_f64_x(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_f32_x), arm_streaming_compatible))
svfloat32_t svmax_n_f32_x(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_f16_x), arm_streaming_compatible))
svfloat16_t svmax_n_f16_x(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_f64_z), arm_streaming_compatible))
svfloat64_t svmax_n_f64_z(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_f32_z), arm_streaming_compatible))
svfloat32_t svmax_n_f32_z(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_f16_z), arm_streaming_compatible))
svfloat16_t svmax_n_f16_z(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_s8_m), arm_streaming_compatible))
svint8_t svmax_n_s8_m(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_s32_m), arm_streaming_compatible))
svint32_t svmax_n_s32_m(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_s64_m), arm_streaming_compatible))
svint64_t svmax_n_s64_m(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_s16_m), arm_streaming_compatible))
svint16_t svmax_n_s16_m(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_s8_x), arm_streaming_compatible))
svint8_t svmax_n_s8_x(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_s32_x), arm_streaming_compatible))
svint32_t svmax_n_s32_x(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_s64_x), arm_streaming_compatible))
svint64_t svmax_n_s64_x(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_s16_x), arm_streaming_compatible))
svint16_t svmax_n_s16_x(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_s8_z), arm_streaming_compatible))
svint8_t svmax_n_s8_z(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_s32_z), arm_streaming_compatible))
svint32_t svmax_n_s32_z(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_s64_z), arm_streaming_compatible))
svint64_t svmax_n_s64_z(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_s16_z), arm_streaming_compatible))
svint16_t svmax_n_s16_z(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_u8_m), arm_streaming_compatible))
svuint8_t svmax_n_u8_m(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_u32_m), arm_streaming_compatible))
svuint32_t svmax_n_u32_m(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_u64_m), arm_streaming_compatible))
svuint64_t svmax_n_u64_m(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_u16_m), arm_streaming_compatible))
svuint16_t svmax_n_u16_m(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_u8_x), arm_streaming_compatible))
svuint8_t svmax_n_u8_x(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_u32_x), arm_streaming_compatible))
svuint32_t svmax_n_u32_x(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_u64_x), arm_streaming_compatible))
svuint64_t svmax_n_u64_x(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_u16_x), arm_streaming_compatible))
svuint16_t svmax_n_u16_x(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_u8_z), arm_streaming_compatible))
svuint8_t svmax_n_u8_z(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_u32_z), arm_streaming_compatible))
svuint32_t svmax_n_u32_z(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_u64_z), arm_streaming_compatible))
svuint64_t svmax_n_u64_z(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_u16_z), arm_streaming_compatible))
svuint16_t svmax_n_u16_z(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_f64_m), arm_streaming_compatible))
svfloat64_t svmax_f64_m(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_f32_m), arm_streaming_compatible))
svfloat32_t svmax_f32_m(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_f16_m), arm_streaming_compatible))
svfloat16_t svmax_f16_m(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_f64_x), arm_streaming_compatible))
svfloat64_t svmax_f64_x(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_f32_x), arm_streaming_compatible))
svfloat32_t svmax_f32_x(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_f16_x), arm_streaming_compatible))
svfloat16_t svmax_f16_x(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_f64_z), arm_streaming_compatible))
svfloat64_t svmax_f64_z(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_f32_z), arm_streaming_compatible))
svfloat32_t svmax_f32_z(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_f16_z), arm_streaming_compatible))
svfloat16_t svmax_f16_z(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s8_m), arm_streaming_compatible))
svint8_t svmax_s8_m(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s32_m), arm_streaming_compatible))
svint32_t svmax_s32_m(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s64_m), arm_streaming_compatible))
svint64_t svmax_s64_m(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s16_m), arm_streaming_compatible))
svint16_t svmax_s16_m(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s8_x), arm_streaming_compatible))
svint8_t svmax_s8_x(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s32_x), arm_streaming_compatible))
svint32_t svmax_s32_x(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s64_x), arm_streaming_compatible))
svint64_t svmax_s64_x(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s16_x), arm_streaming_compatible))
svint16_t svmax_s16_x(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s8_z), arm_streaming_compatible))
svint8_t svmax_s8_z(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s32_z), arm_streaming_compatible))
svint32_t svmax_s32_z(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s64_z), arm_streaming_compatible))
svint64_t svmax_s64_z(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s16_z), arm_streaming_compatible))
svint16_t svmax_s16_z(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u8_m), arm_streaming_compatible))
svuint8_t svmax_u8_m(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u32_m), arm_streaming_compatible))
svuint32_t svmax_u32_m(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u64_m), arm_streaming_compatible))
svuint64_t svmax_u64_m(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u16_m), arm_streaming_compatible))
svuint16_t svmax_u16_m(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u8_x), arm_streaming_compatible))
svuint8_t svmax_u8_x(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u32_x), arm_streaming_compatible))
svuint32_t svmax_u32_x(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u64_x), arm_streaming_compatible))
svuint64_t svmax_u64_x(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u16_x), arm_streaming_compatible))
svuint16_t svmax_u16_x(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u8_z), arm_streaming_compatible))
svuint8_t svmax_u8_z(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u32_z), arm_streaming_compatible))
svuint32_t svmax_u32_z(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u64_z), arm_streaming_compatible))
svuint64_t svmax_u64_z(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u16_z), arm_streaming_compatible))
svuint16_t svmax_u16_z(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_n_f64_m), arm_streaming_compatible))
svfloat64_t svmaxnm_n_f64_m(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_n_f32_m), arm_streaming_compatible))
svfloat32_t svmaxnm_n_f32_m(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_n_f16_m), arm_streaming_compatible))
svfloat16_t svmaxnm_n_f16_m(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_n_f64_x), arm_streaming_compatible))
svfloat64_t svmaxnm_n_f64_x(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_n_f32_x), arm_streaming_compatible))
svfloat32_t svmaxnm_n_f32_x(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_n_f16_x), arm_streaming_compatible))
svfloat16_t svmaxnm_n_f16_x(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_n_f64_z), arm_streaming_compatible))
svfloat64_t svmaxnm_n_f64_z(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_n_f32_z), arm_streaming_compatible))
svfloat32_t svmaxnm_n_f32_z(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_n_f16_z), arm_streaming_compatible))
svfloat16_t svmaxnm_n_f16_z(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_f64_m), arm_streaming_compatible))
svfloat64_t svmaxnm_f64_m(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_f32_m), arm_streaming_compatible))
svfloat32_t svmaxnm_f32_m(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_f16_m), arm_streaming_compatible))
svfloat16_t svmaxnm_f16_m(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_f64_x), arm_streaming_compatible))
svfloat64_t svmaxnm_f64_x(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_f32_x), arm_streaming_compatible))
svfloat32_t svmaxnm_f32_x(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_f16_x), arm_streaming_compatible))
svfloat16_t svmaxnm_f16_x(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_f64_z), arm_streaming_compatible))
svfloat64_t svmaxnm_f64_z(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_f32_z), arm_streaming_compatible))
svfloat32_t svmaxnm_f32_z(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_f16_z), arm_streaming_compatible))
svfloat16_t svmaxnm_f16_z(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnmv_f64), arm_streaming_compatible))
float64_t svmaxnmv_f64(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnmv_f32), arm_streaming_compatible))
float32_t svmaxnmv_f32(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnmv_f16), arm_streaming_compatible))
float16_t svmaxnmv_f16(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxv_f64), arm_streaming_compatible))
float64_t svmaxv_f64(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxv_f32), arm_streaming_compatible))
float32_t svmaxv_f32(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxv_f16), arm_streaming_compatible))
float16_t svmaxv_f16(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxv_s8), arm_streaming_compatible))
int8_t svmaxv_s8(svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxv_s32), arm_streaming_compatible))
int32_t svmaxv_s32(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxv_s64), arm_streaming_compatible))
int64_t svmaxv_s64(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxv_s16), arm_streaming_compatible))
int16_t svmaxv_s16(svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxv_u8), arm_streaming_compatible))
uint8_t svmaxv_u8(svbool_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxv_u32), arm_streaming_compatible))
uint32_t svmaxv_u32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxv_u64), arm_streaming_compatible))
uint64_t svmaxv_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxv_u16), arm_streaming_compatible))
uint16_t svmaxv_u16(svbool_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_f64_m), arm_streaming_compatible))
svfloat64_t svmin_n_f64_m(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_f32_m), arm_streaming_compatible))
svfloat32_t svmin_n_f32_m(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_f16_m), arm_streaming_compatible))
svfloat16_t svmin_n_f16_m(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_f64_x), arm_streaming_compatible))
svfloat64_t svmin_n_f64_x(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_f32_x), arm_streaming_compatible))
svfloat32_t svmin_n_f32_x(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_f16_x), arm_streaming_compatible))
svfloat16_t svmin_n_f16_x(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_f64_z), arm_streaming_compatible))
svfloat64_t svmin_n_f64_z(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_f32_z), arm_streaming_compatible))
svfloat32_t svmin_n_f32_z(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_f16_z), arm_streaming_compatible))
svfloat16_t svmin_n_f16_z(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_s8_m), arm_streaming_compatible))
svint8_t svmin_n_s8_m(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_s32_m), arm_streaming_compatible))
svint32_t svmin_n_s32_m(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_s64_m), arm_streaming_compatible))
svint64_t svmin_n_s64_m(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_s16_m), arm_streaming_compatible))
svint16_t svmin_n_s16_m(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_s8_x), arm_streaming_compatible))
svint8_t svmin_n_s8_x(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_s32_x), arm_streaming_compatible))
svint32_t svmin_n_s32_x(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_s64_x), arm_streaming_compatible))
svint64_t svmin_n_s64_x(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_s16_x), arm_streaming_compatible))
svint16_t svmin_n_s16_x(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_s8_z), arm_streaming_compatible))
svint8_t svmin_n_s8_z(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_s32_z), arm_streaming_compatible))
svint32_t svmin_n_s32_z(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_s64_z), arm_streaming_compatible))
svint64_t svmin_n_s64_z(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_s16_z), arm_streaming_compatible))
svint16_t svmin_n_s16_z(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_u8_m), arm_streaming_compatible))
svuint8_t svmin_n_u8_m(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_u32_m), arm_streaming_compatible))
svuint32_t svmin_n_u32_m(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_u64_m), arm_streaming_compatible))
svuint64_t svmin_n_u64_m(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_u16_m), arm_streaming_compatible))
svuint16_t svmin_n_u16_m(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_u8_x), arm_streaming_compatible))
svuint8_t svmin_n_u8_x(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_u32_x), arm_streaming_compatible))
svuint32_t svmin_n_u32_x(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_u64_x), arm_streaming_compatible))
svuint64_t svmin_n_u64_x(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_u16_x), arm_streaming_compatible))
svuint16_t svmin_n_u16_x(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_u8_z), arm_streaming_compatible))
svuint8_t svmin_n_u8_z(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_u32_z), arm_streaming_compatible))
svuint32_t svmin_n_u32_z(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_u64_z), arm_streaming_compatible))
svuint64_t svmin_n_u64_z(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_u16_z), arm_streaming_compatible))
svuint16_t svmin_n_u16_z(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_f64_m), arm_streaming_compatible))
svfloat64_t svmin_f64_m(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_f32_m), arm_streaming_compatible))
svfloat32_t svmin_f32_m(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_f16_m), arm_streaming_compatible))
svfloat16_t svmin_f16_m(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_f64_x), arm_streaming_compatible))
svfloat64_t svmin_f64_x(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_f32_x), arm_streaming_compatible))
svfloat32_t svmin_f32_x(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_f16_x), arm_streaming_compatible))
svfloat16_t svmin_f16_x(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_f64_z), arm_streaming_compatible))
svfloat64_t svmin_f64_z(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_f32_z), arm_streaming_compatible))
svfloat32_t svmin_f32_z(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_f16_z), arm_streaming_compatible))
svfloat16_t svmin_f16_z(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s8_m), arm_streaming_compatible))
svint8_t svmin_s8_m(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s32_m), arm_streaming_compatible))
svint32_t svmin_s32_m(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s64_m), arm_streaming_compatible))
svint64_t svmin_s64_m(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s16_m), arm_streaming_compatible))
svint16_t svmin_s16_m(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s8_x), arm_streaming_compatible))
svint8_t svmin_s8_x(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s32_x), arm_streaming_compatible))
svint32_t svmin_s32_x(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s64_x), arm_streaming_compatible))
svint64_t svmin_s64_x(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s16_x), arm_streaming_compatible))
svint16_t svmin_s16_x(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s8_z), arm_streaming_compatible))
svint8_t svmin_s8_z(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s32_z), arm_streaming_compatible))
svint32_t svmin_s32_z(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s64_z), arm_streaming_compatible))
svint64_t svmin_s64_z(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s16_z), arm_streaming_compatible))
svint16_t svmin_s16_z(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u8_m), arm_streaming_compatible))
svuint8_t svmin_u8_m(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u32_m), arm_streaming_compatible))
svuint32_t svmin_u32_m(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u64_m), arm_streaming_compatible))
svuint64_t svmin_u64_m(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u16_m), arm_streaming_compatible))
svuint16_t svmin_u16_m(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u8_x), arm_streaming_compatible))
svuint8_t svmin_u8_x(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u32_x), arm_streaming_compatible))
svuint32_t svmin_u32_x(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u64_x), arm_streaming_compatible))
svuint64_t svmin_u64_x(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u16_x), arm_streaming_compatible))
svuint16_t svmin_u16_x(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u8_z), arm_streaming_compatible))
svuint8_t svmin_u8_z(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u32_z), arm_streaming_compatible))
svuint32_t svmin_u32_z(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u64_z), arm_streaming_compatible))
svuint64_t svmin_u64_z(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u16_z), arm_streaming_compatible))
svuint16_t svmin_u16_z(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_n_f64_m), arm_streaming_compatible))
svfloat64_t svminnm_n_f64_m(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_n_f32_m), arm_streaming_compatible))
svfloat32_t svminnm_n_f32_m(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_n_f16_m), arm_streaming_compatible))
svfloat16_t svminnm_n_f16_m(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_n_f64_x), arm_streaming_compatible))
svfloat64_t svminnm_n_f64_x(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_n_f32_x), arm_streaming_compatible))
svfloat32_t svminnm_n_f32_x(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_n_f16_x), arm_streaming_compatible))
svfloat16_t svminnm_n_f16_x(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_n_f64_z), arm_streaming_compatible))
svfloat64_t svminnm_n_f64_z(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_n_f32_z), arm_streaming_compatible))
svfloat32_t svminnm_n_f32_z(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_n_f16_z), arm_streaming_compatible))
svfloat16_t svminnm_n_f16_z(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_f64_m), arm_streaming_compatible))
svfloat64_t svminnm_f64_m(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_f32_m), arm_streaming_compatible))
svfloat32_t svminnm_f32_m(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_f16_m), arm_streaming_compatible))
svfloat16_t svminnm_f16_m(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_f64_x), arm_streaming_compatible))
svfloat64_t svminnm_f64_x(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_f32_x), arm_streaming_compatible))
svfloat32_t svminnm_f32_x(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_f16_x), arm_streaming_compatible))
svfloat16_t svminnm_f16_x(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_f64_z), arm_streaming_compatible))
svfloat64_t svminnm_f64_z(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_f32_z), arm_streaming_compatible))
svfloat32_t svminnm_f32_z(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_f16_z), arm_streaming_compatible))
svfloat16_t svminnm_f16_z(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnmv_f64), arm_streaming_compatible))
float64_t svminnmv_f64(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnmv_f32), arm_streaming_compatible))
float32_t svminnmv_f32(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnmv_f16), arm_streaming_compatible))
float16_t svminnmv_f16(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminv_f64), arm_streaming_compatible))
float64_t svminv_f64(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminv_f32), arm_streaming_compatible))
float32_t svminv_f32(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminv_f16), arm_streaming_compatible))
float16_t svminv_f16(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminv_s8), arm_streaming_compatible))
int8_t svminv_s8(svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminv_s32), arm_streaming_compatible))
int32_t svminv_s32(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminv_s64), arm_streaming_compatible))
int64_t svminv_s64(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminv_s16), arm_streaming_compatible))
int16_t svminv_s16(svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminv_u8), arm_streaming_compatible))
uint8_t svminv_u8(svbool_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminv_u32), arm_streaming_compatible))
uint32_t svminv_u32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminv_u64), arm_streaming_compatible))
uint64_t svminv_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminv_u16), arm_streaming_compatible))
uint16_t svminv_u16(svbool_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_f64_m)))
svfloat64_t svmla_n_f64_m(svbool_t, svfloat64_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_f32_m)))
svfloat32_t svmla_n_f32_m(svbool_t, svfloat32_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_f16_m)))
svfloat16_t svmla_n_f16_m(svbool_t, svfloat16_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_f64_x)))
svfloat64_t svmla_n_f64_x(svbool_t, svfloat64_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_f32_x)))
svfloat32_t svmla_n_f32_x(svbool_t, svfloat32_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_f16_x)))
svfloat16_t svmla_n_f16_x(svbool_t, svfloat16_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_f64_z)))
svfloat64_t svmla_n_f64_z(svbool_t, svfloat64_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_f32_z)))
svfloat32_t svmla_n_f32_z(svbool_t, svfloat32_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_f16_z)))
svfloat16_t svmla_n_f16_z(svbool_t, svfloat16_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_u8_m), arm_streaming_compatible))
svuint8_t svmla_n_u8_m(svbool_t, svuint8_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_u32_m), arm_streaming_compatible))
svuint32_t svmla_n_u32_m(svbool_t, svuint32_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_u64_m), arm_streaming_compatible))
svuint64_t svmla_n_u64_m(svbool_t, svuint64_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_u16_m), arm_streaming_compatible))
svuint16_t svmla_n_u16_m(svbool_t, svuint16_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_s8_m), arm_streaming_compatible))
svint8_t svmla_n_s8_m(svbool_t, svint8_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_s32_m), arm_streaming_compatible))
svint32_t svmla_n_s32_m(svbool_t, svint32_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_s64_m), arm_streaming_compatible))
svint64_t svmla_n_s64_m(svbool_t, svint64_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_s16_m), arm_streaming_compatible))
svint16_t svmla_n_s16_m(svbool_t, svint16_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_u8_x), arm_streaming_compatible))
svuint8_t svmla_n_u8_x(svbool_t, svuint8_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_u32_x), arm_streaming_compatible))
svuint32_t svmla_n_u32_x(svbool_t, svuint32_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_u64_x), arm_streaming_compatible))
svuint64_t svmla_n_u64_x(svbool_t, svuint64_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_u16_x), arm_streaming_compatible))
svuint16_t svmla_n_u16_x(svbool_t, svuint16_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_s8_x), arm_streaming_compatible))
svint8_t svmla_n_s8_x(svbool_t, svint8_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_s32_x), arm_streaming_compatible))
svint32_t svmla_n_s32_x(svbool_t, svint32_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_s64_x), arm_streaming_compatible))
svint64_t svmla_n_s64_x(svbool_t, svint64_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_s16_x), arm_streaming_compatible))
svint16_t svmla_n_s16_x(svbool_t, svint16_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_u8_z), arm_streaming_compatible))
svuint8_t svmla_n_u8_z(svbool_t, svuint8_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_u32_z), arm_streaming_compatible))
svuint32_t svmla_n_u32_z(svbool_t, svuint32_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_u64_z), arm_streaming_compatible))
svuint64_t svmla_n_u64_z(svbool_t, svuint64_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_u16_z), arm_streaming_compatible))
svuint16_t svmla_n_u16_z(svbool_t, svuint16_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_s8_z), arm_streaming_compatible))
svint8_t svmla_n_s8_z(svbool_t, svint8_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_s32_z), arm_streaming_compatible))
svint32_t svmla_n_s32_z(svbool_t, svint32_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_s64_z), arm_streaming_compatible))
svint64_t svmla_n_s64_z(svbool_t, svint64_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_s16_z), arm_streaming_compatible))
svint16_t svmla_n_s16_z(svbool_t, svint16_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_f64_m)))
svfloat64_t svmla_f64_m(svbool_t, svfloat64_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_f32_m)))
svfloat32_t svmla_f32_m(svbool_t, svfloat32_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_f16_m)))
svfloat16_t svmla_f16_m(svbool_t, svfloat16_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_f64_x)))
svfloat64_t svmla_f64_x(svbool_t, svfloat64_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_f32_x)))
svfloat32_t svmla_f32_x(svbool_t, svfloat32_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_f16_x)))
svfloat16_t svmla_f16_x(svbool_t, svfloat16_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_f64_z)))
svfloat64_t svmla_f64_z(svbool_t, svfloat64_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_f32_z)))
svfloat32_t svmla_f32_z(svbool_t, svfloat32_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_f16_z)))
svfloat16_t svmla_f16_z(svbool_t, svfloat16_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_u8_m), arm_streaming_compatible))
svuint8_t svmla_u8_m(svbool_t, svuint8_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_u32_m), arm_streaming_compatible))
svuint32_t svmla_u32_m(svbool_t, svuint32_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_u64_m), arm_streaming_compatible))
svuint64_t svmla_u64_m(svbool_t, svuint64_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_u16_m), arm_streaming_compatible))
svuint16_t svmla_u16_m(svbool_t, svuint16_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_s8_m), arm_streaming_compatible))
svint8_t svmla_s8_m(svbool_t, svint8_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_s32_m), arm_streaming_compatible))
svint32_t svmla_s32_m(svbool_t, svint32_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_s64_m), arm_streaming_compatible))
svint64_t svmla_s64_m(svbool_t, svint64_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_s16_m), arm_streaming_compatible))
svint16_t svmla_s16_m(svbool_t, svint16_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_u8_x), arm_streaming_compatible))
svuint8_t svmla_u8_x(svbool_t, svuint8_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_u32_x), arm_streaming_compatible))
svuint32_t svmla_u32_x(svbool_t, svuint32_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_u64_x), arm_streaming_compatible))
svuint64_t svmla_u64_x(svbool_t, svuint64_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_u16_x), arm_streaming_compatible))
svuint16_t svmla_u16_x(svbool_t, svuint16_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_s8_x), arm_streaming_compatible))
svint8_t svmla_s8_x(svbool_t, svint8_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_s32_x), arm_streaming_compatible))
svint32_t svmla_s32_x(svbool_t, svint32_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_s64_x), arm_streaming_compatible))
svint64_t svmla_s64_x(svbool_t, svint64_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_s16_x), arm_streaming_compatible))
svint16_t svmla_s16_x(svbool_t, svint16_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_u8_z), arm_streaming_compatible))
svuint8_t svmla_u8_z(svbool_t, svuint8_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_u32_z), arm_streaming_compatible))
svuint32_t svmla_u32_z(svbool_t, svuint32_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_u64_z), arm_streaming_compatible))
svuint64_t svmla_u64_z(svbool_t, svuint64_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_u16_z), arm_streaming_compatible))
svuint16_t svmla_u16_z(svbool_t, svuint16_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_s8_z), arm_streaming_compatible))
svint8_t svmla_s8_z(svbool_t, svint8_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_s32_z), arm_streaming_compatible))
svint32_t svmla_s32_z(svbool_t, svint32_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_s64_z), arm_streaming_compatible))
svint64_t svmla_s64_z(svbool_t, svint64_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_s16_z), arm_streaming_compatible))
svint16_t svmla_s16_z(svbool_t, svint16_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_lane_f64), arm_streaming_compatible))
svfloat64_t svmla_lane_f64(svfloat64_t, svfloat64_t, svfloat64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_lane_f32), arm_streaming_compatible))
svfloat32_t svmla_lane_f32(svfloat32_t, svfloat32_t, svfloat32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_lane_f16), arm_streaming_compatible))
svfloat16_t svmla_lane_f16(svfloat16_t, svfloat16_t, svfloat16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_f64_m)))
svfloat64_t svmls_n_f64_m(svbool_t, svfloat64_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_f32_m)))
svfloat32_t svmls_n_f32_m(svbool_t, svfloat32_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_f16_m)))
svfloat16_t svmls_n_f16_m(svbool_t, svfloat16_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_f64_x)))
svfloat64_t svmls_n_f64_x(svbool_t, svfloat64_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_f32_x)))
svfloat32_t svmls_n_f32_x(svbool_t, svfloat32_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_f16_x)))
svfloat16_t svmls_n_f16_x(svbool_t, svfloat16_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_f64_z)))
svfloat64_t svmls_n_f64_z(svbool_t, svfloat64_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_f32_z)))
svfloat32_t svmls_n_f32_z(svbool_t, svfloat32_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_f16_z)))
svfloat16_t svmls_n_f16_z(svbool_t, svfloat16_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_u8_m), arm_streaming_compatible))
svuint8_t svmls_n_u8_m(svbool_t, svuint8_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_u32_m), arm_streaming_compatible))
svuint32_t svmls_n_u32_m(svbool_t, svuint32_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_u64_m), arm_streaming_compatible))
svuint64_t svmls_n_u64_m(svbool_t, svuint64_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_u16_m), arm_streaming_compatible))
svuint16_t svmls_n_u16_m(svbool_t, svuint16_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_s8_m), arm_streaming_compatible))
svint8_t svmls_n_s8_m(svbool_t, svint8_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_s32_m), arm_streaming_compatible))
svint32_t svmls_n_s32_m(svbool_t, svint32_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_s64_m), arm_streaming_compatible))
svint64_t svmls_n_s64_m(svbool_t, svint64_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_s16_m), arm_streaming_compatible))
svint16_t svmls_n_s16_m(svbool_t, svint16_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_u8_x), arm_streaming_compatible))
svuint8_t svmls_n_u8_x(svbool_t, svuint8_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_u32_x), arm_streaming_compatible))
svuint32_t svmls_n_u32_x(svbool_t, svuint32_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_u64_x), arm_streaming_compatible))
svuint64_t svmls_n_u64_x(svbool_t, svuint64_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_u16_x), arm_streaming_compatible))
svuint16_t svmls_n_u16_x(svbool_t, svuint16_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_s8_x), arm_streaming_compatible))
svint8_t svmls_n_s8_x(svbool_t, svint8_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_s32_x), arm_streaming_compatible))
svint32_t svmls_n_s32_x(svbool_t, svint32_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_s64_x), arm_streaming_compatible))
svint64_t svmls_n_s64_x(svbool_t, svint64_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_s16_x), arm_streaming_compatible))
svint16_t svmls_n_s16_x(svbool_t, svint16_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_u8_z), arm_streaming_compatible))
svuint8_t svmls_n_u8_z(svbool_t, svuint8_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_u32_z), arm_streaming_compatible))
svuint32_t svmls_n_u32_z(svbool_t, svuint32_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_u64_z), arm_streaming_compatible))
svuint64_t svmls_n_u64_z(svbool_t, svuint64_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_u16_z), arm_streaming_compatible))
svuint16_t svmls_n_u16_z(svbool_t, svuint16_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_s8_z), arm_streaming_compatible))
svint8_t svmls_n_s8_z(svbool_t, svint8_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_s32_z), arm_streaming_compatible))
svint32_t svmls_n_s32_z(svbool_t, svint32_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_s64_z), arm_streaming_compatible))
svint64_t svmls_n_s64_z(svbool_t, svint64_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_s16_z), arm_streaming_compatible))
svint16_t svmls_n_s16_z(svbool_t, svint16_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_f64_m)))
svfloat64_t svmls_f64_m(svbool_t, svfloat64_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_f32_m)))
svfloat32_t svmls_f32_m(svbool_t, svfloat32_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_f16_m)))
svfloat16_t svmls_f16_m(svbool_t, svfloat16_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_f64_x)))
svfloat64_t svmls_f64_x(svbool_t, svfloat64_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_f32_x)))
svfloat32_t svmls_f32_x(svbool_t, svfloat32_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_f16_x)))
svfloat16_t svmls_f16_x(svbool_t, svfloat16_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_f64_z)))
svfloat64_t svmls_f64_z(svbool_t, svfloat64_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_f32_z)))
svfloat32_t svmls_f32_z(svbool_t, svfloat32_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_f16_z)))
svfloat16_t svmls_f16_z(svbool_t, svfloat16_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_u8_m), arm_streaming_compatible))
svuint8_t svmls_u8_m(svbool_t, svuint8_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_u32_m), arm_streaming_compatible))
svuint32_t svmls_u32_m(svbool_t, svuint32_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_u64_m), arm_streaming_compatible))
svuint64_t svmls_u64_m(svbool_t, svuint64_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_u16_m), arm_streaming_compatible))
svuint16_t svmls_u16_m(svbool_t, svuint16_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_s8_m), arm_streaming_compatible))
svint8_t svmls_s8_m(svbool_t, svint8_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_s32_m), arm_streaming_compatible))
svint32_t svmls_s32_m(svbool_t, svint32_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_s64_m), arm_streaming_compatible))
svint64_t svmls_s64_m(svbool_t, svint64_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_s16_m), arm_streaming_compatible))
svint16_t svmls_s16_m(svbool_t, svint16_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_u8_x), arm_streaming_compatible))
svuint8_t svmls_u8_x(svbool_t, svuint8_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_u32_x), arm_streaming_compatible))
svuint32_t svmls_u32_x(svbool_t, svuint32_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_u64_x), arm_streaming_compatible))
svuint64_t svmls_u64_x(svbool_t, svuint64_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_u16_x), arm_streaming_compatible))
svuint16_t svmls_u16_x(svbool_t, svuint16_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_s8_x), arm_streaming_compatible))
svint8_t svmls_s8_x(svbool_t, svint8_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_s32_x), arm_streaming_compatible))
svint32_t svmls_s32_x(svbool_t, svint32_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_s64_x), arm_streaming_compatible))
svint64_t svmls_s64_x(svbool_t, svint64_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_s16_x), arm_streaming_compatible))
svint16_t svmls_s16_x(svbool_t, svint16_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_u8_z), arm_streaming_compatible))
svuint8_t svmls_u8_z(svbool_t, svuint8_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_u32_z), arm_streaming_compatible))
svuint32_t svmls_u32_z(svbool_t, svuint32_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_u64_z), arm_streaming_compatible))
svuint64_t svmls_u64_z(svbool_t, svuint64_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_u16_z), arm_streaming_compatible))
svuint16_t svmls_u16_z(svbool_t, svuint16_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_s8_z), arm_streaming_compatible))
svint8_t svmls_s8_z(svbool_t, svint8_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_s32_z), arm_streaming_compatible))
svint32_t svmls_s32_z(svbool_t, svint32_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_s64_z), arm_streaming_compatible))
svint64_t svmls_s64_z(svbool_t, svint64_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_s16_z), arm_streaming_compatible))
svint16_t svmls_s16_z(svbool_t, svint16_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_lane_f64), arm_streaming_compatible))
svfloat64_t svmls_lane_f64(svfloat64_t, svfloat64_t, svfloat64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_lane_f32), arm_streaming_compatible))
svfloat32_t svmls_lane_f32(svfloat32_t, svfloat32_t, svfloat32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_lane_f16), arm_streaming_compatible))
svfloat16_t svmls_lane_f16(svfloat16_t, svfloat16_t, svfloat16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmov_b_z), arm_streaming_compatible))
svbool_t svmov_b_z(svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_n_f64_m)))
svfloat64_t svmsb_n_f64_m(svbool_t, svfloat64_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_n_f32_m)))
svfloat32_t svmsb_n_f32_m(svbool_t, svfloat32_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_n_f16_m)))
svfloat16_t svmsb_n_f16_m(svbool_t, svfloat16_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_n_f64_x)))
svfloat64_t svmsb_n_f64_x(svbool_t, svfloat64_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_n_f32_x)))
svfloat32_t svmsb_n_f32_x(svbool_t, svfloat32_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_n_f16_x)))
svfloat16_t svmsb_n_f16_x(svbool_t, svfloat16_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_n_f64_z)))
svfloat64_t svmsb_n_f64_z(svbool_t, svfloat64_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_n_f32_z)))
svfloat32_t svmsb_n_f32_z(svbool_t, svfloat32_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_n_f16_z)))
svfloat16_t svmsb_n_f16_z(svbool_t, svfloat16_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_n_u8_m), arm_streaming_compatible))
svuint8_t svmsb_n_u8_m(svbool_t, svuint8_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_n_u32_m), arm_streaming_compatible))
svuint32_t svmsb_n_u32_m(svbool_t, svuint32_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_n_u64_m), arm_streaming_compatible))
svuint64_t svmsb_n_u64_m(svbool_t, svuint64_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_n_u16_m), arm_streaming_compatible))
svuint16_t svmsb_n_u16_m(svbool_t, svuint16_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_n_s8_m), arm_streaming_compatible))
svint8_t svmsb_n_s8_m(svbool_t, svint8_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_n_s32_m), arm_streaming_compatible))
svint32_t svmsb_n_s32_m(svbool_t, svint32_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_n_s64_m), arm_streaming_compatible))
svint64_t svmsb_n_s64_m(svbool_t, svint64_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_n_s16_m), arm_streaming_compatible))
svint16_t svmsb_n_s16_m(svbool_t, svint16_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_n_u8_x), arm_streaming_compatible))
svuint8_t svmsb_n_u8_x(svbool_t, svuint8_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_n_u32_x), arm_streaming_compatible))
svuint32_t svmsb_n_u32_x(svbool_t, svuint32_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_n_u64_x), arm_streaming_compatible))
svuint64_t svmsb_n_u64_x(svbool_t, svuint64_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_n_u16_x), arm_streaming_compatible))
svuint16_t svmsb_n_u16_x(svbool_t, svuint16_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_n_s8_x), arm_streaming_compatible))
svint8_t svmsb_n_s8_x(svbool_t, svint8_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_n_s32_x), arm_streaming_compatible))
svint32_t svmsb_n_s32_x(svbool_t, svint32_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_n_s64_x), arm_streaming_compatible))
svint64_t svmsb_n_s64_x(svbool_t, svint64_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_n_s16_x), arm_streaming_compatible))
svint16_t svmsb_n_s16_x(svbool_t, svint16_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_n_u8_z), arm_streaming_compatible))
svuint8_t svmsb_n_u8_z(svbool_t, svuint8_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_n_u32_z), arm_streaming_compatible))
svuint32_t svmsb_n_u32_z(svbool_t, svuint32_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_n_u64_z), arm_streaming_compatible))
svuint64_t svmsb_n_u64_z(svbool_t, svuint64_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_n_u16_z), arm_streaming_compatible))
svuint16_t svmsb_n_u16_z(svbool_t, svuint16_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_n_s8_z), arm_streaming_compatible))
svint8_t svmsb_n_s8_z(svbool_t, svint8_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_n_s32_z), arm_streaming_compatible))
svint32_t svmsb_n_s32_z(svbool_t, svint32_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_n_s64_z), arm_streaming_compatible))
svint64_t svmsb_n_s64_z(svbool_t, svint64_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_n_s16_z), arm_streaming_compatible))
svint16_t svmsb_n_s16_z(svbool_t, svint16_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_f64_m)))
svfloat64_t svmsb_f64_m(svbool_t, svfloat64_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_f32_m)))
svfloat32_t svmsb_f32_m(svbool_t, svfloat32_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_f16_m)))
svfloat16_t svmsb_f16_m(svbool_t, svfloat16_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_f64_x)))
svfloat64_t svmsb_f64_x(svbool_t, svfloat64_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_f32_x)))
svfloat32_t svmsb_f32_x(svbool_t, svfloat32_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_f16_x)))
svfloat16_t svmsb_f16_x(svbool_t, svfloat16_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_f64_z)))
svfloat64_t svmsb_f64_z(svbool_t, svfloat64_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_f32_z)))
svfloat32_t svmsb_f32_z(svbool_t, svfloat32_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_f16_z)))
svfloat16_t svmsb_f16_z(svbool_t, svfloat16_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_u8_m), arm_streaming_compatible))
svuint8_t svmsb_u8_m(svbool_t, svuint8_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_u32_m), arm_streaming_compatible))
svuint32_t svmsb_u32_m(svbool_t, svuint32_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_u64_m), arm_streaming_compatible))
svuint64_t svmsb_u64_m(svbool_t, svuint64_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_u16_m), arm_streaming_compatible))
svuint16_t svmsb_u16_m(svbool_t, svuint16_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_s8_m), arm_streaming_compatible))
svint8_t svmsb_s8_m(svbool_t, svint8_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_s32_m), arm_streaming_compatible))
svint32_t svmsb_s32_m(svbool_t, svint32_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_s64_m), arm_streaming_compatible))
svint64_t svmsb_s64_m(svbool_t, svint64_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_s16_m), arm_streaming_compatible))
svint16_t svmsb_s16_m(svbool_t, svint16_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_u8_x), arm_streaming_compatible))
svuint8_t svmsb_u8_x(svbool_t, svuint8_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_u32_x), arm_streaming_compatible))
svuint32_t svmsb_u32_x(svbool_t, svuint32_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_u64_x), arm_streaming_compatible))
svuint64_t svmsb_u64_x(svbool_t, svuint64_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_u16_x), arm_streaming_compatible))
svuint16_t svmsb_u16_x(svbool_t, svuint16_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_s8_x), arm_streaming_compatible))
svint8_t svmsb_s8_x(svbool_t, svint8_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_s32_x), arm_streaming_compatible))
svint32_t svmsb_s32_x(svbool_t, svint32_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_s64_x), arm_streaming_compatible))
svint64_t svmsb_s64_x(svbool_t, svint64_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_s16_x), arm_streaming_compatible))
svint16_t svmsb_s16_x(svbool_t, svint16_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_u8_z), arm_streaming_compatible))
svuint8_t svmsb_u8_z(svbool_t, svuint8_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_u32_z), arm_streaming_compatible))
svuint32_t svmsb_u32_z(svbool_t, svuint32_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_u64_z), arm_streaming_compatible))
svuint64_t svmsb_u64_z(svbool_t, svuint64_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_u16_z), arm_streaming_compatible))
svuint16_t svmsb_u16_z(svbool_t, svuint16_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_s8_z), arm_streaming_compatible))
svint8_t svmsb_s8_z(svbool_t, svint8_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_s32_z), arm_streaming_compatible))
svint32_t svmsb_s32_z(svbool_t, svint32_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_s64_z), arm_streaming_compatible))
svint64_t svmsb_s64_z(svbool_t, svint64_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmsb_s16_z), arm_streaming_compatible))
svint16_t svmsb_s16_z(svbool_t, svint16_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_f64_m), arm_streaming_compatible))
svfloat64_t svmul_n_f64_m(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_f32_m), arm_streaming_compatible))
svfloat32_t svmul_n_f32_m(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_f16_m), arm_streaming_compatible))
svfloat16_t svmul_n_f16_m(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_f64_x), arm_streaming_compatible))
svfloat64_t svmul_n_f64_x(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_f32_x), arm_streaming_compatible))
svfloat32_t svmul_n_f32_x(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_f16_x), arm_streaming_compatible))
svfloat16_t svmul_n_f16_x(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_f64_z), arm_streaming_compatible))
svfloat64_t svmul_n_f64_z(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_f32_z), arm_streaming_compatible))
svfloat32_t svmul_n_f32_z(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_f16_z), arm_streaming_compatible))
svfloat16_t svmul_n_f16_z(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_u8_m), arm_streaming_compatible))
svuint8_t svmul_n_u8_m(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_u32_m), arm_streaming_compatible))
svuint32_t svmul_n_u32_m(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_u64_m), arm_streaming_compatible))
svuint64_t svmul_n_u64_m(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_u16_m), arm_streaming_compatible))
svuint16_t svmul_n_u16_m(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_s8_m), arm_streaming_compatible))
svint8_t svmul_n_s8_m(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_s32_m), arm_streaming_compatible))
svint32_t svmul_n_s32_m(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_s64_m), arm_streaming_compatible))
svint64_t svmul_n_s64_m(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_s16_m), arm_streaming_compatible))
svint16_t svmul_n_s16_m(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_u8_x), arm_streaming_compatible))
svuint8_t svmul_n_u8_x(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_u32_x), arm_streaming_compatible))
svuint32_t svmul_n_u32_x(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_u64_x), arm_streaming_compatible))
svuint64_t svmul_n_u64_x(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_u16_x), arm_streaming_compatible))
svuint16_t svmul_n_u16_x(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_s8_x), arm_streaming_compatible))
svint8_t svmul_n_s8_x(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_s32_x), arm_streaming_compatible))
svint32_t svmul_n_s32_x(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_s64_x), arm_streaming_compatible))
svint64_t svmul_n_s64_x(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_s16_x), arm_streaming_compatible))
svint16_t svmul_n_s16_x(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_u8_z), arm_streaming_compatible))
svuint8_t svmul_n_u8_z(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_u32_z), arm_streaming_compatible))
svuint32_t svmul_n_u32_z(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_u64_z), arm_streaming_compatible))
svuint64_t svmul_n_u64_z(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_u16_z), arm_streaming_compatible))
svuint16_t svmul_n_u16_z(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_s8_z), arm_streaming_compatible))
svint8_t svmul_n_s8_z(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_s32_z), arm_streaming_compatible))
svint32_t svmul_n_s32_z(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_s64_z), arm_streaming_compatible))
svint64_t svmul_n_s64_z(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_s16_z), arm_streaming_compatible))
svint16_t svmul_n_s16_z(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_f64_m), arm_streaming_compatible))
svfloat64_t svmul_f64_m(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_f32_m), arm_streaming_compatible))
svfloat32_t svmul_f32_m(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_f16_m), arm_streaming_compatible))
svfloat16_t svmul_f16_m(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_f64_x), arm_streaming_compatible))
svfloat64_t svmul_f64_x(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_f32_x), arm_streaming_compatible))
svfloat32_t svmul_f32_x(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_f16_x), arm_streaming_compatible))
svfloat16_t svmul_f16_x(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_f64_z), arm_streaming_compatible))
svfloat64_t svmul_f64_z(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_f32_z), arm_streaming_compatible))
svfloat32_t svmul_f32_z(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_f16_z), arm_streaming_compatible))
svfloat16_t svmul_f16_z(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_u8_m), arm_streaming_compatible))
svuint8_t svmul_u8_m(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_u32_m), arm_streaming_compatible))
svuint32_t svmul_u32_m(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_u64_m), arm_streaming_compatible))
svuint64_t svmul_u64_m(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_u16_m), arm_streaming_compatible))
svuint16_t svmul_u16_m(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_s8_m), arm_streaming_compatible))
svint8_t svmul_s8_m(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_s32_m), arm_streaming_compatible))
svint32_t svmul_s32_m(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_s64_m), arm_streaming_compatible))
svint64_t svmul_s64_m(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_s16_m), arm_streaming_compatible))
svint16_t svmul_s16_m(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_u8_x), arm_streaming_compatible))
svuint8_t svmul_u8_x(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_u32_x), arm_streaming_compatible))
svuint32_t svmul_u32_x(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_u64_x), arm_streaming_compatible))
svuint64_t svmul_u64_x(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_u16_x), arm_streaming_compatible))
svuint16_t svmul_u16_x(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_s8_x), arm_streaming_compatible))
svint8_t svmul_s8_x(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_s32_x), arm_streaming_compatible))
svint32_t svmul_s32_x(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_s64_x), arm_streaming_compatible))
svint64_t svmul_s64_x(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_s16_x), arm_streaming_compatible))
svint16_t svmul_s16_x(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_u8_z), arm_streaming_compatible))
svuint8_t svmul_u8_z(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_u32_z), arm_streaming_compatible))
svuint32_t svmul_u32_z(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_u64_z), arm_streaming_compatible))
svuint64_t svmul_u64_z(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_u16_z), arm_streaming_compatible))
svuint16_t svmul_u16_z(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_s8_z), arm_streaming_compatible))
svint8_t svmul_s8_z(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_s32_z), arm_streaming_compatible))
svint32_t svmul_s32_z(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_s64_z), arm_streaming_compatible))
svint64_t svmul_s64_z(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_s16_z), arm_streaming_compatible))
svint16_t svmul_s16_z(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_lane_f64), arm_streaming_compatible))
svfloat64_t svmul_lane_f64(svfloat64_t, svfloat64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_lane_f32), arm_streaming_compatible))
svfloat32_t svmul_lane_f32(svfloat32_t, svfloat32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_lane_f16), arm_streaming_compatible))
svfloat16_t svmul_lane_f16(svfloat16_t, svfloat16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_n_s8_m), arm_streaming_compatible))
svint8_t svmulh_n_s8_m(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_n_s32_m), arm_streaming_compatible))
svint32_t svmulh_n_s32_m(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_n_s64_m), arm_streaming_compatible))
svint64_t svmulh_n_s64_m(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_n_s16_m), arm_streaming_compatible))
svint16_t svmulh_n_s16_m(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_n_s8_x), arm_streaming_compatible))
svint8_t svmulh_n_s8_x(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_n_s32_x), arm_streaming_compatible))
svint32_t svmulh_n_s32_x(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_n_s64_x), arm_streaming_compatible))
svint64_t svmulh_n_s64_x(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_n_s16_x), arm_streaming_compatible))
svint16_t svmulh_n_s16_x(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_n_s8_z), arm_streaming_compatible))
svint8_t svmulh_n_s8_z(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_n_s32_z), arm_streaming_compatible))
svint32_t svmulh_n_s32_z(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_n_s64_z), arm_streaming_compatible))
svint64_t svmulh_n_s64_z(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_n_s16_z), arm_streaming_compatible))
svint16_t svmulh_n_s16_z(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_n_u8_m), arm_streaming_compatible))
svuint8_t svmulh_n_u8_m(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_n_u32_m), arm_streaming_compatible))
svuint32_t svmulh_n_u32_m(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_n_u64_m), arm_streaming_compatible))
svuint64_t svmulh_n_u64_m(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_n_u16_m), arm_streaming_compatible))
svuint16_t svmulh_n_u16_m(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_n_u8_x), arm_streaming_compatible))
svuint8_t svmulh_n_u8_x(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_n_u32_x), arm_streaming_compatible))
svuint32_t svmulh_n_u32_x(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_n_u64_x), arm_streaming_compatible))
svuint64_t svmulh_n_u64_x(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_n_u16_x), arm_streaming_compatible))
svuint16_t svmulh_n_u16_x(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_n_u8_z), arm_streaming_compatible))
svuint8_t svmulh_n_u8_z(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_n_u32_z), arm_streaming_compatible))
svuint32_t svmulh_n_u32_z(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_n_u64_z), arm_streaming_compatible))
svuint64_t svmulh_n_u64_z(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_n_u16_z), arm_streaming_compatible))
svuint16_t svmulh_n_u16_z(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_s8_m), arm_streaming_compatible))
svint8_t svmulh_s8_m(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_s32_m), arm_streaming_compatible))
svint32_t svmulh_s32_m(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_s64_m), arm_streaming_compatible))
svint64_t svmulh_s64_m(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_s16_m), arm_streaming_compatible))
svint16_t svmulh_s16_m(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_s8_x), arm_streaming_compatible))
svint8_t svmulh_s8_x(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_s32_x), arm_streaming_compatible))
svint32_t svmulh_s32_x(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_s64_x), arm_streaming_compatible))
svint64_t svmulh_s64_x(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_s16_x), arm_streaming_compatible))
svint16_t svmulh_s16_x(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_s8_z), arm_streaming_compatible))
svint8_t svmulh_s8_z(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_s32_z), arm_streaming_compatible))
svint32_t svmulh_s32_z(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_s64_z), arm_streaming_compatible))
svint64_t svmulh_s64_z(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_s16_z), arm_streaming_compatible))
svint16_t svmulh_s16_z(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_u8_m), arm_streaming_compatible))
svuint8_t svmulh_u8_m(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_u32_m), arm_streaming_compatible))
svuint32_t svmulh_u32_m(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_u64_m), arm_streaming_compatible))
svuint64_t svmulh_u64_m(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_u16_m), arm_streaming_compatible))
svuint16_t svmulh_u16_m(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_u8_x), arm_streaming_compatible))
svuint8_t svmulh_u8_x(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_u32_x), arm_streaming_compatible))
svuint32_t svmulh_u32_x(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_u64_x), arm_streaming_compatible))
svuint64_t svmulh_u64_x(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_u16_x), arm_streaming_compatible))
svuint16_t svmulh_u16_x(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_u8_z), arm_streaming_compatible))
svuint8_t svmulh_u8_z(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_u32_z), arm_streaming_compatible))
svuint32_t svmulh_u32_z(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_u64_z), arm_streaming_compatible))
svuint64_t svmulh_u64_z(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulh_u16_z), arm_streaming_compatible))
svuint16_t svmulh_u16_z(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulx_n_f64_m), arm_streaming_compatible))
svfloat64_t svmulx_n_f64_m(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulx_n_f32_m), arm_streaming_compatible))
svfloat32_t svmulx_n_f32_m(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulx_n_f16_m), arm_streaming_compatible))
svfloat16_t svmulx_n_f16_m(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulx_n_f64_x), arm_streaming_compatible))
svfloat64_t svmulx_n_f64_x(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulx_n_f32_x), arm_streaming_compatible))
svfloat32_t svmulx_n_f32_x(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulx_n_f16_x), arm_streaming_compatible))
svfloat16_t svmulx_n_f16_x(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulx_n_f64_z), arm_streaming_compatible))
svfloat64_t svmulx_n_f64_z(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulx_n_f32_z), arm_streaming_compatible))
svfloat32_t svmulx_n_f32_z(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulx_n_f16_z), arm_streaming_compatible))
svfloat16_t svmulx_n_f16_z(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulx_f64_m), arm_streaming_compatible))
svfloat64_t svmulx_f64_m(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulx_f32_m), arm_streaming_compatible))
svfloat32_t svmulx_f32_m(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulx_f16_m), arm_streaming_compatible))
svfloat16_t svmulx_f16_m(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulx_f64_x), arm_streaming_compatible))
svfloat64_t svmulx_f64_x(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulx_f32_x), arm_streaming_compatible))
svfloat32_t svmulx_f32_x(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulx_f16_x), arm_streaming_compatible))
svfloat16_t svmulx_f16_x(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulx_f64_z), arm_streaming_compatible))
svfloat64_t svmulx_f64_z(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulx_f32_z), arm_streaming_compatible))
svfloat32_t svmulx_f32_z(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmulx_f16_z), arm_streaming_compatible))
svfloat16_t svmulx_f16_z(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnand_b_z), arm_streaming_compatible))
svbool_t svnand_b_z(svbool_t, svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svneg_f64_m), arm_streaming_compatible))
svfloat64_t svneg_f64_m(svfloat64_t, svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svneg_f32_m), arm_streaming_compatible))
svfloat32_t svneg_f32_m(svfloat32_t, svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svneg_f16_m), arm_streaming_compatible))
svfloat16_t svneg_f16_m(svfloat16_t, svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svneg_f64_x), arm_streaming_compatible))
svfloat64_t svneg_f64_x(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svneg_f32_x), arm_streaming_compatible))
svfloat32_t svneg_f32_x(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svneg_f16_x), arm_streaming_compatible))
svfloat16_t svneg_f16_x(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svneg_f64_z), arm_streaming_compatible))
svfloat64_t svneg_f64_z(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svneg_f32_z), arm_streaming_compatible))
svfloat32_t svneg_f32_z(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svneg_f16_z), arm_streaming_compatible))
svfloat16_t svneg_f16_z(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svneg_s8_m), arm_streaming_compatible))
svint8_t svneg_s8_m(svint8_t, svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svneg_s32_m), arm_streaming_compatible))
svint32_t svneg_s32_m(svint32_t, svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svneg_s64_m), arm_streaming_compatible))
svint64_t svneg_s64_m(svint64_t, svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svneg_s16_m), arm_streaming_compatible))
svint16_t svneg_s16_m(svint16_t, svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svneg_s8_x), arm_streaming_compatible))
svint8_t svneg_s8_x(svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svneg_s32_x), arm_streaming_compatible))
svint32_t svneg_s32_x(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svneg_s64_x), arm_streaming_compatible))
svint64_t svneg_s64_x(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svneg_s16_x), arm_streaming_compatible))
svint16_t svneg_s16_x(svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svneg_s8_z), arm_streaming_compatible))
svint8_t svneg_s8_z(svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svneg_s32_z), arm_streaming_compatible))
svint32_t svneg_s32_z(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svneg_s64_z), arm_streaming_compatible))
svint64_t svneg_s64_z(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svneg_s16_z), arm_streaming_compatible))
svint16_t svneg_s16_z(svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmad_n_f64_m)))
svfloat64_t svnmad_n_f64_m(svbool_t, svfloat64_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmad_n_f32_m)))
svfloat32_t svnmad_n_f32_m(svbool_t, svfloat32_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmad_n_f16_m)))
svfloat16_t svnmad_n_f16_m(svbool_t, svfloat16_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmad_n_f64_x)))
svfloat64_t svnmad_n_f64_x(svbool_t, svfloat64_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmad_n_f32_x)))
svfloat32_t svnmad_n_f32_x(svbool_t, svfloat32_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmad_n_f16_x)))
svfloat16_t svnmad_n_f16_x(svbool_t, svfloat16_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmad_n_f64_z)))
svfloat64_t svnmad_n_f64_z(svbool_t, svfloat64_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmad_n_f32_z)))
svfloat32_t svnmad_n_f32_z(svbool_t, svfloat32_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmad_n_f16_z)))
svfloat16_t svnmad_n_f16_z(svbool_t, svfloat16_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmad_f64_m)))
svfloat64_t svnmad_f64_m(svbool_t, svfloat64_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmad_f32_m)))
svfloat32_t svnmad_f32_m(svbool_t, svfloat32_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmad_f16_m)))
svfloat16_t svnmad_f16_m(svbool_t, svfloat16_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmad_f64_x)))
svfloat64_t svnmad_f64_x(svbool_t, svfloat64_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmad_f32_x)))
svfloat32_t svnmad_f32_x(svbool_t, svfloat32_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmad_f16_x)))
svfloat16_t svnmad_f16_x(svbool_t, svfloat16_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmad_f64_z)))
svfloat64_t svnmad_f64_z(svbool_t, svfloat64_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmad_f32_z)))
svfloat32_t svnmad_f32_z(svbool_t, svfloat32_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmad_f16_z)))
svfloat16_t svnmad_f16_z(svbool_t, svfloat16_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmla_n_f64_m)))
svfloat64_t svnmla_n_f64_m(svbool_t, svfloat64_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmla_n_f32_m)))
svfloat32_t svnmla_n_f32_m(svbool_t, svfloat32_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmla_n_f16_m)))
svfloat16_t svnmla_n_f16_m(svbool_t, svfloat16_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmla_n_f64_x)))
svfloat64_t svnmla_n_f64_x(svbool_t, svfloat64_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmla_n_f32_x)))
svfloat32_t svnmla_n_f32_x(svbool_t, svfloat32_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmla_n_f16_x)))
svfloat16_t svnmla_n_f16_x(svbool_t, svfloat16_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmla_n_f64_z)))
svfloat64_t svnmla_n_f64_z(svbool_t, svfloat64_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmla_n_f32_z)))
svfloat32_t svnmla_n_f32_z(svbool_t, svfloat32_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmla_n_f16_z)))
svfloat16_t svnmla_n_f16_z(svbool_t, svfloat16_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmla_f64_m)))
svfloat64_t svnmla_f64_m(svbool_t, svfloat64_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmla_f32_m)))
svfloat32_t svnmla_f32_m(svbool_t, svfloat32_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmla_f16_m)))
svfloat16_t svnmla_f16_m(svbool_t, svfloat16_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmla_f64_x)))
svfloat64_t svnmla_f64_x(svbool_t, svfloat64_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmla_f32_x)))
svfloat32_t svnmla_f32_x(svbool_t, svfloat32_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmla_f16_x)))
svfloat16_t svnmla_f16_x(svbool_t, svfloat16_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmla_f64_z)))
svfloat64_t svnmla_f64_z(svbool_t, svfloat64_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmla_f32_z)))
svfloat32_t svnmla_f32_z(svbool_t, svfloat32_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmla_f16_z)))
svfloat16_t svnmla_f16_z(svbool_t, svfloat16_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmls_n_f64_m)))
svfloat64_t svnmls_n_f64_m(svbool_t, svfloat64_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmls_n_f32_m)))
svfloat32_t svnmls_n_f32_m(svbool_t, svfloat32_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmls_n_f16_m)))
svfloat16_t svnmls_n_f16_m(svbool_t, svfloat16_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmls_n_f64_x)))
svfloat64_t svnmls_n_f64_x(svbool_t, svfloat64_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmls_n_f32_x)))
svfloat32_t svnmls_n_f32_x(svbool_t, svfloat32_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmls_n_f16_x)))
svfloat16_t svnmls_n_f16_x(svbool_t, svfloat16_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmls_n_f64_z)))
svfloat64_t svnmls_n_f64_z(svbool_t, svfloat64_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmls_n_f32_z)))
svfloat32_t svnmls_n_f32_z(svbool_t, svfloat32_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmls_n_f16_z)))
svfloat16_t svnmls_n_f16_z(svbool_t, svfloat16_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmls_f64_m)))
svfloat64_t svnmls_f64_m(svbool_t, svfloat64_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmls_f32_m)))
svfloat32_t svnmls_f32_m(svbool_t, svfloat32_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmls_f16_m)))
svfloat16_t svnmls_f16_m(svbool_t, svfloat16_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmls_f64_x)))
svfloat64_t svnmls_f64_x(svbool_t, svfloat64_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmls_f32_x)))
svfloat32_t svnmls_f32_x(svbool_t, svfloat32_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmls_f16_x)))
svfloat16_t svnmls_f16_x(svbool_t, svfloat16_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmls_f64_z)))
svfloat64_t svnmls_f64_z(svbool_t, svfloat64_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmls_f32_z)))
svfloat32_t svnmls_f32_z(svbool_t, svfloat32_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmls_f16_z)))
svfloat16_t svnmls_f16_z(svbool_t, svfloat16_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmsb_n_f64_m)))
svfloat64_t svnmsb_n_f64_m(svbool_t, svfloat64_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmsb_n_f32_m)))
svfloat32_t svnmsb_n_f32_m(svbool_t, svfloat32_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmsb_n_f16_m)))
svfloat16_t svnmsb_n_f16_m(svbool_t, svfloat16_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmsb_n_f64_x)))
svfloat64_t svnmsb_n_f64_x(svbool_t, svfloat64_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmsb_n_f32_x)))
svfloat32_t svnmsb_n_f32_x(svbool_t, svfloat32_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmsb_n_f16_x)))
svfloat16_t svnmsb_n_f16_x(svbool_t, svfloat16_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmsb_n_f64_z)))
svfloat64_t svnmsb_n_f64_z(svbool_t, svfloat64_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmsb_n_f32_z)))
svfloat32_t svnmsb_n_f32_z(svbool_t, svfloat32_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmsb_n_f16_z)))
svfloat16_t svnmsb_n_f16_z(svbool_t, svfloat16_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmsb_f64_m)))
svfloat64_t svnmsb_f64_m(svbool_t, svfloat64_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmsb_f32_m)))
svfloat32_t svnmsb_f32_m(svbool_t, svfloat32_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmsb_f16_m)))
svfloat16_t svnmsb_f16_m(svbool_t, svfloat16_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmsb_f64_x)))
svfloat64_t svnmsb_f64_x(svbool_t, svfloat64_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmsb_f32_x)))
svfloat32_t svnmsb_f32_x(svbool_t, svfloat32_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmsb_f16_x)))
svfloat16_t svnmsb_f16_x(svbool_t, svfloat16_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmsb_f64_z)))
svfloat64_t svnmsb_f64_z(svbool_t, svfloat64_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmsb_f32_z)))
svfloat32_t svnmsb_f32_z(svbool_t, svfloat32_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmsb_f16_z)))
svfloat16_t svnmsb_f16_z(svbool_t, svfloat16_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnor_b_z), arm_streaming_compatible))
svbool_t svnor_b_z(svbool_t, svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnot_b_z), arm_streaming_compatible))
svbool_t svnot_b_z(svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnot_u8_m), arm_streaming_compatible))
svuint8_t svnot_u8_m(svuint8_t, svbool_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnot_u32_m), arm_streaming_compatible))
svuint32_t svnot_u32_m(svuint32_t, svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnot_u64_m), arm_streaming_compatible))
svuint64_t svnot_u64_m(svuint64_t, svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnot_u16_m), arm_streaming_compatible))
svuint16_t svnot_u16_m(svuint16_t, svbool_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnot_s8_m), arm_streaming_compatible))
svint8_t svnot_s8_m(svint8_t, svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnot_s32_m), arm_streaming_compatible))
svint32_t svnot_s32_m(svint32_t, svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnot_s64_m), arm_streaming_compatible))
svint64_t svnot_s64_m(svint64_t, svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnot_s16_m), arm_streaming_compatible))
svint16_t svnot_s16_m(svint16_t, svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnot_u8_x), arm_streaming_compatible))
svuint8_t svnot_u8_x(svbool_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnot_u32_x), arm_streaming_compatible))
svuint32_t svnot_u32_x(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnot_u64_x), arm_streaming_compatible))
svuint64_t svnot_u64_x(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnot_u16_x), arm_streaming_compatible))
svuint16_t svnot_u16_x(svbool_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnot_s8_x), arm_streaming_compatible))
svint8_t svnot_s8_x(svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnot_s32_x), arm_streaming_compatible))
svint32_t svnot_s32_x(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnot_s64_x), arm_streaming_compatible))
svint64_t svnot_s64_x(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnot_s16_x), arm_streaming_compatible))
svint16_t svnot_s16_x(svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnot_u8_z), arm_streaming_compatible))
svuint8_t svnot_u8_z(svbool_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnot_u32_z), arm_streaming_compatible))
svuint32_t svnot_u32_z(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnot_u64_z), arm_streaming_compatible))
svuint64_t svnot_u64_z(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnot_u16_z), arm_streaming_compatible))
svuint16_t svnot_u16_z(svbool_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnot_s8_z), arm_streaming_compatible))
svint8_t svnot_s8_z(svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnot_s32_z), arm_streaming_compatible))
svint32_t svnot_s32_z(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnot_s64_z), arm_streaming_compatible))
svint64_t svnot_s64_z(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnot_s16_z), arm_streaming_compatible))
svint16_t svnot_s16_z(svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorn_b_z), arm_streaming_compatible))
svbool_t svorn_b_z(svbool_t, svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_b_z), arm_streaming_compatible))
svbool_t svorr_b_z(svbool_t, svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_n_u8_m), arm_streaming_compatible))
svuint8_t svorr_n_u8_m(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_n_u32_m), arm_streaming_compatible))
svuint32_t svorr_n_u32_m(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_n_u64_m), arm_streaming_compatible))
svuint64_t svorr_n_u64_m(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_n_u16_m), arm_streaming_compatible))
svuint16_t svorr_n_u16_m(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_n_s8_m), arm_streaming_compatible))
svint8_t svorr_n_s8_m(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_n_s32_m), arm_streaming_compatible))
svint32_t svorr_n_s32_m(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_n_s64_m), arm_streaming_compatible))
svint64_t svorr_n_s64_m(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_n_s16_m), arm_streaming_compatible))
svint16_t svorr_n_s16_m(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_n_u8_x), arm_streaming_compatible))
svuint8_t svorr_n_u8_x(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_n_u32_x), arm_streaming_compatible))
svuint32_t svorr_n_u32_x(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_n_u64_x), arm_streaming_compatible))
svuint64_t svorr_n_u64_x(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_n_u16_x), arm_streaming_compatible))
svuint16_t svorr_n_u16_x(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_n_s8_x), arm_streaming_compatible))
svint8_t svorr_n_s8_x(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_n_s32_x), arm_streaming_compatible))
svint32_t svorr_n_s32_x(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_n_s64_x), arm_streaming_compatible))
svint64_t svorr_n_s64_x(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_n_s16_x), arm_streaming_compatible))
svint16_t svorr_n_s16_x(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_n_u8_z), arm_streaming_compatible))
svuint8_t svorr_n_u8_z(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_n_u32_z), arm_streaming_compatible))
svuint32_t svorr_n_u32_z(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_n_u64_z), arm_streaming_compatible))
svuint64_t svorr_n_u64_z(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_n_u16_z), arm_streaming_compatible))
svuint16_t svorr_n_u16_z(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_n_s8_z), arm_streaming_compatible))
svint8_t svorr_n_s8_z(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_n_s32_z), arm_streaming_compatible))
svint32_t svorr_n_s32_z(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_n_s64_z), arm_streaming_compatible))
svint64_t svorr_n_s64_z(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_n_s16_z), arm_streaming_compatible))
svint16_t svorr_n_s16_z(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_u8_m), arm_streaming_compatible))
svuint8_t svorr_u8_m(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_u32_m), arm_streaming_compatible))
svuint32_t svorr_u32_m(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_u64_m), arm_streaming_compatible))
svuint64_t svorr_u64_m(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_u16_m), arm_streaming_compatible))
svuint16_t svorr_u16_m(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_s8_m), arm_streaming_compatible))
svint8_t svorr_s8_m(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_s32_m), arm_streaming_compatible))
svint32_t svorr_s32_m(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_s64_m), arm_streaming_compatible))
svint64_t svorr_s64_m(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_s16_m), arm_streaming_compatible))
svint16_t svorr_s16_m(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_u8_x), arm_streaming_compatible))
svuint8_t svorr_u8_x(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_u32_x), arm_streaming_compatible))
svuint32_t svorr_u32_x(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_u64_x), arm_streaming_compatible))
svuint64_t svorr_u64_x(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_u16_x), arm_streaming_compatible))
svuint16_t svorr_u16_x(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_s8_x), arm_streaming_compatible))
svint8_t svorr_s8_x(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_s32_x), arm_streaming_compatible))
svint32_t svorr_s32_x(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_s64_x), arm_streaming_compatible))
svint64_t svorr_s64_x(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_s16_x), arm_streaming_compatible))
svint16_t svorr_s16_x(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_u8_z), arm_streaming_compatible))
svuint8_t svorr_u8_z(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_u32_z), arm_streaming_compatible))
svuint32_t svorr_u32_z(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_u64_z), arm_streaming_compatible))
svuint64_t svorr_u64_z(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_u16_z), arm_streaming_compatible))
svuint16_t svorr_u16_z(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_s8_z), arm_streaming_compatible))
svint8_t svorr_s8_z(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_s32_z), arm_streaming_compatible))
svint32_t svorr_s32_z(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_s64_z), arm_streaming_compatible))
svint64_t svorr_s64_z(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorr_s16_z), arm_streaming_compatible))
svint16_t svorr_s16_z(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorv_u8), arm_streaming_compatible))
uint8_t svorv_u8(svbool_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorv_u32), arm_streaming_compatible))
uint32_t svorv_u32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorv_u64), arm_streaming_compatible))
uint64_t svorv_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorv_u16), arm_streaming_compatible))
uint16_t svorv_u16(svbool_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorv_s8), arm_streaming_compatible))
int8_t svorv_s8(svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorv_s32), arm_streaming_compatible))
int32_t svorv_s32(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorv_s64), arm_streaming_compatible))
int64_t svorv_s64(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorv_s16), arm_streaming_compatible))
int16_t svorv_s16(svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpfalse_b), arm_streaming_compatible))
svbool_t svpfalse_b(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpfirst_b), arm_streaming_compatible))
svbool_t svpfirst_b(svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpnext_b8), arm_streaming_compatible))
svbool_t svpnext_b8(svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpnext_b32), arm_streaming_compatible))
svbool_t svpnext_b32(svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpnext_b64), arm_streaming_compatible))
svbool_t svpnext_b64(svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpnext_b16), arm_streaming_compatible))
svbool_t svpnext_b16(svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfb), arm_streaming_compatible))
void svprfb(svbool_t, void const *, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfb_gather_u32base)))
void svprfb_gather_u32base(svbool_t, svuint32_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfb_gather_u64base)))
void svprfb_gather_u64base(svbool_t, svuint64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfb_gather_u32base_offset)))
void svprfb_gather_u32base_offset(svbool_t, svuint32_t, int64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfb_gather_u64base_offset)))
void svprfb_gather_u64base_offset(svbool_t, svuint64_t, int64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfb_gather_s32offset)))
void svprfb_gather_s32offset(svbool_t, void const *, svint32_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfb_gather_u32offset)))
void svprfb_gather_u32offset(svbool_t, void const *, svuint32_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfb_gather_s64offset)))
void svprfb_gather_s64offset(svbool_t, void const *, svint64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfb_gather_u64offset)))
void svprfb_gather_u64offset(svbool_t, void const *, svuint64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfb_vnum), arm_streaming_compatible))
void svprfb_vnum(svbool_t, void const *, int64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfd), arm_streaming_compatible))
void svprfd(svbool_t, void const *, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfd_gather_u32base)))
void svprfd_gather_u32base(svbool_t, svuint32_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfd_gather_u64base)))
void svprfd_gather_u64base(svbool_t, svuint64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfd_gather_u32base_index)))
void svprfd_gather_u32base_index(svbool_t, svuint32_t, int64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfd_gather_u64base_index)))
void svprfd_gather_u64base_index(svbool_t, svuint64_t, int64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfd_gather_s32index)))
void svprfd_gather_s32index(svbool_t, void const *, svint32_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfd_gather_u32index)))
void svprfd_gather_u32index(svbool_t, void const *, svuint32_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfd_gather_s64index)))
void svprfd_gather_s64index(svbool_t, void const *, svint64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfd_gather_u64index)))
void svprfd_gather_u64index(svbool_t, void const *, svuint64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfd_vnum), arm_streaming_compatible))
void svprfd_vnum(svbool_t, void const *, int64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfh), arm_streaming_compatible))
void svprfh(svbool_t, void const *, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfh_gather_u32base)))
void svprfh_gather_u32base(svbool_t, svuint32_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfh_gather_u64base)))
void svprfh_gather_u64base(svbool_t, svuint64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfh_gather_u32base_index)))
void svprfh_gather_u32base_index(svbool_t, svuint32_t, int64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfh_gather_u64base_index)))
void svprfh_gather_u64base_index(svbool_t, svuint64_t, int64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfh_gather_s32index)))
void svprfh_gather_s32index(svbool_t, void const *, svint32_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfh_gather_u32index)))
void svprfh_gather_u32index(svbool_t, void const *, svuint32_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfh_gather_s64index)))
void svprfh_gather_s64index(svbool_t, void const *, svint64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfh_gather_u64index)))
void svprfh_gather_u64index(svbool_t, void const *, svuint64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfh_vnum), arm_streaming_compatible))
void svprfh_vnum(svbool_t, void const *, int64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfw), arm_streaming_compatible))
void svprfw(svbool_t, void const *, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfw_gather_u32base)))
void svprfw_gather_u32base(svbool_t, svuint32_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfw_gather_u64base)))
void svprfw_gather_u64base(svbool_t, svuint64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfw_gather_u32base_index)))
void svprfw_gather_u32base_index(svbool_t, svuint32_t, int64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfw_gather_u64base_index)))
void svprfw_gather_u64base_index(svbool_t, svuint64_t, int64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfw_gather_s32index)))
void svprfw_gather_s32index(svbool_t, void const *, svint32_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfw_gather_u32index)))
void svprfw_gather_u32index(svbool_t, void const *, svuint32_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfw_gather_s64index)))
void svprfw_gather_s64index(svbool_t, void const *, svint64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfw_gather_u64index)))
void svprfw_gather_u64index(svbool_t, void const *, svuint64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfw_vnum), arm_streaming_compatible))
void svprfw_vnum(svbool_t, void const *, int64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svptest_any), arm_streaming_compatible))
bool svptest_any(svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svptest_first), arm_streaming_compatible))
bool svptest_first(svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svptest_last), arm_streaming_compatible))
bool svptest_last(svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svptrue_pat_b8), arm_streaming_compatible))
svbool_t svptrue_pat_b8(enum svpattern);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svptrue_pat_b32), arm_streaming_compatible))
svbool_t svptrue_pat_b32(enum svpattern);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svptrue_pat_b64), arm_streaming_compatible))
svbool_t svptrue_pat_b64(enum svpattern);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svptrue_pat_b16), arm_streaming_compatible))
svbool_t svptrue_pat_b16(enum svpattern);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svptrue_b8), arm_streaming_compatible))
svbool_t svptrue_b8(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svptrue_b32), arm_streaming_compatible))
svbool_t svptrue_b32(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svptrue_b64), arm_streaming_compatible))
svbool_t svptrue_b64(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svptrue_b16), arm_streaming_compatible))
svbool_t svptrue_b16(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_n_s8), arm_streaming_compatible))
svint8_t svqadd_n_s8(svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_n_s32), arm_streaming_compatible))
svint32_t svqadd_n_s32(svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_n_s64), arm_streaming_compatible))
svint64_t svqadd_n_s64(svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_n_s16), arm_streaming_compatible))
svint16_t svqadd_n_s16(svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_n_u8), arm_streaming_compatible))
svuint8_t svqadd_n_u8(svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_n_u32), arm_streaming_compatible))
svuint32_t svqadd_n_u32(svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_n_u64), arm_streaming_compatible))
svuint64_t svqadd_n_u64(svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_n_u16), arm_streaming_compatible))
svuint16_t svqadd_n_u16(svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_s8), arm_streaming_compatible))
svint8_t svqadd_s8(svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_s32), arm_streaming_compatible))
svint32_t svqadd_s32(svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_s64), arm_streaming_compatible))
svint64_t svqadd_s64(svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_s16), arm_streaming_compatible))
svint16_t svqadd_s16(svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_u8), arm_streaming_compatible))
svuint8_t svqadd_u8(svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_u32), arm_streaming_compatible))
svuint32_t svqadd_u32(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_u64), arm_streaming_compatible))
svuint64_t svqadd_u64(svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_u16), arm_streaming_compatible))
svuint16_t svqadd_u16(svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecb_n_s32), arm_streaming_compatible))
int32_t svqdecb_n_s32(int32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecb_n_s64), arm_streaming_compatible))
int64_t svqdecb_n_s64(int64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecb_n_u32), arm_streaming_compatible))
uint32_t svqdecb_n_u32(uint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecb_n_u64), arm_streaming_compatible))
uint64_t svqdecb_n_u64(uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecb_pat_n_s32), arm_streaming_compatible))
int32_t svqdecb_pat_n_s32(int32_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecb_pat_n_s64), arm_streaming_compatible))
int64_t svqdecb_pat_n_s64(int64_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecb_pat_n_u32), arm_streaming_compatible))
uint32_t svqdecb_pat_n_u32(uint32_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecb_pat_n_u64), arm_streaming_compatible))
uint64_t svqdecb_pat_n_u64(uint64_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecd_n_s32), arm_streaming_compatible))
int32_t svqdecd_n_s32(int32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecd_n_s64), arm_streaming_compatible))
int64_t svqdecd_n_s64(int64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecd_n_u32), arm_streaming_compatible))
uint32_t svqdecd_n_u32(uint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecd_n_u64), arm_streaming_compatible))
uint64_t svqdecd_n_u64(uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecd_s64), arm_streaming_compatible))
svint64_t svqdecd_s64(svint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecd_u64), arm_streaming_compatible))
svuint64_t svqdecd_u64(svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecd_pat_n_s32), arm_streaming_compatible))
int32_t svqdecd_pat_n_s32(int32_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecd_pat_n_s64), arm_streaming_compatible))
int64_t svqdecd_pat_n_s64(int64_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecd_pat_n_u32), arm_streaming_compatible))
uint32_t svqdecd_pat_n_u32(uint32_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecd_pat_n_u64), arm_streaming_compatible))
uint64_t svqdecd_pat_n_u64(uint64_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecd_pat_s64), arm_streaming_compatible))
svint64_t svqdecd_pat_s64(svint64_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecd_pat_u64), arm_streaming_compatible))
svuint64_t svqdecd_pat_u64(svuint64_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdech_n_s32), arm_streaming_compatible))
int32_t svqdech_n_s32(int32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdech_n_s64), arm_streaming_compatible))
int64_t svqdech_n_s64(int64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdech_n_u32), arm_streaming_compatible))
uint32_t svqdech_n_u32(uint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdech_n_u64), arm_streaming_compatible))
uint64_t svqdech_n_u64(uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdech_s16), arm_streaming_compatible))
svint16_t svqdech_s16(svint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdech_u16), arm_streaming_compatible))
svuint16_t svqdech_u16(svuint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdech_pat_n_s32), arm_streaming_compatible))
int32_t svqdech_pat_n_s32(int32_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdech_pat_n_s64), arm_streaming_compatible))
int64_t svqdech_pat_n_s64(int64_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdech_pat_n_u32), arm_streaming_compatible))
uint32_t svqdech_pat_n_u32(uint32_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdech_pat_n_u64), arm_streaming_compatible))
uint64_t svqdech_pat_n_u64(uint64_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdech_pat_s16), arm_streaming_compatible))
svint16_t svqdech_pat_s16(svint16_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdech_pat_u16), arm_streaming_compatible))
svuint16_t svqdech_pat_u16(svuint16_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecp_n_s32_b8), arm_streaming_compatible))
int32_t svqdecp_n_s32_b8(int32_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecp_n_s32_b32), arm_streaming_compatible))
int32_t svqdecp_n_s32_b32(int32_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecp_n_s32_b64), arm_streaming_compatible))
int32_t svqdecp_n_s32_b64(int32_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecp_n_s32_b16), arm_streaming_compatible))
int32_t svqdecp_n_s32_b16(int32_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecp_n_s64_b8), arm_streaming_compatible))
int64_t svqdecp_n_s64_b8(int64_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecp_n_s64_b32), arm_streaming_compatible))
int64_t svqdecp_n_s64_b32(int64_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecp_n_s64_b64), arm_streaming_compatible))
int64_t svqdecp_n_s64_b64(int64_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecp_n_s64_b16), arm_streaming_compatible))
int64_t svqdecp_n_s64_b16(int64_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecp_n_u32_b8), arm_streaming_compatible))
uint32_t svqdecp_n_u32_b8(uint32_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecp_n_u32_b32), arm_streaming_compatible))
uint32_t svqdecp_n_u32_b32(uint32_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecp_n_u32_b64), arm_streaming_compatible))
uint32_t svqdecp_n_u32_b64(uint32_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecp_n_u32_b16), arm_streaming_compatible))
uint32_t svqdecp_n_u32_b16(uint32_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecp_n_u64_b8), arm_streaming_compatible))
uint64_t svqdecp_n_u64_b8(uint64_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecp_n_u64_b32), arm_streaming_compatible))
uint64_t svqdecp_n_u64_b32(uint64_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecp_n_u64_b64), arm_streaming_compatible))
uint64_t svqdecp_n_u64_b64(uint64_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecp_n_u64_b16), arm_streaming_compatible))
uint64_t svqdecp_n_u64_b16(uint64_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecp_s32), arm_streaming_compatible))
svint32_t svqdecp_s32(svint32_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecp_s64), arm_streaming_compatible))
svint64_t svqdecp_s64(svint64_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecp_s16), arm_streaming_compatible))
svint16_t svqdecp_s16(svint16_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecp_u32), arm_streaming_compatible))
svuint32_t svqdecp_u32(svuint32_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecp_u64), arm_streaming_compatible))
svuint64_t svqdecp_u64(svuint64_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecp_u16), arm_streaming_compatible))
svuint16_t svqdecp_u16(svuint16_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecw_n_s32), arm_streaming_compatible))
int32_t svqdecw_n_s32(int32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecw_n_s64), arm_streaming_compatible))
int64_t svqdecw_n_s64(int64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecw_n_u32), arm_streaming_compatible))
uint32_t svqdecw_n_u32(uint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecw_n_u64), arm_streaming_compatible))
uint64_t svqdecw_n_u64(uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecw_s32), arm_streaming_compatible))
svint32_t svqdecw_s32(svint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecw_u32), arm_streaming_compatible))
svuint32_t svqdecw_u32(svuint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecw_pat_n_s32), arm_streaming_compatible))
int32_t svqdecw_pat_n_s32(int32_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecw_pat_n_s64), arm_streaming_compatible))
int64_t svqdecw_pat_n_s64(int64_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecw_pat_n_u32), arm_streaming_compatible))
uint32_t svqdecw_pat_n_u32(uint32_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecw_pat_n_u64), arm_streaming_compatible))
uint64_t svqdecw_pat_n_u64(uint64_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecw_pat_s32), arm_streaming_compatible))
svint32_t svqdecw_pat_s32(svint32_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdecw_pat_u32), arm_streaming_compatible))
svuint32_t svqdecw_pat_u32(svuint32_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincb_n_s32), arm_streaming_compatible))
int32_t svqincb_n_s32(int32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincb_n_s64), arm_streaming_compatible))
int64_t svqincb_n_s64(int64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincb_n_u32), arm_streaming_compatible))
uint32_t svqincb_n_u32(uint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincb_n_u64), arm_streaming_compatible))
uint64_t svqincb_n_u64(uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincb_pat_n_s32), arm_streaming_compatible))
int32_t svqincb_pat_n_s32(int32_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincb_pat_n_s64), arm_streaming_compatible))
int64_t svqincb_pat_n_s64(int64_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincb_pat_n_u32), arm_streaming_compatible))
uint32_t svqincb_pat_n_u32(uint32_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincb_pat_n_u64), arm_streaming_compatible))
uint64_t svqincb_pat_n_u64(uint64_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincd_n_s32), arm_streaming_compatible))
int32_t svqincd_n_s32(int32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincd_n_s64), arm_streaming_compatible))
int64_t svqincd_n_s64(int64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincd_n_u32), arm_streaming_compatible))
uint32_t svqincd_n_u32(uint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincd_n_u64), arm_streaming_compatible))
uint64_t svqincd_n_u64(uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincd_s64), arm_streaming_compatible))
svint64_t svqincd_s64(svint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincd_u64), arm_streaming_compatible))
svuint64_t svqincd_u64(svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincd_pat_n_s32), arm_streaming_compatible))
int32_t svqincd_pat_n_s32(int32_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincd_pat_n_s64), arm_streaming_compatible))
int64_t svqincd_pat_n_s64(int64_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincd_pat_n_u32), arm_streaming_compatible))
uint32_t svqincd_pat_n_u32(uint32_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincd_pat_n_u64), arm_streaming_compatible))
uint64_t svqincd_pat_n_u64(uint64_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincd_pat_s64), arm_streaming_compatible))
svint64_t svqincd_pat_s64(svint64_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincd_pat_u64), arm_streaming_compatible))
svuint64_t svqincd_pat_u64(svuint64_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqinch_n_s32), arm_streaming_compatible))
int32_t svqinch_n_s32(int32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqinch_n_s64), arm_streaming_compatible))
int64_t svqinch_n_s64(int64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqinch_n_u32), arm_streaming_compatible))
uint32_t svqinch_n_u32(uint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqinch_n_u64), arm_streaming_compatible))
uint64_t svqinch_n_u64(uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqinch_s16), arm_streaming_compatible))
svint16_t svqinch_s16(svint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqinch_u16), arm_streaming_compatible))
svuint16_t svqinch_u16(svuint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqinch_pat_n_s32), arm_streaming_compatible))
int32_t svqinch_pat_n_s32(int32_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqinch_pat_n_s64), arm_streaming_compatible))
int64_t svqinch_pat_n_s64(int64_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqinch_pat_n_u32), arm_streaming_compatible))
uint32_t svqinch_pat_n_u32(uint32_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqinch_pat_n_u64), arm_streaming_compatible))
uint64_t svqinch_pat_n_u64(uint64_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqinch_pat_s16), arm_streaming_compatible))
svint16_t svqinch_pat_s16(svint16_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqinch_pat_u16), arm_streaming_compatible))
svuint16_t svqinch_pat_u16(svuint16_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincp_n_s32_b8), arm_streaming_compatible))
int32_t svqincp_n_s32_b8(int32_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincp_n_s32_b32), arm_streaming_compatible))
int32_t svqincp_n_s32_b32(int32_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincp_n_s32_b64), arm_streaming_compatible))
int32_t svqincp_n_s32_b64(int32_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincp_n_s32_b16), arm_streaming_compatible))
int32_t svqincp_n_s32_b16(int32_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincp_n_s64_b8), arm_streaming_compatible))
int64_t svqincp_n_s64_b8(int64_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincp_n_s64_b32), arm_streaming_compatible))
int64_t svqincp_n_s64_b32(int64_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincp_n_s64_b64), arm_streaming_compatible))
int64_t svqincp_n_s64_b64(int64_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincp_n_s64_b16), arm_streaming_compatible))
int64_t svqincp_n_s64_b16(int64_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincp_n_u32_b8), arm_streaming_compatible))
uint32_t svqincp_n_u32_b8(uint32_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincp_n_u32_b32), arm_streaming_compatible))
uint32_t svqincp_n_u32_b32(uint32_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincp_n_u32_b64), arm_streaming_compatible))
uint32_t svqincp_n_u32_b64(uint32_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincp_n_u32_b16), arm_streaming_compatible))
uint32_t svqincp_n_u32_b16(uint32_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincp_n_u64_b8), arm_streaming_compatible))
uint64_t svqincp_n_u64_b8(uint64_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincp_n_u64_b32), arm_streaming_compatible))
uint64_t svqincp_n_u64_b32(uint64_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincp_n_u64_b64), arm_streaming_compatible))
uint64_t svqincp_n_u64_b64(uint64_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincp_n_u64_b16), arm_streaming_compatible))
uint64_t svqincp_n_u64_b16(uint64_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincp_s32), arm_streaming_compatible))
svint32_t svqincp_s32(svint32_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincp_s64), arm_streaming_compatible))
svint64_t svqincp_s64(svint64_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincp_s16), arm_streaming_compatible))
svint16_t svqincp_s16(svint16_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincp_u32), arm_streaming_compatible))
svuint32_t svqincp_u32(svuint32_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincp_u64), arm_streaming_compatible))
svuint64_t svqincp_u64(svuint64_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincp_u16), arm_streaming_compatible))
svuint16_t svqincp_u16(svuint16_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincw_n_s32), arm_streaming_compatible))
int32_t svqincw_n_s32(int32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincw_n_s64), arm_streaming_compatible))
int64_t svqincw_n_s64(int64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincw_n_u32), arm_streaming_compatible))
uint32_t svqincw_n_u32(uint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincw_n_u64), arm_streaming_compatible))
uint64_t svqincw_n_u64(uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincw_s32), arm_streaming_compatible))
svint32_t svqincw_s32(svint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincw_u32), arm_streaming_compatible))
svuint32_t svqincw_u32(svuint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincw_pat_n_s32), arm_streaming_compatible))
int32_t svqincw_pat_n_s32(int32_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincw_pat_n_s64), arm_streaming_compatible))
int64_t svqincw_pat_n_s64(int64_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincw_pat_n_u32), arm_streaming_compatible))
uint32_t svqincw_pat_n_u32(uint32_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincw_pat_n_u64), arm_streaming_compatible))
uint64_t svqincw_pat_n_u64(uint64_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincw_pat_s32), arm_streaming_compatible))
svint32_t svqincw_pat_s32(svint32_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqincw_pat_u32), arm_streaming_compatible))
svuint32_t svqincw_pat_u32(svuint32_t, enum svpattern, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqsub_n_s8), arm_streaming_compatible))
svint8_t svqsub_n_s8(svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqsub_n_s32), arm_streaming_compatible))
svint32_t svqsub_n_s32(svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqsub_n_s64), arm_streaming_compatible))
svint64_t svqsub_n_s64(svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqsub_n_s16), arm_streaming_compatible))
svint16_t svqsub_n_s16(svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqsub_n_u8), arm_streaming_compatible))
svuint8_t svqsub_n_u8(svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqsub_n_u32), arm_streaming_compatible))
svuint32_t svqsub_n_u32(svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqsub_n_u64), arm_streaming_compatible))
svuint64_t svqsub_n_u64(svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqsub_n_u16), arm_streaming_compatible))
svuint16_t svqsub_n_u16(svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqsub_s8), arm_streaming_compatible))
svint8_t svqsub_s8(svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqsub_s32), arm_streaming_compatible))
svint32_t svqsub_s32(svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqsub_s64), arm_streaming_compatible))
svint64_t svqsub_s64(svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqsub_s16), arm_streaming_compatible))
svint16_t svqsub_s16(svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqsub_u8), arm_streaming_compatible))
svuint8_t svqsub_u8(svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqsub_u32), arm_streaming_compatible))
svuint32_t svqsub_u32(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqsub_u64), arm_streaming_compatible))
svuint64_t svqsub_u64(svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqsub_u16), arm_streaming_compatible))
svuint16_t svqsub_u16(svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrbit_u8_m), arm_streaming_compatible))
svuint8_t svrbit_u8_m(svuint8_t, svbool_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrbit_u32_m), arm_streaming_compatible))
svuint32_t svrbit_u32_m(svuint32_t, svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrbit_u64_m), arm_streaming_compatible))
svuint64_t svrbit_u64_m(svuint64_t, svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrbit_u16_m), arm_streaming_compatible))
svuint16_t svrbit_u16_m(svuint16_t, svbool_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrbit_s8_m), arm_streaming_compatible))
svint8_t svrbit_s8_m(svint8_t, svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrbit_s32_m), arm_streaming_compatible))
svint32_t svrbit_s32_m(svint32_t, svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrbit_s64_m), arm_streaming_compatible))
svint64_t svrbit_s64_m(svint64_t, svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrbit_s16_m), arm_streaming_compatible))
svint16_t svrbit_s16_m(svint16_t, svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrbit_u8_x), arm_streaming_compatible))
svuint8_t svrbit_u8_x(svbool_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrbit_u32_x), arm_streaming_compatible))
svuint32_t svrbit_u32_x(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrbit_u64_x), arm_streaming_compatible))
svuint64_t svrbit_u64_x(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrbit_u16_x), arm_streaming_compatible))
svuint16_t svrbit_u16_x(svbool_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrbit_s8_x), arm_streaming_compatible))
svint8_t svrbit_s8_x(svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrbit_s32_x), arm_streaming_compatible))
svint32_t svrbit_s32_x(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrbit_s64_x), arm_streaming_compatible))
svint64_t svrbit_s64_x(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrbit_s16_x), arm_streaming_compatible))
svint16_t svrbit_s16_x(svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrbit_u8_z), arm_streaming_compatible))
svuint8_t svrbit_u8_z(svbool_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrbit_u32_z), arm_streaming_compatible))
svuint32_t svrbit_u32_z(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrbit_u64_z), arm_streaming_compatible))
svuint64_t svrbit_u64_z(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrbit_u16_z), arm_streaming_compatible))
svuint16_t svrbit_u16_z(svbool_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrbit_s8_z), arm_streaming_compatible))
svint8_t svrbit_s8_z(svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrbit_s32_z), arm_streaming_compatible))
svint32_t svrbit_s32_z(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrbit_s64_z), arm_streaming_compatible))
svint64_t svrbit_s64_z(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrbit_s16_z), arm_streaming_compatible))
svint16_t svrbit_s16_z(svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrdffr)))
svbool_t svrdffr(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrdffr_z)))
svbool_t svrdffr_z(svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrecpe_f64), arm_streaming_compatible))
svfloat64_t svrecpe_f64(svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrecpe_f32), arm_streaming_compatible))
svfloat32_t svrecpe_f32(svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrecpe_f16), arm_streaming_compatible))
svfloat16_t svrecpe_f16(svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrecps_f64), arm_streaming_compatible))
svfloat64_t svrecps_f64(svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrecps_f32), arm_streaming_compatible))
svfloat32_t svrecps_f32(svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrecps_f16), arm_streaming_compatible))
svfloat16_t svrecps_f16(svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrecpx_f64_m), arm_streaming_compatible))
svfloat64_t svrecpx_f64_m(svfloat64_t, svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrecpx_f32_m), arm_streaming_compatible))
svfloat32_t svrecpx_f32_m(svfloat32_t, svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrecpx_f16_m), arm_streaming_compatible))
svfloat16_t svrecpx_f16_m(svfloat16_t, svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrecpx_f64_x), arm_streaming_compatible))
svfloat64_t svrecpx_f64_x(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrecpx_f32_x), arm_streaming_compatible))
svfloat32_t svrecpx_f32_x(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrecpx_f16_x), arm_streaming_compatible))
svfloat16_t svrecpx_f16_x(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrecpx_f64_z), arm_streaming_compatible))
svfloat64_t svrecpx_f64_z(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrecpx_f32_z), arm_streaming_compatible))
svfloat32_t svrecpx_f32_z(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrecpx_f16_z), arm_streaming_compatible))
svfloat16_t svrecpx_f16_z(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrev_u8), arm_streaming_compatible))
svuint8_t svrev_u8(svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrev_u32), arm_streaming_compatible))
svuint32_t svrev_u32(svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrev_u64), arm_streaming_compatible))
svuint64_t svrev_u64(svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrev_u16), arm_streaming_compatible))
svuint16_t svrev_u16(svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrev_s8), arm_streaming_compatible))
svint8_t svrev_s8(svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrev_f64), arm_streaming_compatible))
svfloat64_t svrev_f64(svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrev_f32), arm_streaming_compatible))
svfloat32_t svrev_f32(svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrev_f16), arm_streaming_compatible))
svfloat16_t svrev_f16(svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrev_s32), arm_streaming_compatible))
svint32_t svrev_s32(svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrev_s64), arm_streaming_compatible))
svint64_t svrev_s64(svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrev_s16), arm_streaming_compatible))
svint16_t svrev_s16(svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrev_b16), arm_streaming_compatible))
svbool_t svrev_b16(svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrev_b32), arm_streaming_compatible))
svbool_t svrev_b32(svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrev_b64), arm_streaming_compatible))
svbool_t svrev_b64(svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrev_b8), arm_streaming_compatible))
svbool_t svrev_b8(svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevb_u32_m), arm_streaming_compatible))
svuint32_t svrevb_u32_m(svuint32_t, svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevb_u64_m), arm_streaming_compatible))
svuint64_t svrevb_u64_m(svuint64_t, svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevb_u16_m), arm_streaming_compatible))
svuint16_t svrevb_u16_m(svuint16_t, svbool_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevb_s32_m), arm_streaming_compatible))
svint32_t svrevb_s32_m(svint32_t, svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevb_s64_m), arm_streaming_compatible))
svint64_t svrevb_s64_m(svint64_t, svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevb_s16_m), arm_streaming_compatible))
svint16_t svrevb_s16_m(svint16_t, svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevb_u32_x), arm_streaming_compatible))
svuint32_t svrevb_u32_x(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevb_u64_x), arm_streaming_compatible))
svuint64_t svrevb_u64_x(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevb_u16_x), arm_streaming_compatible))
svuint16_t svrevb_u16_x(svbool_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevb_s32_x), arm_streaming_compatible))
svint32_t svrevb_s32_x(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevb_s64_x), arm_streaming_compatible))
svint64_t svrevb_s64_x(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevb_s16_x), arm_streaming_compatible))
svint16_t svrevb_s16_x(svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevb_u32_z), arm_streaming_compatible))
svuint32_t svrevb_u32_z(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevb_u64_z), arm_streaming_compatible))
svuint64_t svrevb_u64_z(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevb_u16_z), arm_streaming_compatible))
svuint16_t svrevb_u16_z(svbool_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevb_s32_z), arm_streaming_compatible))
svint32_t svrevb_s32_z(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevb_s64_z), arm_streaming_compatible))
svint64_t svrevb_s64_z(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevb_s16_z), arm_streaming_compatible))
svint16_t svrevb_s16_z(svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevh_u32_m), arm_streaming_compatible))
svuint32_t svrevh_u32_m(svuint32_t, svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevh_u64_m), arm_streaming_compatible))
svuint64_t svrevh_u64_m(svuint64_t, svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevh_s32_m), arm_streaming_compatible))
svint32_t svrevh_s32_m(svint32_t, svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevh_s64_m), arm_streaming_compatible))
svint64_t svrevh_s64_m(svint64_t, svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevh_u32_x), arm_streaming_compatible))
svuint32_t svrevh_u32_x(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevh_u64_x), arm_streaming_compatible))
svuint64_t svrevh_u64_x(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevh_s32_x), arm_streaming_compatible))
svint32_t svrevh_s32_x(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevh_s64_x), arm_streaming_compatible))
svint64_t svrevh_s64_x(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevh_u32_z), arm_streaming_compatible))
svuint32_t svrevh_u32_z(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevh_u64_z), arm_streaming_compatible))
svuint64_t svrevh_u64_z(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevh_s32_z), arm_streaming_compatible))
svint32_t svrevh_s32_z(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevh_s64_z), arm_streaming_compatible))
svint64_t svrevh_s64_z(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevw_u64_m), arm_streaming_compatible))
svuint64_t svrevw_u64_m(svuint64_t, svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevw_s64_m), arm_streaming_compatible))
svint64_t svrevw_s64_m(svint64_t, svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevw_u64_x), arm_streaming_compatible))
svuint64_t svrevw_u64_x(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevw_s64_x), arm_streaming_compatible))
svint64_t svrevw_s64_x(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevw_u64_z), arm_streaming_compatible))
svuint64_t svrevw_u64_z(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevw_s64_z), arm_streaming_compatible))
svint64_t svrevw_s64_z(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrinta_f64_m), arm_streaming_compatible))
svfloat64_t svrinta_f64_m(svfloat64_t, svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrinta_f32_m), arm_streaming_compatible))
svfloat32_t svrinta_f32_m(svfloat32_t, svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrinta_f16_m), arm_streaming_compatible))
svfloat16_t svrinta_f16_m(svfloat16_t, svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrinta_f64_x), arm_streaming_compatible))
svfloat64_t svrinta_f64_x(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrinta_f32_x), arm_streaming_compatible))
svfloat32_t svrinta_f32_x(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrinta_f16_x), arm_streaming_compatible))
svfloat16_t svrinta_f16_x(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrinta_f64_z), arm_streaming_compatible))
svfloat64_t svrinta_f64_z(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrinta_f32_z), arm_streaming_compatible))
svfloat32_t svrinta_f32_z(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrinta_f16_z), arm_streaming_compatible))
svfloat16_t svrinta_f16_z(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrinti_f64_m), arm_streaming_compatible))
svfloat64_t svrinti_f64_m(svfloat64_t, svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrinti_f32_m), arm_streaming_compatible))
svfloat32_t svrinti_f32_m(svfloat32_t, svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrinti_f16_m), arm_streaming_compatible))
svfloat16_t svrinti_f16_m(svfloat16_t, svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrinti_f64_x), arm_streaming_compatible))
svfloat64_t svrinti_f64_x(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrinti_f32_x), arm_streaming_compatible))
svfloat32_t svrinti_f32_x(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrinti_f16_x), arm_streaming_compatible))
svfloat16_t svrinti_f16_x(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrinti_f64_z), arm_streaming_compatible))
svfloat64_t svrinti_f64_z(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrinti_f32_z), arm_streaming_compatible))
svfloat32_t svrinti_f32_z(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrinti_f16_z), arm_streaming_compatible))
svfloat16_t svrinti_f16_z(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintm_f64_m), arm_streaming_compatible))
svfloat64_t svrintm_f64_m(svfloat64_t, svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintm_f32_m), arm_streaming_compatible))
svfloat32_t svrintm_f32_m(svfloat32_t, svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintm_f16_m), arm_streaming_compatible))
svfloat16_t svrintm_f16_m(svfloat16_t, svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintm_f64_x), arm_streaming_compatible))
svfloat64_t svrintm_f64_x(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintm_f32_x), arm_streaming_compatible))
svfloat32_t svrintm_f32_x(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintm_f16_x), arm_streaming_compatible))
svfloat16_t svrintm_f16_x(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintm_f64_z), arm_streaming_compatible))
svfloat64_t svrintm_f64_z(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintm_f32_z), arm_streaming_compatible))
svfloat32_t svrintm_f32_z(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintm_f16_z), arm_streaming_compatible))
svfloat16_t svrintm_f16_z(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintn_f64_m), arm_streaming_compatible))
svfloat64_t svrintn_f64_m(svfloat64_t, svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintn_f32_m), arm_streaming_compatible))
svfloat32_t svrintn_f32_m(svfloat32_t, svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintn_f16_m), arm_streaming_compatible))
svfloat16_t svrintn_f16_m(svfloat16_t, svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintn_f64_x), arm_streaming_compatible))
svfloat64_t svrintn_f64_x(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintn_f32_x), arm_streaming_compatible))
svfloat32_t svrintn_f32_x(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintn_f16_x), arm_streaming_compatible))
svfloat16_t svrintn_f16_x(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintn_f64_z), arm_streaming_compatible))
svfloat64_t svrintn_f64_z(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintn_f32_z), arm_streaming_compatible))
svfloat32_t svrintn_f32_z(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintn_f16_z), arm_streaming_compatible))
svfloat16_t svrintn_f16_z(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintp_f64_m), arm_streaming_compatible))
svfloat64_t svrintp_f64_m(svfloat64_t, svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintp_f32_m), arm_streaming_compatible))
svfloat32_t svrintp_f32_m(svfloat32_t, svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintp_f16_m), arm_streaming_compatible))
svfloat16_t svrintp_f16_m(svfloat16_t, svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintp_f64_x), arm_streaming_compatible))
svfloat64_t svrintp_f64_x(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintp_f32_x), arm_streaming_compatible))
svfloat32_t svrintp_f32_x(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintp_f16_x), arm_streaming_compatible))
svfloat16_t svrintp_f16_x(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintp_f64_z), arm_streaming_compatible))
svfloat64_t svrintp_f64_z(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintp_f32_z), arm_streaming_compatible))
svfloat32_t svrintp_f32_z(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintp_f16_z), arm_streaming_compatible))
svfloat16_t svrintp_f16_z(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintx_f64_m), arm_streaming_compatible))
svfloat64_t svrintx_f64_m(svfloat64_t, svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintx_f32_m), arm_streaming_compatible))
svfloat32_t svrintx_f32_m(svfloat32_t, svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintx_f16_m), arm_streaming_compatible))
svfloat16_t svrintx_f16_m(svfloat16_t, svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintx_f64_x), arm_streaming_compatible))
svfloat64_t svrintx_f64_x(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintx_f32_x), arm_streaming_compatible))
svfloat32_t svrintx_f32_x(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintx_f16_x), arm_streaming_compatible))
svfloat16_t svrintx_f16_x(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintx_f64_z), arm_streaming_compatible))
svfloat64_t svrintx_f64_z(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintx_f32_z), arm_streaming_compatible))
svfloat32_t svrintx_f32_z(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintx_f16_z), arm_streaming_compatible))
svfloat16_t svrintx_f16_z(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintz_f64_m), arm_streaming_compatible))
svfloat64_t svrintz_f64_m(svfloat64_t, svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintz_f32_m), arm_streaming_compatible))
svfloat32_t svrintz_f32_m(svfloat32_t, svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintz_f16_m), arm_streaming_compatible))
svfloat16_t svrintz_f16_m(svfloat16_t, svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintz_f64_x), arm_streaming_compatible))
svfloat64_t svrintz_f64_x(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintz_f32_x), arm_streaming_compatible))
svfloat32_t svrintz_f32_x(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintz_f16_x), arm_streaming_compatible))
svfloat16_t svrintz_f16_x(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintz_f64_z), arm_streaming_compatible))
svfloat64_t svrintz_f64_z(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintz_f32_z), arm_streaming_compatible))
svfloat32_t svrintz_f32_z(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintz_f16_z), arm_streaming_compatible))
svfloat16_t svrintz_f16_z(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrsqrte_f64), arm_streaming_compatible))
svfloat64_t svrsqrte_f64(svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrsqrte_f32), arm_streaming_compatible))
svfloat32_t svrsqrte_f32(svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrsqrte_f16), arm_streaming_compatible))
svfloat16_t svrsqrte_f16(svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrsqrts_f64), arm_streaming_compatible))
svfloat64_t svrsqrts_f64(svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrsqrts_f32), arm_streaming_compatible))
svfloat32_t svrsqrts_f32(svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrsqrts_f16), arm_streaming_compatible))
svfloat16_t svrsqrts_f16(svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svscale_n_f64_m), arm_streaming_compatible))
svfloat64_t svscale_n_f64_m(svbool_t, svfloat64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svscale_n_f32_m), arm_streaming_compatible))
svfloat32_t svscale_n_f32_m(svbool_t, svfloat32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svscale_n_f16_m), arm_streaming_compatible))
svfloat16_t svscale_n_f16_m(svbool_t, svfloat16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svscale_n_f64_x), arm_streaming_compatible))
svfloat64_t svscale_n_f64_x(svbool_t, svfloat64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svscale_n_f32_x), arm_streaming_compatible))
svfloat32_t svscale_n_f32_x(svbool_t, svfloat32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svscale_n_f16_x), arm_streaming_compatible))
svfloat16_t svscale_n_f16_x(svbool_t, svfloat16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svscale_n_f64_z), arm_streaming_compatible))
svfloat64_t svscale_n_f64_z(svbool_t, svfloat64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svscale_n_f32_z), arm_streaming_compatible))
svfloat32_t svscale_n_f32_z(svbool_t, svfloat32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svscale_n_f16_z), arm_streaming_compatible))
svfloat16_t svscale_n_f16_z(svbool_t, svfloat16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svscale_f64_m), arm_streaming_compatible))
svfloat64_t svscale_f64_m(svbool_t, svfloat64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svscale_f32_m), arm_streaming_compatible))
svfloat32_t svscale_f32_m(svbool_t, svfloat32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svscale_f16_m), arm_streaming_compatible))
svfloat16_t svscale_f16_m(svbool_t, svfloat16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svscale_f64_x), arm_streaming_compatible))
svfloat64_t svscale_f64_x(svbool_t, svfloat64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svscale_f32_x), arm_streaming_compatible))
svfloat32_t svscale_f32_x(svbool_t, svfloat32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svscale_f16_x), arm_streaming_compatible))
svfloat16_t svscale_f16_x(svbool_t, svfloat16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svscale_f64_z), arm_streaming_compatible))
svfloat64_t svscale_f64_z(svbool_t, svfloat64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svscale_f32_z), arm_streaming_compatible))
svfloat32_t svscale_f32_z(svbool_t, svfloat32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svscale_f16_z), arm_streaming_compatible))
svfloat16_t svscale_f16_z(svbool_t, svfloat16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_b), arm_streaming_compatible))
svbool_t svsel_b(svbool_t, svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_u8), arm_streaming_compatible))
svuint8_t svsel_u8(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_u32), arm_streaming_compatible))
svuint32_t svsel_u32(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_u64), arm_streaming_compatible))
svuint64_t svsel_u64(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_u16), arm_streaming_compatible))
svuint16_t svsel_u16(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_s8), arm_streaming_compatible))
svint8_t svsel_s8(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_f64), arm_streaming_compatible))
svfloat64_t svsel_f64(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_f32), arm_streaming_compatible))
svfloat32_t svsel_f32(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_f16), arm_streaming_compatible))
svfloat16_t svsel_f16(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_s32), arm_streaming_compatible))
svint32_t svsel_s32(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_s64), arm_streaming_compatible))
svint64_t svsel_s64(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_s16), arm_streaming_compatible))
svint16_t svsel_s16(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svset2_u8)))
svuint8x2_t svset2_u8(svuint8x2_t, uint64_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svset2_u32)))
svuint32x2_t svset2_u32(svuint32x2_t, uint64_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svset2_u64)))
svuint64x2_t svset2_u64(svuint64x2_t, uint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svset2_u16)))
svuint16x2_t svset2_u16(svuint16x2_t, uint64_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svset2_s8)))
svint8x2_t svset2_s8(svint8x2_t, uint64_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svset2_f64)))
svfloat64x2_t svset2_f64(svfloat64x2_t, uint64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svset2_f32)))
svfloat32x2_t svset2_f32(svfloat32x2_t, uint64_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svset2_f16)))
svfloat16x2_t svset2_f16(svfloat16x2_t, uint64_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svset2_s32)))
svint32x2_t svset2_s32(svint32x2_t, uint64_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svset2_s64)))
svint64x2_t svset2_s64(svint64x2_t, uint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svset2_s16)))
svint16x2_t svset2_s16(svint16x2_t, uint64_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svset3_u8)))
svuint8x3_t svset3_u8(svuint8x3_t, uint64_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svset3_u32)))
svuint32x3_t svset3_u32(svuint32x3_t, uint64_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svset3_u64)))
svuint64x3_t svset3_u64(svuint64x3_t, uint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svset3_u16)))
svuint16x3_t svset3_u16(svuint16x3_t, uint64_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svset3_s8)))
svint8x3_t svset3_s8(svint8x3_t, uint64_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svset3_f64)))
svfloat64x3_t svset3_f64(svfloat64x3_t, uint64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svset3_f32)))
svfloat32x3_t svset3_f32(svfloat32x3_t, uint64_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svset3_f16)))
svfloat16x3_t svset3_f16(svfloat16x3_t, uint64_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svset3_s32)))
svint32x3_t svset3_s32(svint32x3_t, uint64_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svset3_s64)))
svint64x3_t svset3_s64(svint64x3_t, uint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svset3_s16)))
svint16x3_t svset3_s16(svint16x3_t, uint64_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svset4_u8)))
svuint8x4_t svset4_u8(svuint8x4_t, uint64_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svset4_u32)))
svuint32x4_t svset4_u32(svuint32x4_t, uint64_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svset4_u64)))
svuint64x4_t svset4_u64(svuint64x4_t, uint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svset4_u16)))
svuint16x4_t svset4_u16(svuint16x4_t, uint64_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svset4_s8)))
svint8x4_t svset4_s8(svint8x4_t, uint64_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svset4_f64)))
svfloat64x4_t svset4_f64(svfloat64x4_t, uint64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svset4_f32)))
svfloat32x4_t svset4_f32(svfloat32x4_t, uint64_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svset4_f16)))
svfloat16x4_t svset4_f16(svfloat16x4_t, uint64_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svset4_s32)))
svint32x4_t svset4_s32(svint32x4_t, uint64_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svset4_s64)))
svint64x4_t svset4_s64(svint64x4_t, uint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svset4_s16)))
svint16x4_t svset4_s16(svint16x4_t, uint64_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsetffr)))
void svsetffr(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsplice_u8), arm_streaming_compatible))
svuint8_t svsplice_u8(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsplice_u32), arm_streaming_compatible))
svuint32_t svsplice_u32(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsplice_u64), arm_streaming_compatible))
svuint64_t svsplice_u64(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsplice_u16), arm_streaming_compatible))
svuint16_t svsplice_u16(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsplice_s8), arm_streaming_compatible))
svint8_t svsplice_s8(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsplice_f64), arm_streaming_compatible))
svfloat64_t svsplice_f64(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsplice_f32), arm_streaming_compatible))
svfloat32_t svsplice_f32(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsplice_f16), arm_streaming_compatible))
svfloat16_t svsplice_f16(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsplice_s32), arm_streaming_compatible))
svint32_t svsplice_s32(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsplice_s64), arm_streaming_compatible))
svint64_t svsplice_s64(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsplice_s16), arm_streaming_compatible))
svint16_t svsplice_s16(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsqrt_f64_m), arm_streaming_compatible))
svfloat64_t svsqrt_f64_m(svfloat64_t, svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsqrt_f32_m), arm_streaming_compatible))
svfloat32_t svsqrt_f32_m(svfloat32_t, svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsqrt_f16_m), arm_streaming_compatible))
svfloat16_t svsqrt_f16_m(svfloat16_t, svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsqrt_f64_x), arm_streaming_compatible))
svfloat64_t svsqrt_f64_x(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsqrt_f32_x), arm_streaming_compatible))
svfloat32_t svsqrt_f32_x(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsqrt_f16_x), arm_streaming_compatible))
svfloat16_t svsqrt_f16_x(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsqrt_f64_z), arm_streaming_compatible))
svfloat64_t svsqrt_f64_z(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsqrt_f32_z), arm_streaming_compatible))
svfloat32_t svsqrt_f32_z(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsqrt_f16_z), arm_streaming_compatible))
svfloat16_t svsqrt_f16_z(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_u8), arm_streaming_compatible))
void svst1_u8(svbool_t, uint8_t *, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_u32), arm_streaming_compatible))
void svst1_u32(svbool_t, uint32_t *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_u64), arm_streaming_compatible))
void svst1_u64(svbool_t, uint64_t *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_u16), arm_streaming_compatible))
void svst1_u16(svbool_t, uint16_t *, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_s8), arm_streaming_compatible))
void svst1_s8(svbool_t, int8_t *, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_f64), arm_streaming_compatible))
void svst1_f64(svbool_t, float64_t *, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_f32), arm_streaming_compatible))
void svst1_f32(svbool_t, float32_t *, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_f16), arm_streaming_compatible))
void svst1_f16(svbool_t, float16_t *, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_s32), arm_streaming_compatible))
void svst1_s32(svbool_t, int32_t *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_s64), arm_streaming_compatible))
void svst1_s64(svbool_t, int64_t *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_s16), arm_streaming_compatible))
void svst1_s16(svbool_t, int16_t *, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32base_index_u32)))
void svst1_scatter_u32base_index_u32(svbool_t, svuint32_t, int64_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64base_index_u64)))
void svst1_scatter_u64base_index_u64(svbool_t, svuint64_t, int64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64base_index_f64)))
void svst1_scatter_u64base_index_f64(svbool_t, svuint64_t, int64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32base_index_f32)))
void svst1_scatter_u32base_index_f32(svbool_t, svuint32_t, int64_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32base_index_s32)))
void svst1_scatter_u32base_index_s32(svbool_t, svuint32_t, int64_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64base_index_s64)))
void svst1_scatter_u64base_index_s64(svbool_t, svuint64_t, int64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32base_offset_u32)))
void svst1_scatter_u32base_offset_u32(svbool_t, svuint32_t, int64_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64base_offset_u64)))
void svst1_scatter_u64base_offset_u64(svbool_t, svuint64_t, int64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64base_offset_f64)))
void svst1_scatter_u64base_offset_f64(svbool_t, svuint64_t, int64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32base_offset_f32)))
void svst1_scatter_u32base_offset_f32(svbool_t, svuint32_t, int64_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32base_offset_s32)))
void svst1_scatter_u32base_offset_s32(svbool_t, svuint32_t, int64_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64base_offset_s64)))
void svst1_scatter_u64base_offset_s64(svbool_t, svuint64_t, int64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32base_u32)))
void svst1_scatter_u32base_u32(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64base_u64)))
void svst1_scatter_u64base_u64(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64base_f64)))
void svst1_scatter_u64base_f64(svbool_t, svuint64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32base_f32)))
void svst1_scatter_u32base_f32(svbool_t, svuint32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32base_s32)))
void svst1_scatter_u32base_s32(svbool_t, svuint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64base_s64)))
void svst1_scatter_u64base_s64(svbool_t, svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_s32index_u32)))
void svst1_scatter_s32index_u32(svbool_t, uint32_t *, svint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_s32index_f32)))
void svst1_scatter_s32index_f32(svbool_t, float32_t *, svint32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_s32index_s32)))
void svst1_scatter_s32index_s32(svbool_t, int32_t *, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32index_u32)))
void svst1_scatter_u32index_u32(svbool_t, uint32_t *, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32index_f32)))
void svst1_scatter_u32index_f32(svbool_t, float32_t *, svuint32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32index_s32)))
void svst1_scatter_u32index_s32(svbool_t, int32_t *, svuint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_s64index_u64)))
void svst1_scatter_s64index_u64(svbool_t, uint64_t *, svint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_s64index_f64)))
void svst1_scatter_s64index_f64(svbool_t, float64_t *, svint64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_s64index_s64)))
void svst1_scatter_s64index_s64(svbool_t, int64_t *, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64index_u64)))
void svst1_scatter_u64index_u64(svbool_t, uint64_t *, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64index_f64)))
void svst1_scatter_u64index_f64(svbool_t, float64_t *, svuint64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64index_s64)))
void svst1_scatter_u64index_s64(svbool_t, int64_t *, svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_s32offset_u32)))
void svst1_scatter_s32offset_u32(svbool_t, uint32_t *, svint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_s32offset_f32)))
void svst1_scatter_s32offset_f32(svbool_t, float32_t *, svint32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_s32offset_s32)))
void svst1_scatter_s32offset_s32(svbool_t, int32_t *, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32offset_u32)))
void svst1_scatter_u32offset_u32(svbool_t, uint32_t *, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32offset_f32)))
void svst1_scatter_u32offset_f32(svbool_t, float32_t *, svuint32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32offset_s32)))
void svst1_scatter_u32offset_s32(svbool_t, int32_t *, svuint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_s64offset_u64)))
void svst1_scatter_s64offset_u64(svbool_t, uint64_t *, svint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_s64offset_f64)))
void svst1_scatter_s64offset_f64(svbool_t, float64_t *, svint64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_s64offset_s64)))
void svst1_scatter_s64offset_s64(svbool_t, int64_t *, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64offset_u64)))
void svst1_scatter_u64offset_u64(svbool_t, uint64_t *, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64offset_f64)))
void svst1_scatter_u64offset_f64(svbool_t, float64_t *, svuint64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64offset_s64)))
void svst1_scatter_u64offset_s64(svbool_t, int64_t *, svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_u8), arm_streaming_compatible))
void svst1_vnum_u8(svbool_t, uint8_t *, int64_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_u32), arm_streaming_compatible))
void svst1_vnum_u32(svbool_t, uint32_t *, int64_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_u64), arm_streaming_compatible))
void svst1_vnum_u64(svbool_t, uint64_t *, int64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_u16), arm_streaming_compatible))
void svst1_vnum_u16(svbool_t, uint16_t *, int64_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_s8), arm_streaming_compatible))
void svst1_vnum_s8(svbool_t, int8_t *, int64_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_f64), arm_streaming_compatible))
void svst1_vnum_f64(svbool_t, float64_t *, int64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_f32), arm_streaming_compatible))
void svst1_vnum_f32(svbool_t, float32_t *, int64_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_f16), arm_streaming_compatible))
void svst1_vnum_f16(svbool_t, float16_t *, int64_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_s32), arm_streaming_compatible))
void svst1_vnum_s32(svbool_t, int32_t *, int64_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_s64), arm_streaming_compatible))
void svst1_vnum_s64(svbool_t, int64_t *, int64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_s16), arm_streaming_compatible))
void svst1_vnum_s16(svbool_t, int16_t *, int64_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_s32), arm_streaming_compatible))
void svst1b_s32(svbool_t, int8_t *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_s64), arm_streaming_compatible))
void svst1b_s64(svbool_t, int8_t *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_s16), arm_streaming_compatible))
void svst1b_s16(svbool_t, int8_t *, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_u32), arm_streaming_compatible))
void svst1b_u32(svbool_t, uint8_t *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_u64), arm_streaming_compatible))
void svst1b_u64(svbool_t, uint8_t *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_u16), arm_streaming_compatible))
void svst1b_u16(svbool_t, uint8_t *, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_u32base_offset_u32)))
void svst1b_scatter_u32base_offset_u32(svbool_t, svuint32_t, int64_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_u64base_offset_u64)))
void svst1b_scatter_u64base_offset_u64(svbool_t, svuint64_t, int64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_u32base_offset_s32)))
void svst1b_scatter_u32base_offset_s32(svbool_t, svuint32_t, int64_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_u64base_offset_s64)))
void svst1b_scatter_u64base_offset_s64(svbool_t, svuint64_t, int64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_u32base_u32)))
void svst1b_scatter_u32base_u32(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_u64base_u64)))
void svst1b_scatter_u64base_u64(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_u32base_s32)))
void svst1b_scatter_u32base_s32(svbool_t, svuint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_u64base_s64)))
void svst1b_scatter_u64base_s64(svbool_t, svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_s32offset_s32)))
void svst1b_scatter_s32offset_s32(svbool_t, int8_t *, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_s32offset_u32)))
void svst1b_scatter_s32offset_u32(svbool_t, uint8_t *, svint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_u32offset_s32)))
void svst1b_scatter_u32offset_s32(svbool_t, int8_t *, svuint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_u32offset_u32)))
void svst1b_scatter_u32offset_u32(svbool_t, uint8_t *, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_s64offset_s64)))
void svst1b_scatter_s64offset_s64(svbool_t, int8_t *, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_s64offset_u64)))
void svst1b_scatter_s64offset_u64(svbool_t, uint8_t *, svint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_u64offset_s64)))
void svst1b_scatter_u64offset_s64(svbool_t, int8_t *, svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_u64offset_u64)))
void svst1b_scatter_u64offset_u64(svbool_t, uint8_t *, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_vnum_s32), arm_streaming_compatible))
void svst1b_vnum_s32(svbool_t, int8_t *, int64_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_vnum_s64), arm_streaming_compatible))
void svst1b_vnum_s64(svbool_t, int8_t *, int64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_vnum_s16), arm_streaming_compatible))
void svst1b_vnum_s16(svbool_t, int8_t *, int64_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_vnum_u32), arm_streaming_compatible))
void svst1b_vnum_u32(svbool_t, uint8_t *, int64_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_vnum_u64), arm_streaming_compatible))
void svst1b_vnum_u64(svbool_t, uint8_t *, int64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_vnum_u16), arm_streaming_compatible))
void svst1b_vnum_u16(svbool_t, uint8_t *, int64_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_s32), arm_streaming_compatible))
void svst1h_s32(svbool_t, int16_t *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_s64), arm_streaming_compatible))
void svst1h_s64(svbool_t, int16_t *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_u32), arm_streaming_compatible))
void svst1h_u32(svbool_t, uint16_t *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_u64), arm_streaming_compatible))
void svst1h_u64(svbool_t, uint16_t *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u32base_index_u32)))
void svst1h_scatter_u32base_index_u32(svbool_t, svuint32_t, int64_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u64base_index_u64)))
void svst1h_scatter_u64base_index_u64(svbool_t, svuint64_t, int64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u32base_index_s32)))
void svst1h_scatter_u32base_index_s32(svbool_t, svuint32_t, int64_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u64base_index_s64)))
void svst1h_scatter_u64base_index_s64(svbool_t, svuint64_t, int64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u32base_offset_u32)))
void svst1h_scatter_u32base_offset_u32(svbool_t, svuint32_t, int64_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u64base_offset_u64)))
void svst1h_scatter_u64base_offset_u64(svbool_t, svuint64_t, int64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u32base_offset_s32)))
void svst1h_scatter_u32base_offset_s32(svbool_t, svuint32_t, int64_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u64base_offset_s64)))
void svst1h_scatter_u64base_offset_s64(svbool_t, svuint64_t, int64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u32base_u32)))
void svst1h_scatter_u32base_u32(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u64base_u64)))
void svst1h_scatter_u64base_u64(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u32base_s32)))
void svst1h_scatter_u32base_s32(svbool_t, svuint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u64base_s64)))
void svst1h_scatter_u64base_s64(svbool_t, svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_s32index_s32)))
void svst1h_scatter_s32index_s32(svbool_t, int16_t *, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_s32index_u32)))
void svst1h_scatter_s32index_u32(svbool_t, uint16_t *, svint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u32index_s32)))
void svst1h_scatter_u32index_s32(svbool_t, int16_t *, svuint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u32index_u32)))
void svst1h_scatter_u32index_u32(svbool_t, uint16_t *, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_s64index_s64)))
void svst1h_scatter_s64index_s64(svbool_t, int16_t *, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_s64index_u64)))
void svst1h_scatter_s64index_u64(svbool_t, uint16_t *, svint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u64index_s64)))
void svst1h_scatter_u64index_s64(svbool_t, int16_t *, svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u64index_u64)))
void svst1h_scatter_u64index_u64(svbool_t, uint16_t *, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_s32offset_s32)))
void svst1h_scatter_s32offset_s32(svbool_t, int16_t *, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_s32offset_u32)))
void svst1h_scatter_s32offset_u32(svbool_t, uint16_t *, svint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u32offset_s32)))
void svst1h_scatter_u32offset_s32(svbool_t, int16_t *, svuint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u32offset_u32)))
void svst1h_scatter_u32offset_u32(svbool_t, uint16_t *, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_s64offset_s64)))
void svst1h_scatter_s64offset_s64(svbool_t, int16_t *, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_s64offset_u64)))
void svst1h_scatter_s64offset_u64(svbool_t, uint16_t *, svint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u64offset_s64)))
void svst1h_scatter_u64offset_s64(svbool_t, int16_t *, svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u64offset_u64)))
void svst1h_scatter_u64offset_u64(svbool_t, uint16_t *, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_vnum_s32), arm_streaming_compatible))
void svst1h_vnum_s32(svbool_t, int16_t *, int64_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_vnum_s64), arm_streaming_compatible))
void svst1h_vnum_s64(svbool_t, int16_t *, int64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_vnum_u32), arm_streaming_compatible))
void svst1h_vnum_u32(svbool_t, uint16_t *, int64_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_vnum_u64), arm_streaming_compatible))
void svst1h_vnum_u64(svbool_t, uint16_t *, int64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_s64), arm_streaming_compatible))
void svst1w_s64(svbool_t, int32_t *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_u64), arm_streaming_compatible))
void svst1w_u64(svbool_t, uint32_t *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_scatter_u64base_index_u64)))
void svst1w_scatter_u64base_index_u64(svbool_t, svuint64_t, int64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_scatter_u64base_index_s64)))
void svst1w_scatter_u64base_index_s64(svbool_t, svuint64_t, int64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_scatter_u64base_offset_u64)))
void svst1w_scatter_u64base_offset_u64(svbool_t, svuint64_t, int64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_scatter_u64base_offset_s64)))
void svst1w_scatter_u64base_offset_s64(svbool_t, svuint64_t, int64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_scatter_u64base_u64)))
void svst1w_scatter_u64base_u64(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_scatter_u64base_s64)))
void svst1w_scatter_u64base_s64(svbool_t, svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_scatter_s64index_s64)))
void svst1w_scatter_s64index_s64(svbool_t, int32_t *, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_scatter_s64index_u64)))
void svst1w_scatter_s64index_u64(svbool_t, uint32_t *, svint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_scatter_u64index_s64)))
void svst1w_scatter_u64index_s64(svbool_t, int32_t *, svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_scatter_u64index_u64)))
void svst1w_scatter_u64index_u64(svbool_t, uint32_t *, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_scatter_s64offset_s64)))
void svst1w_scatter_s64offset_s64(svbool_t, int32_t *, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_scatter_s64offset_u64)))
void svst1w_scatter_s64offset_u64(svbool_t, uint32_t *, svint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_scatter_u64offset_s64)))
void svst1w_scatter_u64offset_s64(svbool_t, int32_t *, svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_scatter_u64offset_u64)))
void svst1w_scatter_u64offset_u64(svbool_t, uint32_t *, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_vnum_s64), arm_streaming_compatible))
void svst1w_vnum_s64(svbool_t, int32_t *, int64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_vnum_u64), arm_streaming_compatible))
void svst1w_vnum_u64(svbool_t, uint32_t *, int64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2_u8), arm_streaming_compatible))
void svst2_u8(svbool_t, uint8_t *, svuint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2_u32), arm_streaming_compatible))
void svst2_u32(svbool_t, uint32_t *, svuint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2_u64), arm_streaming_compatible))
void svst2_u64(svbool_t, uint64_t *, svuint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2_u16), arm_streaming_compatible))
void svst2_u16(svbool_t, uint16_t *, svuint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2_s8), arm_streaming_compatible))
void svst2_s8(svbool_t, int8_t *, svint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2_f64), arm_streaming_compatible))
void svst2_f64(svbool_t, float64_t *, svfloat64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2_f32), arm_streaming_compatible))
void svst2_f32(svbool_t, float32_t *, svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2_f16), arm_streaming_compatible))
void svst2_f16(svbool_t, float16_t *, svfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2_s32), arm_streaming_compatible))
void svst2_s32(svbool_t, int32_t *, svint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2_s64), arm_streaming_compatible))
void svst2_s64(svbool_t, int64_t *, svint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2_s16), arm_streaming_compatible))
void svst2_s16(svbool_t, int16_t *, svint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2_vnum_u8), arm_streaming_compatible))
void svst2_vnum_u8(svbool_t, uint8_t *, int64_t, svuint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2_vnum_u32), arm_streaming_compatible))
void svst2_vnum_u32(svbool_t, uint32_t *, int64_t, svuint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2_vnum_u64), arm_streaming_compatible))
void svst2_vnum_u64(svbool_t, uint64_t *, int64_t, svuint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2_vnum_u16), arm_streaming_compatible))
void svst2_vnum_u16(svbool_t, uint16_t *, int64_t, svuint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2_vnum_s8), arm_streaming_compatible))
void svst2_vnum_s8(svbool_t, int8_t *, int64_t, svint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2_vnum_f64), arm_streaming_compatible))
void svst2_vnum_f64(svbool_t, float64_t *, int64_t, svfloat64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2_vnum_f32), arm_streaming_compatible))
void svst2_vnum_f32(svbool_t, float32_t *, int64_t, svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2_vnum_f16), arm_streaming_compatible))
void svst2_vnum_f16(svbool_t, float16_t *, int64_t, svfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2_vnum_s32), arm_streaming_compatible))
void svst2_vnum_s32(svbool_t, int32_t *, int64_t, svint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2_vnum_s64), arm_streaming_compatible))
void svst2_vnum_s64(svbool_t, int64_t *, int64_t, svint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2_vnum_s16), arm_streaming_compatible))
void svst2_vnum_s16(svbool_t, int16_t *, int64_t, svint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3_u8), arm_streaming_compatible))
void svst3_u8(svbool_t, uint8_t *, svuint8x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3_u32), arm_streaming_compatible))
void svst3_u32(svbool_t, uint32_t *, svuint32x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3_u64), arm_streaming_compatible))
void svst3_u64(svbool_t, uint64_t *, svuint64x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3_u16), arm_streaming_compatible))
void svst3_u16(svbool_t, uint16_t *, svuint16x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3_s8), arm_streaming_compatible))
void svst3_s8(svbool_t, int8_t *, svint8x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3_f64), arm_streaming_compatible))
void svst3_f64(svbool_t, float64_t *, svfloat64x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3_f32), arm_streaming_compatible))
void svst3_f32(svbool_t, float32_t *, svfloat32x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3_f16), arm_streaming_compatible))
void svst3_f16(svbool_t, float16_t *, svfloat16x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3_s32), arm_streaming_compatible))
void svst3_s32(svbool_t, int32_t *, svint32x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3_s64), arm_streaming_compatible))
void svst3_s64(svbool_t, int64_t *, svint64x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3_s16), arm_streaming_compatible))
void svst3_s16(svbool_t, int16_t *, svint16x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3_vnum_u8), arm_streaming_compatible))
void svst3_vnum_u8(svbool_t, uint8_t *, int64_t, svuint8x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3_vnum_u32), arm_streaming_compatible))
void svst3_vnum_u32(svbool_t, uint32_t *, int64_t, svuint32x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3_vnum_u64), arm_streaming_compatible))
void svst3_vnum_u64(svbool_t, uint64_t *, int64_t, svuint64x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3_vnum_u16), arm_streaming_compatible))
void svst3_vnum_u16(svbool_t, uint16_t *, int64_t, svuint16x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3_vnum_s8), arm_streaming_compatible))
void svst3_vnum_s8(svbool_t, int8_t *, int64_t, svint8x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3_vnum_f64), arm_streaming_compatible))
void svst3_vnum_f64(svbool_t, float64_t *, int64_t, svfloat64x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3_vnum_f32), arm_streaming_compatible))
void svst3_vnum_f32(svbool_t, float32_t *, int64_t, svfloat32x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3_vnum_f16), arm_streaming_compatible))
void svst3_vnum_f16(svbool_t, float16_t *, int64_t, svfloat16x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3_vnum_s32), arm_streaming_compatible))
void svst3_vnum_s32(svbool_t, int32_t *, int64_t, svint32x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3_vnum_s64), arm_streaming_compatible))
void svst3_vnum_s64(svbool_t, int64_t *, int64_t, svint64x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3_vnum_s16), arm_streaming_compatible))
void svst3_vnum_s16(svbool_t, int16_t *, int64_t, svint16x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4_u8), arm_streaming_compatible))
void svst4_u8(svbool_t, uint8_t *, svuint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4_u32), arm_streaming_compatible))
void svst4_u32(svbool_t, uint32_t *, svuint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4_u64), arm_streaming_compatible))
void svst4_u64(svbool_t, uint64_t *, svuint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4_u16), arm_streaming_compatible))
void svst4_u16(svbool_t, uint16_t *, svuint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4_s8), arm_streaming_compatible))
void svst4_s8(svbool_t, int8_t *, svint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4_f64), arm_streaming_compatible))
void svst4_f64(svbool_t, float64_t *, svfloat64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4_f32), arm_streaming_compatible))
void svst4_f32(svbool_t, float32_t *, svfloat32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4_f16), arm_streaming_compatible))
void svst4_f16(svbool_t, float16_t *, svfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4_s32), arm_streaming_compatible))
void svst4_s32(svbool_t, int32_t *, svint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4_s64), arm_streaming_compatible))
void svst4_s64(svbool_t, int64_t *, svint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4_s16), arm_streaming_compatible))
void svst4_s16(svbool_t, int16_t *, svint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4_vnum_u8), arm_streaming_compatible))
void svst4_vnum_u8(svbool_t, uint8_t *, int64_t, svuint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4_vnum_u32), arm_streaming_compatible))
void svst4_vnum_u32(svbool_t, uint32_t *, int64_t, svuint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4_vnum_u64), arm_streaming_compatible))
void svst4_vnum_u64(svbool_t, uint64_t *, int64_t, svuint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4_vnum_u16), arm_streaming_compatible))
void svst4_vnum_u16(svbool_t, uint16_t *, int64_t, svuint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4_vnum_s8), arm_streaming_compatible))
void svst4_vnum_s8(svbool_t, int8_t *, int64_t, svint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4_vnum_f64), arm_streaming_compatible))
void svst4_vnum_f64(svbool_t, float64_t *, int64_t, svfloat64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4_vnum_f32), arm_streaming_compatible))
void svst4_vnum_f32(svbool_t, float32_t *, int64_t, svfloat32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4_vnum_f16), arm_streaming_compatible))
void svst4_vnum_f16(svbool_t, float16_t *, int64_t, svfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4_vnum_s32), arm_streaming_compatible))
void svst4_vnum_s32(svbool_t, int32_t *, int64_t, svint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4_vnum_s64), arm_streaming_compatible))
void svst4_vnum_s64(svbool_t, int64_t *, int64_t, svint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4_vnum_s16), arm_streaming_compatible))
void svst4_vnum_s16(svbool_t, int16_t *, int64_t, svint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_u8), arm_streaming_compatible))
void svstnt1_u8(svbool_t, uint8_t *, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_u32), arm_streaming_compatible))
void svstnt1_u32(svbool_t, uint32_t *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_u64), arm_streaming_compatible))
void svstnt1_u64(svbool_t, uint64_t *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_u16), arm_streaming_compatible))
void svstnt1_u16(svbool_t, uint16_t *, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_s8), arm_streaming_compatible))
void svstnt1_s8(svbool_t, int8_t *, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_f64), arm_streaming_compatible))
void svstnt1_f64(svbool_t, float64_t *, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_f32), arm_streaming_compatible))
void svstnt1_f32(svbool_t, float32_t *, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_f16), arm_streaming_compatible))
void svstnt1_f16(svbool_t, float16_t *, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_s32), arm_streaming_compatible))
void svstnt1_s32(svbool_t, int32_t *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_s64), arm_streaming_compatible))
void svstnt1_s64(svbool_t, int64_t *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_s16), arm_streaming_compatible))
void svstnt1_s16(svbool_t, int16_t *, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_u8), arm_streaming_compatible))
void svstnt1_vnum_u8(svbool_t, uint8_t *, int64_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_u32), arm_streaming_compatible))
void svstnt1_vnum_u32(svbool_t, uint32_t *, int64_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_u64), arm_streaming_compatible))
void svstnt1_vnum_u64(svbool_t, uint64_t *, int64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_u16), arm_streaming_compatible))
void svstnt1_vnum_u16(svbool_t, uint16_t *, int64_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_s8), arm_streaming_compatible))
void svstnt1_vnum_s8(svbool_t, int8_t *, int64_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_f64), arm_streaming_compatible))
void svstnt1_vnum_f64(svbool_t, float64_t *, int64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_f32), arm_streaming_compatible))
void svstnt1_vnum_f32(svbool_t, float32_t *, int64_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_f16), arm_streaming_compatible))
void svstnt1_vnum_f16(svbool_t, float16_t *, int64_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_s32), arm_streaming_compatible))
void svstnt1_vnum_s32(svbool_t, int32_t *, int64_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_s64), arm_streaming_compatible))
void svstnt1_vnum_s64(svbool_t, int64_t *, int64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_s16), arm_streaming_compatible))
void svstnt1_vnum_s16(svbool_t, int16_t *, int64_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_f64_m), arm_streaming_compatible))
svfloat64_t svsub_n_f64_m(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_f32_m), arm_streaming_compatible))
svfloat32_t svsub_n_f32_m(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_f16_m), arm_streaming_compatible))
svfloat16_t svsub_n_f16_m(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_f64_x), arm_streaming_compatible))
svfloat64_t svsub_n_f64_x(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_f32_x), arm_streaming_compatible))
svfloat32_t svsub_n_f32_x(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_f16_x), arm_streaming_compatible))
svfloat16_t svsub_n_f16_x(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_f64_z), arm_streaming_compatible))
svfloat64_t svsub_n_f64_z(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_f32_z), arm_streaming_compatible))
svfloat32_t svsub_n_f32_z(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_f16_z), arm_streaming_compatible))
svfloat16_t svsub_n_f16_z(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_u8_m), arm_streaming_compatible))
svuint8_t svsub_n_u8_m(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_u32_m), arm_streaming_compatible))
svuint32_t svsub_n_u32_m(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_u64_m), arm_streaming_compatible))
svuint64_t svsub_n_u64_m(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_u16_m), arm_streaming_compatible))
svuint16_t svsub_n_u16_m(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_s8_m), arm_streaming_compatible))
svint8_t svsub_n_s8_m(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_s32_m), arm_streaming_compatible))
svint32_t svsub_n_s32_m(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_s64_m), arm_streaming_compatible))
svint64_t svsub_n_s64_m(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_s16_m), arm_streaming_compatible))
svint16_t svsub_n_s16_m(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_u8_x), arm_streaming_compatible))
svuint8_t svsub_n_u8_x(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_u32_x), arm_streaming_compatible))
svuint32_t svsub_n_u32_x(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_u64_x), arm_streaming_compatible))
svuint64_t svsub_n_u64_x(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_u16_x), arm_streaming_compatible))
svuint16_t svsub_n_u16_x(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_s8_x), arm_streaming_compatible))
svint8_t svsub_n_s8_x(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_s32_x), arm_streaming_compatible))
svint32_t svsub_n_s32_x(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_s64_x), arm_streaming_compatible))
svint64_t svsub_n_s64_x(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_s16_x), arm_streaming_compatible))
svint16_t svsub_n_s16_x(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_u8_z), arm_streaming_compatible))
svuint8_t svsub_n_u8_z(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_u32_z), arm_streaming_compatible))
svuint32_t svsub_n_u32_z(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_u64_z), arm_streaming_compatible))
svuint64_t svsub_n_u64_z(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_u16_z), arm_streaming_compatible))
svuint16_t svsub_n_u16_z(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_s8_z), arm_streaming_compatible))
svint8_t svsub_n_s8_z(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_s32_z), arm_streaming_compatible))
svint32_t svsub_n_s32_z(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_s64_z), arm_streaming_compatible))
svint64_t svsub_n_s64_z(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_s16_z), arm_streaming_compatible))
svint16_t svsub_n_s16_z(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_f64_m), arm_streaming_compatible))
svfloat64_t svsub_f64_m(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_f32_m), arm_streaming_compatible))
svfloat32_t svsub_f32_m(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_f16_m), arm_streaming_compatible))
svfloat16_t svsub_f16_m(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_f64_x), arm_streaming_compatible))
svfloat64_t svsub_f64_x(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_f32_x), arm_streaming_compatible))
svfloat32_t svsub_f32_x(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_f16_x), arm_streaming_compatible))
svfloat16_t svsub_f16_x(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_f64_z), arm_streaming_compatible))
svfloat64_t svsub_f64_z(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_f32_z), arm_streaming_compatible))
svfloat32_t svsub_f32_z(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_f16_z), arm_streaming_compatible))
svfloat16_t svsub_f16_z(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_u8_m), arm_streaming_compatible))
svuint8_t svsub_u8_m(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_u32_m), arm_streaming_compatible))
svuint32_t svsub_u32_m(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_u64_m), arm_streaming_compatible))
svuint64_t svsub_u64_m(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_u16_m), arm_streaming_compatible))
svuint16_t svsub_u16_m(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_s8_m), arm_streaming_compatible))
svint8_t svsub_s8_m(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_s32_m), arm_streaming_compatible))
svint32_t svsub_s32_m(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_s64_m), arm_streaming_compatible))
svint64_t svsub_s64_m(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_s16_m), arm_streaming_compatible))
svint16_t svsub_s16_m(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_u8_x), arm_streaming_compatible))
svuint8_t svsub_u8_x(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_u32_x), arm_streaming_compatible))
svuint32_t svsub_u32_x(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_u64_x), arm_streaming_compatible))
svuint64_t svsub_u64_x(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_u16_x), arm_streaming_compatible))
svuint16_t svsub_u16_x(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_s8_x), arm_streaming_compatible))
svint8_t svsub_s8_x(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_s32_x), arm_streaming_compatible))
svint32_t svsub_s32_x(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_s64_x), arm_streaming_compatible))
svint64_t svsub_s64_x(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_s16_x), arm_streaming_compatible))
svint16_t svsub_s16_x(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_u8_z), arm_streaming_compatible))
svuint8_t svsub_u8_z(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_u32_z), arm_streaming_compatible))
svuint32_t svsub_u32_z(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_u64_z), arm_streaming_compatible))
svuint64_t svsub_u64_z(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_u16_z), arm_streaming_compatible))
svuint16_t svsub_u16_z(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_s8_z), arm_streaming_compatible))
svint8_t svsub_s8_z(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_s32_z), arm_streaming_compatible))
svint32_t svsub_s32_z(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_s64_z), arm_streaming_compatible))
svint64_t svsub_s64_z(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_s16_z), arm_streaming_compatible))
svint16_t svsub_s16_z(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_n_f64_m), arm_streaming_compatible))
svfloat64_t svsubr_n_f64_m(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_n_f32_m), arm_streaming_compatible))
svfloat32_t svsubr_n_f32_m(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_n_f16_m), arm_streaming_compatible))
svfloat16_t svsubr_n_f16_m(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_n_f64_x), arm_streaming_compatible))
svfloat64_t svsubr_n_f64_x(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_n_f32_x), arm_streaming_compatible))
svfloat32_t svsubr_n_f32_x(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_n_f16_x), arm_streaming_compatible))
svfloat16_t svsubr_n_f16_x(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_n_f64_z), arm_streaming_compatible))
svfloat64_t svsubr_n_f64_z(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_n_f32_z), arm_streaming_compatible))
svfloat32_t svsubr_n_f32_z(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_n_f16_z), arm_streaming_compatible))
svfloat16_t svsubr_n_f16_z(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_n_u8_m), arm_streaming_compatible))
svuint8_t svsubr_n_u8_m(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_n_u32_m), arm_streaming_compatible))
svuint32_t svsubr_n_u32_m(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_n_u64_m), arm_streaming_compatible))
svuint64_t svsubr_n_u64_m(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_n_u16_m), arm_streaming_compatible))
svuint16_t svsubr_n_u16_m(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_n_s8_m), arm_streaming_compatible))
svint8_t svsubr_n_s8_m(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_n_s32_m), arm_streaming_compatible))
svint32_t svsubr_n_s32_m(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_n_s64_m), arm_streaming_compatible))
svint64_t svsubr_n_s64_m(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_n_s16_m), arm_streaming_compatible))
svint16_t svsubr_n_s16_m(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_n_u8_x), arm_streaming_compatible))
svuint8_t svsubr_n_u8_x(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_n_u32_x), arm_streaming_compatible))
svuint32_t svsubr_n_u32_x(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_n_u64_x), arm_streaming_compatible))
svuint64_t svsubr_n_u64_x(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_n_u16_x), arm_streaming_compatible))
svuint16_t svsubr_n_u16_x(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_n_s8_x), arm_streaming_compatible))
svint8_t svsubr_n_s8_x(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_n_s32_x), arm_streaming_compatible))
svint32_t svsubr_n_s32_x(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_n_s64_x), arm_streaming_compatible))
svint64_t svsubr_n_s64_x(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_n_s16_x), arm_streaming_compatible))
svint16_t svsubr_n_s16_x(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_n_u8_z), arm_streaming_compatible))
svuint8_t svsubr_n_u8_z(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_n_u32_z), arm_streaming_compatible))
svuint32_t svsubr_n_u32_z(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_n_u64_z), arm_streaming_compatible))
svuint64_t svsubr_n_u64_z(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_n_u16_z), arm_streaming_compatible))
svuint16_t svsubr_n_u16_z(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_n_s8_z), arm_streaming_compatible))
svint8_t svsubr_n_s8_z(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_n_s32_z), arm_streaming_compatible))
svint32_t svsubr_n_s32_z(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_n_s64_z), arm_streaming_compatible))
svint64_t svsubr_n_s64_z(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_n_s16_z), arm_streaming_compatible))
svint16_t svsubr_n_s16_z(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_f64_m), arm_streaming_compatible))
svfloat64_t svsubr_f64_m(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_f32_m), arm_streaming_compatible))
svfloat32_t svsubr_f32_m(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_f16_m), arm_streaming_compatible))
svfloat16_t svsubr_f16_m(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_f64_x), arm_streaming_compatible))
svfloat64_t svsubr_f64_x(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_f32_x), arm_streaming_compatible))
svfloat32_t svsubr_f32_x(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_f16_x), arm_streaming_compatible))
svfloat16_t svsubr_f16_x(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_f64_z), arm_streaming_compatible))
svfloat64_t svsubr_f64_z(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_f32_z), arm_streaming_compatible))
svfloat32_t svsubr_f32_z(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_f16_z), arm_streaming_compatible))
svfloat16_t svsubr_f16_z(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_u8_m), arm_streaming_compatible))
svuint8_t svsubr_u8_m(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_u32_m), arm_streaming_compatible))
svuint32_t svsubr_u32_m(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_u64_m), arm_streaming_compatible))
svuint64_t svsubr_u64_m(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_u16_m), arm_streaming_compatible))
svuint16_t svsubr_u16_m(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_s8_m), arm_streaming_compatible))
svint8_t svsubr_s8_m(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_s32_m), arm_streaming_compatible))
svint32_t svsubr_s32_m(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_s64_m), arm_streaming_compatible))
svint64_t svsubr_s64_m(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_s16_m), arm_streaming_compatible))
svint16_t svsubr_s16_m(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_u8_x), arm_streaming_compatible))
svuint8_t svsubr_u8_x(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_u32_x), arm_streaming_compatible))
svuint32_t svsubr_u32_x(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_u64_x), arm_streaming_compatible))
svuint64_t svsubr_u64_x(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_u16_x), arm_streaming_compatible))
svuint16_t svsubr_u16_x(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_s8_x), arm_streaming_compatible))
svint8_t svsubr_s8_x(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_s32_x), arm_streaming_compatible))
svint32_t svsubr_s32_x(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_s64_x), arm_streaming_compatible))
svint64_t svsubr_s64_x(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_s16_x), arm_streaming_compatible))
svint16_t svsubr_s16_x(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_u8_z), arm_streaming_compatible))
svuint8_t svsubr_u8_z(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_u32_z), arm_streaming_compatible))
svuint32_t svsubr_u32_z(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_u64_z), arm_streaming_compatible))
svuint64_t svsubr_u64_z(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_u16_z), arm_streaming_compatible))
svuint16_t svsubr_u16_z(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_s8_z), arm_streaming_compatible))
svint8_t svsubr_s8_z(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_s32_z), arm_streaming_compatible))
svint32_t svsubr_s32_z(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_s64_z), arm_streaming_compatible))
svint64_t svsubr_s64_z(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsubr_s16_z), arm_streaming_compatible))
svint16_t svsubr_s16_z(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtbl_u8), arm_streaming_compatible))
svuint8_t svtbl_u8(svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtbl_u32), arm_streaming_compatible))
svuint32_t svtbl_u32(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtbl_u64), arm_streaming_compatible))
svuint64_t svtbl_u64(svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtbl_u16), arm_streaming_compatible))
svuint16_t svtbl_u16(svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtbl_s8), arm_streaming_compatible))
svint8_t svtbl_s8(svint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtbl_f64), arm_streaming_compatible))
svfloat64_t svtbl_f64(svfloat64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtbl_f32), arm_streaming_compatible))
svfloat32_t svtbl_f32(svfloat32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtbl_f16), arm_streaming_compatible))
svfloat16_t svtbl_f16(svfloat16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtbl_s32), arm_streaming_compatible))
svint32_t svtbl_s32(svint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtbl_s64), arm_streaming_compatible))
svint64_t svtbl_s64(svint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtbl_s16), arm_streaming_compatible))
svint16_t svtbl_s16(svint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtmad_f64)))
svfloat64_t svtmad_f64(svfloat64_t, svfloat64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtmad_f32)))
svfloat32_t svtmad_f32(svfloat32_t, svfloat32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtmad_f16)))
svfloat16_t svtmad_f16(svfloat16_t, svfloat16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn1_u8), arm_streaming_compatible))
svuint8_t svtrn1_u8(svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn1_u32), arm_streaming_compatible))
svuint32_t svtrn1_u32(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn1_u64), arm_streaming_compatible))
svuint64_t svtrn1_u64(svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn1_u16), arm_streaming_compatible))
svuint16_t svtrn1_u16(svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn1_s8), arm_streaming_compatible))
svint8_t svtrn1_s8(svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn1_f64), arm_streaming_compatible))
svfloat64_t svtrn1_f64(svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn1_f32), arm_streaming_compatible))
svfloat32_t svtrn1_f32(svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn1_f16), arm_streaming_compatible))
svfloat16_t svtrn1_f16(svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn1_s32), arm_streaming_compatible))
svint32_t svtrn1_s32(svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn1_s64), arm_streaming_compatible))
svint64_t svtrn1_s64(svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn1_s16), arm_streaming_compatible))
svint16_t svtrn1_s16(svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn1_b16), arm_streaming_compatible))
svbool_t svtrn1_b16(svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn1_b32), arm_streaming_compatible))
svbool_t svtrn1_b32(svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn1_b64), arm_streaming_compatible))
svbool_t svtrn1_b64(svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn1_b8), arm_streaming_compatible))
svbool_t svtrn1_b8(svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn2_u8), arm_streaming_compatible))
svuint8_t svtrn2_u8(svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn2_u32), arm_streaming_compatible))
svuint32_t svtrn2_u32(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn2_u64), arm_streaming_compatible))
svuint64_t svtrn2_u64(svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn2_u16), arm_streaming_compatible))
svuint16_t svtrn2_u16(svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn2_s8), arm_streaming_compatible))
svint8_t svtrn2_s8(svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn2_f64), arm_streaming_compatible))
svfloat64_t svtrn2_f64(svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn2_f32), arm_streaming_compatible))
svfloat32_t svtrn2_f32(svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn2_f16), arm_streaming_compatible))
svfloat16_t svtrn2_f16(svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn2_s32), arm_streaming_compatible))
svint32_t svtrn2_s32(svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn2_s64), arm_streaming_compatible))
svint64_t svtrn2_s64(svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn2_s16), arm_streaming_compatible))
svint16_t svtrn2_s16(svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn2_b16), arm_streaming_compatible))
svbool_t svtrn2_b16(svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn2_b32), arm_streaming_compatible))
svbool_t svtrn2_b32(svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn2_b64), arm_streaming_compatible))
svbool_t svtrn2_b64(svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn2_b8), arm_streaming_compatible))
svbool_t svtrn2_b8(svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtsmul_f64)))
svfloat64_t svtsmul_f64(svfloat64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtsmul_f32)))
svfloat32_t svtsmul_f32(svfloat32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtsmul_f16)))
svfloat16_t svtsmul_f16(svfloat16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtssel_f64)))
svfloat64_t svtssel_f64(svfloat64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtssel_f32)))
svfloat32_t svtssel_f32(svfloat32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtssel_f16)))
svfloat16_t svtssel_f16(svfloat16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef2_u8), arm_streaming_compatible))
svuint8x2_t svundef2_u8(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef2_u32), arm_streaming_compatible))
svuint32x2_t svundef2_u32(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef2_u64), arm_streaming_compatible))
svuint64x2_t svundef2_u64(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef2_u16), arm_streaming_compatible))
svuint16x2_t svundef2_u16(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef2_s8), arm_streaming_compatible))
svint8x2_t svundef2_s8(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef2_f64), arm_streaming_compatible))
svfloat64x2_t svundef2_f64(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef2_f32), arm_streaming_compatible))
svfloat32x2_t svundef2_f32(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef2_f16), arm_streaming_compatible))
svfloat16x2_t svundef2_f16(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef2_s32), arm_streaming_compatible))
svint32x2_t svundef2_s32(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef2_s64), arm_streaming_compatible))
svint64x2_t svundef2_s64(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef2_s16), arm_streaming_compatible))
svint16x2_t svundef2_s16(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef3_u8), arm_streaming_compatible))
svuint8x3_t svundef3_u8(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef3_u32), arm_streaming_compatible))
svuint32x3_t svundef3_u32(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef3_u64), arm_streaming_compatible))
svuint64x3_t svundef3_u64(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef3_u16), arm_streaming_compatible))
svuint16x3_t svundef3_u16(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef3_s8), arm_streaming_compatible))
svint8x3_t svundef3_s8(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef3_f64), arm_streaming_compatible))
svfloat64x3_t svundef3_f64(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef3_f32), arm_streaming_compatible))
svfloat32x3_t svundef3_f32(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef3_f16), arm_streaming_compatible))
svfloat16x3_t svundef3_f16(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef3_s32), arm_streaming_compatible))
svint32x3_t svundef3_s32(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef3_s64), arm_streaming_compatible))
svint64x3_t svundef3_s64(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef3_s16), arm_streaming_compatible))
svint16x3_t svundef3_s16(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef4_u8), arm_streaming_compatible))
svuint8x4_t svundef4_u8(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef4_u32), arm_streaming_compatible))
svuint32x4_t svundef4_u32(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef4_u64), arm_streaming_compatible))
svuint64x4_t svundef4_u64(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef4_u16), arm_streaming_compatible))
svuint16x4_t svundef4_u16(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef4_s8), arm_streaming_compatible))
svint8x4_t svundef4_s8(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef4_f64), arm_streaming_compatible))
svfloat64x4_t svundef4_f64(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef4_f32), arm_streaming_compatible))
svfloat32x4_t svundef4_f32(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef4_f16), arm_streaming_compatible))
svfloat16x4_t svundef4_f16(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef4_s32), arm_streaming_compatible))
svint32x4_t svundef4_s32(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef4_s64), arm_streaming_compatible))
svint64x4_t svundef4_s64(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef4_s16), arm_streaming_compatible))
svint16x4_t svundef4_s16(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef_u8), arm_streaming_compatible))
svuint8_t svundef_u8(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef_u32), arm_streaming_compatible))
svuint32_t svundef_u32(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef_u64), arm_streaming_compatible))
svuint64_t svundef_u64(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef_u16), arm_streaming_compatible))
svuint16_t svundef_u16(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef_s8), arm_streaming_compatible))
svint8_t svundef_s8(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef_f64), arm_streaming_compatible))
svfloat64_t svundef_f64(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef_f32), arm_streaming_compatible))
svfloat32_t svundef_f32(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef_f16), arm_streaming_compatible))
svfloat16_t svundef_f16(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef_s32), arm_streaming_compatible))
svint32_t svundef_s32(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef_s64), arm_streaming_compatible))
svint64_t svundef_s64(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef_s16), arm_streaming_compatible))
svint16_t svundef_s16(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpkhi_b), arm_streaming_compatible))
svbool_t svunpkhi_b(svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpkhi_s32), arm_streaming_compatible))
svint32_t svunpkhi_s32(svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpkhi_s64), arm_streaming_compatible))
svint64_t svunpkhi_s64(svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpkhi_s16), arm_streaming_compatible))
svint16_t svunpkhi_s16(svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpkhi_u32), arm_streaming_compatible))
svuint32_t svunpkhi_u32(svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpkhi_u64), arm_streaming_compatible))
svuint64_t svunpkhi_u64(svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpkhi_u16), arm_streaming_compatible))
svuint16_t svunpkhi_u16(svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpklo_b), arm_streaming_compatible))
svbool_t svunpklo_b(svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpklo_s32), arm_streaming_compatible))
svint32_t svunpklo_s32(svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpklo_s64), arm_streaming_compatible))
svint64_t svunpklo_s64(svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpklo_s16), arm_streaming_compatible))
svint16_t svunpklo_s16(svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpklo_u32), arm_streaming_compatible))
svuint32_t svunpklo_u32(svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpklo_u64), arm_streaming_compatible))
svuint64_t svunpklo_u64(svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpklo_u16), arm_streaming_compatible))
svuint16_t svunpklo_u16(svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp1_u8), arm_streaming_compatible))
svuint8_t svuzp1_u8(svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp1_u32), arm_streaming_compatible))
svuint32_t svuzp1_u32(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp1_u64), arm_streaming_compatible))
svuint64_t svuzp1_u64(svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp1_u16), arm_streaming_compatible))
svuint16_t svuzp1_u16(svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp1_s8), arm_streaming_compatible))
svint8_t svuzp1_s8(svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp1_f64), arm_streaming_compatible))
svfloat64_t svuzp1_f64(svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp1_f32), arm_streaming_compatible))
svfloat32_t svuzp1_f32(svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp1_f16), arm_streaming_compatible))
svfloat16_t svuzp1_f16(svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp1_s32), arm_streaming_compatible))
svint32_t svuzp1_s32(svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp1_s64), arm_streaming_compatible))
svint64_t svuzp1_s64(svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp1_s16), arm_streaming_compatible))
svint16_t svuzp1_s16(svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp1_b16), arm_streaming_compatible))
svbool_t svuzp1_b16(svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp1_b32), arm_streaming_compatible))
svbool_t svuzp1_b32(svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp1_b64), arm_streaming_compatible))
svbool_t svuzp1_b64(svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp1_b8), arm_streaming_compatible))
svbool_t svuzp1_b8(svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp2_u8), arm_streaming_compatible))
svuint8_t svuzp2_u8(svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp2_u32), arm_streaming_compatible))
svuint32_t svuzp2_u32(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp2_u64), arm_streaming_compatible))
svuint64_t svuzp2_u64(svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp2_u16), arm_streaming_compatible))
svuint16_t svuzp2_u16(svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp2_s8), arm_streaming_compatible))
svint8_t svuzp2_s8(svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp2_f64), arm_streaming_compatible))
svfloat64_t svuzp2_f64(svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp2_f32), arm_streaming_compatible))
svfloat32_t svuzp2_f32(svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp2_f16), arm_streaming_compatible))
svfloat16_t svuzp2_f16(svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp2_s32), arm_streaming_compatible))
svint32_t svuzp2_s32(svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp2_s64), arm_streaming_compatible))
svint64_t svuzp2_s64(svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp2_s16), arm_streaming_compatible))
svint16_t svuzp2_s16(svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp2_b16), arm_streaming_compatible))
svbool_t svuzp2_b16(svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp2_b32), arm_streaming_compatible))
svbool_t svuzp2_b32(svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp2_b64), arm_streaming_compatible))
svbool_t svuzp2_b64(svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp2_b8), arm_streaming_compatible))
svbool_t svuzp2_b8(svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_b8_s32), arm_streaming_compatible))
svbool_t svwhilele_b8_s32(int32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_b32_s32), arm_streaming_compatible))
svbool_t svwhilele_b32_s32(int32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_b64_s32), arm_streaming_compatible))
svbool_t svwhilele_b64_s32(int32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_b16_s32), arm_streaming_compatible))
svbool_t svwhilele_b16_s32(int32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_b8_s64), arm_streaming_compatible))
svbool_t svwhilele_b8_s64(int64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_b32_s64), arm_streaming_compatible))
svbool_t svwhilele_b32_s64(int64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_b64_s64), arm_streaming_compatible))
svbool_t svwhilele_b64_s64(int64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_b16_s64), arm_streaming_compatible))
svbool_t svwhilele_b16_s64(int64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_b8_u32), arm_streaming_compatible))
svbool_t svwhilele_b8_u32(uint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_b32_u32), arm_streaming_compatible))
svbool_t svwhilele_b32_u32(uint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_b64_u32), arm_streaming_compatible))
svbool_t svwhilele_b64_u32(uint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_b16_u32), arm_streaming_compatible))
svbool_t svwhilele_b16_u32(uint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_b8_u64), arm_streaming_compatible))
svbool_t svwhilele_b8_u64(uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_b32_u64), arm_streaming_compatible))
svbool_t svwhilele_b32_u64(uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_b64_u64), arm_streaming_compatible))
svbool_t svwhilele_b64_u64(uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_b16_u64), arm_streaming_compatible))
svbool_t svwhilele_b16_u64(uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_b8_u32), arm_streaming_compatible))
svbool_t svwhilelt_b8_u32(uint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_b32_u32), arm_streaming_compatible))
svbool_t svwhilelt_b32_u32(uint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_b64_u32), arm_streaming_compatible))
svbool_t svwhilelt_b64_u32(uint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_b16_u32), arm_streaming_compatible))
svbool_t svwhilelt_b16_u32(uint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_b8_u64), arm_streaming_compatible))
svbool_t svwhilelt_b8_u64(uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_b32_u64), arm_streaming_compatible))
svbool_t svwhilelt_b32_u64(uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_b64_u64), arm_streaming_compatible))
svbool_t svwhilelt_b64_u64(uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_b16_u64), arm_streaming_compatible))
svbool_t svwhilelt_b16_u64(uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_b8_s32), arm_streaming_compatible))
svbool_t svwhilelt_b8_s32(int32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_b32_s32), arm_streaming_compatible))
svbool_t svwhilelt_b32_s32(int32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_b64_s32), arm_streaming_compatible))
svbool_t svwhilelt_b64_s32(int32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_b16_s32), arm_streaming_compatible))
svbool_t svwhilelt_b16_s32(int32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_b8_s64), arm_streaming_compatible))
svbool_t svwhilelt_b8_s64(int64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_b32_s64), arm_streaming_compatible))
svbool_t svwhilelt_b32_s64(int64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_b64_s64), arm_streaming_compatible))
svbool_t svwhilelt_b64_s64(int64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_b16_s64), arm_streaming_compatible))
svbool_t svwhilelt_b16_s64(int64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwrffr)))
void svwrffr(svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip1_u8), arm_streaming_compatible))
svuint8_t svzip1_u8(svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip1_u32), arm_streaming_compatible))
svuint32_t svzip1_u32(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip1_u64), arm_streaming_compatible))
svuint64_t svzip1_u64(svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip1_u16), arm_streaming_compatible))
svuint16_t svzip1_u16(svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip1_s8), arm_streaming_compatible))
svint8_t svzip1_s8(svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip1_f64), arm_streaming_compatible))
svfloat64_t svzip1_f64(svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip1_f32), arm_streaming_compatible))
svfloat32_t svzip1_f32(svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip1_f16), arm_streaming_compatible))
svfloat16_t svzip1_f16(svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip1_s32), arm_streaming_compatible))
svint32_t svzip1_s32(svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip1_s64), arm_streaming_compatible))
svint64_t svzip1_s64(svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip1_s16), arm_streaming_compatible))
svint16_t svzip1_s16(svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip1_b16), arm_streaming_compatible))
svbool_t svzip1_b16(svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip1_b32), arm_streaming_compatible))
svbool_t svzip1_b32(svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip1_b64), arm_streaming_compatible))
svbool_t svzip1_b64(svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip1_b8), arm_streaming_compatible))
svbool_t svzip1_b8(svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip2_u8), arm_streaming_compatible))
svuint8_t svzip2_u8(svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip2_u32), arm_streaming_compatible))
svuint32_t svzip2_u32(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip2_u64), arm_streaming_compatible))
svuint64_t svzip2_u64(svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip2_u16), arm_streaming_compatible))
svuint16_t svzip2_u16(svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip2_s8), arm_streaming_compatible))
svint8_t svzip2_s8(svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip2_f64), arm_streaming_compatible))
svfloat64_t svzip2_f64(svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip2_f32), arm_streaming_compatible))
svfloat32_t svzip2_f32(svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip2_f16), arm_streaming_compatible))
svfloat16_t svzip2_f16(svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip2_s32), arm_streaming_compatible))
svint32_t svzip2_s32(svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip2_s64), arm_streaming_compatible))
svint64_t svzip2_s64(svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip2_s16), arm_streaming_compatible))
svint16_t svzip2_s16(svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip2_b16), arm_streaming_compatible))
svbool_t svzip2_b16(svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip2_b32), arm_streaming_compatible))
svbool_t svzip2_b32(svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip2_b64), arm_streaming_compatible))
svbool_t svzip2_b64(svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip2_b8), arm_streaming_compatible))
svbool_t svzip2_b8(svbool_t, svbool_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_f64_m), arm_streaming_compatible))
svfloat64_t svabd_m(svbool_t, svfloat64_t, float64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_f32_m), arm_streaming_compatible))
svfloat32_t svabd_m(svbool_t, svfloat32_t, float32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_f16_m), arm_streaming_compatible))
svfloat16_t svabd_m(svbool_t, svfloat16_t, float16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_f64_x), arm_streaming_compatible))
svfloat64_t svabd_x(svbool_t, svfloat64_t, float64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_f32_x), arm_streaming_compatible))
svfloat32_t svabd_x(svbool_t, svfloat32_t, float32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_f16_x), arm_streaming_compatible))
svfloat16_t svabd_x(svbool_t, svfloat16_t, float16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_f64_z), arm_streaming_compatible))
svfloat64_t svabd_z(svbool_t, svfloat64_t, float64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_f32_z), arm_streaming_compatible))
svfloat32_t svabd_z(svbool_t, svfloat32_t, float32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_f16_z), arm_streaming_compatible))
svfloat16_t svabd_z(svbool_t, svfloat16_t, float16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_s8_m), arm_streaming_compatible))
svint8_t svabd_m(svbool_t, svint8_t, int8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_s32_m), arm_streaming_compatible))
svint32_t svabd_m(svbool_t, svint32_t, int32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_s64_m), arm_streaming_compatible))
svint64_t svabd_m(svbool_t, svint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_s16_m), arm_streaming_compatible))
svint16_t svabd_m(svbool_t, svint16_t, int16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_s8_x), arm_streaming_compatible))
svint8_t svabd_x(svbool_t, svint8_t, int8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_s32_x), arm_streaming_compatible))
svint32_t svabd_x(svbool_t, svint32_t, int32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_s64_x), arm_streaming_compatible))
svint64_t svabd_x(svbool_t, svint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_s16_x), arm_streaming_compatible))
svint16_t svabd_x(svbool_t, svint16_t, int16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_s8_z), arm_streaming_compatible))
svint8_t svabd_z(svbool_t, svint8_t, int8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_s32_z), arm_streaming_compatible))
svint32_t svabd_z(svbool_t, svint32_t, int32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_s64_z), arm_streaming_compatible))
svint64_t svabd_z(svbool_t, svint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_s16_z), arm_streaming_compatible))
svint16_t svabd_z(svbool_t, svint16_t, int16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_u8_m), arm_streaming_compatible))
svuint8_t svabd_m(svbool_t, svuint8_t, uint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_u32_m), arm_streaming_compatible))
svuint32_t svabd_m(svbool_t, svuint32_t, uint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_u64_m), arm_streaming_compatible))
svuint64_t svabd_m(svbool_t, svuint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_u16_m), arm_streaming_compatible))
svuint16_t svabd_m(svbool_t, svuint16_t, uint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_u8_x), arm_streaming_compatible))
svuint8_t svabd_x(svbool_t, svuint8_t, uint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_u32_x), arm_streaming_compatible))
svuint32_t svabd_x(svbool_t, svuint32_t, uint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_u64_x), arm_streaming_compatible))
svuint64_t svabd_x(svbool_t, svuint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_u16_x), arm_streaming_compatible))
svuint16_t svabd_x(svbool_t, svuint16_t, uint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_u8_z), arm_streaming_compatible))
svuint8_t svabd_z(svbool_t, svuint8_t, uint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_u32_z), arm_streaming_compatible))
svuint32_t svabd_z(svbool_t, svuint32_t, uint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_u64_z), arm_streaming_compatible))
svuint64_t svabd_z(svbool_t, svuint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_n_u16_z), arm_streaming_compatible))
svuint16_t svabd_z(svbool_t, svuint16_t, uint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_f64_m), arm_streaming_compatible))
svfloat64_t svabd_m(svbool_t, svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_f32_m), arm_streaming_compatible))
svfloat32_t svabd_m(svbool_t, svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_f16_m), arm_streaming_compatible))
svfloat16_t svabd_m(svbool_t, svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_f64_x), arm_streaming_compatible))
svfloat64_t svabd_x(svbool_t, svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_f32_x), arm_streaming_compatible))
svfloat32_t svabd_x(svbool_t, svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_f16_x), arm_streaming_compatible))
svfloat16_t svabd_x(svbool_t, svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_f64_z), arm_streaming_compatible))
svfloat64_t svabd_z(svbool_t, svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_f32_z), arm_streaming_compatible))
svfloat32_t svabd_z(svbool_t, svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_f16_z), arm_streaming_compatible))
svfloat16_t svabd_z(svbool_t, svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_s8_m), arm_streaming_compatible))
svint8_t svabd_m(svbool_t, svint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_s32_m), arm_streaming_compatible))
svint32_t svabd_m(svbool_t, svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_s64_m), arm_streaming_compatible))
svint64_t svabd_m(svbool_t, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_s16_m), arm_streaming_compatible))
svint16_t svabd_m(svbool_t, svint16_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_s8_x), arm_streaming_compatible))
svint8_t svabd_x(svbool_t, svint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_s32_x), arm_streaming_compatible))
svint32_t svabd_x(svbool_t, svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_s64_x), arm_streaming_compatible))
svint64_t svabd_x(svbool_t, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_s16_x), arm_streaming_compatible))
svint16_t svabd_x(svbool_t, svint16_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_s8_z), arm_streaming_compatible))
svint8_t svabd_z(svbool_t, svint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_s32_z), arm_streaming_compatible))
svint32_t svabd_z(svbool_t, svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_s64_z), arm_streaming_compatible))
svint64_t svabd_z(svbool_t, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_s16_z), arm_streaming_compatible))
svint16_t svabd_z(svbool_t, svint16_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_u8_m), arm_streaming_compatible))
svuint8_t svabd_m(svbool_t, svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_u32_m), arm_streaming_compatible))
svuint32_t svabd_m(svbool_t, svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_u64_m), arm_streaming_compatible))
svuint64_t svabd_m(svbool_t, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_u16_m), arm_streaming_compatible))
svuint16_t svabd_m(svbool_t, svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_u8_x), arm_streaming_compatible))
svuint8_t svabd_x(svbool_t, svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_u32_x), arm_streaming_compatible))
svuint32_t svabd_x(svbool_t, svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_u64_x), arm_streaming_compatible))
svuint64_t svabd_x(svbool_t, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_u16_x), arm_streaming_compatible))
svuint16_t svabd_x(svbool_t, svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_u8_z), arm_streaming_compatible))
svuint8_t svabd_z(svbool_t, svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_u32_z), arm_streaming_compatible))
svuint32_t svabd_z(svbool_t, svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_u64_z), arm_streaming_compatible))
svuint64_t svabd_z(svbool_t, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabd_u16_z), arm_streaming_compatible))
svuint16_t svabd_z(svbool_t, svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabs_f64_m), arm_streaming_compatible))
svfloat64_t svabs_m(svfloat64_t, svbool_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabs_f32_m), arm_streaming_compatible))
svfloat32_t svabs_m(svfloat32_t, svbool_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabs_f16_m), arm_streaming_compatible))
svfloat16_t svabs_m(svfloat16_t, svbool_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabs_f64_x), arm_streaming_compatible))
svfloat64_t svabs_x(svbool_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabs_f32_x), arm_streaming_compatible))
svfloat32_t svabs_x(svbool_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabs_f16_x), arm_streaming_compatible))
svfloat16_t svabs_x(svbool_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabs_f64_z), arm_streaming_compatible))
svfloat64_t svabs_z(svbool_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabs_f32_z), arm_streaming_compatible))
svfloat32_t svabs_z(svbool_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabs_f16_z), arm_streaming_compatible))
svfloat16_t svabs_z(svbool_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabs_s8_m), arm_streaming_compatible))
svint8_t svabs_m(svint8_t, svbool_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabs_s32_m), arm_streaming_compatible))
svint32_t svabs_m(svint32_t, svbool_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabs_s64_m), arm_streaming_compatible))
svint64_t svabs_m(svint64_t, svbool_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabs_s16_m), arm_streaming_compatible))
svint16_t svabs_m(svint16_t, svbool_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabs_s8_x), arm_streaming_compatible))
svint8_t svabs_x(svbool_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabs_s32_x), arm_streaming_compatible))
svint32_t svabs_x(svbool_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabs_s64_x), arm_streaming_compatible))
svint64_t svabs_x(svbool_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabs_s16_x), arm_streaming_compatible))
svint16_t svabs_x(svbool_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabs_s8_z), arm_streaming_compatible))
svint8_t svabs_z(svbool_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabs_s32_z), arm_streaming_compatible))
svint32_t svabs_z(svbool_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabs_s64_z), arm_streaming_compatible))
svint64_t svabs_z(svbool_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabs_s16_z), arm_streaming_compatible))
svint16_t svabs_z(svbool_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svacge_n_f64)))
svbool_t svacge(svbool_t, svfloat64_t, float64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svacge_n_f32)))
svbool_t svacge(svbool_t, svfloat32_t, float32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svacge_n_f16)))
svbool_t svacge(svbool_t, svfloat16_t, float16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svacge_f64), arm_streaming_compatible))
svbool_t svacge(svbool_t, svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svacge_f32), arm_streaming_compatible))
svbool_t svacge(svbool_t, svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svacge_f16), arm_streaming_compatible))
svbool_t svacge(svbool_t, svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svacgt_n_f64)))
svbool_t svacgt(svbool_t, svfloat64_t, float64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svacgt_n_f32)))
svbool_t svacgt(svbool_t, svfloat32_t, float32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svacgt_n_f16)))
svbool_t svacgt(svbool_t, svfloat16_t, float16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svacgt_f64), arm_streaming_compatible))
svbool_t svacgt(svbool_t, svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svacgt_f32), arm_streaming_compatible))
svbool_t svacgt(svbool_t, svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svacgt_f16), arm_streaming_compatible))
svbool_t svacgt(svbool_t, svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svacle_n_f64)))
svbool_t svacle(svbool_t, svfloat64_t, float64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svacle_n_f32)))
svbool_t svacle(svbool_t, svfloat32_t, float32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svacle_n_f16)))
svbool_t svacle(svbool_t, svfloat16_t, float16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svacle_f64), arm_streaming_compatible))
svbool_t svacle(svbool_t, svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svacle_f32), arm_streaming_compatible))
svbool_t svacle(svbool_t, svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svacle_f16), arm_streaming_compatible))
svbool_t svacle(svbool_t, svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaclt_n_f64)))
svbool_t svaclt(svbool_t, svfloat64_t, float64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaclt_n_f32)))
svbool_t svaclt(svbool_t, svfloat32_t, float32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaclt_n_f16)))
svbool_t svaclt(svbool_t, svfloat16_t, float16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaclt_f64), arm_streaming_compatible))
svbool_t svaclt(svbool_t, svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaclt_f32), arm_streaming_compatible))
svbool_t svaclt(svbool_t, svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaclt_f16), arm_streaming_compatible))
svbool_t svaclt(svbool_t, svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_f64_m), arm_streaming_compatible))
svfloat64_t svadd_m(svbool_t, svfloat64_t, float64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_f32_m), arm_streaming_compatible))
svfloat32_t svadd_m(svbool_t, svfloat32_t, float32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_f16_m), arm_streaming_compatible))
svfloat16_t svadd_m(svbool_t, svfloat16_t, float16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_f64_x), arm_streaming_compatible))
svfloat64_t svadd_x(svbool_t, svfloat64_t, float64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_f32_x), arm_streaming_compatible))
svfloat32_t svadd_x(svbool_t, svfloat32_t, float32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_f16_x), arm_streaming_compatible))
svfloat16_t svadd_x(svbool_t, svfloat16_t, float16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_f64_z), arm_streaming_compatible))
svfloat64_t svadd_z(svbool_t, svfloat64_t, float64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_f32_z), arm_streaming_compatible))
svfloat32_t svadd_z(svbool_t, svfloat32_t, float32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_f16_z), arm_streaming_compatible))
svfloat16_t svadd_z(svbool_t, svfloat16_t, float16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_u8_m), arm_streaming_compatible))
svuint8_t svadd_m(svbool_t, svuint8_t, uint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_u32_m), arm_streaming_compatible))
svuint32_t svadd_m(svbool_t, svuint32_t, uint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_u64_m), arm_streaming_compatible))
svuint64_t svadd_m(svbool_t, svuint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_u16_m), arm_streaming_compatible))
svuint16_t svadd_m(svbool_t, svuint16_t, uint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_s8_m), arm_streaming_compatible))
svint8_t svadd_m(svbool_t, svint8_t, int8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_s32_m), arm_streaming_compatible))
svint32_t svadd_m(svbool_t, svint32_t, int32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_s64_m), arm_streaming_compatible))
svint64_t svadd_m(svbool_t, svint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_s16_m), arm_streaming_compatible))
svint16_t svadd_m(svbool_t, svint16_t, int16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_u8_x), arm_streaming_compatible))
svuint8_t svadd_x(svbool_t, svuint8_t, uint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_u32_x), arm_streaming_compatible))
svuint32_t svadd_x(svbool_t, svuint32_t, uint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_u64_x), arm_streaming_compatible))
svuint64_t svadd_x(svbool_t, svuint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_u16_x), arm_streaming_compatible))
svuint16_t svadd_x(svbool_t, svuint16_t, uint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_s8_x), arm_streaming_compatible))
svint8_t svadd_x(svbool_t, svint8_t, int8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_s32_x), arm_streaming_compatible))
svint32_t svadd_x(svbool_t, svint32_t, int32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_s64_x), arm_streaming_compatible))
svint64_t svadd_x(svbool_t, svint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_s16_x), arm_streaming_compatible))
svint16_t svadd_x(svbool_t, svint16_t, int16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_u8_z), arm_streaming_compatible))
svuint8_t svadd_z(svbool_t, svuint8_t, uint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_u32_z), arm_streaming_compatible))
svuint32_t svadd_z(svbool_t, svuint32_t, uint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_u64_z), arm_streaming_compatible))
svuint64_t svadd_z(svbool_t, svuint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_u16_z), arm_streaming_compatible))
svuint16_t svadd_z(svbool_t, svuint16_t, uint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_s8_z), arm_streaming_compatible))
svint8_t svadd_z(svbool_t, svint8_t, int8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_s32_z), arm_streaming_compatible))
svint32_t svadd_z(svbool_t, svint32_t, int32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_s64_z), arm_streaming_compatible))
svint64_t svadd_z(svbool_t, svint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_s16_z), arm_streaming_compatible))
svint16_t svadd_z(svbool_t, svint16_t, int16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_f64_m), arm_streaming_compatible))
svfloat64_t svadd_m(svbool_t, svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_f32_m), arm_streaming_compatible))
svfloat32_t svadd_m(svbool_t, svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_f16_m), arm_streaming_compatible))
svfloat16_t svadd_m(svbool_t, svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_f64_x), arm_streaming_compatible))
svfloat64_t svadd_x(svbool_t, svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_f32_x), arm_streaming_compatible))
svfloat32_t svadd_x(svbool_t, svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_f16_x), arm_streaming_compatible))
svfloat16_t svadd_x(svbool_t, svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_f64_z), arm_streaming_compatible))
svfloat64_t svadd_z(svbool_t, svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_f32_z), arm_streaming_compatible))
svfloat32_t svadd_z(svbool_t, svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_f16_z), arm_streaming_compatible))
svfloat16_t svadd_z(svbool_t, svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_u8_m), arm_streaming_compatible))
svuint8_t svadd_m(svbool_t, svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_u32_m), arm_streaming_compatible))
svuint32_t svadd_m(svbool_t, svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_u64_m), arm_streaming_compatible))
svuint64_t svadd_m(svbool_t, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_u16_m), arm_streaming_compatible))
svuint16_t svadd_m(svbool_t, svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_s8_m), arm_streaming_compatible))
svint8_t svadd_m(svbool_t, svint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_s32_m), arm_streaming_compatible))
svint32_t svadd_m(svbool_t, svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_s64_m), arm_streaming_compatible))
svint64_t svadd_m(svbool_t, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_s16_m), arm_streaming_compatible))
svint16_t svadd_m(svbool_t, svint16_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_u8_x), arm_streaming_compatible))
svuint8_t svadd_x(svbool_t, svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_u32_x), arm_streaming_compatible))
svuint32_t svadd_x(svbool_t, svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_u64_x), arm_streaming_compatible))
svuint64_t svadd_x(svbool_t, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_u16_x), arm_streaming_compatible))
svuint16_t svadd_x(svbool_t, svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_s8_x), arm_streaming_compatible))
svint8_t svadd_x(svbool_t, svint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_s32_x), arm_streaming_compatible))
svint32_t svadd_x(svbool_t, svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_s64_x), arm_streaming_compatible))
svint64_t svadd_x(svbool_t, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_s16_x), arm_streaming_compatible))
svint16_t svadd_x(svbool_t, svint16_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_u8_z), arm_streaming_compatible))
svuint8_t svadd_z(svbool_t, svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_u32_z), arm_streaming_compatible))
svuint32_t svadd_z(svbool_t, svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_u64_z), arm_streaming_compatible))
svuint64_t svadd_z(svbool_t, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_u16_z), arm_streaming_compatible))
svuint16_t svadd_z(svbool_t, svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_s8_z), arm_streaming_compatible))
svint8_t svadd_z(svbool_t, svint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_s32_z), arm_streaming_compatible))
svint32_t svadd_z(svbool_t, svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_s64_z), arm_streaming_compatible))
svint64_t svadd_z(svbool_t, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_s16_z), arm_streaming_compatible))
svint16_t svadd_z(svbool_t, svint16_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadda_f64), arm_streaming_compatible))
float64_t svadda(svbool_t, float64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadda_f32), arm_streaming_compatible))
float32_t svadda(svbool_t, float32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadda_f16), arm_streaming_compatible))
float16_t svadda(svbool_t, float16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddv_s8), arm_streaming_compatible))
int64_t svaddv(svbool_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddv_s32), arm_streaming_compatible))
int64_t svaddv(svbool_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddv_s64), arm_streaming_compatible))
int64_t svaddv(svbool_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddv_s16), arm_streaming_compatible))
int64_t svaddv(svbool_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddv_u8), arm_streaming_compatible))
uint64_t svaddv(svbool_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddv_u32), arm_streaming_compatible))
uint64_t svaddv(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddv_u64), arm_streaming_compatible))
uint64_t svaddv(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddv_u16), arm_streaming_compatible))
uint64_t svaddv(svbool_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddv_f64), arm_streaming_compatible))
float64_t svaddv(svbool_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddv_f32), arm_streaming_compatible))
float32_t svaddv(svbool_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddv_f16), arm_streaming_compatible))
float16_t svaddv(svbool_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrb_u32base_u32offset)))
svuint32_t svadrb_offset(svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrb_u64base_u64offset)))
svuint64_t svadrb_offset(svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrb_u32base_s32offset)))
svuint32_t svadrb_offset(svuint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrb_u64base_s64offset)))
svuint64_t svadrb_offset(svuint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrd_u32base_u32index)))
svuint32_t svadrd_index(svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrd_u64base_u64index)))
svuint64_t svadrd_index(svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrd_u32base_s32index)))
svuint32_t svadrd_index(svuint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrd_u64base_s64index)))
svuint64_t svadrd_index(svuint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrh_u32base_u32index)))
svuint32_t svadrh_index(svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrh_u64base_u64index)))
svuint64_t svadrh_index(svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrh_u32base_s32index)))
svuint32_t svadrh_index(svuint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrh_u64base_s64index)))
svuint64_t svadrh_index(svuint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrw_u32base_u32index)))
svuint32_t svadrw_index(svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrw_u64base_u64index)))
svuint64_t svadrw_index(svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrw_u32base_s32index)))
svuint32_t svadrw_index(svuint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrw_u64base_s64index)))
svuint64_t svadrw_index(svuint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_b_z), arm_streaming_compatible))
svbool_t svand_z(svbool_t, svbool_t, svbool_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_u8_m), arm_streaming_compatible))
svuint8_t svand_m(svbool_t, svuint8_t, uint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_u32_m), arm_streaming_compatible))
svuint32_t svand_m(svbool_t, svuint32_t, uint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_u64_m), arm_streaming_compatible))
svuint64_t svand_m(svbool_t, svuint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_u16_m), arm_streaming_compatible))
svuint16_t svand_m(svbool_t, svuint16_t, uint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_s8_m), arm_streaming_compatible))
svint8_t svand_m(svbool_t, svint8_t, int8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_s32_m), arm_streaming_compatible))
svint32_t svand_m(svbool_t, svint32_t, int32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_s64_m), arm_streaming_compatible))
svint64_t svand_m(svbool_t, svint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_s16_m), arm_streaming_compatible))
svint16_t svand_m(svbool_t, svint16_t, int16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_u8_x), arm_streaming_compatible))
svuint8_t svand_x(svbool_t, svuint8_t, uint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_u32_x), arm_streaming_compatible))
svuint32_t svand_x(svbool_t, svuint32_t, uint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_u64_x), arm_streaming_compatible))
svuint64_t svand_x(svbool_t, svuint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_u16_x), arm_streaming_compatible))
svuint16_t svand_x(svbool_t, svuint16_t, uint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_s8_x), arm_streaming_compatible))
svint8_t svand_x(svbool_t, svint8_t, int8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_s32_x), arm_streaming_compatible))
svint32_t svand_x(svbool_t, svint32_t, int32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_s64_x), arm_streaming_compatible))
svint64_t svand_x(svbool_t, svint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_s16_x), arm_streaming_compatible))
svint16_t svand_x(svbool_t, svint16_t, int16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_u8_z), arm_streaming_compatible))
svuint8_t svand_z(svbool_t, svuint8_t, uint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_u32_z), arm_streaming_compatible))
svuint32_t svand_z(svbool_t, svuint32_t, uint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_u64_z), arm_streaming_compatible))
svuint64_t svand_z(svbool_t, svuint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_u16_z), arm_streaming_compatible))
svuint16_t svand_z(svbool_t, svuint16_t, uint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_s8_z), arm_streaming_compatible))
svint8_t svand_z(svbool_t, svint8_t, int8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_s32_z), arm_streaming_compatible))
svint32_t svand_z(svbool_t, svint32_t, int32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_s64_z), arm_streaming_compatible))
svint64_t svand_z(svbool_t, svint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_n_s16_z), arm_streaming_compatible))
svint16_t svand_z(svbool_t, svint16_t, int16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_u8_m), arm_streaming_compatible))
svuint8_t svand_m(svbool_t, svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_u32_m), arm_streaming_compatible))
svuint32_t svand_m(svbool_t, svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_u64_m), arm_streaming_compatible))
svuint64_t svand_m(svbool_t, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_u16_m), arm_streaming_compatible))
svuint16_t svand_m(svbool_t, svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_s8_m), arm_streaming_compatible))
svint8_t svand_m(svbool_t, svint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_s32_m), arm_streaming_compatible))
svint32_t svand_m(svbool_t, svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_s64_m), arm_streaming_compatible))
svint64_t svand_m(svbool_t, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_s16_m), arm_streaming_compatible))
svint16_t svand_m(svbool_t, svint16_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_u8_x), arm_streaming_compatible))
svuint8_t svand_x(svbool_t, svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_u32_x), arm_streaming_compatible))
svuint32_t svand_x(svbool_t, svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_u64_x), arm_streaming_compatible))
svuint64_t svand_x(svbool_t, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_u16_x), arm_streaming_compatible))
svuint16_t svand_x(svbool_t, svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_s8_x), arm_streaming_compatible))
svint8_t svand_x(svbool_t, svint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_s32_x), arm_streaming_compatible))
svint32_t svand_x(svbool_t, svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_s64_x), arm_streaming_compatible))
svint64_t svand_x(svbool_t, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_s16_x), arm_streaming_compatible))
svint16_t svand_x(svbool_t, svint16_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_u8_z), arm_streaming_compatible))
svuint8_t svand_z(svbool_t, svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_u32_z), arm_streaming_compatible))
svuint32_t svand_z(svbool_t, svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_u64_z), arm_streaming_compatible))
svuint64_t svand_z(svbool_t, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_u16_z), arm_streaming_compatible))
svuint16_t svand_z(svbool_t, svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_s8_z), arm_streaming_compatible))
svint8_t svand_z(svbool_t, svint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_s32_z), arm_streaming_compatible))
svint32_t svand_z(svbool_t, svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_s64_z), arm_streaming_compatible))
svint64_t svand_z(svbool_t, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svand_s16_z), arm_streaming_compatible))
svint16_t svand_z(svbool_t, svint16_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svandv_u8), arm_streaming_compatible))
uint8_t svandv(svbool_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svandv_u32), arm_streaming_compatible))
uint32_t svandv(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svandv_u64), arm_streaming_compatible))
uint64_t svandv(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svandv_u16), arm_streaming_compatible))
uint16_t svandv(svbool_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svandv_s8), arm_streaming_compatible))
int8_t svandv(svbool_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svandv_s32), arm_streaming_compatible))
int32_t svandv(svbool_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svandv_s64), arm_streaming_compatible))
int64_t svandv(svbool_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svandv_s16), arm_streaming_compatible))
int16_t svandv(svbool_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_n_s8_m), arm_streaming_compatible))
svint8_t svasr_m(svbool_t, svint8_t, uint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_n_s32_m), arm_streaming_compatible))
svint32_t svasr_m(svbool_t, svint32_t, uint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_n_s64_m), arm_streaming_compatible))
svint64_t svasr_m(svbool_t, svint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_n_s16_m), arm_streaming_compatible))
svint16_t svasr_m(svbool_t, svint16_t, uint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_n_s8_x), arm_streaming_compatible))
svint8_t svasr_x(svbool_t, svint8_t, uint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_n_s32_x), arm_streaming_compatible))
svint32_t svasr_x(svbool_t, svint32_t, uint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_n_s64_x), arm_streaming_compatible))
svint64_t svasr_x(svbool_t, svint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_n_s16_x), arm_streaming_compatible))
svint16_t svasr_x(svbool_t, svint16_t, uint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_n_s8_z), arm_streaming_compatible))
svint8_t svasr_z(svbool_t, svint8_t, uint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_n_s32_z), arm_streaming_compatible))
svint32_t svasr_z(svbool_t, svint32_t, uint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_n_s64_z), arm_streaming_compatible))
svint64_t svasr_z(svbool_t, svint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_n_s16_z), arm_streaming_compatible))
svint16_t svasr_z(svbool_t, svint16_t, uint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_s8_m), arm_streaming_compatible))
svint8_t svasr_m(svbool_t, svint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_s32_m), arm_streaming_compatible))
svint32_t svasr_m(svbool_t, svint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_s64_m), arm_streaming_compatible))
svint64_t svasr_m(svbool_t, svint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_s16_m), arm_streaming_compatible))
svint16_t svasr_m(svbool_t, svint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_s8_x), arm_streaming_compatible))
svint8_t svasr_x(svbool_t, svint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_s32_x), arm_streaming_compatible))
svint32_t svasr_x(svbool_t, svint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_s64_x), arm_streaming_compatible))
svint64_t svasr_x(svbool_t, svint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_s16_x), arm_streaming_compatible))
svint16_t svasr_x(svbool_t, svint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_s8_z), arm_streaming_compatible))
svint8_t svasr_z(svbool_t, svint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_s32_z), arm_streaming_compatible))
svint32_t svasr_z(svbool_t, svint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_s64_z), arm_streaming_compatible))
svint64_t svasr_z(svbool_t, svint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_s16_z), arm_streaming_compatible))
svint16_t svasr_z(svbool_t, svint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_wide_n_s8_m), arm_streaming_compatible))
svint8_t svasr_wide_m(svbool_t, svint8_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_wide_n_s32_m), arm_streaming_compatible))
svint32_t svasr_wide_m(svbool_t, svint32_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_wide_n_s16_m), arm_streaming_compatible))
svint16_t svasr_wide_m(svbool_t, svint16_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_wide_n_s8_x), arm_streaming_compatible))
svint8_t svasr_wide_x(svbool_t, svint8_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_wide_n_s32_x), arm_streaming_compatible))
svint32_t svasr_wide_x(svbool_t, svint32_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_wide_n_s16_x), arm_streaming_compatible))
svint16_t svasr_wide_x(svbool_t, svint16_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_wide_n_s8_z), arm_streaming_compatible))
svint8_t svasr_wide_z(svbool_t, svint8_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_wide_n_s32_z), arm_streaming_compatible))
svint32_t svasr_wide_z(svbool_t, svint32_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_wide_n_s16_z), arm_streaming_compatible))
svint16_t svasr_wide_z(svbool_t, svint16_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_wide_s8_m), arm_streaming_compatible))
svint8_t svasr_wide_m(svbool_t, svint8_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_wide_s32_m), arm_streaming_compatible))
svint32_t svasr_wide_m(svbool_t, svint32_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_wide_s16_m), arm_streaming_compatible))
svint16_t svasr_wide_m(svbool_t, svint16_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_wide_s8_x), arm_streaming_compatible))
svint8_t svasr_wide_x(svbool_t, svint8_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_wide_s32_x), arm_streaming_compatible))
svint32_t svasr_wide_x(svbool_t, svint32_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_wide_s16_x), arm_streaming_compatible))
svint16_t svasr_wide_x(svbool_t, svint16_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_wide_s8_z), arm_streaming_compatible))
svint8_t svasr_wide_z(svbool_t, svint8_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_wide_s32_z), arm_streaming_compatible))
svint32_t svasr_wide_z(svbool_t, svint32_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasr_wide_s16_z), arm_streaming_compatible))
svint16_t svasr_wide_z(svbool_t, svint16_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasrd_n_s8_m), arm_streaming_compatible))
svint8_t svasrd_m(svbool_t, svint8_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasrd_n_s32_m), arm_streaming_compatible))
svint32_t svasrd_m(svbool_t, svint32_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasrd_n_s64_m), arm_streaming_compatible))
svint64_t svasrd_m(svbool_t, svint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasrd_n_s16_m), arm_streaming_compatible))
svint16_t svasrd_m(svbool_t, svint16_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasrd_n_s8_x), arm_streaming_compatible))
svint8_t svasrd_x(svbool_t, svint8_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasrd_n_s32_x), arm_streaming_compatible))
svint32_t svasrd_x(svbool_t, svint32_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasrd_n_s64_x), arm_streaming_compatible))
svint64_t svasrd_x(svbool_t, svint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasrd_n_s16_x), arm_streaming_compatible))
svint16_t svasrd_x(svbool_t, svint16_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasrd_n_s8_z), arm_streaming_compatible))
svint8_t svasrd_z(svbool_t, svint8_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasrd_n_s32_z), arm_streaming_compatible))
svint32_t svasrd_z(svbool_t, svint32_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasrd_n_s64_z), arm_streaming_compatible))
svint64_t svasrd_z(svbool_t, svint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svasrd_n_s16_z), arm_streaming_compatible))
svint16_t svasrd_z(svbool_t, svint16_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_b_z), arm_streaming_compatible))
svbool_t svbic_z(svbool_t, svbool_t, svbool_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_u8_m), arm_streaming_compatible))
svuint8_t svbic_m(svbool_t, svuint8_t, uint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_u32_m), arm_streaming_compatible))
svuint32_t svbic_m(svbool_t, svuint32_t, uint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_u64_m), arm_streaming_compatible))
svuint64_t svbic_m(svbool_t, svuint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_u16_m), arm_streaming_compatible))
svuint16_t svbic_m(svbool_t, svuint16_t, uint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_s8_m), arm_streaming_compatible))
svint8_t svbic_m(svbool_t, svint8_t, int8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_s32_m), arm_streaming_compatible))
svint32_t svbic_m(svbool_t, svint32_t, int32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_s64_m), arm_streaming_compatible))
svint64_t svbic_m(svbool_t, svint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_s16_m), arm_streaming_compatible))
svint16_t svbic_m(svbool_t, svint16_t, int16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_u8_x), arm_streaming_compatible))
svuint8_t svbic_x(svbool_t, svuint8_t, uint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_u32_x), arm_streaming_compatible))
svuint32_t svbic_x(svbool_t, svuint32_t, uint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_u64_x), arm_streaming_compatible))
svuint64_t svbic_x(svbool_t, svuint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_u16_x), arm_streaming_compatible))
svuint16_t svbic_x(svbool_t, svuint16_t, uint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_s8_x), arm_streaming_compatible))
svint8_t svbic_x(svbool_t, svint8_t, int8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_s32_x), arm_streaming_compatible))
svint32_t svbic_x(svbool_t, svint32_t, int32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_s64_x), arm_streaming_compatible))
svint64_t svbic_x(svbool_t, svint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_s16_x), arm_streaming_compatible))
svint16_t svbic_x(svbool_t, svint16_t, int16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_u8_z), arm_streaming_compatible))
svuint8_t svbic_z(svbool_t, svuint8_t, uint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_u32_z), arm_streaming_compatible))
svuint32_t svbic_z(svbool_t, svuint32_t, uint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_u64_z), arm_streaming_compatible))
svuint64_t svbic_z(svbool_t, svuint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_u16_z), arm_streaming_compatible))
svuint16_t svbic_z(svbool_t, svuint16_t, uint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_s8_z), arm_streaming_compatible))
svint8_t svbic_z(svbool_t, svint8_t, int8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_s32_z), arm_streaming_compatible))
svint32_t svbic_z(svbool_t, svint32_t, int32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_s64_z), arm_streaming_compatible))
svint64_t svbic_z(svbool_t, svint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_n_s16_z), arm_streaming_compatible))
svint16_t svbic_z(svbool_t, svint16_t, int16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_u8_m), arm_streaming_compatible))
svuint8_t svbic_m(svbool_t, svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_u32_m), arm_streaming_compatible))
svuint32_t svbic_m(svbool_t, svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_u64_m), arm_streaming_compatible))
svuint64_t svbic_m(svbool_t, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_u16_m), arm_streaming_compatible))
svuint16_t svbic_m(svbool_t, svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_s8_m), arm_streaming_compatible))
svint8_t svbic_m(svbool_t, svint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_s32_m), arm_streaming_compatible))
svint32_t svbic_m(svbool_t, svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_s64_m), arm_streaming_compatible))
svint64_t svbic_m(svbool_t, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_s16_m), arm_streaming_compatible))
svint16_t svbic_m(svbool_t, svint16_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_u8_x), arm_streaming_compatible))
svuint8_t svbic_x(svbool_t, svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_u32_x), arm_streaming_compatible))
svuint32_t svbic_x(svbool_t, svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_u64_x), arm_streaming_compatible))
svuint64_t svbic_x(svbool_t, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_u16_x), arm_streaming_compatible))
svuint16_t svbic_x(svbool_t, svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_s8_x), arm_streaming_compatible))
svint8_t svbic_x(svbool_t, svint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_s32_x), arm_streaming_compatible))
svint32_t svbic_x(svbool_t, svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_s64_x), arm_streaming_compatible))
svint64_t svbic_x(svbool_t, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_s16_x), arm_streaming_compatible))
svint16_t svbic_x(svbool_t, svint16_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_u8_z), arm_streaming_compatible))
svuint8_t svbic_z(svbool_t, svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_u32_z), arm_streaming_compatible))
svuint32_t svbic_z(svbool_t, svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_u64_z), arm_streaming_compatible))
svuint64_t svbic_z(svbool_t, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_u16_z), arm_streaming_compatible))
svuint16_t svbic_z(svbool_t, svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_s8_z), arm_streaming_compatible))
svint8_t svbic_z(svbool_t, svint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_s32_z), arm_streaming_compatible))
svint32_t svbic_z(svbool_t, svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_s64_z), arm_streaming_compatible))
svint64_t svbic_z(svbool_t, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbic_s16_z), arm_streaming_compatible))
svint16_t svbic_z(svbool_t, svint16_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbrka_b_m), arm_streaming_compatible))
svbool_t svbrka_m(svbool_t, svbool_t, svbool_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbrka_b_z), arm_streaming_compatible))
svbool_t svbrka_z(svbool_t, svbool_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbrkb_b_m), arm_streaming_compatible))
svbool_t svbrkb_m(svbool_t, svbool_t, svbool_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbrkb_b_z), arm_streaming_compatible))
svbool_t svbrkb_z(svbool_t, svbool_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbrkn_b_z), arm_streaming_compatible))
svbool_t svbrkn_z(svbool_t, svbool_t, svbool_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbrkpa_b_z), arm_streaming_compatible))
svbool_t svbrkpa_z(svbool_t, svbool_t, svbool_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbrkpb_b_z), arm_streaming_compatible))
svbool_t svbrkpb_z(svbool_t, svbool_t, svbool_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcadd_f64_m), arm_streaming_compatible))
svfloat64_t svcadd_m(svbool_t, svfloat64_t, svfloat64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcadd_f32_m), arm_streaming_compatible))
svfloat32_t svcadd_m(svbool_t, svfloat32_t, svfloat32_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcadd_f16_m), arm_streaming_compatible))
svfloat16_t svcadd_m(svbool_t, svfloat16_t, svfloat16_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcadd_f64_x), arm_streaming_compatible))
svfloat64_t svcadd_x(svbool_t, svfloat64_t, svfloat64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcadd_f32_x), arm_streaming_compatible))
svfloat32_t svcadd_x(svbool_t, svfloat32_t, svfloat32_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcadd_f16_x), arm_streaming_compatible))
svfloat16_t svcadd_x(svbool_t, svfloat16_t, svfloat16_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcadd_f64_z), arm_streaming_compatible))
svfloat64_t svcadd_z(svbool_t, svfloat64_t, svfloat64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcadd_f32_z), arm_streaming_compatible))
svfloat32_t svcadd_z(svbool_t, svfloat32_t, svfloat32_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcadd_f16_z), arm_streaming_compatible))
svfloat16_t svcadd_z(svbool_t, svfloat16_t, svfloat16_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_n_u8), arm_streaming_compatible))
uint8_t svclasta(svbool_t, uint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_n_u32), arm_streaming_compatible))
uint32_t svclasta(svbool_t, uint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_n_u64), arm_streaming_compatible))
uint64_t svclasta(svbool_t, uint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_n_u16), arm_streaming_compatible))
uint16_t svclasta(svbool_t, uint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_n_s8), arm_streaming_compatible))
int8_t svclasta(svbool_t, int8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_n_f64), arm_streaming_compatible))
float64_t svclasta(svbool_t, float64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_n_f32), arm_streaming_compatible))
float32_t svclasta(svbool_t, float32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_n_f16), arm_streaming_compatible))
float16_t svclasta(svbool_t, float16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_n_s32), arm_streaming_compatible))
int32_t svclasta(svbool_t, int32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_n_s64), arm_streaming_compatible))
int64_t svclasta(svbool_t, int64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_n_s16), arm_streaming_compatible))
int16_t svclasta(svbool_t, int16_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_u8), arm_streaming_compatible))
svuint8_t svclasta(svbool_t, svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_u32), arm_streaming_compatible))
svuint32_t svclasta(svbool_t, svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_u64), arm_streaming_compatible))
svuint64_t svclasta(svbool_t, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_u16), arm_streaming_compatible))
svuint16_t svclasta(svbool_t, svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_s8), arm_streaming_compatible))
svint8_t svclasta(svbool_t, svint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_f64), arm_streaming_compatible))
svfloat64_t svclasta(svbool_t, svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_f32), arm_streaming_compatible))
svfloat32_t svclasta(svbool_t, svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_f16), arm_streaming_compatible))
svfloat16_t svclasta(svbool_t, svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_s32), arm_streaming_compatible))
svint32_t svclasta(svbool_t, svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_s64), arm_streaming_compatible))
svint64_t svclasta(svbool_t, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclasta_s16), arm_streaming_compatible))
svint16_t svclasta(svbool_t, svint16_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_n_u8), arm_streaming_compatible))
uint8_t svclastb(svbool_t, uint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_n_u32), arm_streaming_compatible))
uint32_t svclastb(svbool_t, uint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_n_u64), arm_streaming_compatible))
uint64_t svclastb(svbool_t, uint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_n_u16), arm_streaming_compatible))
uint16_t svclastb(svbool_t, uint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_n_s8), arm_streaming_compatible))
int8_t svclastb(svbool_t, int8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_n_f64), arm_streaming_compatible))
float64_t svclastb(svbool_t, float64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_n_f32), arm_streaming_compatible))
float32_t svclastb(svbool_t, float32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_n_f16), arm_streaming_compatible))
float16_t svclastb(svbool_t, float16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_n_s32), arm_streaming_compatible))
int32_t svclastb(svbool_t, int32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_n_s64), arm_streaming_compatible))
int64_t svclastb(svbool_t, int64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_n_s16), arm_streaming_compatible))
int16_t svclastb(svbool_t, int16_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_u8), arm_streaming_compatible))
svuint8_t svclastb(svbool_t, svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_u32), arm_streaming_compatible))
svuint32_t svclastb(svbool_t, svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_u64), arm_streaming_compatible))
svuint64_t svclastb(svbool_t, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_u16), arm_streaming_compatible))
svuint16_t svclastb(svbool_t, svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_s8), arm_streaming_compatible))
svint8_t svclastb(svbool_t, svint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_f64), arm_streaming_compatible))
svfloat64_t svclastb(svbool_t, svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_f32), arm_streaming_compatible))
svfloat32_t svclastb(svbool_t, svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_f16), arm_streaming_compatible))
svfloat16_t svclastb(svbool_t, svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_s32), arm_streaming_compatible))
svint32_t svclastb(svbool_t, svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_s64), arm_streaming_compatible))
svint64_t svclastb(svbool_t, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclastb_s16), arm_streaming_compatible))
svint16_t svclastb(svbool_t, svint16_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcls_s8_m), arm_streaming_compatible))
svuint8_t svcls_m(svuint8_t, svbool_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcls_s32_m), arm_streaming_compatible))
svuint32_t svcls_m(svuint32_t, svbool_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcls_s64_m), arm_streaming_compatible))
svuint64_t svcls_m(svuint64_t, svbool_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcls_s16_m), arm_streaming_compatible))
svuint16_t svcls_m(svuint16_t, svbool_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcls_s8_x), arm_streaming_compatible))
svuint8_t svcls_x(svbool_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcls_s32_x), arm_streaming_compatible))
svuint32_t svcls_x(svbool_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcls_s64_x), arm_streaming_compatible))
svuint64_t svcls_x(svbool_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcls_s16_x), arm_streaming_compatible))
svuint16_t svcls_x(svbool_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcls_s8_z), arm_streaming_compatible))
svuint8_t svcls_z(svbool_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcls_s32_z), arm_streaming_compatible))
svuint32_t svcls_z(svbool_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcls_s64_z), arm_streaming_compatible))
svuint64_t svcls_z(svbool_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcls_s16_z), arm_streaming_compatible))
svuint16_t svcls_z(svbool_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_u8_m), arm_streaming_compatible))
svuint8_t svclz_m(svuint8_t, svbool_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_u32_m), arm_streaming_compatible))
svuint32_t svclz_m(svuint32_t, svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_u64_m), arm_streaming_compatible))
svuint64_t svclz_m(svuint64_t, svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_u16_m), arm_streaming_compatible))
svuint16_t svclz_m(svuint16_t, svbool_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_s8_m), arm_streaming_compatible))
svuint8_t svclz_m(svuint8_t, svbool_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_s32_m), arm_streaming_compatible))
svuint32_t svclz_m(svuint32_t, svbool_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_s64_m), arm_streaming_compatible))
svuint64_t svclz_m(svuint64_t, svbool_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_s16_m), arm_streaming_compatible))
svuint16_t svclz_m(svuint16_t, svbool_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_u8_x), arm_streaming_compatible))
svuint8_t svclz_x(svbool_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_u32_x), arm_streaming_compatible))
svuint32_t svclz_x(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_u64_x), arm_streaming_compatible))
svuint64_t svclz_x(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_u16_x), arm_streaming_compatible))
svuint16_t svclz_x(svbool_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_s8_x), arm_streaming_compatible))
svuint8_t svclz_x(svbool_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_s32_x), arm_streaming_compatible))
svuint32_t svclz_x(svbool_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_s64_x), arm_streaming_compatible))
svuint64_t svclz_x(svbool_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_s16_x), arm_streaming_compatible))
svuint16_t svclz_x(svbool_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_u8_z), arm_streaming_compatible))
svuint8_t svclz_z(svbool_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_u32_z), arm_streaming_compatible))
svuint32_t svclz_z(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_u64_z), arm_streaming_compatible))
svuint64_t svclz_z(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_u16_z), arm_streaming_compatible))
svuint16_t svclz_z(svbool_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_s8_z), arm_streaming_compatible))
svuint8_t svclz_z(svbool_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_s32_z), arm_streaming_compatible))
svuint32_t svclz_z(svbool_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_s64_z), arm_streaming_compatible))
svuint64_t svclz_z(svbool_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclz_s16_z), arm_streaming_compatible))
svuint16_t svclz_z(svbool_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmla_f64_m), arm_streaming_compatible))
svfloat64_t svcmla_m(svbool_t, svfloat64_t, svfloat64_t, svfloat64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmla_f32_m), arm_streaming_compatible))
svfloat32_t svcmla_m(svbool_t, svfloat32_t, svfloat32_t, svfloat32_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmla_f16_m), arm_streaming_compatible))
svfloat16_t svcmla_m(svbool_t, svfloat16_t, svfloat16_t, svfloat16_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmla_f64_x), arm_streaming_compatible))
svfloat64_t svcmla_x(svbool_t, svfloat64_t, svfloat64_t, svfloat64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmla_f32_x), arm_streaming_compatible))
svfloat32_t svcmla_x(svbool_t, svfloat32_t, svfloat32_t, svfloat32_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmla_f16_x), arm_streaming_compatible))
svfloat16_t svcmla_x(svbool_t, svfloat16_t, svfloat16_t, svfloat16_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmla_f64_z), arm_streaming_compatible))
svfloat64_t svcmla_z(svbool_t, svfloat64_t, svfloat64_t, svfloat64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmla_f32_z), arm_streaming_compatible))
svfloat32_t svcmla_z(svbool_t, svfloat32_t, svfloat32_t, svfloat32_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmla_f16_z), arm_streaming_compatible))
svfloat16_t svcmla_z(svbool_t, svfloat16_t, svfloat16_t, svfloat16_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmla_lane_f32), arm_streaming_compatible))
svfloat32_t svcmla_lane(svfloat32_t, svfloat32_t, svfloat32_t, uint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmla_lane_f16), arm_streaming_compatible))
svfloat16_t svcmla_lane(svfloat16_t, svfloat16_t, svfloat16_t, uint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_n_f64), arm_streaming_compatible))
svbool_t svcmpeq(svbool_t, svfloat64_t, float64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_n_f32), arm_streaming_compatible))
svbool_t svcmpeq(svbool_t, svfloat32_t, float32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_n_f16), arm_streaming_compatible))
svbool_t svcmpeq(svbool_t, svfloat16_t, float16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_n_u8), arm_streaming_compatible))
svbool_t svcmpeq(svbool_t, svuint8_t, uint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_n_u32), arm_streaming_compatible))
svbool_t svcmpeq(svbool_t, svuint32_t, uint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_n_u64), arm_streaming_compatible))
svbool_t svcmpeq(svbool_t, svuint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_n_u16), arm_streaming_compatible))
svbool_t svcmpeq(svbool_t, svuint16_t, uint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_n_s8), arm_streaming_compatible))
svbool_t svcmpeq(svbool_t, svint8_t, int8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_n_s32), arm_streaming_compatible))
svbool_t svcmpeq(svbool_t, svint32_t, int32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_n_s64), arm_streaming_compatible))
svbool_t svcmpeq(svbool_t, svint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_n_s16), arm_streaming_compatible))
svbool_t svcmpeq(svbool_t, svint16_t, int16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_u8), arm_streaming_compatible))
svbool_t svcmpeq(svbool_t, svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_u32), arm_streaming_compatible))
svbool_t svcmpeq(svbool_t, svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_u64), arm_streaming_compatible))
svbool_t svcmpeq(svbool_t, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_u16), arm_streaming_compatible))
svbool_t svcmpeq(svbool_t, svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_s8), arm_streaming_compatible))
svbool_t svcmpeq(svbool_t, svint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_s32), arm_streaming_compatible))
svbool_t svcmpeq(svbool_t, svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_s64), arm_streaming_compatible))
svbool_t svcmpeq(svbool_t, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_s16), arm_streaming_compatible))
svbool_t svcmpeq(svbool_t, svint16_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_f64), arm_streaming_compatible))
svbool_t svcmpeq(svbool_t, svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_f32), arm_streaming_compatible))
svbool_t svcmpeq(svbool_t, svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_f16), arm_streaming_compatible))
svbool_t svcmpeq(svbool_t, svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_wide_n_s8), arm_streaming_compatible))
svbool_t svcmpeq_wide(svbool_t, svint8_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_wide_n_s32), arm_streaming_compatible))
svbool_t svcmpeq_wide(svbool_t, svint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_wide_n_s16), arm_streaming_compatible))
svbool_t svcmpeq_wide(svbool_t, svint16_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_wide_s8), arm_streaming_compatible))
svbool_t svcmpeq_wide(svbool_t, svint8_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_wide_s32), arm_streaming_compatible))
svbool_t svcmpeq_wide(svbool_t, svint32_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpeq_wide_s16), arm_streaming_compatible))
svbool_t svcmpeq_wide(svbool_t, svint16_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_n_f64), arm_streaming_compatible))
svbool_t svcmpge(svbool_t, svfloat64_t, float64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_n_f32), arm_streaming_compatible))
svbool_t svcmpge(svbool_t, svfloat32_t, float32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_n_f16), arm_streaming_compatible))
svbool_t svcmpge(svbool_t, svfloat16_t, float16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_n_s8), arm_streaming_compatible))
svbool_t svcmpge(svbool_t, svint8_t, int8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_n_s32), arm_streaming_compatible))
svbool_t svcmpge(svbool_t, svint32_t, int32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_n_s64), arm_streaming_compatible))
svbool_t svcmpge(svbool_t, svint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_n_s16), arm_streaming_compatible))
svbool_t svcmpge(svbool_t, svint16_t, int16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_n_u8), arm_streaming_compatible))
svbool_t svcmpge(svbool_t, svuint8_t, uint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_n_u32), arm_streaming_compatible))
svbool_t svcmpge(svbool_t, svuint32_t, uint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_n_u64), arm_streaming_compatible))
svbool_t svcmpge(svbool_t, svuint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_n_u16), arm_streaming_compatible))
svbool_t svcmpge(svbool_t, svuint16_t, uint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_s8), arm_streaming_compatible))
svbool_t svcmpge(svbool_t, svint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_s32), arm_streaming_compatible))
svbool_t svcmpge(svbool_t, svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_s64), arm_streaming_compatible))
svbool_t svcmpge(svbool_t, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_s16), arm_streaming_compatible))
svbool_t svcmpge(svbool_t, svint16_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_f64), arm_streaming_compatible))
svbool_t svcmpge(svbool_t, svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_f32), arm_streaming_compatible))
svbool_t svcmpge(svbool_t, svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_f16), arm_streaming_compatible))
svbool_t svcmpge(svbool_t, svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_u8), arm_streaming_compatible))
svbool_t svcmpge(svbool_t, svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_u32), arm_streaming_compatible))
svbool_t svcmpge(svbool_t, svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_u64), arm_streaming_compatible))
svbool_t svcmpge(svbool_t, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_u16), arm_streaming_compatible))
svbool_t svcmpge(svbool_t, svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_wide_n_s8), arm_streaming_compatible))
svbool_t svcmpge_wide(svbool_t, svint8_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_wide_n_s32), arm_streaming_compatible))
svbool_t svcmpge_wide(svbool_t, svint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_wide_n_s16), arm_streaming_compatible))
svbool_t svcmpge_wide(svbool_t, svint16_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_wide_n_u8), arm_streaming_compatible))
svbool_t svcmpge_wide(svbool_t, svuint8_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_wide_n_u32), arm_streaming_compatible))
svbool_t svcmpge_wide(svbool_t, svuint32_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_wide_n_u16), arm_streaming_compatible))
svbool_t svcmpge_wide(svbool_t, svuint16_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_wide_s8), arm_streaming_compatible))
svbool_t svcmpge_wide(svbool_t, svint8_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_wide_s32), arm_streaming_compatible))
svbool_t svcmpge_wide(svbool_t, svint32_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_wide_s16), arm_streaming_compatible))
svbool_t svcmpge_wide(svbool_t, svint16_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_wide_u8), arm_streaming_compatible))
svbool_t svcmpge_wide(svbool_t, svuint8_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_wide_u32), arm_streaming_compatible))
svbool_t svcmpge_wide(svbool_t, svuint32_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpge_wide_u16), arm_streaming_compatible))
svbool_t svcmpge_wide(svbool_t, svuint16_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_n_f64), arm_streaming_compatible))
svbool_t svcmpgt(svbool_t, svfloat64_t, float64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_n_f32), arm_streaming_compatible))
svbool_t svcmpgt(svbool_t, svfloat32_t, float32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_n_f16), arm_streaming_compatible))
svbool_t svcmpgt(svbool_t, svfloat16_t, float16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_n_s8), arm_streaming_compatible))
svbool_t svcmpgt(svbool_t, svint8_t, int8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_n_s32), arm_streaming_compatible))
svbool_t svcmpgt(svbool_t, svint32_t, int32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_n_s64), arm_streaming_compatible))
svbool_t svcmpgt(svbool_t, svint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_n_s16), arm_streaming_compatible))
svbool_t svcmpgt(svbool_t, svint16_t, int16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_n_u8), arm_streaming_compatible))
svbool_t svcmpgt(svbool_t, svuint8_t, uint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_n_u32), arm_streaming_compatible))
svbool_t svcmpgt(svbool_t, svuint32_t, uint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_n_u64), arm_streaming_compatible))
svbool_t svcmpgt(svbool_t, svuint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_n_u16), arm_streaming_compatible))
svbool_t svcmpgt(svbool_t, svuint16_t, uint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_s8), arm_streaming_compatible))
svbool_t svcmpgt(svbool_t, svint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_s32), arm_streaming_compatible))
svbool_t svcmpgt(svbool_t, svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_s64), arm_streaming_compatible))
svbool_t svcmpgt(svbool_t, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_s16), arm_streaming_compatible))
svbool_t svcmpgt(svbool_t, svint16_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_f64), arm_streaming_compatible))
svbool_t svcmpgt(svbool_t, svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_f32), arm_streaming_compatible))
svbool_t svcmpgt(svbool_t, svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_f16), arm_streaming_compatible))
svbool_t svcmpgt(svbool_t, svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_u8), arm_streaming_compatible))
svbool_t svcmpgt(svbool_t, svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_u32), arm_streaming_compatible))
svbool_t svcmpgt(svbool_t, svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_u64), arm_streaming_compatible))
svbool_t svcmpgt(svbool_t, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_u16), arm_streaming_compatible))
svbool_t svcmpgt(svbool_t, svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_wide_n_s8), arm_streaming_compatible))
svbool_t svcmpgt_wide(svbool_t, svint8_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_wide_n_s32), arm_streaming_compatible))
svbool_t svcmpgt_wide(svbool_t, svint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_wide_n_s16), arm_streaming_compatible))
svbool_t svcmpgt_wide(svbool_t, svint16_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_wide_n_u8), arm_streaming_compatible))
svbool_t svcmpgt_wide(svbool_t, svuint8_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_wide_n_u32), arm_streaming_compatible))
svbool_t svcmpgt_wide(svbool_t, svuint32_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_wide_n_u16), arm_streaming_compatible))
svbool_t svcmpgt_wide(svbool_t, svuint16_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_wide_s8), arm_streaming_compatible))
svbool_t svcmpgt_wide(svbool_t, svint8_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_wide_s32), arm_streaming_compatible))
svbool_t svcmpgt_wide(svbool_t, svint32_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_wide_s16), arm_streaming_compatible))
svbool_t svcmpgt_wide(svbool_t, svint16_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_wide_u8), arm_streaming_compatible))
svbool_t svcmpgt_wide(svbool_t, svuint8_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_wide_u32), arm_streaming_compatible))
svbool_t svcmpgt_wide(svbool_t, svuint32_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpgt_wide_u16), arm_streaming_compatible))
svbool_t svcmpgt_wide(svbool_t, svuint16_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_n_f64), arm_streaming_compatible))
svbool_t svcmple(svbool_t, svfloat64_t, float64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_n_f32), arm_streaming_compatible))
svbool_t svcmple(svbool_t, svfloat32_t, float32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_n_f16), arm_streaming_compatible))
svbool_t svcmple(svbool_t, svfloat16_t, float16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_n_s8), arm_streaming_compatible))
svbool_t svcmple(svbool_t, svint8_t, int8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_n_s32), arm_streaming_compatible))
svbool_t svcmple(svbool_t, svint32_t, int32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_n_s64), arm_streaming_compatible))
svbool_t svcmple(svbool_t, svint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_n_s16), arm_streaming_compatible))
svbool_t svcmple(svbool_t, svint16_t, int16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_n_u8), arm_streaming_compatible))
svbool_t svcmple(svbool_t, svuint8_t, uint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_n_u32), arm_streaming_compatible))
svbool_t svcmple(svbool_t, svuint32_t, uint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_n_u64), arm_streaming_compatible))
svbool_t svcmple(svbool_t, svuint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_n_u16), arm_streaming_compatible))
svbool_t svcmple(svbool_t, svuint16_t, uint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_s8), arm_streaming_compatible))
svbool_t svcmple(svbool_t, svint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_s32), arm_streaming_compatible))
svbool_t svcmple(svbool_t, svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_s64), arm_streaming_compatible))
svbool_t svcmple(svbool_t, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_s16), arm_streaming_compatible))
svbool_t svcmple(svbool_t, svint16_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_f64), arm_streaming_compatible))
svbool_t svcmple(svbool_t, svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_f32), arm_streaming_compatible))
svbool_t svcmple(svbool_t, svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_f16), arm_streaming_compatible))
svbool_t svcmple(svbool_t, svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_u8), arm_streaming_compatible))
svbool_t svcmple(svbool_t, svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_u32), arm_streaming_compatible))
svbool_t svcmple(svbool_t, svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_u64), arm_streaming_compatible))
svbool_t svcmple(svbool_t, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_u16), arm_streaming_compatible))
svbool_t svcmple(svbool_t, svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_wide_n_s8), arm_streaming_compatible))
svbool_t svcmple_wide(svbool_t, svint8_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_wide_n_s32), arm_streaming_compatible))
svbool_t svcmple_wide(svbool_t, svint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_wide_n_s16), arm_streaming_compatible))
svbool_t svcmple_wide(svbool_t, svint16_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_wide_n_u8), arm_streaming_compatible))
svbool_t svcmple_wide(svbool_t, svuint8_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_wide_n_u32), arm_streaming_compatible))
svbool_t svcmple_wide(svbool_t, svuint32_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_wide_n_u16), arm_streaming_compatible))
svbool_t svcmple_wide(svbool_t, svuint16_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_wide_s8), arm_streaming_compatible))
svbool_t svcmple_wide(svbool_t, svint8_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_wide_s32), arm_streaming_compatible))
svbool_t svcmple_wide(svbool_t, svint32_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_wide_s16), arm_streaming_compatible))
svbool_t svcmple_wide(svbool_t, svint16_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_wide_u8), arm_streaming_compatible))
svbool_t svcmple_wide(svbool_t, svuint8_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_wide_u32), arm_streaming_compatible))
svbool_t svcmple_wide(svbool_t, svuint32_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmple_wide_u16), arm_streaming_compatible))
svbool_t svcmple_wide(svbool_t, svuint16_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_n_u8), arm_streaming_compatible))
svbool_t svcmplt(svbool_t, svuint8_t, uint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_n_u32), arm_streaming_compatible))
svbool_t svcmplt(svbool_t, svuint32_t, uint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_n_u64), arm_streaming_compatible))
svbool_t svcmplt(svbool_t, svuint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_n_u16), arm_streaming_compatible))
svbool_t svcmplt(svbool_t, svuint16_t, uint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_n_f64), arm_streaming_compatible))
svbool_t svcmplt(svbool_t, svfloat64_t, float64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_n_f32), arm_streaming_compatible))
svbool_t svcmplt(svbool_t, svfloat32_t, float32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_n_f16), arm_streaming_compatible))
svbool_t svcmplt(svbool_t, svfloat16_t, float16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_n_s8), arm_streaming_compatible))
svbool_t svcmplt(svbool_t, svint8_t, int8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_n_s32), arm_streaming_compatible))
svbool_t svcmplt(svbool_t, svint32_t, int32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_n_s64), arm_streaming_compatible))
svbool_t svcmplt(svbool_t, svint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_n_s16), arm_streaming_compatible))
svbool_t svcmplt(svbool_t, svint16_t, int16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_u8), arm_streaming_compatible))
svbool_t svcmplt(svbool_t, svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_u32), arm_streaming_compatible))
svbool_t svcmplt(svbool_t, svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_u64), arm_streaming_compatible))
svbool_t svcmplt(svbool_t, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_u16), arm_streaming_compatible))
svbool_t svcmplt(svbool_t, svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_s8), arm_streaming_compatible))
svbool_t svcmplt(svbool_t, svint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_s32), arm_streaming_compatible))
svbool_t svcmplt(svbool_t, svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_s64), arm_streaming_compatible))
svbool_t svcmplt(svbool_t, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_s16), arm_streaming_compatible))
svbool_t svcmplt(svbool_t, svint16_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_f64), arm_streaming_compatible))
svbool_t svcmplt(svbool_t, svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_f32), arm_streaming_compatible))
svbool_t svcmplt(svbool_t, svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_f16), arm_streaming_compatible))
svbool_t svcmplt(svbool_t, svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_wide_n_u8), arm_streaming_compatible))
svbool_t svcmplt_wide(svbool_t, svuint8_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_wide_n_u32), arm_streaming_compatible))
svbool_t svcmplt_wide(svbool_t, svuint32_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_wide_n_u16), arm_streaming_compatible))
svbool_t svcmplt_wide(svbool_t, svuint16_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_wide_n_s8), arm_streaming_compatible))
svbool_t svcmplt_wide(svbool_t, svint8_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_wide_n_s32), arm_streaming_compatible))
svbool_t svcmplt_wide(svbool_t, svint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_wide_n_s16), arm_streaming_compatible))
svbool_t svcmplt_wide(svbool_t, svint16_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_wide_u8), arm_streaming_compatible))
svbool_t svcmplt_wide(svbool_t, svuint8_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_wide_u32), arm_streaming_compatible))
svbool_t svcmplt_wide(svbool_t, svuint32_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_wide_u16), arm_streaming_compatible))
svbool_t svcmplt_wide(svbool_t, svuint16_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_wide_s8), arm_streaming_compatible))
svbool_t svcmplt_wide(svbool_t, svint8_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_wide_s32), arm_streaming_compatible))
svbool_t svcmplt_wide(svbool_t, svint32_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmplt_wide_s16), arm_streaming_compatible))
svbool_t svcmplt_wide(svbool_t, svint16_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_n_f64), arm_streaming_compatible))
svbool_t svcmpne(svbool_t, svfloat64_t, float64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_n_f32), arm_streaming_compatible))
svbool_t svcmpne(svbool_t, svfloat32_t, float32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_n_f16), arm_streaming_compatible))
svbool_t svcmpne(svbool_t, svfloat16_t, float16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_n_u8), arm_streaming_compatible))
svbool_t svcmpne(svbool_t, svuint8_t, uint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_n_u32), arm_streaming_compatible))
svbool_t svcmpne(svbool_t, svuint32_t, uint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_n_u64), arm_streaming_compatible))
svbool_t svcmpne(svbool_t, svuint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_n_u16), arm_streaming_compatible))
svbool_t svcmpne(svbool_t, svuint16_t, uint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_n_s8), arm_streaming_compatible))
svbool_t svcmpne(svbool_t, svint8_t, int8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_n_s32), arm_streaming_compatible))
svbool_t svcmpne(svbool_t, svint32_t, int32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_n_s64), arm_streaming_compatible))
svbool_t svcmpne(svbool_t, svint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_n_s16), arm_streaming_compatible))
svbool_t svcmpne(svbool_t, svint16_t, int16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_u8), arm_streaming_compatible))
svbool_t svcmpne(svbool_t, svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_u32), arm_streaming_compatible))
svbool_t svcmpne(svbool_t, svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_u64), arm_streaming_compatible))
svbool_t svcmpne(svbool_t, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_u16), arm_streaming_compatible))
svbool_t svcmpne(svbool_t, svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_s8), arm_streaming_compatible))
svbool_t svcmpne(svbool_t, svint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_s32), arm_streaming_compatible))
svbool_t svcmpne(svbool_t, svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_s64), arm_streaming_compatible))
svbool_t svcmpne(svbool_t, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_s16), arm_streaming_compatible))
svbool_t svcmpne(svbool_t, svint16_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_f64), arm_streaming_compatible))
svbool_t svcmpne(svbool_t, svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_f32), arm_streaming_compatible))
svbool_t svcmpne(svbool_t, svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_f16), arm_streaming_compatible))
svbool_t svcmpne(svbool_t, svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_wide_n_s8), arm_streaming_compatible))
svbool_t svcmpne_wide(svbool_t, svint8_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_wide_n_s32), arm_streaming_compatible))
svbool_t svcmpne_wide(svbool_t, svint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_wide_n_s16), arm_streaming_compatible))
svbool_t svcmpne_wide(svbool_t, svint16_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_wide_s8), arm_streaming_compatible))
svbool_t svcmpne_wide(svbool_t, svint8_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_wide_s32), arm_streaming_compatible))
svbool_t svcmpne_wide(svbool_t, svint32_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpne_wide_s16), arm_streaming_compatible))
svbool_t svcmpne_wide(svbool_t, svint16_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpuo_n_f64)))
svbool_t svcmpuo(svbool_t, svfloat64_t, float64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpuo_n_f32)))
svbool_t svcmpuo(svbool_t, svfloat32_t, float32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpuo_n_f16)))
svbool_t svcmpuo(svbool_t, svfloat16_t, float16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpuo_f64), arm_streaming_compatible))
svbool_t svcmpuo(svbool_t, svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpuo_f32), arm_streaming_compatible))
svbool_t svcmpuo(svbool_t, svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmpuo_f16), arm_streaming_compatible))
svbool_t svcmpuo(svbool_t, svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_u8_m), arm_streaming_compatible))
svuint8_t svcnot_m(svuint8_t, svbool_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_u32_m), arm_streaming_compatible))
svuint32_t svcnot_m(svuint32_t, svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_u64_m), arm_streaming_compatible))
svuint64_t svcnot_m(svuint64_t, svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_u16_m), arm_streaming_compatible))
svuint16_t svcnot_m(svuint16_t, svbool_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_s8_m), arm_streaming_compatible))
svint8_t svcnot_m(svint8_t, svbool_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_s32_m), arm_streaming_compatible))
svint32_t svcnot_m(svint32_t, svbool_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_s64_m), arm_streaming_compatible))
svint64_t svcnot_m(svint64_t, svbool_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_s16_m), arm_streaming_compatible))
svint16_t svcnot_m(svint16_t, svbool_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_u8_x), arm_streaming_compatible))
svuint8_t svcnot_x(svbool_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_u32_x), arm_streaming_compatible))
svuint32_t svcnot_x(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_u64_x), arm_streaming_compatible))
svuint64_t svcnot_x(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_u16_x), arm_streaming_compatible))
svuint16_t svcnot_x(svbool_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_s8_x), arm_streaming_compatible))
svint8_t svcnot_x(svbool_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_s32_x), arm_streaming_compatible))
svint32_t svcnot_x(svbool_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_s64_x), arm_streaming_compatible))
svint64_t svcnot_x(svbool_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_s16_x), arm_streaming_compatible))
svint16_t svcnot_x(svbool_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_u8_z), arm_streaming_compatible))
svuint8_t svcnot_z(svbool_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_u32_z), arm_streaming_compatible))
svuint32_t svcnot_z(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_u64_z), arm_streaming_compatible))
svuint64_t svcnot_z(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_u16_z), arm_streaming_compatible))
svuint16_t svcnot_z(svbool_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_s8_z), arm_streaming_compatible))
svint8_t svcnot_z(svbool_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_s32_z), arm_streaming_compatible))
svint32_t svcnot_z(svbool_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_s64_z), arm_streaming_compatible))
svint64_t svcnot_z(svbool_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnot_s16_z), arm_streaming_compatible))
svint16_t svcnot_z(svbool_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_u8_m), arm_streaming_compatible))
svuint8_t svcnt_m(svuint8_t, svbool_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_u32_m), arm_streaming_compatible))
svuint32_t svcnt_m(svuint32_t, svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_u64_m), arm_streaming_compatible))
svuint64_t svcnt_m(svuint64_t, svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_u16_m), arm_streaming_compatible))
svuint16_t svcnt_m(svuint16_t, svbool_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_s8_m), arm_streaming_compatible))
svuint8_t svcnt_m(svuint8_t, svbool_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_f64_m), arm_streaming_compatible))
svuint64_t svcnt_m(svuint64_t, svbool_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_f32_m), arm_streaming_compatible))
svuint32_t svcnt_m(svuint32_t, svbool_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_f16_m), arm_streaming_compatible))
svuint16_t svcnt_m(svuint16_t, svbool_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_s32_m), arm_streaming_compatible))
svuint32_t svcnt_m(svuint32_t, svbool_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_s64_m), arm_streaming_compatible))
svuint64_t svcnt_m(svuint64_t, svbool_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_s16_m), arm_streaming_compatible))
svuint16_t svcnt_m(svuint16_t, svbool_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_u8_x), arm_streaming_compatible))
svuint8_t svcnt_x(svbool_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_u32_x), arm_streaming_compatible))
svuint32_t svcnt_x(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_u64_x), arm_streaming_compatible))
svuint64_t svcnt_x(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_u16_x), arm_streaming_compatible))
svuint16_t svcnt_x(svbool_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_s8_x), arm_streaming_compatible))
svuint8_t svcnt_x(svbool_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_f64_x), arm_streaming_compatible))
svuint64_t svcnt_x(svbool_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_f32_x), arm_streaming_compatible))
svuint32_t svcnt_x(svbool_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_f16_x), arm_streaming_compatible))
svuint16_t svcnt_x(svbool_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_s32_x), arm_streaming_compatible))
svuint32_t svcnt_x(svbool_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_s64_x), arm_streaming_compatible))
svuint64_t svcnt_x(svbool_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_s16_x), arm_streaming_compatible))
svuint16_t svcnt_x(svbool_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_u8_z), arm_streaming_compatible))
svuint8_t svcnt_z(svbool_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_u32_z), arm_streaming_compatible))
svuint32_t svcnt_z(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_u64_z), arm_streaming_compatible))
svuint64_t svcnt_z(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_u16_z), arm_streaming_compatible))
svuint16_t svcnt_z(svbool_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_s8_z), arm_streaming_compatible))
svuint8_t svcnt_z(svbool_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_f64_z), arm_streaming_compatible))
svuint64_t svcnt_z(svbool_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_f32_z), arm_streaming_compatible))
svuint32_t svcnt_z(svbool_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_f16_z), arm_streaming_compatible))
svuint16_t svcnt_z(svbool_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_s32_z), arm_streaming_compatible))
svuint32_t svcnt_z(svbool_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_s64_z), arm_streaming_compatible))
svuint64_t svcnt_z(svbool_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcnt_s16_z), arm_streaming_compatible))
svuint16_t svcnt_z(svbool_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcompact_u32)))
svuint32_t svcompact(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcompact_u64)))
svuint64_t svcompact(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcompact_f64)))
svfloat64_t svcompact(svbool_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcompact_f32)))
svfloat32_t svcompact(svbool_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcompact_s32)))
svint32_t svcompact(svbool_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcompact_s64)))
svint64_t svcompact(svbool_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate2_u8)))
svuint8x2_t svcreate2(svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate2_u32)))
svuint32x2_t svcreate2(svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate2_u64)))
svuint64x2_t svcreate2(svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate2_u16)))
svuint16x2_t svcreate2(svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate2_s8)))
svint8x2_t svcreate2(svint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate2_f64)))
svfloat64x2_t svcreate2(svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate2_f32)))
svfloat32x2_t svcreate2(svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate2_f16)))
svfloat16x2_t svcreate2(svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate2_s32)))
svint32x2_t svcreate2(svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate2_s64)))
svint64x2_t svcreate2(svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate2_s16)))
svint16x2_t svcreate2(svint16_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate3_u8)))
svuint8x3_t svcreate3(svuint8_t, svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate3_u32)))
svuint32x3_t svcreate3(svuint32_t, svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate3_u64)))
svuint64x3_t svcreate3(svuint64_t, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate3_u16)))
svuint16x3_t svcreate3(svuint16_t, svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate3_s8)))
svint8x3_t svcreate3(svint8_t, svint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate3_f64)))
svfloat64x3_t svcreate3(svfloat64_t, svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate3_f32)))
svfloat32x3_t svcreate3(svfloat32_t, svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate3_f16)))
svfloat16x3_t svcreate3(svfloat16_t, svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate3_s32)))
svint32x3_t svcreate3(svint32_t, svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate3_s64)))
svint64x3_t svcreate3(svint64_t, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate3_s16)))
svint16x3_t svcreate3(svint16_t, svint16_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate4_u8)))
svuint8x4_t svcreate4(svuint8_t, svuint8_t, svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate4_u32)))
svuint32x4_t svcreate4(svuint32_t, svuint32_t, svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate4_u64)))
svuint64x4_t svcreate4(svuint64_t, svuint64_t, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate4_u16)))
svuint16x4_t svcreate4(svuint16_t, svuint16_t, svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate4_s8)))
svint8x4_t svcreate4(svint8_t, svint8_t, svint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate4_f64)))
svfloat64x4_t svcreate4(svfloat64_t, svfloat64_t, svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate4_f32)))
svfloat32x4_t svcreate4(svfloat32_t, svfloat32_t, svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate4_f16)))
svfloat16x4_t svcreate4(svfloat16_t, svfloat16_t, svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate4_s32)))
svint32x4_t svcreate4(svint32_t, svint32_t, svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate4_s64)))
svint64x4_t svcreate4(svint64_t, svint64_t, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate4_s16)))
svint16x4_t svcreate4(svint16_t, svint16_t, svint16_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_f32_m), arm_streaming_compatible))
svfloat16_t svcvt_f16_m(svfloat16_t, svbool_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_f32_x), arm_streaming_compatible))
svfloat16_t svcvt_f16_x(svbool_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_f32_z), arm_streaming_compatible))
svfloat16_t svcvt_f16_z(svbool_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_f64_m), arm_streaming_compatible))
svfloat16_t svcvt_f16_m(svfloat16_t, svbool_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_f64_x), arm_streaming_compatible))
svfloat16_t svcvt_f16_x(svbool_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_f64_z), arm_streaming_compatible))
svfloat16_t svcvt_f16_z(svbool_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_s16_m), arm_streaming_compatible))
svfloat16_t svcvt_f16_m(svfloat16_t, svbool_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_s16_x), arm_streaming_compatible))
svfloat16_t svcvt_f16_x(svbool_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_s16_z), arm_streaming_compatible))
svfloat16_t svcvt_f16_z(svbool_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_s32_m), arm_streaming_compatible))
svfloat16_t svcvt_f16_m(svfloat16_t, svbool_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_s32_x), arm_streaming_compatible))
svfloat16_t svcvt_f16_x(svbool_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_s32_z), arm_streaming_compatible))
svfloat16_t svcvt_f16_z(svbool_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_s64_m), arm_streaming_compatible))
svfloat16_t svcvt_f16_m(svfloat16_t, svbool_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_s64_x), arm_streaming_compatible))
svfloat16_t svcvt_f16_x(svbool_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_s64_z), arm_streaming_compatible))
svfloat16_t svcvt_f16_z(svbool_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_u16_m), arm_streaming_compatible))
svfloat16_t svcvt_f16_m(svfloat16_t, svbool_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_u16_x), arm_streaming_compatible))
svfloat16_t svcvt_f16_x(svbool_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_u16_z), arm_streaming_compatible))
svfloat16_t svcvt_f16_z(svbool_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_u32_m), arm_streaming_compatible))
svfloat16_t svcvt_f16_m(svfloat16_t, svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_u32_x), arm_streaming_compatible))
svfloat16_t svcvt_f16_x(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_u32_z), arm_streaming_compatible))
svfloat16_t svcvt_f16_z(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_u64_m), arm_streaming_compatible))
svfloat16_t svcvt_f16_m(svfloat16_t, svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_u64_x), arm_streaming_compatible))
svfloat16_t svcvt_f16_x(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_u64_z), arm_streaming_compatible))
svfloat16_t svcvt_f16_z(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_f16_m), arm_streaming_compatible))
svfloat32_t svcvt_f32_m(svfloat32_t, svbool_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_f16_x), arm_streaming_compatible))
svfloat32_t svcvt_f32_x(svbool_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_f16_z), arm_streaming_compatible))
svfloat32_t svcvt_f32_z(svbool_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_f64_m), arm_streaming_compatible))
svfloat32_t svcvt_f32_m(svfloat32_t, svbool_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_f64_x), arm_streaming_compatible))
svfloat32_t svcvt_f32_x(svbool_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_f64_z), arm_streaming_compatible))
svfloat32_t svcvt_f32_z(svbool_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_s32_m), arm_streaming_compatible))
svfloat32_t svcvt_f32_m(svfloat32_t, svbool_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_s32_x), arm_streaming_compatible))
svfloat32_t svcvt_f32_x(svbool_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_s32_z), arm_streaming_compatible))
svfloat32_t svcvt_f32_z(svbool_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_s64_m), arm_streaming_compatible))
svfloat32_t svcvt_f32_m(svfloat32_t, svbool_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_s64_x), arm_streaming_compatible))
svfloat32_t svcvt_f32_x(svbool_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_s64_z), arm_streaming_compatible))
svfloat32_t svcvt_f32_z(svbool_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_u32_m), arm_streaming_compatible))
svfloat32_t svcvt_f32_m(svfloat32_t, svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_u32_x), arm_streaming_compatible))
svfloat32_t svcvt_f32_x(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_u32_z), arm_streaming_compatible))
svfloat32_t svcvt_f32_z(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_u64_m), arm_streaming_compatible))
svfloat32_t svcvt_f32_m(svfloat32_t, svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_u64_x), arm_streaming_compatible))
svfloat32_t svcvt_f32_x(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_u64_z), arm_streaming_compatible))
svfloat32_t svcvt_f32_z(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f64_f16_m), arm_streaming_compatible))
svfloat64_t svcvt_f64_m(svfloat64_t, svbool_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f64_f16_x), arm_streaming_compatible))
svfloat64_t svcvt_f64_x(svbool_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f64_f16_z), arm_streaming_compatible))
svfloat64_t svcvt_f64_z(svbool_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f64_f32_m), arm_streaming_compatible))
svfloat64_t svcvt_f64_m(svfloat64_t, svbool_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f64_f32_x), arm_streaming_compatible))
svfloat64_t svcvt_f64_x(svbool_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f64_f32_z), arm_streaming_compatible))
svfloat64_t svcvt_f64_z(svbool_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f64_s32_m), arm_streaming_compatible))
svfloat64_t svcvt_f64_m(svfloat64_t, svbool_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f64_s32_x), arm_streaming_compatible))
svfloat64_t svcvt_f64_x(svbool_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f64_s32_z), arm_streaming_compatible))
svfloat64_t svcvt_f64_z(svbool_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f64_s64_m), arm_streaming_compatible))
svfloat64_t svcvt_f64_m(svfloat64_t, svbool_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f64_s64_x), arm_streaming_compatible))
svfloat64_t svcvt_f64_x(svbool_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f64_s64_z), arm_streaming_compatible))
s